/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.swing.text.html.css;

public class FontSize {
    private String value;
    private int size;
    private int sizeIndex;
    private boolean isRelative;
    public static final int DEFAULT_FONT_SIZE = 12;
    private static final double[] SCALE = new double[]{0.8, 0.9, 1.0, 1.2, 1.4, 1.6, 1.8};

    public FontSize(String val) {
        this.value = val;
        this.sizeIndex = -1;
        this.isRelative = false;
        this.size = this.mapValue();
    }

    public int getValue(int p) {
        if (this.isRelative) {
            this.mapRelative(p);
        }
        return this.size;
    }

    public int getValue() {
        assert (!this.isRelative);
        return this.size;
    }

    private int mapValue() {
        int intVal;
        if (this.value.contains("pt")) {
            intVal = this.mapPoints();
        } else if (this.value.contains("px")) {
            intVal = this.mapPixels();
        } else if (this.value.contains("em") || this.value.contains("%") || this.value.contains("larger") || this.value.contains("smaller")) {
            intVal = -1;
            this.isRelative = true;
        } else {
            intVal = this.mapAbsolute();
        }
        return intVal;
    }

    private int mapPoints() {
        int end = this.value.indexOf("pt");
        String number = this.value.substring(0, end);
        int intVal = (int)Double.parseDouble(number);
        return intVal;
    }

    private int mapPixels() {
        int end = this.value.indexOf("px");
        if (end == -1) {
            end = this.value.length();
        }
        String number = this.value.substring(0, end);
        try {
            int intVal = (int)Double.parseDouble(number);
            return intVal;
        }
        catch (NumberFormatException numberFormatException) {
            return 12;
        }
    }

    private int mapPercent(int par) {
        int end = this.value.indexOf("%");
        if (end == -1) {
            end = this.value.length();
        }
        String number = this.value.substring(0, end);
        try {
            int intVal = (int)Double.parseDouble(number);
            return intVal * par / 100;
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("couldn't map value: '" + this.value + "'");
            return 12;
        }
    }

    private int mapEM(int par) {
        int end = this.value.indexOf("em");
        if (end == -1) {
            end = this.value.length();
        }
        String number = this.value.substring(0, end);
        try {
            float factor = Float.parseFloat(number);
            return (int)(factor * (float)par);
        }
        catch (NumberFormatException numberFormatException) {
            return 12;
        }
    }

    private int mapSmaller(int par) {
        return (int)((double)par * 0.9);
    }

    private int mapLarger(int par) {
        return (int)((double)par * 0.9);
    }

    private int mapAbsolute() {
        int index = this.value.equals("xx-small") || this.value.equals("x-small") ? 0 : (this.value.equals("small") ? 1 : (this.value.equals("medium") ? 2 : (this.value.equals("large") ? 3 : (this.value.equals("x-large") ? 4 : (this.value.equals("xx-large") ? 5 : 2)))));
        double scale = SCALE[index];
        int intVal = (int)(scale * 12.0);
        this.sizeIndex = index;
        return intVal;
    }

    public String toString() {
        return this.value;
    }

    private int mapRelative(int par) {
        if (this.value.indexOf(37) != -1) {
            this.size = this.mapPercent(par);
        } else if (this.value.indexOf("em") != -1) {
            this.size = this.mapEM(par);
        } else if (this.value.indexOf("larger") != -1) {
            this.size = this.mapLarger(par);
        } else if (this.value.indexOf("smaller") != -1) {
            this.size = this.mapSmaller(par);
        }
        return this.size;
    }

    public boolean isRelative() {
        return this.isRelative;
    }
}

