/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.Handshake;
import gnu.javax.net.ssl.provider.KeyExchangeAlgorithm;
import gnu.javax.net.ssl.provider.ServerDHE_PSKParameters;
import gnu.javax.net.ssl.provider.ServerDHParams;
import gnu.javax.net.ssl.provider.ServerKeyExchangeParams;
import gnu.javax.net.ssl.provider.ServerPSKParameters;
import gnu.javax.net.ssl.provider.ServerRSAParams;
import gnu.javax.net.ssl.provider.Signature;
import gnu.javax.net.ssl.provider.SignatureAlgorithm;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ServerKeyExchange
implements Handshake.Body {
    protected ByteBuffer buffer;
    protected final CipherSuite suite;

    public ServerKeyExchange(ByteBuffer buffer, CipherSuite suite) {
        suite.getClass();
        this.buffer = buffer.duplicate().order(ByteOrder.BIG_ENDIAN);
        this.suite = suite;
    }

    public int length() {
        if (this.suite.keyExchangeAlgorithm().equals((Object)KeyExchangeAlgorithm.NONE)) {
            return 0;
        }
        int len = 0;
        ServerKeyExchangeParams params = this.params();
        Signature sig = this.signature();
        if (params != null) {
            len += params.length();
        }
        if (sig != null) {
            len += sig.length();
        }
        return len;
    }

    public ServerKeyExchangeParams params() {
        KeyExchangeAlgorithm kex = this.suite.keyExchangeAlgorithm();
        if (kex == KeyExchangeAlgorithm.RSA) {
            return new ServerRSAParams(this.buffer.duplicate());
        }
        if (kex == KeyExchangeAlgorithm.DHE_DSS || kex == KeyExchangeAlgorithm.DHE_RSA || kex == KeyExchangeAlgorithm.DH_anon) {
            return new ServerDHParams(this.buffer.duplicate());
        }
        if (kex == KeyExchangeAlgorithm.NONE) {
            return null;
        }
        if (kex == KeyExchangeAlgorithm.DHE_PSK) {
            return new ServerDHE_PSKParameters(this.buffer.duplicate());
        }
        if (kex == KeyExchangeAlgorithm.PSK) {
            return new ServerPSKParameters(this.buffer.duplicate());
        }
        if (kex == KeyExchangeAlgorithm.RSA_PSK) {
            return new ServerPSKParameters(this.buffer.duplicate());
        }
        throw new IllegalArgumentException("unsupported key exchange: " + (Object)((Object)kex));
    }

    public Signature signature() {
        KeyExchangeAlgorithm kex = this.suite.keyExchangeAlgorithm();
        if (kex == KeyExchangeAlgorithm.NONE || kex == KeyExchangeAlgorithm.DH_anon || kex == KeyExchangeAlgorithm.DHE_PSK || kex == KeyExchangeAlgorithm.PSK || kex == KeyExchangeAlgorithm.RSA_PSK) {
            return null;
        }
        ServerKeyExchangeParams params = this.params();
        ByteBuffer sigbuf = ((ByteBuffer)this.buffer.position(params.length())).slice();
        return new Signature(sigbuf, this.suite.signatureAlgorithm());
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String prefix) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("struct {");
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("  algorithm: ");
        out.print((Object)this.suite.keyExchangeAlgorithm());
        out.println(";");
        if (!this.suite.keyExchangeAlgorithm().equals((Object)KeyExchangeAlgorithm.NONE)) {
            if (prefix != null) {
                out.print(prefix);
            }
            out.println("  parameters:");
            out.println(this.params().toString(prefix != null ? String.valueOf(prefix) + "  " : "  "));
        }
        if (!this.suite.signatureAlgorithm().equals((Object)SignatureAlgorithm.ANONYMOUS)) {
            if (prefix != null) {
                out.print(prefix);
            }
            out.println("  signature:");
            out.println(this.signature().toString(prefix != null ? String.valueOf(prefix) + "  " : "  "));
        }
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("} ServerKeyExchange;");
        return str.toString();
    }
}

