/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509;

import gnu.java.security.OID;
import gnu.java.security.der.DEREncodingException;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class X509CertPath
extends CertPath {
    public static final List ENCODINGS = Collections.unmodifiableList(Arrays.asList("PkiPath", "PKCS7"));
    private static final OID PKCS7_SIGNED_DATA = new OID("1.2.840.113549.1.7.2");
    private static final OID PKCS7_DATA = new OID("1.2.840.113549.1.7.1");
    private List path;
    private byte[] pkcs_encoded;
    private byte[] pki_encoded;

    public X509CertPath(List path) {
        super("X.509");
        this.path = Collections.unmodifiableList(path);
    }

    public X509CertPath(InputStream in) throws CertificateEncodingException {
        this(in, (String)ENCODINGS.get(0));
    }

    public X509CertPath(InputStream in, String encoding) throws CertificateEncodingException {
        super("X.509");
        try {
            this.parse(in, encoding);
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException();
        }
    }

    public List getCertificates() {
        return this.path;
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        return this.getEncoded((String)ENCODINGS.get(0));
    }

    public byte[] getEncoded(String encoding) throws CertificateEncodingException {
        if (encoding.equalsIgnoreCase("PkiPath")) {
            if (this.pki_encoded == null) {
                try {
                    this.pki_encoded = this.encodePki();
                }
                catch (IOException iOException) {
                    throw new CertificateEncodingException();
                }
            }
            return (byte[])this.pki_encoded.clone();
        }
        if (encoding.equalsIgnoreCase("PKCS7")) {
            if (this.pkcs_encoded == null) {
                try {
                    this.pkcs_encoded = this.encodePKCS();
                }
                catch (IOException iOException) {
                    throw new CertificateEncodingException();
                }
            }
            return (byte[])this.pkcs_encoded.clone();
        }
        throw new CertificateEncodingException("unknown encoding: " + encoding);
    }

    public Iterator getEncodings() {
        return ENCODINGS.iterator();
    }

    private void parse(InputStream in, String encoding) throws CertificateEncodingException, IOException {
        DERReader der = new DERReader(in);
        DERValue path = null;
        if (encoding.equalsIgnoreCase("PkiPath")) {
            path = der.read();
            if (!path.isConstructed()) {
                throw new DEREncodingException("malformed PkiPath");
            }
        } else if (encoding.equalsIgnoreCase("PKCS7")) {
            DERValue value = der.read();
            if (!value.isConstructed()) {
                throw new DEREncodingException("malformed ContentInfo");
            }
            value = der.read();
            if (!(value.getValue() instanceof OID) || ((OID)value.getValue()).equals(PKCS7_SIGNED_DATA)) {
                throw new DEREncodingException("not a SignedData");
            }
            value = der.read();
            if (!value.isConstructed() || value.getTag() != 0) {
                throw new DEREncodingException("malformed content");
            }
            value = der.read();
            if (value.getTag() != 2) {
                throw new DEREncodingException("malformed Version");
            }
            value = der.read();
            if (!value.isConstructed() || value.getTag() != 17) {
                throw new DEREncodingException("malformed DigestAlgorithmIdentifiers");
            }
            der.skip(value.getLength());
            value = der.read();
            if (!value.isConstructed()) {
                throw new DEREncodingException("malformed ContentInfo");
            }
            der.skip(value.getLength());
            path = der.read();
            if (!path.isConstructed() || path.getTag() != 0) {
                throw new DEREncodingException("no certificates");
            }
        } else {
            throw new CertificateEncodingException("unknown encoding: " + encoding);
        }
        LinkedList<X509Certificate> certs = new LinkedList<X509Certificate>();
        int len = 0;
        while (len < path.getLength()) {
            DERValue cert = der.read();
            try {
                certs.add(new X509Certificate(new ByteArrayInputStream(cert.getEncoded())));
            }
            catch (CertificateException ce) {
                throw new CertificateEncodingException(ce.getMessage());
            }
            len += cert.getEncodedLength();
            der.skip(cert.getLength());
        }
        this.path = Collections.unmodifiableList(certs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] encodePki() throws CertificateEncodingException, IOException {
        List list2 = this.path;
        synchronized (list2) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Iterator i = this.path.iterator();
            while (i.hasNext()) {
                out.write(((Certificate)i.next()).getEncoded());
            }
            byte[] b = out.toByteArray();
            DERValue val = new DERValue(48, b.length, b, null);
            return val.getEncoded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] encodePKCS() throws CertificateEncodingException, IOException {
        List list2 = this.path;
        synchronized (list2) {
            ArrayList<DERValue> signedData = new ArrayList<DERValue>(5);
            signedData.add(new DERValue(2, BigInteger.ONE));
            signedData.add(new DERValue(49, Collections.EMPTY_SET));
            signedData.add(new DERValue(48, Collections.singletonList(new DERValue(6, PKCS7_DATA))));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Iterator i = this.path.iterator();
            while (i.hasNext()) {
                out.write(((Certificate)i.next()).getEncoded());
            }
            byte[] b = out.toByteArray();
            signedData.add(new DERValue(160, b.length, b, null));
            DERValue sdValue = new DERValue(48, signedData);
            ArrayList<DERValue> contentInfo = new ArrayList<DERValue>(2);
            contentInfo.add(new DERValue(6, PKCS7_SIGNED_DATA));
            contentInfo.add(new DERValue(160, sdValue));
            return new DERValue(48, contentInfo).getEncoded();
        }
    }
}

