/* Twitter.c generated by valac 0.30.0, the Vala compiler
 * generated from Twitter.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <gio/gio.h>


#define TYPE_TWITTER (twitter_get_type ())
#define TWITTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWITTER, Twitter))
#define TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWITTER, TwitterClass))
#define IS_TWITTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWITTER))
#define IS_TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWITTER))
#define TWITTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWITTER, TwitterClass))

typedef struct _Twitter Twitter;
typedef struct _TwitterClass TwitterClass;
typedef struct _TwitterPrivate TwitterPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block24Data Block24Data;
typedef struct _Block25Data Block25Data;

struct _Twitter {
	GObject parent_instance;
	TwitterPrivate * priv;
	GeeHashMap* avatars;
	GeeHashMap* avatar_refcounts;
};

struct _TwitterClass {
	GObjectClass parent_class;
};

typedef void (*TwitterAvatarDownloadedFunc) (cairo_surface_t* avatar, void* user_data);
struct _Block24Data {
	int _ref_count_;
	Twitter* self;
	gchar* url;
	TwitterAvatarDownloadedFunc func;
	gpointer func_target;
	GDestroyNotify func_target_destroy_notify;
};

struct _Block25Data {
	int _ref_count_;
	Block24Data * _data24_;
	gulong handler_id;
};


static gpointer twitter_parent_class = NULL;
static Twitter* twitter_twitter;
static Twitter* twitter_twitter = NULL;
extern gint twitter_short_url_length;
gint twitter_short_url_length = 22;
extern gint twitter_short_url_length_https;
gint twitter_short_url_length_https = 23;
extern gint twitter_max_media_per_upload;
gint twitter_max_media_per_upload = 4;
extern cairo_surface_t* twitter_no_avatar;
cairo_surface_t* twitter_no_avatar = NULL;
extern GdkPixbuf* twitter_no_banner;
GdkPixbuf* twitter_no_banner = NULL;

GType twitter_get_type (void) G_GNUC_CONST;
enum  {
	TWITTER_DUMMY_PROPERTY
};
Twitter* twitter_get (void);
Twitter* twitter_new (void);
Twitter* twitter_construct (GType object_type);
void twitter_init (Twitter* self);
void twitter_ref_avatar (cairo_surface_t* surface);
void twitter_unref_avatar (cairo_surface_t* surface);
cairo_surface_t* twitter_get_avatar (Twitter* self, const gchar* url, TwitterAvatarDownloadedFunc func, void* func_target, GDestroyNotify func_target_destroy_notify, gint size);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (void * _userdata_);
static Block25Data* block25_data_ref (Block25Data* _data25_);
static void block25_data_unref (void * _userdata_);
static void ___lambda8_ (Block25Data* _data25_, cairo_surface_t* ava);
static void ____lambda8__twitter_avatar_downloaded (Twitter* _sender, cairo_surface_t* avatar, gpointer self);
void tweet_utils_download_avatar (const gchar* avatar_url, gint size, GAsyncReadyCallback _callback_, gpointer _user_data_);
GdkPixbuf* tweet_utils_download_avatar_finish (GAsyncResult* _res_, GError** error);
static void ___lambda10_ (Block24Data* _data24_, GObject* obj, GAsyncResult* res);
static void ____lambda10__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void twitter_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


Twitter* twitter_get (void) {
	Twitter* result = NULL;
	Twitter* _tmp0_ = NULL;
	Twitter* _tmp2_ = NULL;
	Twitter* _tmp3_ = NULL;
	_tmp0_ = twitter_twitter;
	if (_tmp0_ == NULL) {
		Twitter* _tmp1_ = NULL;
		_tmp1_ = twitter_new ();
		_g_object_unref0 (twitter_twitter);
		twitter_twitter = _tmp1_;
	}
	_tmp2_ = twitter_twitter;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


Twitter* twitter_construct (GType object_type) {
	Twitter * self = NULL;
	self = (Twitter*) g_object_new (object_type, NULL);
	return self;
}


Twitter* twitter_new (void) {
	return twitter_construct (TYPE_TWITTER);
}


void twitter_init (Twitter* self) {
	GeeHashMap* _tmp7_ = NULL;
	GeeHashMap* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (IS_TWITTER (self));
	{
		GdkPixbuf* _tmp0_ = NULL;
		GdkPixbuf* _tmp1_ = NULL;
		cairo_surface_t* _tmp2_ = NULL;
		GdkPixbuf* _tmp3_ = NULL;
		GdkPixbuf* _tmp4_ = NULL;
		GdkPixbuf* _tmp5_ = NULL;
		_tmp1_ = gdk_pixbuf_new_from_resource ("/org/baedert/corebird/assets/no_avatar.png", &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch30_g_error;
		}
		_tmp2_ = gdk_cairo_surface_create_from_pixbuf (_tmp0_, 1, NULL);
		_cairo_surface_destroy0 (twitter_no_avatar);
		twitter_no_avatar = _tmp2_;
		_tmp4_ = gdk_pixbuf_new_from_resource ("/org/baedert/corebird/assets/no_banner.png", &_inner_error_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			goto __catch30_g_error;
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		_g_object_unref0 (twitter_no_banner);
		twitter_no_banner = _tmp5_;
		_g_object_unref0 (_tmp3_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally30;
	__catch30_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp6_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e->message;
		g_error ("Twitter.vala:54: Error while loading assets: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally30:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_POINTER, (GBoxedCopyFunc) cairo_surface_reference, cairo_surface_destroy, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->avatars);
	self->avatars = _tmp7_;
	_tmp8_ = gee_hash_map_new (G_TYPE_POINTER, (GBoxedCopyFunc) cairo_surface_reference, cairo_surface_destroy, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->avatar_refcounts);
	self->avatar_refcounts = _tmp8_;
}


void twitter_ref_avatar (cairo_surface_t* surface) {
	guint cur = 0U;
	Twitter* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	cairo_surface_t* _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
	Twitter* _tmp4_ = NULL;
	GeeHashMap* _tmp5_ = NULL;
	cairo_surface_t* _tmp6_ = NULL;
	Twitter* _tmp7_ = NULL;
	GeeHashMap* _tmp8_ = NULL;
	cairo_surface_t* _tmp9_ = NULL;
	g_return_if_fail (surface != NULL);
	_tmp0_ = twitter_twitter;
	_tmp1_ = _tmp0_->avatar_refcounts;
	_tmp2_ = surface;
	_tmp3_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp2_);
	cur = (guint) ((guintptr) _tmp3_);
	_tmp4_ = twitter_twitter;
	_tmp5_ = _tmp4_->avatar_refcounts;
	_tmp6_ = surface;
	gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp6_, NULL);
	_tmp7_ = twitter_twitter;
	_tmp8_ = _tmp7_->avatar_refcounts;
	_tmp9_ = surface;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp9_, (gpointer) ((guintptr) (cur + 1)));
}


void twitter_unref_avatar (cairo_surface_t* surface) {
	guint cur = 0U;
	Twitter* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	cairo_surface_t* _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
	guint next = 0U;
	guint _tmp4_ = 0U;
	Twitter* _tmp5_ = NULL;
	GeeHashMap* _tmp6_ = NULL;
	cairo_surface_t* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	g_return_if_fail (surface != NULL);
	_tmp0_ = twitter_twitter;
	_tmp1_ = _tmp0_->avatar_refcounts;
	_tmp2_ = surface;
	_tmp3_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp2_);
	cur = (guint) ((guintptr) _tmp3_);
	_tmp4_ = cur;
	next = _tmp4_ - 1;
	_tmp5_ = twitter_twitter;
	_tmp6_ = _tmp5_->avatar_refcounts;
	_tmp7_ = surface;
	gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp7_, NULL);
	_tmp8_ = next;
	if (_tmp8_ > ((guint) 0)) {
		Twitter* _tmp9_ = NULL;
		GeeHashMap* _tmp10_ = NULL;
		cairo_surface_t* _tmp11_ = NULL;
		guint _tmp12_ = 0U;
		_tmp9_ = twitter_twitter;
		_tmp10_ = _tmp9_->avatar_refcounts;
		_tmp11_ = surface;
		_tmp12_ = next;
		gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp11_, (gpointer) ((guintptr) _tmp12_));
	} else {
		GeeMapIterator* iter = NULL;
		Twitter* _tmp13_ = NULL;
		GeeHashMap* _tmp14_ = NULL;
		GeeMapIterator* _tmp15_ = NULL;
		gchar* path = NULL;
		const gchar* _tmp25_ = NULL;
		_tmp13_ = twitter_twitter;
		_tmp14_ = _tmp13_->avatars;
		_tmp15_ = gee_abstract_map_map_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
		iter = _tmp15_;
		path = NULL;
		while (TRUE) {
			GeeMapIterator* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			GeeMapIterator* _tmp18_ = NULL;
			gpointer _tmp19_ = NULL;
			cairo_surface_t* _tmp20_ = NULL;
			cairo_surface_t* _tmp21_ = NULL;
			gboolean _tmp22_ = FALSE;
			_tmp16_ = iter;
			_tmp17_ = gee_map_iterator_next (_tmp16_);
			if (!_tmp17_) {
				break;
			}
			_tmp18_ = iter;
			_tmp19_ = gee_map_iterator_get_value (_tmp18_);
			_tmp20_ = (cairo_surface_t*) _tmp19_;
			_tmp21_ = surface;
			_tmp22_ = _tmp20_ == _tmp21_;
			_cairo_surface_destroy0 (_tmp20_);
			if (_tmp22_) {
				GeeMapIterator* _tmp23_ = NULL;
				gpointer _tmp24_ = NULL;
				_tmp23_ = iter;
				_tmp24_ = gee_map_iterator_get_key (_tmp23_);
				_g_free0 (path);
				path = (gchar*) _tmp24_;
				break;
			}
		}
		_tmp25_ = path;
		if (_tmp25_ != NULL) {
			Twitter* _tmp26_ = NULL;
			GeeHashMap* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
			_tmp26_ = twitter_twitter;
			_tmp27_ = _tmp26_->avatars;
			_tmp28_ = path;
			gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp28_, NULL);
		}
		_g_free0 (path);
		_g_object_unref0 (iter);
	}
}


/**
   * Get the avatar with the given url. If the avatar exists on the
   * hard drive already, it is loaded and returned immediately. If
   * the avatar is in memory already, that version is returned.
   * If the avatar is neither on disk nor in memory, it will be downladed
   * first and set via the supplied `func`.
   *
   * Example usage:
   *
   * Gdk.Pixbuf? a = get_avatar("http://foo", (avatar) => {
   *   a = avatar;
   * });
   * (a may be null here)
   *
   * @param url The url of the avatar to return
   * @param func The AvatarDownloadedFunc to call once the avatar has been
   *             downloaded successfully.
   *
   * @return The requested avatar if it was already downloaded/in ram, or null
   *         if it has to be downloaded first, in which case the AvatarDownloadedFunc
   *         will be called after that's finished.
   */
static Block24Data* block24_data_ref (Block24Data* _data24_) {
	g_atomic_int_inc (&_data24_->_ref_count_);
	return _data24_;
}


static void block24_data_unref (void * _userdata_) {
	Block24Data* _data24_;
	_data24_ = (Block24Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
		Twitter* self;
		self = _data24_->self;
		_g_free0 (_data24_->url);
		(_data24_->func_target_destroy_notify == NULL) ? NULL : (_data24_->func_target_destroy_notify (_data24_->func_target), NULL);
		_data24_->func = NULL;
		_data24_->func_target = NULL;
		_data24_->func_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block24Data, _data24_);
	}
}


static Block25Data* block25_data_ref (Block25Data* _data25_) {
	g_atomic_int_inc (&_data25_->_ref_count_);
	return _data25_;
}


static void block25_data_unref (void * _userdata_) {
	Block25Data* _data25_;
	_data25_ = (Block25Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data25_->_ref_count_)) {
		Twitter* self;
		self = _data25_->_data24_->self;
		block24_data_unref (_data25_->_data24_);
		_data25_->_data24_ = NULL;
		g_slice_free (Block25Data, _data25_);
	}
}


static void ___lambda8_ (Block25Data* _data25_, cairo_surface_t* ava) {
	Block24Data* _data24_;
	Twitter* self;
	TwitterAvatarDownloadedFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	cairo_surface_t* _tmp1_ = NULL;
	gulong _tmp2_ = 0UL;
	_data24_ = _data25_->_data24_;
	self = _data24_->self;
	g_return_if_fail (ava != NULL);
	_tmp0_ = _data24_->func;
	_tmp0__target = _data24_->func_target;
	_tmp1_ = ava;
	_tmp0_ (_tmp1_, _tmp0__target);
	_tmp2_ = _data25_->handler_id;
	g_signal_handler_disconnect (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), _tmp2_);
}


static void ____lambda8__twitter_avatar_downloaded (Twitter* _sender, cairo_surface_t* avatar, gpointer self) {
	___lambda8_ (self, avatar);
}


static void ___lambda10_ (Block24Data* _data24_, GObject* obj, GAsyncResult* res) {
	Twitter* self;
	GdkPixbuf* avatar = NULL;
	cairo_surface_t* s = NULL;
	GdkPixbuf* _tmp16_ = NULL;
	cairo_surface_t* _tmp17_ = NULL;
	TwitterAvatarDownloadedFunc _tmp18_ = NULL;
	void* _tmp18__target = NULL;
	cairo_surface_t* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	cairo_surface_t* _tmp22_ = NULL;
	GeeHashMap* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	cairo_surface_t* _tmp25_ = NULL;
	GeeHashMap* _tmp26_ = NULL;
	cairo_surface_t* _tmp27_ = NULL;
	GError * _inner_error_ = NULL;
	self = _data24_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	avatar = NULL;
	{
		GdkPixbuf* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		GdkPixbuf* _tmp2_ = NULL;
		GdkPixbuf* _tmp3_ = NULL;
		_tmp1_ = res;
		_tmp2_ = tweet_utils_download_avatar_finish (_tmp1_, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch31_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (avatar);
		avatar = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally31;
	__catch31_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		TwitterAvatarDownloadedFunc _tmp11_ = NULL;
		void* _tmp11__target = NULL;
		cairo_surface_t* _tmp12_ = NULL;
		GeeHashMap* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		cairo_surface_t* _tmp15_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = g_strconcat (_tmp5_, " for ", NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = _data24_->url;
		_tmp9_ = g_strconcat (_tmp7_, _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		g_warning ("Twitter.vala:137: %s", _tmp10_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp7_);
		_tmp11_ = _data24_->func;
		_tmp11__target = _data24_->func_target;
		_tmp12_ = twitter_no_avatar;
		_tmp11_ (_tmp12_, _tmp11__target);
		_tmp13_ = self->avatars;
		_tmp14_ = _data24_->url;
		_tmp15_ = twitter_no_avatar;
		gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp14_, _tmp15_);
		_g_error_free0 (e);
		_g_object_unref0 (avatar);
		return;
	}
	__finally31:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (avatar);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp16_ = avatar;
	_tmp17_ = gdk_cairo_surface_create_from_pixbuf (_tmp16_, 1, NULL);
	s = _tmp17_;
	_tmp18_ = _data24_->func;
	_tmp18__target = _data24_->func_target;
	_tmp19_ = s;
	_tmp18_ (_tmp19_, _tmp18__target);
	_tmp20_ = _data24_->url;
	_tmp21_ = g_strconcat ("avatar-downloaded::", _tmp20_, NULL);
	_tmp22_ = s;
	g_signal_emit_by_name (self, _tmp21_, _tmp22_);
	_g_free0 (_tmp21_);
	_tmp23_ = self->avatars;
	_tmp24_ = _data24_->url;
	_tmp25_ = s;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp24_, _tmp25_);
	_tmp26_ = self->avatar_refcounts;
	_tmp27_ = s;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp27_, (gpointer) ((guintptr) ((guint) 0)));
	_cairo_surface_destroy0 (s);
	_g_object_unref0 (avatar);
}


static void ____lambda10__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda10_ (self, source_object, res);
	block24_data_unref (self);
}


cairo_surface_t* twitter_get_avatar (Twitter* self, const gchar* url, TwitterAvatarDownloadedFunc func, void* func_target, GDestroyNotify func_target_destroy_notify, gint size) {
	cairo_surface_t* result = NULL;
	Block24Data* _data24_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	TwitterAvatarDownloadedFunc _tmp2_ = NULL;
	void* _tmp2__target = NULL;
	cairo_surface_t* a = NULL;
	GeeHashMap* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gpointer _tmp5_ = NULL;
	gboolean has_key = FALSE;
	GeeHashMap* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	cairo_surface_t* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	g_return_val_if_fail (IS_TWITTER (self), NULL);
	g_return_val_if_fail (url != NULL, NULL);
	_data24_ = g_slice_new0 (Block24Data);
	_data24_->_ref_count_ = 1;
	_data24_->self = g_object_ref (self);
	_tmp0_ = url;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data24_->url);
	_data24_->url = _tmp1_;
	_tmp2_ = func;
	_tmp2__target = func_target;
	(_data24_->func_target_destroy_notify == NULL) ? NULL : (_data24_->func_target_destroy_notify (_data24_->func_target), NULL);
	_data24_->func = NULL;
	_data24_->func_target = NULL;
	_data24_->func_target_destroy_notify = NULL;
	_data24_->func = _tmp2_;
	_data24_->func_target = _tmp2__target;
	_data24_->func_target_destroy_notify = func_target_destroy_notify;
	_tmp3_ = self->avatars;
	_tmp4_ = _data24_->url;
	_tmp5_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp4_);
	a = (cairo_surface_t*) _tmp5_;
	_tmp6_ = self->avatars;
	_tmp7_ = _data24_->url;
	_tmp8_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp7_);
	has_key = _tmp8_;
	_tmp9_ = a;
	if (_tmp9_ != NULL) {
		result = a;
		block24_data_unref (_data24_);
		_data24_ = NULL;
		return result;
	}
	_tmp10_ = has_key;
	if (_tmp10_) {
		Block25Data* _data25_;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gulong _tmp13_ = 0UL;
		_data25_ = g_slice_new0 (Block25Data);
		_data25_->_ref_count_ = 1;
		_data25_->_data24_ = block24_data_ref (_data24_);
		_data25_->handler_id = (gulong) 0;
		_tmp11_ = _data24_->url;
		_tmp12_ = g_strconcat ("avatar-downloaded::", _tmp11_, NULL);
		_tmp13_ = g_signal_connect_data (self, _tmp12_, (GCallback) ____lambda8__twitter_avatar_downloaded, block25_data_ref (_data25_), (GClosureNotify) block25_data_unref, 0);
		_data25_->handler_id = _tmp13_;
		_g_free0 (_tmp12_);
		block25_data_unref (_data25_);
		_data25_ = NULL;
	} else {
		GeeHashMap* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		_tmp14_ = self->avatars;
		_tmp15_ = _data24_->url;
		gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp15_, NULL);
		_tmp16_ = _data24_->url;
		_tmp17_ = size;
		tweet_utils_download_avatar (_tmp16_, _tmp17_, ____lambda10__gasync_ready_callback, block24_data_ref (_data24_));
	}
	result = NULL;
	_cairo_surface_destroy0 (a);
	block24_data_unref (_data24_);
	_data24_ = NULL;
	return result;
}


static void twitter_class_init (TwitterClass * klass) {
	twitter_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = twitter_finalize;
	g_signal_new ("avatar_downloaded", TYPE_TWITTER, G_SIGNAL_RUN_LAST | G_SIGNAL_DETAILED, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
}


static void twitter_instance_init (Twitter * self) {
}


static void twitter_finalize (GObject* obj) {
	Twitter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TWITTER, Twitter);
	_g_object_unref0 (self->avatars);
	_g_object_unref0 (self->avatar_refcounts);
	G_OBJECT_CLASS (twitter_parent_class)->finalize (obj);
}


GType twitter_get_type (void) {
	static volatile gsize twitter_type_id__volatile = 0;
	if (g_once_init_enter (&twitter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TwitterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) twitter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Twitter), 0, (GInstanceInitFunc) twitter_instance_init, NULL };
		GType twitter_type_id;
		twitter_type_id = g_type_register_static (G_TYPE_OBJECT, "Twitter", &g_define_type_info, 0);
		g_once_init_leave (&twitter_type_id__volatile, twitter_type_id);
	}
	return twitter_type_id__volatile;
}



