/* InlineMediaDownloader.c generated by valac 0.30.0, the Vala compiler
 * generated from InlineMediaDownloader.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <cairo.h>
#include <libsoup/soup.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>


#define TYPE_INLINE_MEDIA_DOWNLOADER (inline_media_downloader_get_type ())
#define INLINE_MEDIA_DOWNLOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INLINE_MEDIA_DOWNLOADER, InlineMediaDownloader))
#define INLINE_MEDIA_DOWNLOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INLINE_MEDIA_DOWNLOADER, InlineMediaDownloaderClass))
#define IS_INLINE_MEDIA_DOWNLOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INLINE_MEDIA_DOWNLOADER))
#define IS_INLINE_MEDIA_DOWNLOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INLINE_MEDIA_DOWNLOADER))
#define INLINE_MEDIA_DOWNLOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INLINE_MEDIA_DOWNLOADER, InlineMediaDownloaderClass))

typedef struct _InlineMediaDownloader InlineMediaDownloader;
typedef struct _InlineMediaDownloaderClass InlineMediaDownloaderClass;
typedef struct _InlineMediaDownloaderPrivate InlineMediaDownloaderPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _mini_tweet_unref0(var) ((var == NULL) ? NULL : (var = (mini_tweet_unref (var), NULL)))

#define TYPE_MINI_TWEET (mini_tweet_get_type ())
#define MINI_TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINI_TWEET, MiniTweet))
#define MINI_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINI_TWEET, MiniTweetClass))
#define IS_MINI_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINI_TWEET))
#define IS_MINI_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINI_TWEET))
#define MINI_TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINI_TWEET, MiniTweetClass))

typedef struct _MiniTweet MiniTweet;
typedef struct _MiniTweetClass MiniTweetClass;

#define TYPE_MEDIA (media_get_type ())
#define MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA, Media))
#define MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA, MediaClass))
#define IS_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA))
#define IS_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA))
#define MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA, MediaClass))

typedef struct _Media Media;
typedef struct _MediaClass MediaClass;
typedef struct _InlineMediaDownloaderLoadMediaData InlineMediaDownloaderLoadMediaData;
typedef struct _MediaPrivate MediaPrivate;

#define TYPE_MEDIA_TYPE (media_type_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block20Data Block20Data;
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _InlineMediaDownloaderLoadRealUrlData InlineMediaDownloaderLoadRealUrlData;
typedef struct _Block21Data Block21Data;
typedef struct _Block22Data Block22Data;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef struct _Block23Data Block23Data;
typedef struct _InlineMediaDownloaderLoadInlineMediaData InlineMediaDownloaderLoadInlineMediaData;
typedef struct _MiniTweetPrivate MiniTweetPrivate;

#define TYPE_USER_IDENTITY (user_identity_get_type ())
typedef struct _UserIdentity UserIdentity;

#define TYPE_TEXT_ENTITY (text_entity_get_type ())
typedef struct _TextEntity TextEntity;
typedef struct _InlineMediaDownloaderLoadAnimationData InlineMediaDownloaderLoadAnimationData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _InlineMediaDownloader {
	GObject parent_instance;
	InlineMediaDownloaderPrivate * priv;
};

struct _InlineMediaDownloaderClass {
	GObjectClass parent_class;
};

struct _InlineMediaDownloaderPrivate {
	GeeArrayList* urls_downloading;
};

struct _InlineMediaDownloaderLoadMediaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	InlineMediaDownloader* self;
	MiniTweet* t;
	Media* media;
	MiniTweet* _tmp0_;
	Media* _tmp1_;
};

typedef enum  {
	MEDIA_TYPE_IMAGE,
	MEDIA_TYPE_VINE,
	MEDIA_TYPE_GIF,
	MEDIA_TYPE_ANIMATED_GIF,
	MEDIA_TYPE_TWITTER_VIDEO,
	MEDIA_TYPE_UNKNOWN
} MediaType;

struct _Media {
	GObject parent_instance;
	MediaPrivate * priv;
	gint64 id;
	gchar* path;
	gchar* thumb_path;
	gchar* url;
	MediaType type;
	cairo_surface_t* thumbnail;
	gboolean loaded;
	gboolean invalid;
};

struct _MediaClass {
	GObjectClass parent_class;
};

struct _Block20Data {
	int _ref_count_;
	InlineMediaDownloader* self;
	SoupMessage* msg;
	Media* media;
	gchar* regex_str1;
	gint match_index1;
	gpointer _async_data_;
};

struct _InlineMediaDownloaderLoadRealUrlData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	InlineMediaDownloader* self;
	MiniTweet* t;
	Media* media;
	gchar* regex_str1;
	gint match_index1;
	Block20Data* _data20_;
	Media* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	Media* _tmp3_;
	const gchar* _tmp4_;
	SoupMessage* _tmp5_;
	SoupSession* _tmp6_;
	SoupMessage* _tmp7_;
};

struct _Block21Data {
	int _ref_count_;
	InlineMediaDownloader* self;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	GOutputStream* thumb_out_stream;
	GOutputStream* media_out_stream;
	SoupMessage* msg;
	MiniTweet* t;
	Media* media;
	gpointer _async_data_;
};

struct _Block22Data {
	int _ref_count_;
	Block21Data * _data21_;
	gulong id;
};

struct _Block23Data {
	int _ref_count_;
	Block21Data * _data21_;
	GMemoryInputStream* ms;
};

struct _InlineMediaDownloaderLoadInlineMediaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	InlineMediaDownloader* self;
	MiniTweet* t;
	Media* media;
	Block21Data* _data21_;
	MiniTweet* _tmp0_;
	Media* _tmp1_;
	Media* _tmp2_;
	MiniTweet* _tmp3_;
	Media* _tmp4_;
	gchar* _tmp5_;
	Media* _tmp6_;
	MiniTweet* _tmp7_;
	Media* _tmp8_;
	gchar* _tmp9_;
	GeeArrayList* _tmp10_;
	Media* _tmp11_;
	const gchar* _tmp12_;
	gboolean _tmp13_;
	Block22Data* _data22_;
	Media* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gulong _tmp17_;
	gboolean main_file_exists;
	GFileOutputStream* _tmp18_;
	Media* _tmp19_;
	const gchar* _tmp20_;
	GFile* _tmp21_;
	GFile* _tmp22_;
	GFileOutputStream* _tmp23_;
	GFileOutputStream* _tmp24_;
	GFileOutputStream* _tmp25_;
	GError* e;
	GError* _tmp26_;
	GError* _tmp27_;
	const gchar* _tmp28_;
	GFileOutputStream* _tmp29_;
	Media* _tmp30_;
	const gchar* _tmp31_;
	GFile* _tmp32_;
	GFile* _tmp33_;
	GFileOutputStream* _tmp34_;
	GFileOutputStream* _tmp35_;
	GFileOutputStream* _tmp36_;
	gboolean _tmp37_;
	GFileInputStream* in_stream;
	Media* _tmp38_;
	const gchar* _tmp39_;
	GFile* _tmp40_;
	GFile* _tmp41_;
	GFileInputStream* _tmp42_;
	GFileInputStream* _tmp43_;
	MiniTweet* _tmp44_;
	GFileInputStream* _tmp45_;
	GOutputStream* _tmp46_;
	Media* _tmp47_;
	GFileInputStream* _tmp48_;
	GOutputStream* _tmp49_;
	GError* _vala1_e;
	GError* _tmp50_;
	const gchar* _tmp51_;
	GError* _vala2_e;
	GError* _tmp52_;
	gboolean _tmp53_;
	Media* _tmp54_;
	Media* _tmp55_;
	const gchar* _tmp56_;
	cairo_surface_t* _tmp57_;
	Media* _tmp58_;
	cairo_surface_t* _tmp59_;
	Media* _tmp60_;
	const gchar* _tmp61_;
	Media* _tmp62_;
	Media* _tmp63_;
	Media* _tmp64_;
	Media* _tmp65_;
	const gchar* _tmp66_;
	GFileOutputStream* _tmp67_;
	Media* _tmp68_;
	const gchar* _tmp69_;
	GFile* _tmp70_;
	GFile* _tmp71_;
	GFileOutputStream* _tmp72_;
	GFileOutputStream* _tmp73_;
	GFileOutputStream* _tmp74_;
	GError* _vala3_e;
	GError* _tmp75_;
	const gchar* _tmp76_;
	GError* _tmp77_;
	const gchar* _tmp78_;
	gchar* url;
	Media* _tmp79_;
	const gchar* _tmp80_;
	gchar* _tmp81_;
	gboolean _tmp82_;
	gboolean _tmp83_;
	gboolean _tmp84_;
	gboolean _tmp85_;
	gboolean _tmp86_;
	gboolean _tmp87_;
	gboolean _tmp88_;
	const gchar* _tmp89_;
	gboolean _tmp90_;
	const gchar* _tmp91_;
	gboolean _tmp92_;
	const gchar* _tmp93_;
	gboolean _tmp94_;
	const gchar* _tmp95_;
	gboolean _tmp96_;
	const gchar* _tmp97_;
	gboolean _tmp98_;
	const gchar* _tmp99_;
	gboolean _tmp100_;
	const gchar* _tmp101_;
	gboolean _tmp102_;
	const gchar* _tmp103_;
	gboolean _tmp104_;
	MiniTweet* _tmp105_;
	Media* _tmp106_;
	const gchar* _tmp107_;
	gboolean _tmp108_;
	MiniTweet* _tmp109_;
	Media* _tmp110_;
	const gchar* _tmp111_;
	gboolean _tmp112_;
	MiniTweet* _tmp113_;
	Media* _tmp114_;
	const gchar* _tmp115_;
	gboolean _tmp116_;
	MiniTweet* _tmp117_;
	Media* _tmp118_;
	const gchar* _tmp119_;
	gboolean _tmp120_;
	MiniTweet* _tmp121_;
	Media* _tmp122_;
	Media* _tmp123_;
	const gchar* _tmp124_;
	const gchar* _tmp125_;
	SoupMessage* _tmp126_;
	SoupMessage* _tmp127_;
	SoupMessage* _tmp128_;
	GeeArrayList* _tmp129_;
	Media* _tmp130_;
	const gchar* _tmp131_;
	gboolean _tmp132_;
	GeeArrayList* _tmp133_;
	Media* _tmp134_;
	const gchar* _tmp135_;
	SoupSession* _tmp136_;
	SoupMessage* _tmp137_;
	SoupMessage* _tmp138_;
	GError * _inner_error_;
};

struct _UserIdentity {
	gint64 id;
	gchar* screen_name;
	gchar* user_name;
};

struct _TextEntity {
	guint from;
	guint to;
	gchar* display_text;
	gchar* tooltip_text;
	gchar* target;
	guint info;
};

struct _MiniTweet {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MiniTweetPrivate * priv;
	gint64 id;
	gint64 created_at;
	UserIdentity author;
	gchar* text;
	TextEntity* entities;
	gint entities_length1;
	Media** medias;
	gint medias_length1;
};

struct _MiniTweetClass {
	GTypeClass parent_class;
	void (*finalize) (MiniTweet *self);
};

struct _InlineMediaDownloaderLoadAnimationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	InlineMediaDownloader* self;
	MiniTweet* t;
	GInputStream* in_stream;
	GOutputStream* thumb_out_stream;
	Media* media;
	GdkPixbufAnimation* anim;
	GdkPixbufAnimation* _tmp0_;
	GInputStream* _tmp1_;
	GdkPixbufAnimation* _tmp2_;
	GdkPixbufAnimation* _tmp3_;
	GError* e;
	Media* _tmp4_;
	const gchar* _tmp5_;
	GError* _tmp6_;
	const gchar* _tmp7_;
	Media* _tmp8_;
	GInputStream* _tmp9_;
	GOutputStream* _tmp10_;
	GdkPixbuf* pic;
	GdkPixbufAnimation* _tmp11_;
	GdkPixbuf* _tmp12_;
	GdkPixbuf* _tmp13_;
	gint thumb_width;
	MiniTweet* _tmp14_;
	Media** _tmp15_;
	gint _tmp15__length1;
	GdkPixbuf* thumb;
	GdkPixbuf* _tmp16_;
	gint _tmp17_;
	GdkPixbuf* _tmp18_;
	GdkPixbuf* _tmp19_;
	GOutputStream* _tmp20_;
	Media* _tmp21_;
	GdkPixbuf* _tmp22_;
	cairo_surface_t* _tmp23_;
	Media* _tmp24_;
	Media* _tmp25_;
	GError * _inner_error_;
};


static gpointer inline_media_downloader_parent_class = NULL;
static InlineMediaDownloader* inline_media_downloader_instance;
static InlineMediaDownloader* inline_media_downloader_instance = NULL;
extern SoupSession* SOUP_SESSION;

gboolean is_media_candidate (const gchar* url);
gdouble settings_max_media_size (void);
GType inline_media_downloader_get_type (void) G_GNUC_CONST;
#define INLINE_MEDIA_DOWNLOADER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_INLINE_MEDIA_DOWNLOADER, InlineMediaDownloaderPrivate))
enum  {
	INLINE_MEDIA_DOWNLOADER_DUMMY_PROPERTY
};
static InlineMediaDownloader* inline_media_downloader_new (void);
static InlineMediaDownloader* inline_media_downloader_construct (GType object_type);
InlineMediaDownloader* inline_media_downloader_get (void);
static void inline_media_downloader_load_media_data_free (gpointer _data);
gpointer mini_tweet_ref (gpointer instance);
void mini_tweet_unref (gpointer instance);
GParamSpec* param_spec_mini_tweet (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_mini_tweet (GValue* value, gpointer v_object);
void value_take_mini_tweet (GValue* value, gpointer v_object);
gpointer value_get_mini_tweet (const GValue* value);
GType mini_tweet_get_type (void) G_GNUC_CONST;
GType media_get_type (void) G_GNUC_CONST;
void inline_media_downloader_load_media (InlineMediaDownloader* self, MiniTweet* t, Media* media, GAsyncReadyCallback _callback_, gpointer _user_data_);
void inline_media_downloader_load_media_finish (InlineMediaDownloader* self, GAsyncResult* _res_);
static gboolean inline_media_downloader_load_media_co (InlineMediaDownloaderLoadMediaData* _data_);
static void inline_media_downloader_load_inline_media (InlineMediaDownloader* self, MiniTweet* t, Media* media, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void inline_media_downloader_load_inline_media_finish (InlineMediaDownloader* self, GAsyncResult* _res_);
static void inline_media_downloader_load_media_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void inline_media_downloader_load_all_media (InlineMediaDownloader* self, MiniTweet* t, Media** medias, int medias_length1);
static void inline_media_downloader_mark_invalid (Media* m, GInputStream* in_stream, GOutputStream* out_stream, GOutputStream* out_stream2);
GType media_type_get_type (void) G_GNUC_CONST;
static void inline_media_downloader_load_real_url_data_free (gpointer _data);
static void inline_media_downloader_load_real_url (InlineMediaDownloader* self, MiniTweet* t, Media* media, const gchar* regex_str1, gint match_index1, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void inline_media_downloader_load_real_url_finish (InlineMediaDownloader* self, GAsyncResult* _res_);
static gboolean inline_media_downloader_load_real_url_co (InlineMediaDownloaderLoadRealUrlData* _data_);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
static void __lambda35_ (Block20Data* _data20_, SoupSession* _s, SoupMessage* _msg);
void media_set_thumb_url (Media* self, const gchar* value);
static void ___lambda35__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
static void inline_media_downloader_load_inline_media_data_free (gpointer _data);
static gboolean inline_media_downloader_load_inline_media_co (InlineMediaDownloaderLoadInlineMediaData* _data_);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
static gboolean _inline_media_downloader_load_inline_media_co_gsource_func (gpointer self);
gchar* inline_media_downloader_get_media_path (InlineMediaDownloader* self, MiniTweet* t, Media* media);
gchar* inline_media_downloader_get_thumb_path (InlineMediaDownloader* self, MiniTweet* t, Media* media);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
static void ___lambda31_ (Block22Data* _data22_);
static void __lambda32_ (Block22Data* _data22_);
static void ___lambda32__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ____lambda31__inline_media_downloader_downloading (InlineMediaDownloader* _sender, gpointer self);
static void inline_media_downloader_load_animation (InlineMediaDownloader* self, MiniTweet* t, GInputStream* in_stream, GOutputStream* thumb_out_stream, Media* media, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void inline_media_downloader_load_animation_finish (InlineMediaDownloader* self, GAsyncResult* _res_);
static void inline_media_downloader_load_inline_media_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
cairo_surface_t* load_surface (const gchar* path);
const gchar* media_get_thumb_url (Media* self);
static void __lambda36_ (Block21Data* _data21_);
void media_set_length (Media* self, gint64 value);
static void ___lambda36__soup_message_got_headers (SoupMessage* _sender, gpointer self);
static void __lambda37_ (Block21Data* _data21_, SoupBuffer* buf);
gint64 media_get_length (Media* self);
gdouble media_get_percent_loaded (Media* self);
void media_set_percent_loaded (Media* self, gdouble value);
static void ___lambda37__soup_message_got_chunk (SoupMessage* _sender, SoupBuffer* chunk, gpointer self);
static void __lambda38_ (Block21Data* _data21_, SoupSession* s, SoupMessage* _msg);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (void * _userdata_);
static guint8* _vala_array_dup7 (guint8* self, int length);
static void ___lambda39_ (Block23Data* _data23_);
static void ____lambda39__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ___lambda38__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
static void inline_media_downloader_load_animation_data_free (gpointer _data);
static gboolean inline_media_downloader_load_animation_co (InlineMediaDownloaderLoadAnimationData* _data_);
static void inline_media_downloader_load_animation_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType user_identity_get_type (void) G_GNUC_CONST;
UserIdentity* user_identity_dup (const UserIdentity* self);
void user_identity_free (UserIdentity* self);
void user_identity_copy (const UserIdentity* self, UserIdentity* dest);
void user_identity_destroy (UserIdentity* self);
GType text_entity_get_type (void) G_GNUC_CONST;
TextEntity* text_entity_dup (const TextEntity* self);
void text_entity_free (TextEntity* self);
void text_entity_copy (const TextEntity* self, TextEntity* dest);
void text_entity_destroy (TextEntity* self);
GdkPixbuf* utils_slice_pixbuf (GdkPixbuf* pic, gint thumb_width, gint thumb_height);
#define MULTI_MEDIA_WIDGET_HEIGHT 60
void utils_write_pixbuf_async (GdkPixbuf* pixbuf, GOutputStream* out_stream, const gchar* type, GAsyncReadyCallback _callback_, gpointer _user_data_);
void utils_write_pixbuf_finish (GAsyncResult* _res_);
gchar* utils_get_file_type (const gchar* path);
gchar* dirs_cache (const gchar* path);
static void inline_media_downloader_finalize (GObject* obj);


gboolean is_media_candidate (const gchar* url) {
	gboolean result = FALSE;
	gdouble _tmp0_ = 0.0;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	g_return_val_if_fail (url != NULL, FALSE);
	_tmp0_ = settings_max_media_size ();
	if (_tmp0_ < 0.001) {
		result = FALSE;
		return result;
	}
	_tmp15_ = url;
	_tmp16_ = g_str_has_prefix (_tmp15_, "http://instagra.am");
	if (_tmp16_) {
		_tmp14_ = TRUE;
	} else {
		const gchar* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
		_tmp17_ = url;
		_tmp18_ = g_str_has_prefix (_tmp17_, "http://instagram.com/p/");
		_tmp14_ = _tmp18_;
	}
	if (_tmp14_) {
		_tmp13_ = TRUE;
	} else {
		const gchar* _tmp19_ = NULL;
		gboolean _tmp20_ = FALSE;
		_tmp19_ = url;
		_tmp20_ = g_str_has_prefix (_tmp19_, "https://instagr.am");
		_tmp13_ = _tmp20_;
	}
	if (_tmp13_) {
		_tmp12_ = TRUE;
	} else {
		const gchar* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
		_tmp21_ = url;
		_tmp22_ = g_str_has_prefix (_tmp21_, "https://instagram.com/p/");
		_tmp12_ = _tmp22_;
	}
	if (_tmp12_) {
		_tmp11_ = TRUE;
	} else {
		gboolean _tmp23_ = FALSE;
		const gchar* _tmp24_ = NULL;
		gboolean _tmp25_ = FALSE;
		_tmp24_ = url;
		_tmp25_ = g_str_has_prefix (_tmp24_, "http://i.imgur.com");
		if (_tmp25_) {
			const gchar* _tmp26_ = NULL;
			gboolean _tmp27_ = FALSE;
			_tmp26_ = url;
			_tmp27_ = g_str_has_suffix (_tmp26_, "gifv");
			_tmp23_ = !_tmp27_;
		} else {
			_tmp23_ = FALSE;
		}
		_tmp11_ = _tmp23_;
	}
	if (_tmp11_) {
		_tmp10_ = TRUE;
	} else {
		gboolean _tmp28_ = FALSE;
		const gchar* _tmp29_ = NULL;
		gboolean _tmp30_ = FALSE;
		_tmp29_ = url;
		_tmp30_ = g_str_has_prefix (_tmp29_, "https://i.imgur.com");
		if (_tmp30_) {
			const gchar* _tmp31_ = NULL;
			gboolean _tmp32_ = FALSE;
			_tmp31_ = url;
			_tmp32_ = g_str_has_suffix (_tmp31_, "gifv");
			_tmp28_ = !_tmp32_;
		} else {
			_tmp28_ = FALSE;
		}
		_tmp10_ = _tmp28_;
	}
	if (_tmp10_) {
		_tmp9_ = TRUE;
	} else {
		const gchar* _tmp33_ = NULL;
		gboolean _tmp34_ = FALSE;
		_tmp33_ = url;
		_tmp34_ = g_str_has_prefix (_tmp33_, "http://d.pr/i/");
		_tmp9_ = _tmp34_;
	}
	if (_tmp9_) {
		_tmp8_ = TRUE;
	} else {
		const gchar* _tmp35_ = NULL;
		gboolean _tmp36_ = FALSE;
		_tmp35_ = url;
		_tmp36_ = g_str_has_prefix (_tmp35_, "http://ow.ly/i/");
		_tmp8_ = _tmp36_;
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		const gchar* _tmp37_ = NULL;
		gboolean _tmp38_ = FALSE;
		_tmp37_ = url;
		_tmp38_ = g_str_has_prefix (_tmp37_, "http://www.flickr.com/photos/");
		_tmp7_ = _tmp38_;
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		const gchar* _tmp39_ = NULL;
		gboolean _tmp40_ = FALSE;
		_tmp39_ = url;
		_tmp40_ = g_str_has_prefix (_tmp39_, "https://www.flickr.com/photos/");
		_tmp6_ = _tmp40_;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp41_ = NULL;
		gboolean _tmp42_ = FALSE;
		_tmp41_ = url;
		_tmp42_ = g_str_has_prefix (_tmp41_, "https://vine.co/v/");
		_tmp5_ = _tmp42_;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp43_ = NULL;
		gboolean _tmp44_ = FALSE;
		_tmp43_ = url;
		_tmp44_ = g_str_has_suffix (_tmp43_, "/photo/1");
		_tmp4_ = _tmp44_;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp45_ = NULL;
		gboolean _tmp46_ = FALSE;
		_tmp45_ = url;
		_tmp46_ = g_str_has_prefix (_tmp45_, "https://video.twimg.com/ext_tw_video/");
		_tmp3_ = _tmp46_;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp47_ = NULL;
		gboolean _tmp48_ = FALSE;
		_tmp47_ = url;
		_tmp48_ = g_str_has_prefix (_tmp47_, "http://pbs.twimg.com/media/");
		_tmp2_ = _tmp48_;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp49_ = NULL;
		gboolean _tmp50_ = FALSE;
		_tmp49_ = url;
		_tmp50_ = g_str_has_prefix (_tmp49_, "http://twitpic.com/");
		_tmp1_ = _tmp50_;
	}
	result = _tmp1_;
	return result;
}


static InlineMediaDownloader* inline_media_downloader_construct (GType object_type) {
	InlineMediaDownloader * self = NULL;
	self = (InlineMediaDownloader*) g_object_new (object_type, NULL);
	return self;
}


static InlineMediaDownloader* inline_media_downloader_new (void) {
	return inline_media_downloader_construct (TYPE_INLINE_MEDIA_DOWNLOADER);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


InlineMediaDownloader* inline_media_downloader_get (void) {
	InlineMediaDownloader* result = NULL;
	InlineMediaDownloader* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	InlineMediaDownloader* _tmp3_ = NULL;
	InlineMediaDownloader* _tmp4_ = NULL;
	_tmp0_ = inline_media_downloader_instance;
	_tmp1_ = G_UNLIKELY (_tmp0_ == NULL);
	if (_tmp1_) {
		InlineMediaDownloader* _tmp2_ = NULL;
		_tmp2_ = inline_media_downloader_new ();
		_g_object_unref0 (inline_media_downloader_instance);
		inline_media_downloader_instance = _tmp2_;
	}
	_tmp3_ = inline_media_downloader_instance;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	result = _tmp4_;
	return result;
}


static void inline_media_downloader_load_media_data_free (gpointer _data) {
	InlineMediaDownloaderLoadMediaData* _data_;
	_data_ = _data;
	_mini_tweet_unref0 (_data_->t);
	_g_object_unref0 (_data_->media);
	_g_object_unref0 (_data_->self);
	g_slice_free (InlineMediaDownloaderLoadMediaData, _data_);
}


static gpointer _mini_tweet_ref0 (gpointer self) {
	return self ? mini_tweet_ref (self) : NULL;
}


void inline_media_downloader_load_media (InlineMediaDownloader* self, MiniTweet* t, Media* media, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	InlineMediaDownloaderLoadMediaData* _data_;
	InlineMediaDownloader* _tmp0_ = NULL;
	MiniTweet* _tmp1_ = NULL;
	MiniTweet* _tmp2_ = NULL;
	Media* _tmp3_ = NULL;
	Media* _tmp4_ = NULL;
	_data_ = g_slice_new0 (InlineMediaDownloaderLoadMediaData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, inline_media_downloader_load_media);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, inline_media_downloader_load_media_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = t;
	_tmp2_ = _mini_tweet_ref0 (_tmp1_);
	_mini_tweet_unref0 (_data_->t);
	_data_->t = _tmp2_;
	_tmp3_ = media;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->media);
	_data_->media = _tmp4_;
	inline_media_downloader_load_media_co (_data_);
}


void inline_media_downloader_load_media_finish (InlineMediaDownloader* self, GAsyncResult* _res_) {
	InlineMediaDownloaderLoadMediaData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void inline_media_downloader_load_media_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	InlineMediaDownloaderLoadMediaData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	inline_media_downloader_load_media_co (_data_);
}


static gboolean inline_media_downloader_load_media_co (InlineMediaDownloaderLoadMediaData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->t;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->media;
	_data_->_state_ = 1;
	inline_media_downloader_load_inline_media (_data_->self, _data_->_tmp0_, _data_->_tmp1_, inline_media_downloader_load_media_ready, _data_);
	return FALSE;
	_state_1:
	inline_media_downloader_load_inline_media_finish (_data_->self, _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void inline_media_downloader_load_all_media (InlineMediaDownloader* self, MiniTweet* t, Media** medias, int medias_length1) {
	Media** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_if_fail (IS_INLINE_MEDIA_DOWNLOADER (self));
	g_return_if_fail (IS_MINI_TWEET (t));
	_tmp0_ = medias;
	_tmp0__length1 = medias_length1;
	{
		Media** m_collection = NULL;
		gint m_collection_length1 = 0;
		gint _m_collection_size_ = 0;
		gint m_it = 0;
		m_collection = _tmp0_;
		m_collection_length1 = _tmp0__length1;
		for (m_it = 0; m_it < _tmp0__length1; m_it = m_it + 1) {
			Media* _tmp1_ = NULL;
			Media* m = NULL;
			_tmp1_ = _g_object_ref0 (m_collection[m_it]);
			m = _tmp1_;
			{
				MiniTweet* _tmp2_ = NULL;
				Media* _tmp3_ = NULL;
				_tmp2_ = t;
				_tmp3_ = m;
				inline_media_downloader_load_media (self, _tmp2_, _tmp3_, NULL, NULL);
				_g_object_unref0 (m);
			}
		}
	}
}


static void inline_media_downloader_mark_invalid (Media* m, GInputStream* in_stream, GOutputStream* out_stream, GOutputStream* out_stream2) {
	Media* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	Media* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	Media* _tmp4_ = NULL;
	Media* _tmp5_ = NULL;
	Media* _tmp14_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (IS_MEDIA (m));
	g_return_if_fail ((in_stream == NULL) || G_IS_INPUT_STREAM (in_stream));
	g_return_if_fail ((out_stream == NULL) || G_IS_OUTPUT_STREAM (out_stream));
	g_return_if_fail ((out_stream2 == NULL) || G_IS_OUTPUT_STREAM (out_stream2));
	_tmp0_ = m;
	_tmp1_ = _tmp0_->path;
	g_remove (_tmp1_);
	_tmp2_ = m;
	_tmp3_ = _tmp2_->thumb_path;
	g_remove (_tmp3_);
	_tmp4_ = m;
	_tmp4_->invalid = TRUE;
	_tmp5_ = m;
	_tmp5_->loaded = TRUE;
	{
		GInputStream* _tmp6_ = NULL;
		GOutputStream* _tmp8_ = NULL;
		GOutputStream* _tmp10_ = NULL;
		_tmp6_ = in_stream;
		if (_tmp6_ != NULL) {
			GInputStream* _tmp7_ = NULL;
			_tmp7_ = in_stream;
			g_input_stream_close (_tmp7_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch20_g_error;
			}
		}
		_tmp8_ = out_stream;
		if (_tmp8_ != NULL) {
			GOutputStream* _tmp9_ = NULL;
			_tmp9_ = out_stream;
			g_output_stream_close (_tmp9_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch20_g_error;
			}
		}
		_tmp10_ = out_stream2;
		if (_tmp10_ != NULL) {
			GOutputStream* _tmp11_ = NULL;
			_tmp11_ = out_stream2;
			g_output_stream_close (_tmp11_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch20_g_error;
			}
		}
	}
	goto __finally20;
	__catch20_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("InlineMediaDownloader.vala:87: %s", _tmp13_);
		_g_error_free0 (e);
	}
	__finally20:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp14_ = m;
	g_signal_emit_by_name (_tmp14_, "finished-loading");
}


static void inline_media_downloader_load_real_url_data_free (gpointer _data) {
	InlineMediaDownloaderLoadRealUrlData* _data_;
	_data_ = _data;
	_mini_tweet_unref0 (_data_->t);
	_g_object_unref0 (_data_->self);
	g_slice_free (InlineMediaDownloaderLoadRealUrlData, _data_);
}


static void inline_media_downloader_load_real_url (InlineMediaDownloader* self, MiniTweet* t, Media* media, const gchar* regex_str1, gint match_index1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	InlineMediaDownloaderLoadRealUrlData* _data_;
	InlineMediaDownloader* _tmp0_ = NULL;
	MiniTweet* _tmp1_ = NULL;
	MiniTweet* _tmp2_ = NULL;
	Media* _tmp3_ = NULL;
	Media* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	_data_ = g_slice_new0 (InlineMediaDownloaderLoadRealUrlData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, inline_media_downloader_load_real_url);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, inline_media_downloader_load_real_url_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = t;
	_tmp2_ = _mini_tweet_ref0 (_tmp1_);
	_mini_tweet_unref0 (_data_->t);
	_data_->t = _tmp2_;
	_tmp3_ = media;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->media);
	_data_->media = _tmp4_;
	_tmp5_ = regex_str1;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (_data_->regex_str1);
	_data_->regex_str1 = _tmp6_;
	_tmp7_ = match_index1;
	_data_->match_index1 = _tmp7_;
	inline_media_downloader_load_real_url_co (_data_);
}


static void inline_media_downloader_load_real_url_finish (InlineMediaDownloader* self, GAsyncResult* _res_) {
	InlineMediaDownloaderLoadRealUrlData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block20Data* block20_data_ref (Block20Data* _data20_) {
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}


static void block20_data_unref (void * _userdata_) {
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		InlineMediaDownloader* self;
		self = _data20_->self;
		_g_object_unref0 (_data20_->msg);
		_g_object_unref0 (_data20_->media);
		_g_free0 (_data20_->regex_str1);
		_g_object_unref0 (self);
		g_slice_free (Block20Data, _data20_);
	}
}


static void __lambda35_ (Block20Data* _data20_, SoupSession* _s, SoupMessage* _msg) {
	InlineMediaDownloader* self;
	gchar* back = NULL;
	SoupMessage* _tmp0_ = NULL;
	SoupMessageBody* _tmp1_ = NULL;
	guint8* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	const gchar* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
	self = _data20_->self;
	g_return_if_fail (SOUP_IS_SESSION (_s));
	g_return_if_fail (SOUP_IS_MESSAGE (_msg));
	_tmp0_ = _msg;
	_tmp1_ = _tmp0_->response_body;
	_tmp2_ = _tmp1_->data;
	_tmp2__length1 = (gint) _tmp1_->length;
	_tmp3_ = g_strdup ((const gchar*) _tmp2_);
	back = _tmp3_;
	g_object_get (_data20_->msg, "status-code", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != ((guint) SOUP_STATUS_OK)) {
		guint _tmp6_ = 0U;
		guint _tmp7_ = 0U;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		Media* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		Media* _tmp12_ = NULL;
		g_object_get (_data20_->msg, "status-code", &_tmp6_, NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf ("%u", _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _data20_->media;
		_tmp11_ = _tmp10_->url;
		g_warning ("InlineMediaDownloader.vala:100: Message status: %s on %s", _tmp9_, _tmp11_);
		_g_free0 (_tmp9_);
		_tmp12_ = _data20_->media;
		inline_media_downloader_mark_invalid (_tmp12_, NULL, NULL, NULL);
		_g_free0 (back);
		return;
	}
	_tmp13_ = back;
	if (_tmp13_ == NULL) {
		Media* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		Media* _tmp16_ = NULL;
		_tmp14_ = _data20_->media;
		_tmp15_ = _tmp14_->url;
		g_warning ("InlineMediaDownloader.vala:106: Url '%s' returned null", _tmp15_);
		_tmp16_ = _data20_->media;
		inline_media_downloader_mark_invalid (_tmp16_, NULL, NULL, NULL);
		_g_free0 (back);
		return;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp17_ = NULL;
		GRegex* _tmp18_ = NULL;
		GMatchInfo* info = NULL;
		GRegex* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		GMatchInfo* _tmp21_ = NULL;
		gchar* real_url = NULL;
		GMatchInfo* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		gchar* _tmp24_ = NULL;
		Media* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		_tmp17_ = _data20_->regex_str1;
		_tmp18_ = g_regex_new (_tmp17_, 0, 0, &_inner_error_);
		regex = _tmp18_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch21_g_regex_error;
			}
			_g_free0 (back);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp19_ = regex;
		_tmp20_ = back;
		g_regex_match (_tmp19_, _tmp20_, 0, &_tmp21_);
		_g_match_info_unref0 (info);
		info = _tmp21_;
		_tmp22_ = info;
		_tmp23_ = _data20_->match_index1;
		_tmp24_ = g_match_info_fetch (_tmp22_, _tmp23_);
		real_url = _tmp24_;
		_tmp25_ = _data20_->media;
		_tmp26_ = real_url;
		media_set_thumb_url (_tmp25_, _tmp26_);
		inline_media_downloader_load_real_url_co (_data20_->_async_data_);
		_g_free0 (real_url);
		_g_match_info_unref0 (info);
		_g_regex_unref0 (regex);
	}
	goto __finally21;
	__catch21_g_regex_error:
	{
		GError* e = NULL;
		const gchar* _tmp27_ = NULL;
		GError* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp27_ = _data20_->regex_str1;
		_tmp28_ = e;
		_tmp29_ = _tmp28_->message;
		g_critical ("InlineMediaDownloader.vala:119: Regex Error(%s): %s", _tmp27_, _tmp29_);
		_g_error_free0 (e);
	}
	__finally21:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (back);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (back);
}


static void ___lambda35__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
	__lambda35_ (self, session, msg);
	block20_data_unref (self);
}


static gboolean inline_media_downloader_load_real_url_co (InlineMediaDownloaderLoadRealUrlData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data20_ = g_slice_new0 (Block20Data);
	_data_->_data20_->_ref_count_ = 1;
	_data_->_data20_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->media;
	_g_object_unref0 (_data_->_data20_->media);
	_data_->_data20_->media = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->regex_str1;
	_g_free0 (_data_->_data20_->regex_str1);
	_data_->_data20_->regex_str1 = _data_->_tmp1_;
	_data_->_tmp2_ = 0;
	_data_->_tmp2_ = _data_->match_index1;
	_data_->_data20_->match_index1 = _data_->_tmp2_;
	_data_->_data20_->_async_data_ = _data_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->_data20_->media;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->_tmp3_->url;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = soup_message_new ("GET", _data_->_tmp4_);
	_data_->_data20_->msg = _data_->_tmp5_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = SOUP_SESSION;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _g_object_ref0 (_data_->_data20_->msg);
	soup_session_queue_message (_data_->_tmp6_, _data_->_tmp7_, ___lambda35__soup_session_callback, block20_data_ref (_data_->_data20_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block20_data_unref (_data_->_data20_);
	_data_->_data20_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void inline_media_downloader_load_inline_media_data_free (gpointer _data) {
	InlineMediaDownloaderLoadInlineMediaData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (InlineMediaDownloaderLoadInlineMediaData, _data_);
}


static void inline_media_downloader_load_inline_media (InlineMediaDownloader* self, MiniTweet* t, Media* media, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	InlineMediaDownloaderLoadInlineMediaData* _data_;
	InlineMediaDownloader* _tmp0_ = NULL;
	MiniTweet* _tmp1_ = NULL;
	MiniTweet* _tmp2_ = NULL;
	Media* _tmp3_ = NULL;
	Media* _tmp4_ = NULL;
	_data_ = g_slice_new0 (InlineMediaDownloaderLoadInlineMediaData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, inline_media_downloader_load_inline_media);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, inline_media_downloader_load_inline_media_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = t;
	_tmp2_ = _mini_tweet_ref0 (_tmp1_);
	_mini_tweet_unref0 (_data_->t);
	_data_->t = _tmp2_;
	_tmp3_ = media;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->media);
	_data_->media = _tmp4_;
	inline_media_downloader_load_inline_media_co (_data_);
}


static void inline_media_downloader_load_inline_media_finish (InlineMediaDownloader* self, GAsyncResult* _res_) {
	InlineMediaDownloaderLoadInlineMediaData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block21Data* block21_data_ref (Block21Data* _data21_) {
	g_atomic_int_inc (&_data21_->_ref_count_);
	return _data21_;
}


static void block21_data_unref (void * _userdata_) {
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
		InlineMediaDownloader* self;
		self = _data21_->self;
		_g_object_unref0 (_data21_->msg);
		_g_object_unref0 (_data21_->media_out_stream);
		_g_object_unref0 (_data21_->thumb_out_stream);
		(_data21_->callback_target_destroy_notify == NULL) ? NULL : (_data21_->callback_target_destroy_notify (_data21_->callback_target), NULL);
		_data21_->callback = NULL;
		_data21_->callback_target = NULL;
		_data21_->callback_target_destroy_notify = NULL;
		_mini_tweet_unref0 (_data21_->t);
		_g_object_unref0 (_data21_->media);
		_g_object_unref0 (self);
		g_slice_free (Block21Data, _data21_);
	}
}


static gboolean _inline_media_downloader_load_inline_media_co_gsource_func (gpointer self) {
	gboolean result;
	result = inline_media_downloader_load_inline_media_co (self);
	return result;
}


static Block22Data* block22_data_ref (Block22Data* _data22_) {
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}


static void block22_data_unref (void * _userdata_) {
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		InlineMediaDownloader* self;
		self = _data22_->_data21_->self;
		block21_data_unref (_data22_->_data21_);
		_data22_->_data21_ = NULL;
		g_slice_free (Block22Data, _data22_);
	}
}


static void __lambda32_ (Block22Data* _data22_) {
	Block21Data* _data21_;
	InlineMediaDownloader* self;
	GSourceFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	_data21_ = _data22_->_data21_;
	self = _data21_->self;
	_tmp0_ = _data21_->callback;
	_tmp0__target = _data21_->callback_target;
	_tmp0_ (_tmp0__target);
}


static void ___lambda32__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda32_ (self);
	block22_data_unref (self);
}


static void ___lambda31_ (Block22Data* _data22_) {
	Block21Data* _data21_;
	InlineMediaDownloader* self;
	gulong _tmp0_ = 0UL;
	MiniTweet* _tmp1_ = NULL;
	Media* _tmp2_ = NULL;
	_data21_ = _data22_->_data21_;
	self = _data21_->self;
	_tmp0_ = _data22_->id;
	g_signal_handler_disconnect (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), _tmp0_);
	_tmp1_ = _data21_->t;
	_tmp2_ = _data21_->media;
	inline_media_downloader_load_inline_media (self, _tmp1_, _tmp2_, ___lambda32__gasync_ready_callback, block22_data_ref (_data22_));
}


static void ____lambda31__inline_media_downloader_downloading (InlineMediaDownloader* _sender, gpointer self) {
	___lambda31_ (self);
}


static void inline_media_downloader_load_inline_media_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	InlineMediaDownloaderLoadInlineMediaData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	inline_media_downloader_load_inline_media_co (_data_);
}


static void __lambda36_ (Block21Data* _data21_) {
	InlineMediaDownloader* self;
	gint64 content_length = 0LL;
	SoupMessage* _tmp0_ = NULL;
	SoupMessageHeaders* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gdouble mb = 0.0;
	gint64 _tmp3_ = 0LL;
	gdouble max = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	self = _data21_->self;
	_tmp0_ = _data21_->msg;
	_tmp1_ = _tmp0_->response_headers;
	_tmp2_ = soup_message_headers_get_content_length (_tmp1_);
	content_length = _tmp2_;
	_tmp3_ = content_length;
	mb = (_tmp3_ / 1024.0) / 1024.0;
	_tmp4_ = settings_max_media_size ();
	max = _tmp4_;
	_tmp5_ = mb;
	_tmp6_ = max;
	if (_tmp5_ > _tmp6_) {
		Media* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gdouble _tmp10_ = 0.0;
		gdouble _tmp11_ = 0.0;
		Media* _tmp12_ = NULL;
		GOutputStream* _tmp13_ = NULL;
		GOutputStream* _tmp14_ = NULL;
		SoupSession* _tmp15_ = NULL;
		SoupMessage* _tmp16_ = NULL;
		_tmp7_ = _data21_->media;
		_tmp8_ = media_get_thumb_url (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = mb;
		_tmp11_ = max;
		g_debug ("InlineMediaDownloader.vala:229: Image %s won't be downloaded,  %fMB > " \
"%fMB", _tmp9_, _tmp10_, _tmp11_);
		_tmp12_ = _data21_->media;
		_tmp13_ = _data21_->thumb_out_stream;
		_tmp14_ = _data21_->media_out_stream;
		inline_media_downloader_mark_invalid (_tmp12_, NULL, _tmp13_, _tmp14_);
		_tmp15_ = SOUP_SESSION;
		_tmp16_ = _data21_->msg;
		soup_session_cancel_message (_tmp15_, _tmp16_, (guint) SOUP_STATUS_CANCELLED);
	} else {
		Media* _tmp17_ = NULL;
		gint64 _tmp18_ = 0LL;
		_tmp17_ = _data21_->media;
		_tmp18_ = content_length;
		media_set_length (_tmp17_, _tmp18_);
	}
}


static void ___lambda36__soup_message_got_headers (SoupMessage* _sender, gpointer self) {
	__lambda36_ (self);
}


static void __lambda37_ (Block21Data* _data21_, SoupBuffer* buf) {
	InlineMediaDownloader* self;
	gdouble percent = 0.0;
	SoupBuffer* _tmp0_ = NULL;
	gsize _tmp1_ = 0UL;
	Media* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
	Media* _tmp5_ = NULL;
	Media* _tmp6_ = NULL;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	self = _data21_->self;
	g_return_if_fail (buf != NULL);
	_tmp0_ = buf;
	_tmp1_ = _tmp0_->length;
	_tmp2_ = _data21_->media;
	_tmp3_ = media_get_length (_tmp2_);
	_tmp4_ = _tmp3_;
	percent = ((gdouble) _tmp1_) / ((gdouble) _tmp4_);
	_tmp5_ = _data21_->media;
	_tmp6_ = _data21_->media;
	_tmp7_ = media_get_percent_loaded (_tmp6_);
	_tmp8_ = _tmp7_;
	media_set_percent_loaded (_tmp6_, _tmp8_ + percent);
}


static void ___lambda37__soup_message_got_chunk (SoupMessage* _sender, SoupBuffer* chunk, gpointer self) {
	__lambda37_ (self, chunk);
}


static Block23Data* block23_data_ref (Block23Data* _data23_) {
	g_atomic_int_inc (&_data23_->_ref_count_);
	return _data23_;
}


static void block23_data_unref (void * _userdata_) {
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
		InlineMediaDownloader* self;
		self = _data23_->_data21_->self;
		_g_object_unref0 (_data23_->ms);
		block21_data_unref (_data23_->_data21_);
		_data23_->_data21_ = NULL;
		g_slice_free (Block23Data, _data23_);
	}
}


static guint8* _vala_array_dup7 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static void ___lambda39_ (Block23Data* _data23_) {
	Block21Data* _data21_;
	InlineMediaDownloader* self;
	GeeArrayList* _tmp4_ = NULL;
	Media* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GSourceFunc _tmp7_ = NULL;
	void* _tmp7__target = NULL;
	Media* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
	_data21_ = _data23_->_data21_;
	self = _data21_->self;
	{
		GMemoryInputStream* _tmp0_ = NULL;
		GOutputStream* _tmp1_ = NULL;
		_tmp0_ = _data23_->ms;
		g_input_stream_close (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, G_TYPE_INPUT_STREAM, GInputStream), NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch27_g_error;
		}
		_tmp1_ = _data21_->thumb_out_stream;
		g_output_stream_close (_tmp1_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch27_g_error;
		}
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("InlineMediaDownloader.vala:263: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally27:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = self->priv->urls_downloading;
	_tmp5_ = _data21_->media;
	_tmp6_ = _tmp5_->url;
	gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp6_);
	_tmp7_ = _data21_->callback;
	_tmp7__target = _data21_->callback_target;
	_tmp7_ (_tmp7__target);
	_tmp8_ = _data21_->media;
	_tmp9_ = _tmp8_->url;
	_tmp10_ = g_strconcat ("downloading::", _tmp9_, NULL);
	g_signal_emit_by_name (self, _tmp10_);
	_g_free0 (_tmp10_);
}


static void ____lambda39__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda39_ (self);
	block23_data_unref (self);
}


static void __lambda38_ (Block21Data* _data21_, SoupSession* s, SoupMessage* _msg) {
	InlineMediaDownloader* self;
	SoupMessage* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	GError * _inner_error_ = NULL;
	self = _data21_->self;
	g_return_if_fail (SOUP_IS_SESSION (s));
	g_return_if_fail (SOUP_IS_MESSAGE (_msg));
	_tmp0_ = _msg;
	g_object_get (_tmp0_, "status-code", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != ((guint) SOUP_STATUS_OK)) {
		SoupMessage* _tmp3_ = NULL;
		SoupURI* _tmp4_ = NULL;
		SoupURI* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		SoupMessage* _tmp8_ = NULL;
		guint _tmp9_ = 0U;
		guint _tmp10_ = 0U;
		const gchar* _tmp11_ = NULL;
		Media* _tmp12_ = NULL;
		GOutputStream* _tmp13_ = NULL;
		GOutputStream* _tmp14_ = NULL;
		GeeArrayList* _tmp15_ = NULL;
		Media* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		GSourceFunc _tmp18_ = NULL;
		void* _tmp18__target = NULL;
		_tmp3_ = _msg;
		_tmp4_ = soup_message_get_uri (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = soup_uri_to_string (_tmp5_, FALSE);
		_tmp7_ = _tmp6_;
		_tmp8_ = _msg;
		g_object_get (_tmp8_, "status-code", &_tmp9_, NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = soup_status_get_phrase (_tmp10_);
		g_debug ("InlineMediaDownloader.vala:247: Request on '%s' returned '%s'", _tmp7_, _tmp11_);
		_g_free0 (_tmp7_);
		_tmp12_ = _data21_->media;
		_tmp13_ = _data21_->thumb_out_stream;
		_tmp14_ = _data21_->media_out_stream;
		inline_media_downloader_mark_invalid (_tmp12_, NULL, _tmp13_, _tmp14_);
		_tmp15_ = self->priv->urls_downloading;
		_tmp16_ = _data21_->media;
		_tmp17_ = _tmp16_->url;
		gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp17_);
		_tmp18_ = _data21_->callback;
		_tmp18__target = _data21_->callback_target;
		_tmp18_ (_tmp18__target);
		return;
	}
	{
		Block23Data* _data23_;
		SoupMessage* _tmp19_ = NULL;
		SoupMessageBody* _tmp20_ = NULL;
		guint8* _tmp21_ = NULL;
		gint _tmp21__length1 = 0;
		guint8* _tmp22_ = NULL;
		gint _tmp22__length1 = 0;
		GMemoryInputStream* _tmp23_ = NULL;
		GOutputStream* _tmp24_ = NULL;
		SoupMessage* _tmp25_ = NULL;
		SoupMessageBody* _tmp26_ = NULL;
		guint8* _tmp27_ = NULL;
		gint _tmp27__length1 = 0;
		GOutputStream* _tmp28_ = NULL;
		MiniTweet* _tmp29_ = NULL;
		GMemoryInputStream* _tmp30_ = NULL;
		GOutputStream* _tmp31_ = NULL;
		Media* _tmp32_ = NULL;
		_data23_ = g_slice_new0 (Block23Data);
		_data23_->_ref_count_ = 1;
		_data23_->_data21_ = block21_data_ref (_data21_);
		_tmp19_ = _msg;
		_tmp20_ = _tmp19_->response_body;
		_tmp21_ = _tmp20_->data;
		_tmp21__length1 = (gint) _tmp20_->length;
		_tmp22_ = (_tmp21_ != NULL) ? _vala_array_dup7 (_tmp21_, _tmp21__length1) : ((gpointer) _tmp21_);
		_tmp22__length1 = _tmp21__length1;
		_tmp23_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp22_, _tmp22__length1, NULL);
		_data23_->ms = _tmp23_;
		_tmp24_ = _data21_->media_out_stream;
		_tmp25_ = _msg;
		_tmp26_ = _tmp25_->response_body;
		_tmp27_ = _tmp26_->data;
		_tmp27__length1 = (gint) _tmp26_->length;
		g_output_stream_write_all (_tmp24_, _tmp27_, (gsize) _tmp27__length1, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			block23_data_unref (_data23_);
			_data23_ = NULL;
			goto __catch26_g_error;
		}
		_tmp28_ = _data21_->media_out_stream;
		g_output_stream_close (_tmp28_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			block23_data_unref (_data23_);
			_data23_ = NULL;
			goto __catch26_g_error;
		}
		_tmp29_ = _data21_->t;
		_tmp30_ = _data23_->ms;
		_tmp31_ = _data21_->thumb_out_stream;
		_tmp32_ = _data21_->media;
		inline_media_downloader_load_animation (self, _tmp29_, G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, G_TYPE_INPUT_STREAM, GInputStream), _tmp31_, _tmp32_, ____lambda39__gasync_ready_callback, block23_data_ref (_data23_));
		block23_data_unref (_data23_);
		_data23_ = NULL;
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError* e = NULL;
		GError* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		Media* _tmp37_ = NULL;
		const gchar* _tmp38_ = NULL;
		const gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
		GSourceFunc _tmp42_ = NULL;
		void* _tmp42__target = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp33_ = e;
		_tmp34_ = _tmp33_->message;
		_tmp35_ = g_strconcat (_tmp34_, " for MEDIA ", NULL);
		_tmp36_ = _tmp35_;
		_tmp37_ = _data21_->media;
		_tmp38_ = media_get_thumb_url (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = g_strconcat (_tmp36_, _tmp39_, NULL);
		_tmp41_ = _tmp40_;
		g_critical ("InlineMediaDownloader.vala:271: %s", _tmp41_);
		_g_free0 (_tmp41_);
		_g_free0 (_tmp36_);
		_tmp42_ = _data21_->callback;
		_tmp42__target = _data21_->callback_target;
		_tmp42_ (_tmp42__target);
		_g_error_free0 (e);
	}
	__finally26:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda38__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
	__lambda38_ (self, session, msg);
	block21_data_unref (self);
}


static gboolean inline_media_downloader_load_inline_media_co (InlineMediaDownloaderLoadInlineMediaData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		case 7:
		goto _state_7;
		case 8:
		goto _state_8;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data21_ = g_slice_new0 (Block21Data);
	_data_->_data21_->_ref_count_ = 1;
	_data_->_data21_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->t;
	_mini_tweet_unref0 (_data_->_data21_->t);
	_data_->_data21_->t = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->media;
	_g_object_unref0 (_data_->_data21_->media);
	_data_->_data21_->media = _data_->_tmp1_;
	_data_->_data21_->_async_data_ = _data_;
	_data_->_data21_->callback = _inline_media_downloader_load_inline_media_co_gsource_func;
	_data_->_data21_->callback_target = _data_;
	_data_->_data21_->callback_target_destroy_notify = NULL;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_data21_->media;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->_data21_->t;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->_data21_->media;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = inline_media_downloader_get_media_path (_data_->self, _data_->_tmp3_, _data_->_tmp4_);
	_g_free0 (_data_->_tmp2_->path);
	_data_->_tmp2_->path = _data_->_tmp5_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->_data21_->media;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->_data21_->t;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->_data21_->media;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = inline_media_downloader_get_thumb_path (_data_->self, _data_->_tmp7_, _data_->_tmp8_);
	_g_free0 (_data_->_tmp6_->thumb_path);
	_data_->_tmp6_->thumb_path = _data_->_tmp9_;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->self->priv->urls_downloading;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->_data21_->media;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->_tmp11_->url;
	_data_->_tmp13_ = FALSE;
	_data_->_tmp13_ = gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp10_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _data_->_tmp12_);
	if (_data_->_tmp13_) {
		_data_->_data22_ = g_slice_new0 (Block22Data);
		_data_->_data22_->_ref_count_ = 1;
		_data_->_data22_->_data21_ = block21_data_ref (_data_->_data21_);
		_data_->_data22_->id = (gulong) 0;
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->_data21_->media;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->_tmp14_->url;
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = g_strconcat ("downloading::", _data_->_tmp15_, NULL);
		_data_->_tmp17_ = 0UL;
		_data_->_tmp17_ = g_signal_connect_data (_data_->self, _data_->_tmp16_, (GCallback) ____lambda31__inline_media_downloader_downloading, block22_data_ref (_data_->_data22_), (GClosureNotify) block22_data_unref, 0);
		_data_->_data22_->id = _data_->_tmp17_;
		_g_free0 (_data_->_tmp16_);
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		block22_data_unref (_data_->_data22_);
		_data_->_data22_ = NULL;
	}
	_data_->_data21_->thumb_out_stream = NULL;
	_data_->_data21_->media_out_stream = NULL;
	_data_->main_file_exists = FALSE;
	{
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->_data21_->media;
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = _data_->_tmp19_->path;
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = g_file_new_for_path (_data_->_tmp20_);
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = _data_->_tmp21_;
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = g_file_create (_data_->_tmp22_, G_FILE_CREATE_NONE, NULL, &_data_->_inner_error_);
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = _data_->_tmp23_;
		_g_object_unref0 (_data_->_tmp22_);
		_data_->_tmp18_ = _data_->_tmp24_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch22_g_error;
		}
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = _data_->_tmp18_;
		_data_->_tmp18_ = NULL;
		_g_object_unref0 (_data_->_data21_->media_out_stream);
		_data_->_data21_->media_out_stream = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp25_, G_TYPE_OUTPUT_STREAM, GOutputStream);
		_g_object_unref0 (_data_->_tmp18_);
	}
	goto __finally22;
	__catch22_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = _data_->e;
		if (g_error_matches (_data_->_tmp26_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
			_data_->main_file_exists = TRUE;
		} else {
			_data_->_tmp27_ = NULL;
			_data_->_tmp27_ = _data_->e;
			_data_->_tmp28_ = NULL;
			_data_->_tmp28_ = _data_->_tmp27_->message;
			g_warning ("InlineMediaDownloader.vala:150: %s", _data_->_tmp28_);
			_g_error_free0 (_data_->e);
			block21_data_unref (_data_->_data21_);
			_data_->_data21_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_error_free0 (_data_->e);
	}
	__finally22:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		block21_data_unref (_data_->_data21_);
		_data_->_data21_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	{
		_data_->_tmp30_ = NULL;
		_data_->_tmp30_ = _data_->_data21_->media;
		_data_->_tmp31_ = NULL;
		_data_->_tmp31_ = _data_->_tmp30_->thumb_path;
		_data_->_tmp32_ = NULL;
		_data_->_tmp32_ = g_file_new_for_path (_data_->_tmp31_);
		_data_->_tmp33_ = NULL;
		_data_->_tmp33_ = _data_->_tmp32_;
		_data_->_tmp34_ = NULL;
		_data_->_tmp34_ = g_file_create (_data_->_tmp33_, G_FILE_CREATE_NONE, NULL, &_data_->_inner_error_);
		_data_->_tmp35_ = NULL;
		_data_->_tmp35_ = _data_->_tmp34_;
		_g_object_unref0 (_data_->_tmp33_);
		_data_->_tmp29_ = _data_->_tmp35_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch23_g_error;
		}
		_data_->_tmp36_ = NULL;
		_data_->_tmp36_ = _data_->_tmp29_;
		_data_->_tmp29_ = NULL;
		_g_object_unref0 (_data_->_data21_->thumb_out_stream);
		_data_->_data21_->thumb_out_stream = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp36_, G_TYPE_OUTPUT_STREAM, GOutputStream);
		_data_->_tmp37_ = FALSE;
		_data_->_tmp37_ = _data_->main_file_exists;
		if (_data_->_tmp37_) {
			_data_->_tmp38_ = NULL;
			_data_->_tmp38_ = _data_->_data21_->media;
			_data_->_tmp39_ = NULL;
			_data_->_tmp39_ = _data_->_tmp38_->path;
			_data_->_tmp40_ = NULL;
			_data_->_tmp40_ = g_file_new_for_path (_data_->_tmp39_);
			_data_->_tmp41_ = NULL;
			_data_->_tmp41_ = _data_->_tmp40_;
			_data_->_tmp42_ = NULL;
			_data_->_tmp42_ = g_file_read (_data_->_tmp41_, NULL, &_data_->_inner_error_);
			_data_->_tmp43_ = NULL;
			_data_->_tmp43_ = _data_->_tmp42_;
			_g_object_unref0 (_data_->_tmp41_);
			_data_->in_stream = _data_->_tmp43_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				_g_object_unref0 (_data_->_tmp29_);
				goto __catch23_g_error;
			}
			_data_->_tmp44_ = NULL;
			_data_->_tmp44_ = _data_->_data21_->t;
			_data_->_tmp45_ = NULL;
			_data_->_tmp45_ = _data_->in_stream;
			_data_->_tmp46_ = NULL;
			_data_->_tmp46_ = _data_->_data21_->thumb_out_stream;
			_data_->_tmp47_ = NULL;
			_data_->_tmp47_ = _data_->_data21_->media;
			_data_->_state_ = 2;
			inline_media_downloader_load_animation (_data_->self, _data_->_tmp44_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp45_, G_TYPE_INPUT_STREAM, GInputStream), _data_->_tmp46_, _data_->_tmp47_, inline_media_downloader_load_inline_media_ready, _data_);
			return FALSE;
			_state_2:
			inline_media_downloader_load_animation_finish (_data_->self, _data_->_res_);
			{
				_data_->_tmp48_ = NULL;
				_data_->_tmp48_ = _data_->in_stream;
				g_input_stream_close (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp48_, G_TYPE_INPUT_STREAM, GInputStream), NULL, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					goto __catch24_g_error;
				}
				_data_->_tmp49_ = NULL;
				_data_->_tmp49_ = _data_->_data21_->thumb_out_stream;
				g_output_stream_close (_data_->_tmp49_, NULL, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					goto __catch24_g_error;
				}
			}
			goto __finally24;
			__catch24_g_error:
			{
				_data_->_vala1_e = _data_->_inner_error_;
				_data_->_inner_error_ = NULL;
				_data_->_tmp50_ = NULL;
				_data_->_tmp50_ = _data_->_vala1_e;
				_data_->_tmp51_ = NULL;
				_data_->_tmp51_ = _data_->_tmp50_->message;
				g_warning ("InlineMediaDownloader.vala:166: %s", _data_->_tmp51_);
				_g_error_free0 (_data_->_vala1_e);
			}
			__finally24:
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				_g_object_unref0 (_data_->in_stream);
				_g_object_unref0 (_data_->_tmp29_);
				goto __catch23_g_error;
			}
			_g_object_unref0 (_data_->in_stream);
			_g_object_unref0 (_data_->_tmp29_);
			block21_data_unref (_data_->_data21_);
			_data_->_data21_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->_tmp29_);
	}
	goto __finally23;
	__catch23_g_error:
	{
		_data_->_vala2_e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp52_ = NULL;
		_data_->_tmp52_ = _data_->_vala2_e;
		if (g_error_matches (_data_->_tmp52_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
			_data_->_tmp53_ = FALSE;
			_data_->_tmp53_ = _data_->main_file_exists;
			if (_data_->_tmp53_) {
				_data_->_tmp54_ = NULL;
				_data_->_tmp54_ = _data_->_data21_->media;
				_data_->_tmp55_ = NULL;
				_data_->_tmp55_ = _data_->_data21_->media;
				_data_->_tmp56_ = NULL;
				_data_->_tmp56_ = _data_->_tmp55_->thumb_path;
				_data_->_tmp57_ = NULL;
				_data_->_tmp57_ = load_surface (_data_->_tmp56_);
				_cairo_surface_destroy0 (_data_->_tmp54_->thumbnail);
				_data_->_tmp54_->thumbnail = _data_->_tmp57_;
				_data_->_tmp58_ = NULL;
				_data_->_tmp58_ = _data_->_data21_->media;
				_data_->_tmp59_ = NULL;
				_data_->_tmp59_ = _data_->_tmp58_->thumbnail;
				if (_data_->_tmp59_ == NULL) {
					_data_->_tmp60_ = NULL;
					_data_->_tmp60_ = _data_->_data21_->media;
					_data_->_tmp61_ = NULL;
					_data_->_tmp61_ = _data_->_tmp60_->url;
					g_warning ("InlineMediaDownloader.vala:175: '%s` couldn't be loaded from disk.", _data_->_tmp61_);
					_data_->_tmp62_ = NULL;
					_data_->_tmp62_ = _data_->_data21_->media;
					_data_->_tmp62_->invalid = TRUE;
				}
				_data_->_tmp63_ = NULL;
				_data_->_tmp63_ = _data_->_data21_->media;
				_data_->_tmp63_->loaded = TRUE;
				_data_->_tmp64_ = NULL;
				_data_->_tmp64_ = _data_->_data21_->media;
				g_signal_emit_by_name (_data_->_tmp64_, "finished-loading");
				_g_error_free0 (_data_->_vala2_e);
				block21_data_unref (_data_->_data21_);
				_data_->_data21_ = NULL;
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_data_->_tmp65_ = NULL;
				_data_->_tmp65_ = _data_->_data21_->media;
				_data_->_tmp66_ = NULL;
				_data_->_tmp66_ = _data_->_tmp65_->thumb_path;
				g_remove (_data_->_tmp66_);
				{
					_data_->_tmp68_ = NULL;
					_data_->_tmp68_ = _data_->_data21_->media;
					_data_->_tmp69_ = NULL;
					_data_->_tmp69_ = _data_->_tmp68_->thumb_path;
					_data_->_tmp70_ = NULL;
					_data_->_tmp70_ = g_file_new_for_path (_data_->_tmp69_);
					_data_->_tmp71_ = NULL;
					_data_->_tmp71_ = _data_->_tmp70_;
					_data_->_tmp72_ = NULL;
					_data_->_tmp72_ = g_file_create (_data_->_tmp71_, G_FILE_CREATE_NONE, NULL, &_data_->_inner_error_);
					_data_->_tmp73_ = NULL;
					_data_->_tmp73_ = _data_->_tmp72_;
					_g_object_unref0 (_data_->_tmp71_);
					_data_->_tmp67_ = _data_->_tmp73_;
					if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
						goto __catch25_g_error;
					}
					_data_->_tmp74_ = NULL;
					_data_->_tmp74_ = _data_->_tmp67_;
					_data_->_tmp67_ = NULL;
					_g_object_unref0 (_data_->_data21_->thumb_out_stream);
					_data_->_data21_->thumb_out_stream = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp74_, G_TYPE_OUTPUT_STREAM, GOutputStream);
					_g_object_unref0 (_data_->_tmp67_);
				}
				goto __finally25;
				__catch25_g_error:
				{
					_data_->_vala3_e = _data_->_inner_error_;
					_data_->_inner_error_ = NULL;
					_data_->_tmp75_ = NULL;
					_data_->_tmp75_ = _data_->_vala3_e;
					_data_->_tmp76_ = NULL;
					_data_->_tmp76_ = _data_->_tmp75_->message;
					g_critical ("InlineMediaDownloader.vala:188: %s", _data_->_tmp76_);
					_g_error_free0 (_data_->_vala3_e);
					_g_error_free0 (_data_->_vala2_e);
					block21_data_unref (_data_->_data21_);
					_data_->_data21_ = NULL;
					if (_data_->_state_ == 0) {
						g_simple_async_result_complete_in_idle (_data_->_async_result);
					} else {
						g_simple_async_result_complete (_data_->_async_result);
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				__finally25:
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_g_error_free0 (_data_->_vala2_e);
					_g_error_free0 (_data_->_vala2_e);
					block21_data_unref (_data_->_data21_);
					_data_->_data21_ = NULL;
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
			}
		} else {
			_data_->_tmp77_ = NULL;
			_data_->_tmp77_ = _data_->_vala2_e;
			_data_->_tmp78_ = NULL;
			_data_->_tmp78_ = _data_->_tmp77_->message;
			g_warning ("InlineMediaDownloader.vala:193: %s", _data_->_tmp78_);
			_g_error_free0 (_data_->_vala2_e);
			block21_data_unref (_data_->_data21_);
			_data_->_data21_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_error_free0 (_data_->_vala2_e);
	}
	__finally23:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		block21_data_unref (_data_->_data21_);
		_data_->_data21_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp79_ = NULL;
	_data_->_tmp79_ = _data_->_data21_->media;
	_data_->_tmp80_ = NULL;
	_data_->_tmp80_ = _data_->_tmp79_->url;
	_data_->_tmp81_ = NULL;
	_data_->_tmp81_ = g_strdup (_data_->_tmp80_);
	_data_->url = _data_->_tmp81_;
	_data_->_tmp89_ = NULL;
	_data_->_tmp89_ = _data_->url;
	_data_->_tmp90_ = FALSE;
	_data_->_tmp90_ = g_str_has_prefix (_data_->_tmp89_, "http://instagr.am");
	if (_data_->_tmp90_) {
		_data_->_tmp88_ = TRUE;
	} else {
		_data_->_tmp91_ = NULL;
		_data_->_tmp91_ = _data_->url;
		_data_->_tmp92_ = FALSE;
		_data_->_tmp92_ = g_str_has_prefix (_data_->_tmp91_, "http://instagram.com/p/");
		_data_->_tmp88_ = _data_->_tmp92_;
	}
	if (_data_->_tmp88_) {
		_data_->_tmp87_ = TRUE;
	} else {
		_data_->_tmp93_ = NULL;
		_data_->_tmp93_ = _data_->url;
		_data_->_tmp94_ = FALSE;
		_data_->_tmp94_ = g_str_has_prefix (_data_->_tmp93_, "https://instagr.am");
		_data_->_tmp87_ = _data_->_tmp94_;
	}
	if (_data_->_tmp87_) {
		_data_->_tmp86_ = TRUE;
	} else {
		_data_->_tmp95_ = NULL;
		_data_->_tmp95_ = _data_->url;
		_data_->_tmp96_ = FALSE;
		_data_->_tmp96_ = g_str_has_prefix (_data_->_tmp95_, "https://instagram.com/p/");
		_data_->_tmp86_ = _data_->_tmp96_;
	}
	if (_data_->_tmp86_) {
		_data_->_tmp85_ = TRUE;
	} else {
		_data_->_tmp97_ = NULL;
		_data_->_tmp97_ = _data_->url;
		_data_->_tmp98_ = FALSE;
		_data_->_tmp98_ = g_str_has_prefix (_data_->_tmp97_, "http://ow.ly/i/");
		_data_->_tmp85_ = _data_->_tmp98_;
	}
	if (_data_->_tmp85_) {
		_data_->_tmp84_ = TRUE;
	} else {
		_data_->_tmp99_ = NULL;
		_data_->_tmp99_ = _data_->url;
		_data_->_tmp100_ = FALSE;
		_data_->_tmp100_ = g_str_has_prefix (_data_->_tmp99_, "https://ow.ly/i/");
		_data_->_tmp84_ = _data_->_tmp100_;
	}
	if (_data_->_tmp84_) {
		_data_->_tmp83_ = TRUE;
	} else {
		_data_->_tmp101_ = NULL;
		_data_->_tmp101_ = _data_->url;
		_data_->_tmp102_ = FALSE;
		_data_->_tmp102_ = g_str_has_prefix (_data_->_tmp101_, "http://www.flickr.com/photos/");
		_data_->_tmp83_ = _data_->_tmp102_;
	}
	if (_data_->_tmp83_) {
		_data_->_tmp82_ = TRUE;
	} else {
		_data_->_tmp103_ = NULL;
		_data_->_tmp103_ = _data_->url;
		_data_->_tmp104_ = FALSE;
		_data_->_tmp104_ = g_str_has_prefix (_data_->_tmp103_, "https://www.flickr.com/photos/");
		_data_->_tmp82_ = _data_->_tmp104_;
	}
	if (_data_->_tmp82_) {
		_data_->_tmp105_ = NULL;
		_data_->_tmp105_ = _data_->_data21_->t;
		_data_->_tmp106_ = NULL;
		_data_->_tmp106_ = _data_->_data21_->media;
		_data_->_state_ = 3;
		inline_media_downloader_load_real_url (_data_->self, _data_->_tmp105_, _data_->_tmp106_, "<meta property=\"og:image\" content=\"(.*?)\"", 1, inline_media_downloader_load_inline_media_ready, _data_);
		return FALSE;
		_state_3:
		inline_media_downloader_load_real_url_finish (_data_->self, _data_->_res_);
	} else {
		_data_->_tmp107_ = NULL;
		_data_->_tmp107_ = _data_->url;
		_data_->_tmp108_ = FALSE;
		_data_->_tmp108_ = g_str_has_prefix (_data_->_tmp107_, "http://twitpic.com/");
		if (_data_->_tmp108_) {
			_data_->_tmp109_ = NULL;
			_data_->_tmp109_ = _data_->_data21_->t;
			_data_->_tmp110_ = NULL;
			_data_->_tmp110_ = _data_->_data21_->media;
			_data_->_state_ = 4;
			inline_media_downloader_load_real_url (_data_->self, _data_->_tmp109_, _data_->_tmp110_, "<meta name=\"twitter:image\" value=\"(.*?)\"", 1, inline_media_downloader_load_inline_media_ready, _data_);
			return FALSE;
			_state_4:
			inline_media_downloader_load_real_url_finish (_data_->self, _data_->_res_);
		} else {
			_data_->_tmp111_ = NULL;
			_data_->_tmp111_ = _data_->url;
			_data_->_tmp112_ = FALSE;
			_data_->_tmp112_ = g_str_has_prefix (_data_->_tmp111_, "https://vine.co/v/");
			if (_data_->_tmp112_) {
				_data_->_tmp113_ = NULL;
				_data_->_tmp113_ = _data_->_data21_->t;
				_data_->_tmp114_ = NULL;
				_data_->_tmp114_ = _data_->_data21_->media;
				_data_->_state_ = 5;
				inline_media_downloader_load_real_url (_data_->self, _data_->_tmp113_, _data_->_tmp114_, "<meta property=\"og:image\" content=\"(.*?)\"", 1, inline_media_downloader_load_inline_media_ready, _data_);
				return FALSE;
				_state_5:
				inline_media_downloader_load_real_url_finish (_data_->self, _data_->_res_);
			} else {
				_data_->_tmp115_ = NULL;
				_data_->_tmp115_ = _data_->url;
				_data_->_tmp116_ = FALSE;
				_data_->_tmp116_ = g_str_has_suffix (_data_->_tmp115_, "/photo/1");
				if (_data_->_tmp116_) {
					_data_->_tmp117_ = NULL;
					_data_->_tmp117_ = _data_->_data21_->t;
					_data_->_tmp118_ = NULL;
					_data_->_tmp118_ = _data_->_data21_->media;
					_data_->_state_ = 6;
					inline_media_downloader_load_real_url (_data_->self, _data_->_tmp117_, _data_->_tmp118_, "<img src=\"(.*?)\" class=\"animated-gif-thumbnail", 1, inline_media_downloader_load_inline_media_ready, _data_);
					return FALSE;
					_state_6:
					inline_media_downloader_load_real_url_finish (_data_->self, _data_->_res_);
				} else {
					_data_->_tmp119_ = NULL;
					_data_->_tmp119_ = _data_->url;
					_data_->_tmp120_ = FALSE;
					_data_->_tmp120_ = g_str_has_prefix (_data_->_tmp119_, "http://d.pr/i/");
					if (_data_->_tmp120_) {
						_data_->_tmp121_ = NULL;
						_data_->_tmp121_ = _data_->_data21_->t;
						_data_->_tmp122_ = NULL;
						_data_->_tmp122_ = _data_->_data21_->media;
						_data_->_state_ = 7;
						inline_media_downloader_load_real_url (_data_->self, _data_->_tmp121_, _data_->_tmp122_, "<meta property=\"og:image\"\\s+content=\"(.*?)\"", 1, inline_media_downloader_load_inline_media_ready, _data_);
						return FALSE;
						_state_7:
						inline_media_downloader_load_real_url_finish (_data_->self, _data_->_res_);
					}
				}
			}
		}
	}
	_data_->_tmp123_ = NULL;
	_data_->_tmp123_ = _data_->_data21_->media;
	_data_->_tmp124_ = NULL;
	_data_->_tmp124_ = media_get_thumb_url (_data_->_tmp123_);
	_data_->_tmp125_ = NULL;
	_data_->_tmp125_ = _data_->_tmp124_;
	_data_->_tmp126_ = NULL;
	_data_->_tmp126_ = soup_message_new ("GET", _data_->_tmp125_);
	_data_->_data21_->msg = _data_->_tmp126_;
	_data_->_tmp127_ = NULL;
	_data_->_tmp127_ = _data_->_data21_->msg;
	g_signal_connect_data (_data_->_tmp127_, "got-headers", (GCallback) ___lambda36__soup_message_got_headers, block21_data_ref (_data_->_data21_), (GClosureNotify) block21_data_unref, 0);
	_data_->_tmp128_ = NULL;
	_data_->_tmp128_ = _data_->_data21_->msg;
	g_signal_connect_data (_data_->_tmp128_, "got-chunk", (GCallback) ___lambda37__soup_message_got_chunk, block21_data_ref (_data_->_data21_), (GClosureNotify) block21_data_unref, 0);
	_data_->_tmp129_ = NULL;
	_data_->_tmp129_ = _data_->self->priv->urls_downloading;
	_data_->_tmp130_ = NULL;
	_data_->_tmp130_ = _data_->_data21_->media;
	_data_->_tmp131_ = NULL;
	_data_->_tmp131_ = _data_->_tmp130_->url;
	_data_->_tmp132_ = FALSE;
	_data_->_tmp132_ = gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp129_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _data_->_tmp131_);
	_vala_assert (!_data_->_tmp132_, "!this.urls_downloading.contains (media.url)");
	_data_->_tmp133_ = NULL;
	_data_->_tmp133_ = _data_->self->priv->urls_downloading;
	_data_->_tmp134_ = NULL;
	_data_->_tmp134_ = _data_->_data21_->media;
	_data_->_tmp135_ = NULL;
	_data_->_tmp135_ = _data_->_tmp134_->url;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp133_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _data_->_tmp135_);
	_data_->_tmp136_ = NULL;
	_data_->_tmp136_ = SOUP_SESSION;
	_data_->_tmp137_ = NULL;
	_data_->_tmp137_ = _data_->_data21_->msg;
	_data_->_tmp138_ = NULL;
	_data_->_tmp138_ = _g_object_ref0 (_data_->_tmp137_);
	soup_session_queue_message (_data_->_tmp136_, _data_->_tmp138_, ___lambda38__soup_session_callback, block21_data_ref (_data_->_data21_));
	_data_->_state_ = 8;
	return FALSE;
	_state_8:
	;
	_g_free0 (_data_->url);
	block21_data_unref (_data_->_data21_);
	_data_->_data21_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void inline_media_downloader_load_animation_data_free (gpointer _data) {
	InlineMediaDownloaderLoadAnimationData* _data_;
	_data_ = _data;
	_mini_tweet_unref0 (_data_->t);
	_g_object_unref0 (_data_->in_stream);
	_g_object_unref0 (_data_->thumb_out_stream);
	_g_object_unref0 (_data_->media);
	_g_object_unref0 (_data_->self);
	g_slice_free (InlineMediaDownloaderLoadAnimationData, _data_);
}


static void inline_media_downloader_load_animation (InlineMediaDownloader* self, MiniTweet* t, GInputStream* in_stream, GOutputStream* thumb_out_stream, Media* media, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	InlineMediaDownloaderLoadAnimationData* _data_;
	InlineMediaDownloader* _tmp0_ = NULL;
	MiniTweet* _tmp1_ = NULL;
	MiniTweet* _tmp2_ = NULL;
	GInputStream* _tmp3_ = NULL;
	GInputStream* _tmp4_ = NULL;
	GOutputStream* _tmp5_ = NULL;
	GOutputStream* _tmp6_ = NULL;
	Media* _tmp7_ = NULL;
	Media* _tmp8_ = NULL;
	_data_ = g_slice_new0 (InlineMediaDownloaderLoadAnimationData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, inline_media_downloader_load_animation);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, inline_media_downloader_load_animation_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = t;
	_tmp2_ = _mini_tweet_ref0 (_tmp1_);
	_mini_tweet_unref0 (_data_->t);
	_data_->t = _tmp2_;
	_tmp3_ = in_stream;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->in_stream);
	_data_->in_stream = _tmp4_;
	_tmp5_ = thumb_out_stream;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (_data_->thumb_out_stream);
	_data_->thumb_out_stream = _tmp6_;
	_tmp7_ = media;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (_data_->media);
	_data_->media = _tmp8_;
	inline_media_downloader_load_animation_co (_data_);
}


static void inline_media_downloader_load_animation_finish (InlineMediaDownloader* self, GAsyncResult* _res_) {
	InlineMediaDownloaderLoadAnimationData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void inline_media_downloader_load_animation_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	InlineMediaDownloaderLoadAnimationData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	inline_media_downloader_load_animation_co (_data_);
}


static gboolean inline_media_downloader_load_animation_co (InlineMediaDownloaderLoadAnimationData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _data_->in_stream;
		_data_->_state_ = 1;
		gdk_pixbuf_animation_new_from_stream_async (_data_->_tmp1_, NULL, inline_media_downloader_load_animation_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = gdk_pixbuf_animation_new_from_stream_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp0_ = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch28_g_error;
		}
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->anim);
		_data_->anim = _data_->_tmp3_;
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally28;
	__catch28_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->media;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->_tmp4_->url;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->e;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->_tmp6_->message;
		g_warning ("InlineMediaDownloader.vala:286: %s: %s", _data_->_tmp5_, _data_->_tmp7_);
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->media;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->in_stream;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->thumb_out_stream;
		inline_media_downloader_mark_invalid (_data_->_tmp8_, _data_->_tmp9_, _data_->_tmp10_, NULL);
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->anim);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally28:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_object_unref0 (_data_->anim);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->anim;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = gdk_pixbuf_animation_get_static_image (_data_->_tmp11_);
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _g_object_ref0 (_data_->_tmp12_);
	_data_->pic = _data_->_tmp13_;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->t;
	_data_->_tmp15_ = NULL;
	_data_->_tmp15__length1 = 0;
	_data_->_tmp15_ = _data_->_tmp14_->medias;
	_data_->_tmp15__length1 = _data_->_tmp14_->medias_length1;
	_data_->thumb_width = (gint) (600.0 / ((gfloat) _data_->_tmp15__length1));
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = _data_->pic;
	_data_->_tmp17_ = 0;
	_data_->_tmp17_ = _data_->thumb_width;
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = utils_slice_pixbuf (_data_->_tmp16_, _data_->_tmp17_, MULTI_MEDIA_WIDGET_HEIGHT);
	_data_->thumb = _data_->_tmp18_;
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = _data_->thumb;
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = _data_->thumb_out_stream;
	_data_->_state_ = 2;
	utils_write_pixbuf_async (_data_->_tmp19_, _data_->_tmp20_, "png", inline_media_downloader_load_animation_ready, _data_);
	return FALSE;
	_state_2:
	utils_write_pixbuf_finish (_data_->_res_);
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = _data_->media;
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = _data_->thumb;
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = gdk_cairo_surface_create_from_pixbuf (_data_->_tmp22_, 1, NULL);
	_cairo_surface_destroy0 (_data_->_tmp21_->thumbnail);
	_data_->_tmp21_->thumbnail = _data_->_tmp23_;
	_data_->_tmp24_ = NULL;
	_data_->_tmp24_ = _data_->media;
	_data_->_tmp24_->loaded = TRUE;
	_data_->_tmp25_ = NULL;
	_data_->_tmp25_ = _data_->media;
	g_signal_emit_by_name (_data_->_tmp25_, "finished-loading");
	_g_object_unref0 (_data_->thumb);
	_g_object_unref0 (_data_->pic);
	_g_object_unref0 (_data_->anim);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


gchar* inline_media_downloader_get_media_path (InlineMediaDownloader* self, MiniTweet* t, Media* media) {
	gchar* result = NULL;
	gchar* ext = NULL;
	Media* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint64 id = 0LL;
	MiniTweet* _tmp10_ = NULL;
	gint64 _tmp11_ = 0LL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	MiniTweet* _tmp14_ = NULL;
	UserIdentity _tmp15_ = {0};
	gint64 _tmp16_ = 0LL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	Media* _tmp19_ = NULL;
	gint64 _tmp20_ = 0LL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	g_return_val_if_fail (IS_INLINE_MEDIA_DOWNLOADER (self), NULL);
	g_return_val_if_fail (IS_MINI_TWEET (t), NULL);
	g_return_val_if_fail (IS_MEDIA (media), NULL);
	_tmp0_ = media;
	_tmp1_ = media_get_thumb_url (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = utils_get_file_type (_tmp2_);
	ext = _tmp3_;
	_tmp4_ = ext;
	_tmp5_ = g_utf8_strdown (_tmp4_, (gssize) -1);
	_g_free0 (ext);
	ext = _tmp5_;
	_tmp6_ = ext;
	_tmp7_ = strlen (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == 0) {
		gchar* _tmp9_ = NULL;
		_tmp9_ = g_strdup ("png");
		_g_free0 (ext);
		ext = _tmp9_;
	}
	_tmp10_ = t;
	_tmp11_ = _tmp10_->id;
	id = _tmp11_;
	_tmp12_ = g_strdup_printf ("%" G_GINT64_FORMAT, id);
	_tmp13_ = _tmp12_;
	_tmp14_ = t;
	_tmp15_ = _tmp14_->author;
	_tmp16_ = _tmp15_.id;
	_tmp17_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = media;
	_tmp20_ = _tmp19_->id;
	_tmp21_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = ext;
	_tmp24_ = string_to_string (_tmp23_);
	_tmp25_ = g_strconcat ("assets/media/", _tmp13_, "_", _tmp18_, "_", _tmp22_, ".", _tmp24_, NULL);
	_tmp26_ = _tmp25_;
	_tmp27_ = dirs_cache (_tmp26_);
	_tmp28_ = _tmp27_;
	_g_free0 (_tmp26_);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp13_);
	result = _tmp28_;
	_g_free0 (ext);
	return result;
}


gchar* inline_media_downloader_get_thumb_path (InlineMediaDownloader* self, MiniTweet* t, Media* media) {
	gchar* result = NULL;
	gint64 id = 0LL;
	MiniTweet* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	MiniTweet* _tmp4_ = NULL;
	UserIdentity _tmp5_ = {0};
	gint64 _tmp6_ = 0LL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	Media* _tmp9_ = NULL;
	gint64 _tmp10_ = 0LL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	g_return_val_if_fail (IS_INLINE_MEDIA_DOWNLOADER (self), NULL);
	g_return_val_if_fail (IS_MINI_TWEET (t), NULL);
	g_return_val_if_fail (IS_MEDIA (media), NULL);
	_tmp0_ = t;
	_tmp1_ = _tmp0_->id;
	id = _tmp1_;
	_tmp2_ = g_strdup_printf ("%" G_GINT64_FORMAT, id);
	_tmp3_ = _tmp2_;
	_tmp4_ = t;
	_tmp5_ = _tmp4_->author;
	_tmp6_ = _tmp5_.id;
	_tmp7_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = media;
	_tmp10_ = _tmp9_->id;
	_tmp11_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat ("assets/media/thumbs/", _tmp3_, "_", _tmp8_, "_", _tmp12_, ".png", NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = dirs_cache (_tmp14_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp3_);
	result = _tmp16_;
	return result;
}


static void inline_media_downloader_class_init (InlineMediaDownloaderClass * klass) {
	inline_media_downloader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (InlineMediaDownloaderPrivate));
	G_OBJECT_CLASS (klass)->finalize = inline_media_downloader_finalize;
	g_signal_new ("downloading", TYPE_INLINE_MEDIA_DOWNLOADER, G_SIGNAL_RUN_LAST | G_SIGNAL_DETAILED, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void inline_media_downloader_instance_init (InlineMediaDownloader * self) {
	GeeArrayList* _tmp0_ = NULL;
	self->priv = INLINE_MEDIA_DOWNLOADER_GET_PRIVATE (self);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	self->priv->urls_downloading = _tmp0_;
}


static void inline_media_downloader_finalize (GObject* obj) {
	InlineMediaDownloader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_INLINE_MEDIA_DOWNLOADER, InlineMediaDownloader);
	_g_object_unref0 (self->priv->urls_downloading);
	G_OBJECT_CLASS (inline_media_downloader_parent_class)->finalize (obj);
}


GType inline_media_downloader_get_type (void) {
	static volatile gsize inline_media_downloader_type_id__volatile = 0;
	if (g_once_init_enter (&inline_media_downloader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (InlineMediaDownloaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) inline_media_downloader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (InlineMediaDownloader), 0, (GInstanceInitFunc) inline_media_downloader_instance_init, NULL };
		GType inline_media_downloader_type_id;
		inline_media_downloader_type_id = g_type_register_static (G_TYPE_OBJECT, "InlineMediaDownloader", &g_define_type_info, 0);
		g_once_init_leave (&inline_media_downloader_type_id__volatile, inline_media_downloader_type_id);
	}
	return inline_media_downloader_type_id__volatile;
}



