/* DefaultTimeline.c generated by valac 0.30.0, the Vala compiler
 * generated from DefaultTimeline.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <gee.h>
#include <rest/rest-proxy-call.h>
#include <rest/oauth-proxy.h>
#include <rest/rest-proxy.h>
#include <json-glib/json-glib.h>


#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;
typedef struct _ScrollWidgetPrivate ScrollWidgetPrivate;

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_ITIMELINE (itimeline_get_type ())
#define ITIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITIMELINE, ITimeline))
#define IS_ITIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITIMELINE))
#define ITIMELINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITIMELINE, ITimelineIface))

typedef struct _ITimeline ITimeline;
typedef struct _ITimelineIface ITimelineIface;

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;

#define TYPE_DELTA_UPDATER (delta_updater_get_type ())
#define DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELTA_UPDATER, DeltaUpdater))
#define DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELTA_UPDATER, DeltaUpdaterClass))
#define IS_DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELTA_UPDATER))
#define IS_DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELTA_UPDATER))
#define DELTA_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELTA_UPDATER, DeltaUpdaterClass))

typedef struct _DeltaUpdater DeltaUpdater;
typedef struct _DeltaUpdaterClass DeltaUpdaterClass;

#define TYPE_DEFAULT_TIMELINE (default_timeline_get_type ())
#define DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimeline))
#define DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))
#define IS_DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEFAULT_TIMELINE))
#define IS_DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEFAULT_TIMELINE))
#define DEFAULT_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))

typedef struct _DefaultTimeline DefaultTimeline;
typedef struct _DefaultTimelineClass DefaultTimelineClass;
typedef struct _DefaultTimelinePrivate DefaultTimelinePrivate;

#define TYPE_BADGE_RADIO_TOOL_BUTTON (badge_radio_tool_button_get_type ())
#define BADGE_RADIO_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BADGE_RADIO_TOOL_BUTTON, BadgeRadioToolButton))
#define BADGE_RADIO_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BADGE_RADIO_TOOL_BUTTON, BadgeRadioToolButtonClass))
#define IS_BADGE_RADIO_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BADGE_RADIO_TOOL_BUTTON))
#define IS_BADGE_RADIO_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BADGE_RADIO_TOOL_BUTTON))
#define BADGE_RADIO_TOOL_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BADGE_RADIO_TOOL_BUTTON, BadgeRadioToolButtonClass))

typedef struct _BadgeRadioToolButton BadgeRadioToolButton;
typedef struct _BadgeRadioToolButtonClass BadgeRadioToolButtonClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;

#define TYPE_ITWITTER_ITEM (itwitter_item_get_type ())
#define ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITWITTER_ITEM, ITwitterItem))
#define IS_ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITWITTER_ITEM))
#define ITWITTER_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITWITTER_ITEM, ITwitterItemIface))

typedef struct _ITwitterItem ITwitterItem;
typedef struct _ITwitterItemIface ITwitterItemIface;
typedef struct _TweetListEntryPrivate TweetListEntryPrivate;

#define TYPE_TWEET (tweet_get_type ())
#define TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET, Tweet))
#define TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET, TweetClass))
#define IS_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET))
#define IS_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET))
#define TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET, TweetClass))

typedef struct _Tweet Tweet;
typedef struct _TweetClass TweetClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_PAGE (page_get_type ())
typedef struct _TweetListBoxPrivate TweetListBoxPrivate;

#define TYPE_TWEET_MODEL (tweet_model_get_type ())
#define TWEET_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_MODEL, TweetModel))
#define TWEET_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_MODEL, TweetModelClass))
#define IS_TWEET_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_MODEL))
#define IS_TWEET_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_MODEL))
#define TWEET_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_MODEL, TweetModelClass))

typedef struct _TweetModel TweetModel;
typedef struct _TweetModelClass TweetModelClass;

#define TYPE_USER_STREAM (user_stream_get_type ())
#define USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_STREAM, UserStream))
#define USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_STREAM, UserStreamClass))
#define IS_USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_STREAM))
#define IS_USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_STREAM))
#define USER_STREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_STREAM, UserStreamClass))

typedef struct _UserStream UserStream;
typedef struct _UserStreamClass UserStreamClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _TweetPrivate TweetPrivate;

#define TYPE_MINI_TWEET (mini_tweet_get_type ())
#define MINI_TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINI_TWEET, MiniTweet))
#define MINI_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINI_TWEET, MiniTweetClass))
#define IS_MINI_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINI_TWEET))
#define IS_MINI_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINI_TWEET))
#define MINI_TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINI_TWEET, MiniTweetClass))

typedef struct _MiniTweet MiniTweet;
typedef struct _MiniTweetClass MiniTweetClass;
typedef struct _MiniTweetPrivate MiniTweetPrivate;

#define TYPE_USER_IDENTITY (user_identity_get_type ())
typedef struct _UserIdentity UserIdentity;

#define TYPE_TEXT_ENTITY (text_entity_get_type ())
typedef struct _TextEntity TextEntity;

#define TYPE_MEDIA (media_get_type ())
#define MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA, Media))
#define MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA, MediaClass))
#define IS_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA))
#define IS_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA))
#define MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA, MediaClass))

typedef struct _Media Media;
typedef struct _MediaClass MediaClass;
typedef struct _AccountPrivate AccountPrivate;

#define TYPE_FILTER (filter_get_type ())
#define FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILTER, Filter))
#define FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILTER, FilterClass))
#define IS_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILTER))
#define IS_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILTER))
#define FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILTER, FilterClass))

typedef struct _Filter Filter;
typedef struct _FilterClass FilterClass;
typedef struct _Block16Data Block16Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))

struct _ScrollWidget {
	GtkScrolledWindow parent_instance;
	ScrollWidgetPrivate * priv;
};

struct _ScrollWidgetClass {
	GtkScrolledWindowClass parent_class;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, Bundle* args);
	void (*on_leave) (IPage* self);
	void (*create_tool_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_tool_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	MainWindow* (*get_main_window) (IPage* self);
	void (*set_main_window) (IPage* self, MainWindow* value);
	Account* (*get_account) (IPage* self);
	void (*set_account) (IPage* self, Account* value);
};

struct _ITimelineIface {
	GTypeInterface parent_iface;
	TweetListBox* (*get_tweet_list) (ITimeline* self);
	void (*set_tweet_list) (ITimeline* self, TweetListBox* value);
	gint (*get_unread_count) (ITimeline* self);
	void (*set_unread_count) (ITimeline* self, gint value);
	DeltaUpdater* (*get_delta_updater) (ITimeline* self);
	void (*set_delta_updater) (ITimeline* self, DeltaUpdater* value);
	const gchar* (*get_function) (ITimeline* self);
};

struct _DefaultTimeline {
	ScrollWidget parent_instance;
	DefaultTimelinePrivate * priv;
	gboolean initialized;
	BadgeRadioToolButton* tool_button;
	gboolean loading;
	GtkWidget* last_focus_widget;
};

struct _DefaultTimelineClass {
	ScrollWidgetClass parent_class;
	void (*on_join) (DefaultTimeline* self, gint page_id, Bundle* args);
	void (*on_leave) (DefaultTimeline* self);
	void (*load_newest) (DefaultTimeline* self);
	void (*load_older) (DefaultTimeline* self);
	gchar* (*get_title) (DefaultTimeline* self);
	void (*create_tool_button) (DefaultTimeline* self, GtkRadioButton* group);
	const gchar* (*get_function) (DefaultTimeline* self);
};

struct _DefaultTimelinePrivate {
	gint _id;
	gint _unread_count;
	MainWindow* _main_window;
	TweetListBox* _tweet_list;
	Account* _account;
	guint _tweet_remove_timeout;
	DeltaUpdater* _delta_updater;
};

struct _ITwitterItemIface {
	GTypeInterface parent_iface;
	gint (*update_time_delta) (ITwitterItem* self, GDateTime* now);
	gint64 (*get_sort_factor) (ITwitterItem* self);
};

struct _TweetListEntry {
	GtkListBoxRow parent_instance;
	TweetListEntryPrivate * priv;
	Tweet* tweet;
};

struct _TweetListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _TweetListBox {
	GtkListBox parent_instance;
	TweetListBoxPrivate * priv;
	DeltaUpdater* delta_updater;
	Account* account;
	TweetModel* model;
};

struct _TweetListBoxClass {
	GtkListBoxClass parent_class;
};

struct _Tweet {
	GObject parent_instance;
	TweetPrivate * priv;
	guint hidden_flags;
	gint64 id;
	MiniTweet* source_tweet;
	MiniTweet* retweeted_tweet;
	MiniTweet* quoted_tweet;
	gchar* avatar_url;
	gboolean verified;
	gint64 my_retweet;
	gboolean protected;
	gchar* notification_id;
	gint64 reply_id;
	gint retweet_count;
	gint favorite_count;
};

struct _TweetClass {
	GObjectClass parent_class;
};

struct _UserIdentity {
	gint64 id;
	gchar* screen_name;
	gchar* user_name;
};

struct _TextEntity {
	guint from;
	guint to;
	gchar* display_text;
	gchar* tooltip_text;
	gchar* target;
	guint info;
};

struct _MiniTweet {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MiniTweetPrivate * priv;
	gint64 id;
	gint64 created_at;
	UserIdentity author;
	gchar* text;
	TextEntity* entities;
	gint entities_length1;
	Media** medias;
	gint medias_length1;
};

struct _MiniTweetClass {
	GTypeClass parent_class;
	void (*finalize) (MiniTweet *self);
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GeeArrayList* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _Block16Data {
	int _ref_count_;
	DefaultTimeline* self;
	RestProxyCall* call;
};


static gpointer default_timeline_parent_class = NULL;
static IPageIface* default_timeline_ipage_parent_iface = NULL;
static ITimelineIface* default_timeline_itimeline_parent_iface = NULL;

GType scroll_widget_get_type (void) G_GNUC_CONST;
GType bundle_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType tweet_list_box_get_type (void) G_GNUC_CONST;
GType delta_updater_get_type (void) G_GNUC_CONST;
GType itimeline_get_type (void) G_GNUC_CONST;
GType default_timeline_get_type (void) G_GNUC_CONST;
GType badge_radio_tool_button_get_type (void) G_GNUC_CONST;
#define DEFAULT_TIMELINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DEFAULT_TIMELINE, DefaultTimelinePrivate))
enum  {
	DEFAULT_TIMELINE_DUMMY_PROPERTY,
	DEFAULT_TIMELINE_ID,
	DEFAULT_TIMELINE_UNREAD_COUNT,
	DEFAULT_TIMELINE_MAIN_WINDOW,
	DEFAULT_TIMELINE_TWEET_LIST,
	DEFAULT_TIMELINE_ACCOUNT,
	DEFAULT_TIMELINE_TWEET_REMOVE_TIMEOUT,
	DEFAULT_TIMELINE_DELTA_UPDATER,
	DEFAULT_TIMELINE_FUNCTION
};
TweetListBox* tweet_list_box_new (gboolean show_placeholder);
TweetListBox* tweet_list_box_construct (GType object_type, gboolean show_placeholder);
DefaultTimeline* default_timeline_construct (GType object_type, gint id);
ScrollWidget* scroll_widget_new (void);
ScrollWidget* scroll_widget_construct (GType object_type);
void ipage_set_id (IPage* self, gint value);
void default_timeline_handle_scrolled_to_start (DefaultTimeline* self);
static void _default_timeline_handle_scrolled_to_start_scroll_widget_scrolled_to_start (ScrollWidget* _sender, gdouble value, gpointer self);
static void __lambda56_ (DefaultTimeline* self);
void default_timeline_load_older (DefaultTimeline* self);
static void ___lambda56__scroll_widget_scrolled_to_end (ScrollWidget* _sender, gpointer self);
static void __lambda57_ (DefaultTimeline* self);
void itimeline_mark_seen_on_scroll (ITimeline* self, gdouble value);
static void ___lambda57__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
TweetListBox* itimeline_get_tweet_list (ITimeline* self);
static void __lambda58_ (DefaultTimeline* self, GtkListBoxRow* row);
GType tweet_list_entry_get_type (void) G_GNUC_CONST;
Bundle* bundle_new (void);
Bundle* bundle_construct (GType object_type);
void bundle_put_int (Bundle* self, const gchar* key, gint value);
#define TWEET_INFO_PAGE_BY_INSTANCE 1
void bundle_put_object (Bundle* self, const gchar* key, GObject* object);
GType itwitter_item_get_type (void) G_GNUC_CONST;
GType tweet_get_type (void) G_GNUC_CONST;
MainWindow* ipage_get_main_window (IPage* self);
GType main_widget_get_type (void) G_GNUC_CONST;
void main_widget_switch_page (MainWidget* self, gint page_id, Bundle* args);
GType page_get_type (void) G_GNUC_CONST;
static void ___lambda58__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static void __lambda89_ (DefaultTimeline* self);
GType tweet_model_get_type (void) G_GNUC_CONST;
void tweet_model_clear (TweetModel* self);
void default_timeline_load_newest (DefaultTimeline* self);
static void ___lambda89__tweet_list_box_retry_button_clicked (TweetListBox* _sender, gpointer self);
void default_timeline_on_join (DefaultTimeline* self, gint page_id, Bundle* args);
static void default_timeline_real_on_join (DefaultTimeline* self, gint page_id, Bundle* args);
Account* ipage_get_account (IPage* self);
GType user_stream_get_type (void) G_GNUC_CONST;
UserStream* account_get_user_stream (Account* self);
static void default_timeline_stream_resumed_cb (DefaultTimeline* self);
static void _default_timeline_stream_resumed_cb_user_stream_resumed (UserStream* _sender, gpointer self);
gboolean settings_auto_scroll_on_new_tweets (void);
void default_timeline_mark_seen (DefaultTimeline* self, gint64 id);
static gboolean default_timeline_real_handles_double_open (IPage* base);
static void default_timeline_real_double_open (IPage* base);
void scroll_widget_scroll_up_next (ScrollWidget* self, gboolean animate, gboolean force_wait, gboolean force_start);
void default_timeline_on_leave (DefaultTimeline* self);
static void default_timeline_real_on_leave (DefaultTimeline* self);
TweetListEntry* tweet_list_box_get_action_entry (TweetListBox* self);
gboolean tweet_list_entry_get_shows_actions (TweetListEntry* self);
void tweet_list_entry_toggle_mode (TweetListEntry* self);
static void default_timeline_real_load_newest (DefaultTimeline* self);
static void default_timeline_real_load_older (DefaultTimeline* self);
gchar* default_timeline_get_title (DefaultTimeline* self);
static gchar* default_timeline_real_get_title (DefaultTimeline* self);
static void default_timeline_real_destroy (GtkWidget* base);
guint default_timeline_get_tweet_remove_timeout (DefaultTimeline* self);
void default_timeline_set_tweet_remove_timeout (DefaultTimeline* self, guint value);
void default_timeline_create_tool_button (DefaultTimeline* self, GtkRadioButton* group);
static void default_timeline_real_create_tool_button (DefaultTimeline* self, GtkRadioButton* group);
static GtkRadioButton* default_timeline_real_get_tool_button (IPage* base);
#define ITIMELINE_REST 25
static gboolean ___lambda55_ (DefaultTimeline* self);
gboolean scroll_widget_get_scrolled_up (ScrollWidget* self);
void tweet_model_remove_last_n_visible (TweetModel* self, guint amount);
static gboolean ____lambda55__gsource_func (gpointer self);
void default_timeline_delete_tweet (DefaultTimeline* self, gint64 tweet_id);
gboolean tweet_model_delete_id (TweetModel* self, gint64 id, gboolean* seen);
gint itimeline_get_unread_count (ITimeline* self);
void itimeline_set_unread_count (ITimeline* self, gint value);
void default_timeline_toggle_favorite (DefaultTimeline* self, gint64 id, gboolean mode);
gpointer mini_tweet_ref (gpointer instance);
void mini_tweet_unref (gpointer instance);
GParamSpec* param_spec_mini_tweet (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_mini_tweet (GValue* value, gpointer v_object);
void value_take_mini_tweet (GValue* value, gpointer v_object);
gpointer value_get_mini_tweet (const GValue* value);
GType mini_tweet_get_type (void) G_GNUC_CONST;
void tweet_set_favorited (Tweet* self, gboolean value);
guint default_timeline_get_rt_flags (DefaultTimeline* self, Tweet* t);
gint64 tweet_get_user_id (Tweet* self);
gint64 account_get_id (Account* self);
#define TWEET_HIDDEN_FORCE ((guint) (1 << 0))
gboolean account_follows_id (Account* self, gint64 user_id);
#define TWEET_HIDDEN_RT_BY_FOLLOWEE ((guint) (1 << 5))
GType user_identity_get_type (void) G_GNUC_CONST;
UserIdentity* user_identity_dup (const UserIdentity* self);
void user_identity_free (UserIdentity* self);
void user_identity_copy (const UserIdentity* self, UserIdentity* dest);
void user_identity_destroy (UserIdentity* self);
GType text_entity_get_type (void) G_GNUC_CONST;
TextEntity* text_entity_dup (const TextEntity* self);
void text_entity_free (TextEntity* self);
void text_entity_copy (const TextEntity* self, TextEntity* dest);
void text_entity_destroy (TextEntity* self);
GType media_get_type (void) G_GNUC_CONST;
GType filter_get_type (void) G_GNUC_CONST;
#define TWEET_HIDDEN_RTS_DISABLED ((guint) (1 << 3))
gboolean tweet_get_seen (Tweet* self);
void tweet_set_seen (Tweet* self, gboolean value);
void default_timeline_scroll_up (DefaultTimeline* self, Tweet* t);
gint main_window_get_cur_page_id (MainWindow* self);
gint ipage_get_id (IPage* self);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
OAuthProxy* account_get_proxy (Account* self);
const gchar* itimeline_get_function (ITimeline* self);
gint64 tweet_model_get_greatest_id (TweetModel* self);
static void __lambda90_ (Block16Data* _data16_, GObject* o, GAsyncResult* res);
static void ___lambda90__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void badge_radio_tool_button_set_show_badge (BadgeRadioToolButton* self, gboolean value);
const gchar* default_timeline_get_function (DefaultTimeline* self);
static void default_timeline_finalize (GObject* obj);
DeltaUpdater* itimeline_get_delta_updater (ITimeline* self);
static void _vala_default_timeline_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void ipage_set_main_window (IPage* self, MainWindow* value);
void itimeline_set_tweet_list (ITimeline* self, TweetListBox* value);
void ipage_set_account (IPage* self, Account* value);
void itimeline_set_delta_updater (ITimeline* self, DeltaUpdater* value);
static void _vala_default_timeline_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _default_timeline_handle_scrolled_to_start_scroll_widget_scrolled_to_start (ScrollWidget* _sender, gdouble value, gpointer self) {
	default_timeline_handle_scrolled_to_start ((DefaultTimeline*) self);
}


static void __lambda56_ (DefaultTimeline* self) {
	gboolean _tmp0_ = FALSE;
	_tmp0_ = self->loading;
	if (!_tmp0_) {
		default_timeline_load_older (self);
	}
}


static void ___lambda56__scroll_widget_scrolled_to_end (ScrollWidget* _sender, gpointer self) {
	__lambda56_ ((DefaultTimeline*) self);
}


static void __lambda57_ (DefaultTimeline* self) {
	GtkAdjustment* _tmp0_ = NULL;
	GtkAdjustment* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	_tmp0_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_adjustment_get_value (_tmp1_);
	_tmp3_ = _tmp2_;
	itimeline_mark_seen_on_scroll (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline), _tmp3_);
}


static void ___lambda57__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda57_ ((DefaultTimeline*) self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda58_ (DefaultTimeline* self, GtkListBoxRow* row) {
	GtkListBoxRow* _tmp0_ = NULL;
	GtkListBoxRow* _tmp10_ = NULL;
	GtkWidget* _tmp11_ = NULL;
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = row;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_TWEET_LIST_ENTRY)) {
		Bundle* bundle = NULL;
		Bundle* _tmp1_ = NULL;
		Bundle* _tmp2_ = NULL;
		Bundle* _tmp3_ = NULL;
		GtkListBoxRow* _tmp4_ = NULL;
		Tweet* _tmp5_ = NULL;
		MainWindow* _tmp6_ = NULL;
		MainWindow* _tmp7_ = NULL;
		MainWidget* _tmp8_ = NULL;
		Bundle* _tmp9_ = NULL;
		_tmp1_ = bundle_new ();
		bundle = _tmp1_;
		_tmp2_ = bundle;
		bundle_put_int (_tmp2_, "mode", TWEET_INFO_PAGE_BY_INSTANCE);
		_tmp3_ = bundle;
		_tmp4_ = row;
		_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_TWEET_LIST_ENTRY, TweetListEntry)->tweet;
		bundle_put_object (_tmp3_, "tweet", G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, G_TYPE_OBJECT, GObject));
		_tmp6_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_->main_widget;
		_tmp9_ = bundle;
		main_widget_switch_page (_tmp8_, (gint) PAGE_TWEET_INFO, _tmp9_);
		_g_object_unref0 (bundle);
	}
	_tmp10_ = row;
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->last_focus_widget);
	self->last_focus_widget = _tmp11_;
}


static void ___lambda58__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	__lambda58_ ((DefaultTimeline*) self, row);
}


static void __lambda89_ (DefaultTimeline* self) {
	TweetListBox* _tmp0_ = NULL;
	TweetListBox* _tmp1_ = NULL;
	TweetModel* _tmp2_ = NULL;
	_tmp0_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->model;
	tweet_model_clear (_tmp2_);
	default_timeline_load_newest (self);
}


static void ___lambda89__tweet_list_box_retry_button_clicked (TweetListBox* _sender, gpointer self) {
	__lambda89_ ((DefaultTimeline*) self);
}


DefaultTimeline* default_timeline_construct (GType object_type, gint id) {
	DefaultTimeline * self = NULL;
	gint _tmp0_ = 0;
	GtkAdjustment* _tmp1_ = NULL;
	GtkAdjustment* _tmp2_ = NULL;
	TweetListBox* _tmp3_ = NULL;
	TweetListBox* _tmp4_ = NULL;
	TweetListBox* _tmp5_ = NULL;
	TweetListBox* _tmp6_ = NULL;
	TweetListBox* _tmp7_ = NULL;
	TweetListBox* _tmp8_ = NULL;
	self = (DefaultTimeline*) scroll_widget_construct (object_type);
	_tmp0_ = id;
	ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), _tmp0_);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), "scrolled-to-start", (GCallback) _default_timeline_handle_scrolled_to_start_scroll_widget_scrolled_to_start, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), "scrolled-to-end", (GCallback) ___lambda56__scroll_widget_scrolled_to_end, self, 0);
	_tmp1_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp2_ = _tmp1_;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, G_TYPE_OBJECT, GObject), "notify::value", (GCallback) ___lambda57__g_object_notify, self, 0);
	_tmp3_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp4_ = _tmp3_;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget));
	_tmp5_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp6_ = _tmp5_;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_list_box_get_type (), GtkListBox), "row-activated", (GCallback) ___lambda58__gtk_list_box_row_activated, self, 0);
	_tmp7_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp8_ = _tmp7_;
	g_signal_connect_object (_tmp8_, "retry-button-clicked", (GCallback) ___lambda89__tweet_list_box_retry_button_clicked, self, 0);
	gtk_widget_set_hexpand (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), TRUE);
	return self;
}


static void _default_timeline_stream_resumed_cb_user_stream_resumed (UserStream* _sender, gpointer self) {
	default_timeline_stream_resumed_cb ((DefaultTimeline*) self);
}


static void default_timeline_real_on_join (DefaultTimeline* self, gint page_id, Bundle* args) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GtkWidget* _tmp6_ = NULL;
	g_return_if_fail ((args == NULL) || IS_BUNDLE (args));
	_tmp0_ = self->initialized;
	if (!_tmp0_) {
		Account* _tmp1_ = NULL;
		Account* _tmp2_ = NULL;
		UserStream* _tmp3_ = NULL;
		UserStream* _tmp4_ = NULL;
		default_timeline_load_newest (self);
		_tmp1_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp2_ = _tmp1_;
		_tmp3_ = account_get_user_stream (_tmp2_);
		_tmp4_ = _tmp3_;
		g_signal_connect_object (_tmp4_, "resumed", (GCallback) _default_timeline_stream_resumed_cb_user_stream_resumed, self, 0);
		self->initialized = TRUE;
	}
	_tmp5_ = settings_auto_scroll_on_new_tweets ();
	if (_tmp5_) {
		self->priv->_unread_count = 0;
		default_timeline_mark_seen (self, (gint64) -1);
	}
	_tmp6_ = self->last_focus_widget;
	if (_tmp6_ != NULL) {
		GtkWidget* _tmp7_ = NULL;
		_tmp7_ = self->last_focus_widget;
		gtk_widget_grab_focus (_tmp7_);
	}
}


void default_timeline_on_join (DefaultTimeline* self, gint page_id, Bundle* args) {
	g_return_if_fail (IS_DEFAULT_TIMELINE (self));
	DEFAULT_TIMELINE_GET_CLASS (self)->on_join (self, page_id, args);
}


static gboolean default_timeline_real_handles_double_open (IPage* base) {
	DefaultTimeline * self;
	gboolean result = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	result = TRUE;
	return result;
}


static void default_timeline_real_double_open (IPage* base) {
	DefaultTimeline * self;
	gboolean _tmp0_ = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	_tmp0_ = self->loading;
	if (!_tmp0_) {
		TweetListBox* _tmp1_ = NULL;
		TweetListBox* _tmp2_ = NULL;
		GtkListBoxRow* _tmp3_ = NULL;
		scroll_widget_scroll_up_next (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), TRUE, FALSE, TRUE);
		_tmp1_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
		_tmp2_ = _tmp1_;
		_tmp3_ = gtk_list_box_get_row_at_index (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_list_box_get_type (), GtkListBox), 0);
		gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget));
	}
}


static void default_timeline_real_on_leave (DefaultTimeline* self) {
	GtkWidget* focus_widget = NULL;
	MainWindow* _tmp0_ = NULL;
	MainWindow* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	GtkWidget* _tmp4_ = NULL;
	GList* list_rows = NULL;
	TweetListBox* _tmp5_ = NULL;
	TweetListBox* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
	GList* _tmp8_ = NULL;
	gboolean _tmp14_ = FALSE;
	TweetListBox* _tmp15_ = NULL;
	TweetListBox* _tmp16_ = NULL;
	TweetListEntry* _tmp17_ = NULL;
	TweetListEntry* _tmp18_ = NULL;
	_tmp0_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_window_get_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow));
	_tmp3_ = _g_object_ref0 (_tmp2_);
	focus_widget = _tmp3_;
	_tmp4_ = focus_widget;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (focus_widget);
		return;
	}
	_tmp5_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp6_ = _tmp5_;
	_tmp7_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_container_get_type (), GtkContainer));
	list_rows = _tmp7_;
	_tmp8_ = list_rows;
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp8_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* _tmp9_ = NULL;
			GtkWidget* w = NULL;
			_tmp9_ = _g_object_ref0 ((GtkWidget*) w_it->data);
			w = _tmp9_;
			{
				GtkWidget* _tmp10_ = NULL;
				GtkWidget* _tmp11_ = NULL;
				_tmp10_ = w;
				_tmp11_ = focus_widget;
				if (_tmp10_ == _tmp11_) {
					GtkWidget* _tmp12_ = NULL;
					GtkWidget* _tmp13_ = NULL;
					_tmp12_ = w;
					_tmp13_ = _g_object_ref0 (_tmp12_);
					_g_object_unref0 (self->last_focus_widget);
					self->last_focus_widget = _tmp13_;
					_g_object_unref0 (w);
					break;
				}
				_g_object_unref0 (w);
			}
		}
	}
	_tmp15_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp16_ = _tmp15_;
	_tmp17_ = tweet_list_box_get_action_entry (_tmp16_);
	_tmp18_ = _tmp17_;
	if (_tmp18_ != NULL) {
		TweetListBox* _tmp19_ = NULL;
		TweetListBox* _tmp20_ = NULL;
		TweetListEntry* _tmp21_ = NULL;
		TweetListEntry* _tmp22_ = NULL;
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_ = FALSE;
		_tmp19_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
		_tmp20_ = _tmp19_;
		_tmp21_ = tweet_list_box_get_action_entry (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = tweet_list_entry_get_shows_actions (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp14_ = _tmp24_;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		TweetListBox* _tmp25_ = NULL;
		TweetListBox* _tmp26_ = NULL;
		TweetListEntry* _tmp27_ = NULL;
		TweetListEntry* _tmp28_ = NULL;
		_tmp25_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
		_tmp26_ = _tmp25_;
		_tmp27_ = tweet_list_box_get_action_entry (_tmp26_);
		_tmp28_ = _tmp27_;
		tweet_list_entry_toggle_mode (_tmp28_);
	}
	_g_list_free0 (list_rows);
	_g_object_unref0 (focus_widget);
}


void default_timeline_on_leave (DefaultTimeline* self) {
	g_return_if_fail (IS_DEFAULT_TIMELINE (self));
	DEFAULT_TIMELINE_GET_CLASS (self)->on_leave (self);
}


static void default_timeline_real_load_newest (DefaultTimeline* self) {
	g_critical ("Type `%s' does not implement abstract method `default_timeline_load_newest'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void default_timeline_load_newest (DefaultTimeline* self) {
	g_return_if_fail (IS_DEFAULT_TIMELINE (self));
	DEFAULT_TIMELINE_GET_CLASS (self)->load_newest (self);
}


static void default_timeline_real_load_older (DefaultTimeline* self) {
	g_critical ("Type `%s' does not implement abstract method `default_timeline_load_older'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void default_timeline_load_older (DefaultTimeline* self) {
	g_return_if_fail (IS_DEFAULT_TIMELINE (self));
	DEFAULT_TIMELINE_GET_CLASS (self)->load_older (self);
}


static gchar* default_timeline_real_get_title (DefaultTimeline* self) {
	g_critical ("Type `%s' does not implement abstract method `default_timeline_get_title'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gchar* default_timeline_get_title (DefaultTimeline* self) {
	g_return_val_if_fail (IS_DEFAULT_TIMELINE (self), NULL);
	return DEFAULT_TIMELINE_GET_CLASS (self)->get_title (self);
}


static void default_timeline_real_destroy (GtkWidget* base) {
	DefaultTimeline * self;
	guint _tmp0_ = 0U;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	_tmp0_ = self->priv->_tweet_remove_timeout;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->_tweet_remove_timeout;
		g_source_remove (_tmp1_);
		default_timeline_set_tweet_remove_timeout (self, (guint) 0);
	}
}


static void default_timeline_real_create_tool_button (DefaultTimeline* self, GtkRadioButton* group) {
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
}


void default_timeline_create_tool_button (DefaultTimeline* self, GtkRadioButton* group) {
	g_return_if_fail (IS_DEFAULT_TIMELINE (self));
	DEFAULT_TIMELINE_GET_CLASS (self)->create_tool_button (self, group);
}


static GtkRadioButton* default_timeline_real_get_tool_button (IPage* base) {
	DefaultTimeline * self;
	GtkRadioButton* result = NULL;
	BadgeRadioToolButton* _tmp0_ = NULL;
	GtkRadioButton* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	_tmp0_ = self->tool_button;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_radio_button_get_type (), GtkRadioButton));
	result = _tmp1_;
	return result;
}


/**
   * Handle the case of the user scrolling to the start of the list,
   * i.e. remove all the items except a few ones after a timeout.
   */
static gboolean ___lambda55_ (DefaultTimeline* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	TweetListBox* _tmp2_ = NULL;
	TweetListBox* _tmp3_ = NULL;
	TweetModel* _tmp4_ = NULL;
	TweetListBox* _tmp5_ = NULL;
	TweetListBox* _tmp6_ = NULL;
	TweetModel* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	_tmp0_ = scroll_widget_get_scrolled_up (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget));
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		default_timeline_set_tweet_remove_timeout (self, (guint) 0);
		result = FALSE;
		return result;
	}
	_tmp2_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_->model;
	_tmp5_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_->model;
	_tmp8_ = g_list_model_get_n_items (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_list_model_get_type (), GListModel));
	tweet_model_remove_last_n_visible (_tmp4_, _tmp8_ - ITIMELINE_REST);
	default_timeline_set_tweet_remove_timeout (self, (guint) 0);
	result = G_SOURCE_REMOVE;
	return result;
}


static gboolean ____lambda55__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda55_ ((DefaultTimeline*) self);
	return result;
}


void default_timeline_handle_scrolled_to_start (DefaultTimeline* self) {
	guint _tmp0_ = 0U;
	TweetListBox* _tmp1_ = NULL;
	TweetListBox* _tmp2_ = NULL;
	TweetModel* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	g_return_if_fail (IS_DEFAULT_TIMELINE (self));
	_tmp0_ = self->priv->_tweet_remove_timeout;
	if (_tmp0_ != ((guint) 0)) {
		return;
	}
	_tmp1_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->model;
	_tmp4_ = g_list_model_get_n_items (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_list_model_get_type (), GListModel));
	if (_tmp4_ > ((guint) ITIMELINE_REST)) {
		guint _tmp5_ = 0U;
		_tmp5_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ____lambda55__gsource_func, g_object_ref (self), g_object_unref);
		default_timeline_set_tweet_remove_timeout (self, _tmp5_);
	} else {
		guint _tmp6_ = 0U;
		_tmp6_ = self->priv->_tweet_remove_timeout;
		if (_tmp6_ != ((guint) 0)) {
			guint _tmp7_ = 0U;
			_tmp7_ = self->priv->_tweet_remove_timeout;
			g_source_remove (_tmp7_);
			default_timeline_set_tweet_remove_timeout (self, (guint) 0);
		}
	}
}


void default_timeline_delete_tweet (DefaultTimeline* self, gint64 tweet_id) {
	gboolean was_seen = FALSE;
	gboolean removed = FALSE;
	TweetListBox* _tmp0_ = NULL;
	TweetListBox* _tmp1_ = NULL;
	TweetModel* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (IS_DEFAULT_TIMELINE (self));
	_tmp0_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->model;
	_tmp3_ = tweet_id;
	_tmp5_ = tweet_model_delete_id (_tmp2_, _tmp3_, &_tmp4_);
	was_seen = _tmp4_;
	removed = _tmp5_;
	_tmp7_ = removed;
	if (_tmp7_) {
		gboolean _tmp8_ = FALSE;
		_tmp8_ = was_seen;
		_tmp6_ = !_tmp8_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		_tmp9_ = itimeline_get_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
		_tmp10_ = _tmp9_;
		itimeline_set_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline), _tmp10_ - 1);
	}
}


void default_timeline_toggle_favorite (DefaultTimeline* self, gint64 id, gboolean mode) {
	GList* tweets = NULL;
	TweetListBox* _tmp0_ = NULL;
	TweetListBox* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	g_return_if_fail (IS_DEFAULT_TIMELINE (self));
	_tmp0_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_container_get_type (), GtkContainer));
	tweets = _tmp2_;
	_tmp3_ = tweets;
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp3_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* w = NULL;
			w = (GtkWidget*) w_it->data;
			{
				GtkWidget* _tmp4_ = NULL;
				Tweet* t = NULL;
				GtkWidget* _tmp5_ = NULL;
				Tweet* _tmp6_ = NULL;
				Tweet* _tmp7_ = NULL;
				Tweet* _tmp8_ = NULL;
				gint64 _tmp9_ = 0LL;
				gint64 _tmp10_ = 0LL;
				_tmp4_ = w;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, TYPE_TWEET_LIST_ENTRY)) {
					continue;
				}
				_tmp5_ = w;
				_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_TWEET_LIST_ENTRY, TweetListEntry)->tweet;
				_tmp7_ = _g_object_ref0 (_tmp6_);
				t = _tmp7_;
				_tmp8_ = t;
				_tmp9_ = _tmp8_->id;
				_tmp10_ = id;
				if (_tmp9_ == _tmp10_) {
					Tweet* _tmp11_ = NULL;
					gboolean _tmp12_ = FALSE;
					_tmp11_ = t;
					_tmp12_ = mode;
					tweet_set_favorited (_tmp11_, _tmp12_);
					_g_object_unref0 (t);
					break;
				}
				_g_object_unref0 (t);
			}
		}
	}
	_g_list_free0 (tweets);
}


/**
   * So, we don't want to display a retweet in the following situations:
   *   1) If the original tweet was a tweet by the authenticated user
   *   2) In any case, if the user follows the author of the tweet
   *      (not the author of the retweet!), we already get the source
   *      tweet by other means, so don't display it again.
   *   3) It's a retweet from the authenticating user itself
   *   4) If the tweet was retweeted by a user that is on the list of
   *      users the authenticating user disabled RTs for.
   *   5) If the retweet is already in the timeline. There's no other
   *      way of checking the case where 2 indipendend users retweet
   *      the same tweet.
   */
guint default_timeline_get_rt_flags (DefaultTimeline* self, Tweet* t) {
	guint result = 0U;
	guint flags = 0U;
	Tweet* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	Account* _tmp3_ = NULL;
	Account* _tmp4_ = NULL;
	gint64 _tmp5_ = 0LL;
	gint64 _tmp6_ = 0LL;
	Account* _tmp8_ = NULL;
	Account* _tmp9_ = NULL;
	Tweet* _tmp10_ = NULL;
	gint64 _tmp11_ = 0LL;
	gint64 _tmp12_ = 0LL;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp15_ = FALSE;
	Tweet* _tmp16_ = NULL;
	MiniTweet* _tmp17_ = NULL;
	Account* _tmp27_ = NULL;
	Account* _tmp28_ = NULL;
	gint64* _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	TweetListBox* _tmp36_ = NULL;
	TweetListBox* _tmp37_ = NULL;
	GList* _tmp38_ = NULL;
	g_return_val_if_fail (IS_DEFAULT_TIMELINE (self), 0U);
	g_return_val_if_fail (IS_TWEET (t), 0U);
	flags = (guint) 0;
	_tmp0_ = t;
	_tmp1_ = tweet_get_user_id (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp4_ = _tmp3_;
	_tmp5_ = account_get_id (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp2_ == _tmp6_) {
		guint _tmp7_ = 0U;
		_tmp7_ = flags;
		flags = _tmp7_ | TWEET_HIDDEN_FORCE;
	}
	_tmp8_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp9_ = _tmp8_;
	_tmp10_ = t;
	_tmp11_ = tweet_get_user_id (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = account_follows_id (_tmp9_, _tmp12_);
	if (_tmp13_) {
		guint _tmp14_ = 0U;
		_tmp14_ = flags;
		flags = _tmp14_ | TWEET_HIDDEN_RT_BY_FOLLOWEE;
	}
	_tmp16_ = t;
	_tmp17_ = _tmp16_->retweeted_tweet;
	if (_tmp17_ != NULL) {
		Tweet* _tmp18_ = NULL;
		MiniTweet* _tmp19_ = NULL;
		UserIdentity _tmp20_ = {0};
		gint64 _tmp21_ = 0LL;
		Account* _tmp22_ = NULL;
		Account* _tmp23_ = NULL;
		gint64 _tmp24_ = 0LL;
		gint64 _tmp25_ = 0LL;
		_tmp18_ = t;
		_tmp19_ = _tmp18_->retweeted_tweet;
		_tmp20_ = _tmp19_->author;
		_tmp21_ = _tmp20_.id;
		_tmp22_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp23_ = _tmp22_;
		_tmp24_ = account_get_id (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp15_ = _tmp21_ == _tmp25_;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		guint _tmp26_ = 0U;
		_tmp26_ = flags;
		flags = _tmp26_ | TWEET_HIDDEN_FORCE;
	}
	_tmp27_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp28_ = _tmp27_;
	_tmp29_ = _tmp28_->disabled_rts;
	_tmp29__length1 = _tmp28_->disabled_rts_length1;
	{
		gint64* id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp29_;
		id_collection_length1 = _tmp29__length1;
		for (id_it = 0; id_it < _tmp29__length1; id_it = id_it + 1) {
			gint64 id = 0LL;
			id = id_collection[id_it];
			{
				gint64 _tmp30_ = 0LL;
				Tweet* _tmp31_ = NULL;
				MiniTweet* _tmp32_ = NULL;
				UserIdentity _tmp33_ = {0};
				gint64 _tmp34_ = 0LL;
				_tmp30_ = id;
				_tmp31_ = t;
				_tmp32_ = _tmp31_->source_tweet;
				_tmp33_ = _tmp32_->author;
				_tmp34_ = _tmp33_.id;
				if (_tmp30_ == _tmp34_) {
					guint _tmp35_ = 0U;
					_tmp35_ = flags;
					flags = _tmp35_ | TWEET_HIDDEN_RTS_DISABLED;
					break;
				}
			}
		}
	}
	_tmp36_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp37_ = _tmp36_;
	_tmp38_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_container_get_type (), GtkContainer));
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp38_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* _tmp39_ = NULL;
			GtkWidget* w = NULL;
			_tmp39_ = _g_object_ref0 ((GtkWidget*) w_it->data);
			w = _tmp39_;
			{
				GtkWidget* _tmp40_ = NULL;
				_tmp40_ = w;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp40_, TYPE_TWEET_LIST_ENTRY)) {
					Tweet* tt = NULL;
					GtkWidget* _tmp41_ = NULL;
					Tweet* _tmp42_ = NULL;
					Tweet* _tmp43_ = NULL;
					gboolean _tmp44_ = FALSE;
					Tweet* _tmp45_ = NULL;
					MiniTweet* _tmp46_ = NULL;
					_tmp41_ = w;
					_tmp42_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, TYPE_TWEET_LIST_ENTRY, TweetListEntry)->tweet;
					_tmp43_ = _g_object_ref0 (_tmp42_);
					tt = _tmp43_;
					_tmp45_ = tt;
					_tmp46_ = _tmp45_->retweeted_tweet;
					if (_tmp46_ != NULL) {
						Tweet* _tmp47_ = NULL;
						MiniTweet* _tmp48_ = NULL;
						gint64 _tmp49_ = 0LL;
						Tweet* _tmp50_ = NULL;
						MiniTweet* _tmp51_ = NULL;
						gint64 _tmp52_ = 0LL;
						_tmp47_ = tt;
						_tmp48_ = _tmp47_->retweeted_tweet;
						_tmp49_ = _tmp48_->id;
						_tmp50_ = t;
						_tmp51_ = _tmp50_->retweeted_tweet;
						_tmp52_ = _tmp51_->id;
						_tmp44_ = _tmp49_ == _tmp52_;
					} else {
						_tmp44_ = FALSE;
					}
					if (_tmp44_) {
						guint _tmp53_ = 0U;
						_tmp53_ = flags;
						flags = _tmp53_ | TWEET_HIDDEN_FORCE;
						_g_object_unref0 (tt);
						_g_object_unref0 (w);
						break;
					}
					_g_object_unref0 (tt);
				}
				_g_object_unref0 (w);
			}
		}
		_g_list_free0 (w_collection);
	}
	result = flags;
	return result;
}


void default_timeline_mark_seen (DefaultTimeline* self, gint64 id) {
	TweetListBox* _tmp0_ = NULL;
	TweetListBox* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	g_return_if_fail (IS_DEFAULT_TIMELINE (self));
	_tmp0_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_container_get_type (), GtkContainer));
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp2_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* _tmp3_ = NULL;
			GtkWidget* w = NULL;
			_tmp3_ = _g_object_ref0 ((GtkWidget*) w_it->data);
			w = _tmp3_;
			{
				gboolean _tmp4_ = FALSE;
				GtkWidget* _tmp5_ = NULL;
				TweetListEntry* tle = NULL;
				GtkWidget* _tmp7_ = NULL;
				TweetListEntry* _tmp8_ = NULL;
				gboolean _tmp9_ = FALSE;
				TweetListEntry* _tmp10_ = NULL;
				Tweet* _tmp11_ = NULL;
				gint64 _tmp12_ = 0LL;
				gint64 _tmp13_ = 0LL;
				_tmp5_ = w;
				if (_tmp5_ == NULL) {
					_tmp4_ = TRUE;
				} else {
					GtkWidget* _tmp6_ = NULL;
					_tmp6_ = w;
					_tmp4_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, TYPE_TWEET_LIST_ENTRY);
				}
				if (_tmp4_) {
					_g_object_unref0 (w);
					continue;
				}
				_tmp7_ = w;
				_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_TWEET_LIST_ENTRY, TweetListEntry));
				tle = _tmp8_;
				_tmp10_ = tle;
				_tmp11_ = _tmp10_->tweet;
				_tmp12_ = _tmp11_->id;
				_tmp13_ = id;
				if (_tmp12_ == _tmp13_) {
					_tmp9_ = TRUE;
				} else {
					gint64 _tmp14_ = 0LL;
					_tmp14_ = id;
					_tmp9_ = _tmp14_ == ((gint64) -1);
				}
				if (_tmp9_) {
					TweetListEntry* _tmp15_ = NULL;
					Tweet* _tmp16_ = NULL;
					gboolean _tmp17_ = FALSE;
					gboolean _tmp18_ = FALSE;
					TweetListEntry* _tmp21_ = NULL;
					Tweet* _tmp22_ = NULL;
					_tmp15_ = tle;
					_tmp16_ = _tmp15_->tweet;
					_tmp17_ = tweet_get_seen (_tmp16_);
					_tmp18_ = _tmp17_;
					if (!_tmp18_) {
						gint _tmp19_ = 0;
						gint _tmp20_ = 0;
						_tmp19_ = itimeline_get_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
						_tmp20_ = _tmp19_;
						itimeline_set_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline), _tmp20_ - 1);
					}
					_tmp21_ = tle;
					_tmp22_ = _tmp21_->tweet;
					tweet_set_seen (_tmp22_, TRUE);
					_g_object_unref0 (tle);
					_g_object_unref0 (w);
					break;
				}
				_g_object_unref0 (tle);
				_g_object_unref0 (w);
			}
		}
		_g_list_free0 (w_collection);
	}
}


void default_timeline_scroll_up (DefaultTimeline* self, Tweet* t) {
	gboolean auto_scroll = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (IS_DEFAULT_TIMELINE (self));
	g_return_if_fail (IS_TWEET (t));
	_tmp0_ = settings_auto_scroll_on_new_tweets ();
	auto_scroll = _tmp0_;
	_tmp2_ = scroll_widget_get_scrolled_up (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget));
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		gboolean _tmp4_ = FALSE;
		Tweet* _tmp5_ = NULL;
		gint64 _tmp6_ = 0LL;
		gint64 _tmp7_ = 0LL;
		Account* _tmp8_ = NULL;
		Account* _tmp9_ = NULL;
		gint64 _tmp10_ = 0LL;
		gint64 _tmp11_ = 0LL;
		_tmp5_ = t;
		_tmp6_ = tweet_get_user_id (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp9_ = _tmp8_;
		_tmp10_ = account_get_id (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp7_ == _tmp11_) {
			_tmp4_ = TRUE;
		} else {
			gboolean _tmp12_ = FALSE;
			_tmp12_ = auto_scroll;
			_tmp4_ = _tmp12_;
		}
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		MainWindow* _tmp13_ = NULL;
		MainWindow* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		_tmp13_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp14_ = _tmp13_;
		_tmp15_ = main_window_get_cur_page_id (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp18_ = _tmp17_;
		scroll_widget_scroll_up_next (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), TRUE, FALSE, _tmp16_ != _tmp18_);
	}
}


static Block16Data* block16_data_ref (Block16Data* _data16_) {
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}


static void block16_data_unref (void * _userdata_) {
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		DefaultTimeline* self;
		self = _data16_->self;
		_g_object_unref0 (_data16_->call);
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static void __lambda90_ (Block16Data* _data16_, GObject* o, GAsyncResult* res) {
	DefaultTimeline* self;
	JsonParser* parser = NULL;
	JsonParser* _tmp7_ = NULL;
	JsonArray* root_arr = NULL;
	JsonParser* _tmp16_ = NULL;
	JsonNode* _tmp17_ = NULL;
	JsonArray* _tmp18_ = NULL;
	JsonArray* _tmp19_ = NULL;
	JsonArray* _tmp20_ = NULL;
	guint _tmp21_ = 0U;
	GError * _inner_error_ = NULL;
	self = _data16_->self;
	g_return_if_fail ((o == NULL) || G_IS_OBJECT (o));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = _data16_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch15_g_error;
		}
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError* e = NULL;
		TweetListBox* _tmp2_ = NULL;
		TweetListBox* _tmp3_ = NULL;
		TweetModel* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_->model;
		tweet_model_clear (_tmp4_);
		default_timeline_load_newest (self);
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("DefaultTimeline.vala:291: %s", _tmp6_);
		_g_error_free0 (e);
		return;
	}
	__finally15:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = json_parser_new ();
	parser = _tmp7_;
	{
		JsonParser* _tmp8_ = NULL;
		RestProxyCall* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		_tmp8_ = parser;
		_tmp9_ = _data16_->call;
		_tmp10_ = rest_proxy_call_get_payload (_tmp9_);
		json_parser_load_from_data (_tmp8_, _tmp10_, (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch16_g_error;
		}
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError* e = NULL;
		TweetListBox* _tmp11_ = NULL;
		TweetListBox* _tmp12_ = NULL;
		TweetModel* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_->model;
		tweet_model_clear (_tmp13_);
		default_timeline_load_newest (self);
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("DefaultTimeline.vala:301: %s", _tmp15_);
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		return;
	}
	__finally16:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (parser);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp16_ = parser;
	_tmp17_ = json_parser_get_root (_tmp16_);
	_tmp18_ = json_node_get_array (_tmp17_);
	_tmp19_ = _json_array_ref0 (_tmp18_);
	root_arr = _tmp19_;
	_tmp20_ = root_arr;
	_tmp21_ = json_array_get_length (_tmp20_);
	if (_tmp21_ > ((guint) 0)) {
		TweetListBox* _tmp22_ = NULL;
		TweetListBox* _tmp23_ = NULL;
		TweetModel* _tmp24_ = NULL;
		_tmp22_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
		_tmp23_ = _tmp22_;
		_tmp24_ = _tmp23_->model;
		tweet_model_clear (_tmp24_);
		itimeline_set_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline), 0);
		default_timeline_load_newest (self);
	}
	_json_array_unref0 (root_arr);
	_g_object_unref0 (parser);
}


static void ___lambda90__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda90_ (self, source_object, res);
	block16_data_unref (self);
}


static void default_timeline_stream_resumed_cb (DefaultTimeline* self) {
	Block16Data* _data16_;
	TweetListBox* _tmp0_ = NULL;
	TweetListBox* _tmp1_ = NULL;
	TweetModel* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	Account* _tmp4_ = NULL;
	Account* _tmp5_ = NULL;
	OAuthProxy* _tmp6_ = NULL;
	OAuthProxy* _tmp7_ = NULL;
	RestProxyCall* _tmp8_ = NULL;
	RestProxyCall* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	RestProxyCall* _tmp12_ = NULL;
	RestProxyCall* _tmp13_ = NULL;
	RestProxyCall* _tmp14_ = NULL;
	TweetListBox* _tmp15_ = NULL;
	TweetListBox* _tmp16_ = NULL;
	TweetModel* _tmp17_ = NULL;
	gint64 _tmp18_ = 0LL;
	gint64 _tmp19_ = 0LL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	RestProxyCall* _tmp22_ = NULL;
	RestProxyCall* _tmp23_ = NULL;
	RestProxyCall* _tmp24_ = NULL;
	RestProxyCall* _tmp25_ = NULL;
	g_return_if_fail (IS_DEFAULT_TIMELINE (self));
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_data16_->self = g_object_ref (self);
	_tmp0_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->model;
	_tmp3_ = g_list_model_get_n_items (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_list_model_get_type (), GListModel));
	if (_tmp3_ == ((guint) 0)) {
		block16_data_unref (_data16_);
		_data16_ = NULL;
		return;
	}
	_tmp4_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp5_ = _tmp4_;
	_tmp6_ = account_get_proxy (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, rest_proxy_get_type (), RestProxy));
	_data16_->call = _tmp8_;
	_tmp9_ = _data16_->call;
	_tmp10_ = itimeline_get_function (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp11_ = _tmp10_;
	rest_proxy_call_set_function (_tmp9_, _tmp11_);
	_tmp12_ = _data16_->call;
	rest_proxy_call_set_method (_tmp12_, "GET");
	_tmp13_ = _data16_->call;
	rest_proxy_call_add_param (_tmp13_, "count", "1");
	_tmp14_ = _data16_->call;
	_tmp15_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp16_ = _tmp15_;
	_tmp17_ = _tmp16_->model;
	_tmp18_ = tweet_model_get_greatest_id (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp19_ + 1);
	_tmp21_ = _tmp20_;
	rest_proxy_call_add_param (_tmp14_, "since_id", _tmp21_);
	_g_free0 (_tmp21_);
	_tmp22_ = _data16_->call;
	rest_proxy_call_add_param (_tmp22_, "trim_user", "true");
	_tmp23_ = _data16_->call;
	rest_proxy_call_add_param (_tmp23_, "contributor_details", "false");
	_tmp24_ = _data16_->call;
	rest_proxy_call_add_param (_tmp24_, "include_entities", "false");
	_tmp25_ = _data16_->call;
	rest_proxy_call_invoke_async (_tmp25_, NULL, ___lambda90__gasync_ready_callback, block16_data_ref (_data16_));
	block16_data_unref (_data16_);
	_data16_ = NULL;
}


static gint default_timeline_real_get_id (IPage* base) {
	gint result;
	DefaultTimeline* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void default_timeline_real_set_id (IPage* base, gint value) {
	DefaultTimeline* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	_tmp0_ = value;
	self->priv->_id = _tmp0_;
	g_object_notify ((GObject *) self, "id");
}


static gint default_timeline_real_get_unread_count (ITimeline* base) {
	gint result;
	DefaultTimeline* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	_tmp0_ = self->priv->_unread_count;
	result = _tmp0_;
	return result;
}


static void default_timeline_real_set_unread_count (ITimeline* base, gint value) {
	DefaultTimeline* self;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	BadgeRadioToolButton* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	_tmp0_ = value;
	self->priv->_unread_count = _tmp0_;
	_tmp1_ = value;
	g_debug ("DefaultTimeline.vala:25: New unread count: %d", _tmp1_);
	_tmp2_ = self->tool_button;
	_tmp3_ = self->priv->_unread_count;
	badge_radio_tool_button_set_show_badge (_tmp2_, _tmp3_ > 0);
	g_object_notify ((GObject *) self, "unread-count");
}


static MainWindow* default_timeline_real_get_main_window (IPage* base) {
	MainWindow* result;
	DefaultTimeline* self;
	MainWindow* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	_tmp0_ = self->priv->_main_window;
	result = _tmp0_;
	return result;
}


static void default_timeline_real_set_main_window (IPage* base, MainWindow* value) {
	DefaultTimeline* self;
	MainWindow* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	_tmp0_ = value;
	self->priv->_main_window = _tmp0_;
	g_object_notify ((GObject *) self, "main-window");
}


static TweetListBox* default_timeline_real_get_tweet_list (ITimeline* base) {
	TweetListBox* result;
	DefaultTimeline* self;
	TweetListBox* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	_tmp0_ = self->priv->_tweet_list;
	result = _tmp0_;
	return result;
}


static void default_timeline_real_set_tweet_list (ITimeline* base, TweetListBox* value) {
	DefaultTimeline* self;
	TweetListBox* _tmp0_ = NULL;
	TweetListBox* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_tweet_list);
	self->priv->_tweet_list = _tmp1_;
	g_object_notify ((GObject *) self, "tweet-list");
}


static Account* default_timeline_real_get_account (IPage* base) {
	Account* result;
	DefaultTimeline* self;
	Account* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}


static void default_timeline_real_set_account (IPage* base, Account* value) {
	DefaultTimeline* self;
	Account* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	_tmp0_ = value;
	self->priv->_account = _tmp0_;
	g_object_notify ((GObject *) self, "account");
}


guint default_timeline_get_tweet_remove_timeout (DefaultTimeline* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (IS_DEFAULT_TIMELINE (self), 0U);
	_tmp0_ = self->priv->_tweet_remove_timeout;
	result = _tmp0_;
	return result;
}


void default_timeline_set_tweet_remove_timeout (DefaultTimeline* self, guint value) {
	guint _tmp0_ = 0U;
	g_return_if_fail (IS_DEFAULT_TIMELINE (self));
	_tmp0_ = value;
	self->priv->_tweet_remove_timeout = _tmp0_;
	g_object_notify ((GObject *) self, "tweet-remove-timeout");
}


static DeltaUpdater* default_timeline_real_get_delta_updater (ITimeline* base) {
	DeltaUpdater* result;
	DefaultTimeline* self;
	DeltaUpdater* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	_tmp0_ = self->priv->_delta_updater;
	result = _tmp0_;
	return result;
}


static void default_timeline_real_set_delta_updater (ITimeline* base, DeltaUpdater* value) {
	DefaultTimeline* self;
	DeltaUpdater* _tmp0_ = NULL;
	DeltaUpdater* _tmp1_ = NULL;
	TweetListBox* _tmp2_ = NULL;
	TweetListBox* _tmp3_ = NULL;
	DeltaUpdater* _tmp4_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_delta_updater);
	self->priv->_delta_updater = _tmp1_;
	_tmp2_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp3_ = _tmp2_;
	_tmp4_ = value;
	_tmp3_->delta_updater = _tmp4_;
	g_object_notify ((GObject *) self, "delta-updater");
}


const gchar* default_timeline_get_function (DefaultTimeline* self) {
	g_return_val_if_fail (IS_DEFAULT_TIMELINE (self), NULL);
	return DEFAULT_TIMELINE_GET_CLASS (self)->get_function (self);
}


static void default_timeline_class_init (DefaultTimelineClass * klass) {
	default_timeline_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DefaultTimelinePrivate));
	((DefaultTimelineClass *) klass)->on_join = default_timeline_real_on_join;
	((DefaultTimelineClass *) klass)->on_leave = default_timeline_real_on_leave;
	((DefaultTimelineClass *) klass)->load_newest = default_timeline_real_load_newest;
	((DefaultTimelineClass *) klass)->load_older = default_timeline_real_load_older;
	((DefaultTimelineClass *) klass)->get_title = default_timeline_real_get_title;
	((GtkWidgetClass *) klass)->destroy = default_timeline_real_destroy;
	((DefaultTimelineClass *) klass)->create_tool_button = default_timeline_real_create_tool_button;
	G_OBJECT_CLASS (klass)->get_property = _vala_default_timeline_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_default_timeline_set_property;
	G_OBJECT_CLASS (klass)->finalize = default_timeline_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEFAULT_TIMELINE_ID, g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEFAULT_TIMELINE_UNREAD_COUNT, g_param_spec_int ("unread-count", "unread-count", "unread-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEFAULT_TIMELINE_MAIN_WINDOW, g_param_spec_object ("main-window", "main-window", "main-window", TYPE_MAIN_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEFAULT_TIMELINE_TWEET_LIST, g_param_spec_object ("tweet-list", "tweet-list", "tweet-list", TYPE_TWEET_LIST_BOX, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEFAULT_TIMELINE_ACCOUNT, g_param_spec_object ("account", "account", "account", TYPE_ACCOUNT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEFAULT_TIMELINE_TWEET_REMOVE_TIMEOUT, g_param_spec_uint ("tweet-remove-timeout", "tweet-remove-timeout", "tweet-remove-timeout", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEFAULT_TIMELINE_DELTA_UPDATER, g_param_spec_object ("delta-updater", "delta-updater", "delta-updater", TYPE_DELTA_UPDATER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEFAULT_TIMELINE_FUNCTION, g_param_spec_string ("function", "function", "function", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void default_timeline_ipage_interface_init (IPageIface * iface) {
	default_timeline_ipage_parent_iface = g_type_interface_peek_parent (iface);
	iface->on_join = (void (*)(IPage*, gint, Bundle*)) default_timeline_on_join;
	iface->handles_double_open = (gboolean (*)(IPage*)) default_timeline_real_handles_double_open;
	iface->double_open = (void (*)(IPage*)) default_timeline_real_double_open;
	iface->on_leave = (void (*)(IPage*)) default_timeline_on_leave;
	iface->get_title = (gchar* (*)(IPage*)) default_timeline_get_title;
	iface->create_tool_button = (void (*)(IPage*, GtkRadioButton*)) default_timeline_create_tool_button;
	iface->get_tool_button = (GtkRadioButton* (*)(IPage*)) default_timeline_real_get_tool_button;
	iface->get_id = default_timeline_real_get_id;
	iface->set_id = default_timeline_real_set_id;
	iface->get_main_window = default_timeline_real_get_main_window;
	iface->set_main_window = default_timeline_real_set_main_window;
	iface->get_account = default_timeline_real_get_account;
	iface->set_account = default_timeline_real_set_account;
}


static void default_timeline_itimeline_interface_init (ITimelineIface * iface) {
	default_timeline_itimeline_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_unread_count = default_timeline_real_get_unread_count;
	iface->set_unread_count = default_timeline_real_set_unread_count;
	iface->get_tweet_list = default_timeline_real_get_tweet_list;
	iface->set_tweet_list = default_timeline_real_set_tweet_list;
	iface->get_delta_updater = default_timeline_real_get_delta_updater;
	iface->set_delta_updater = default_timeline_real_set_delta_updater;
	iface->get_function = (const gchar* (*) (ITimeline *)) default_timeline_get_function;
}


static void default_timeline_instance_init (DefaultTimeline * self) {
	TweetListBox* _tmp0_ = NULL;
	self->priv = DEFAULT_TIMELINE_GET_PRIVATE (self);
	self->initialized = FALSE;
	self->priv->_unread_count = 0;
	_tmp0_ = tweet_list_box_new (TRUE);
	g_object_ref_sink (_tmp0_);
	self->priv->_tweet_list = _tmp0_;
	self->loading = FALSE;
	self->last_focus_widget = NULL;
}


static void default_timeline_finalize (GObject* obj) {
	DefaultTimeline * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	_g_object_unref0 (self->priv->_tweet_list);
	_g_object_unref0 (self->tool_button);
	_g_object_unref0 (self->priv->_delta_updater);
	_g_object_unref0 (self->last_focus_widget);
	G_OBJECT_CLASS (default_timeline_parent_class)->finalize (obj);
}


GType default_timeline_get_type (void) {
	static volatile gsize default_timeline_type_id__volatile = 0;
	if (g_once_init_enter (&default_timeline_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DefaultTimelineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) default_timeline_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DefaultTimeline), 0, (GInstanceInitFunc) default_timeline_instance_init, NULL };
		static const GInterfaceInfo ipage_info = { (GInterfaceInitFunc) default_timeline_ipage_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo itimeline_info = { (GInterfaceInitFunc) default_timeline_itimeline_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType default_timeline_type_id;
		default_timeline_type_id = g_type_register_static (TYPE_SCROLL_WIDGET, "DefaultTimeline", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (default_timeline_type_id, TYPE_IPAGE, &ipage_info);
		g_type_add_interface_static (default_timeline_type_id, TYPE_ITIMELINE, &itimeline_info);
		g_once_init_leave (&default_timeline_type_id__volatile, default_timeline_type_id);
	}
	return default_timeline_type_id__volatile;
}


static void _vala_default_timeline_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DefaultTimeline * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	switch (property_id) {
		case DEFAULT_TIMELINE_ID:
		g_value_set_int (value, ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		case DEFAULT_TIMELINE_UNREAD_COUNT:
		g_value_set_int (value, itimeline_get_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline)));
		break;
		case DEFAULT_TIMELINE_MAIN_WINDOW:
		g_value_set_object (value, ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		case DEFAULT_TIMELINE_TWEET_LIST:
		g_value_set_object (value, itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline)));
		break;
		case DEFAULT_TIMELINE_ACCOUNT:
		g_value_set_object (value, ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		case DEFAULT_TIMELINE_TWEET_REMOVE_TIMEOUT:
		g_value_set_uint (value, default_timeline_get_tweet_remove_timeout (self));
		break;
		case DEFAULT_TIMELINE_DELTA_UPDATER:
		g_value_set_object (value, itimeline_get_delta_updater (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_default_timeline_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DefaultTimeline * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	switch (property_id) {
		case DEFAULT_TIMELINE_ID:
		ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_int (value));
		break;
		case DEFAULT_TIMELINE_UNREAD_COUNT:
		itimeline_set_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline), g_value_get_int (value));
		break;
		case DEFAULT_TIMELINE_MAIN_WINDOW:
		ipage_set_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		case DEFAULT_TIMELINE_TWEET_LIST:
		itimeline_set_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline), g_value_get_object (value));
		break;
		case DEFAULT_TIMELINE_ACCOUNT:
		ipage_set_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		case DEFAULT_TIMELINE_TWEET_REMOVE_TIMEOUT:
		default_timeline_set_tweet_remove_timeout (self, g_value_get_uint (value));
		break;
		case DEFAULT_TIMELINE_DELTA_UPDATER:
		itimeline_set_delta_updater (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline), g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



