/* ProfilePage.c generated by valac 0.26.2, the Vala compiler
 * generated from ProfilePage.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib/gstdio.h>
#include <rest/rest-proxy-call.h>
#include <rest/oauth-proxy.h>
#include <rest/rest-proxy.h>
#include <json-glib/json-glib.h>
#include <glib/gi18n-lib.h>


#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;
typedef struct _ScrollWidgetPrivate ScrollWidgetPrivate;

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_PROFILE_PAGE (profile_page_get_type ())
#define PROFILE_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROFILE_PAGE, ProfilePage))
#define PROFILE_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROFILE_PAGE, ProfilePageClass))
#define IS_PROFILE_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROFILE_PAGE))
#define IS_PROFILE_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROFILE_PAGE))
#define PROFILE_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROFILE_PAGE, ProfilePageClass))

typedef struct _ProfilePage ProfilePage;
typedef struct _ProfilePageClass ProfilePageClass;
typedef struct _ProfilePagePrivate ProfilePagePrivate;

#define TYPE_DELTA_UPDATER (delta_updater_get_type ())
#define DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELTA_UPDATER, DeltaUpdater))
#define DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELTA_UPDATER, DeltaUpdaterClass))
#define IS_DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELTA_UPDATER))
#define IS_DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELTA_UPDATER))
#define DELTA_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELTA_UPDATER, DeltaUpdaterClass))

typedef struct _DeltaUpdater DeltaUpdater;
typedef struct _DeltaUpdaterClass DeltaUpdaterClass;

#define TYPE_ASPECT_IMAGE (aspect_image_get_type ())
#define ASPECT_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASPECT_IMAGE, AspectImage))
#define ASPECT_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASPECT_IMAGE, AspectImageClass))
#define IS_ASPECT_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASPECT_IMAGE))
#define IS_ASPECT_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASPECT_IMAGE))
#define ASPECT_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASPECT_IMAGE, AspectImageClass))

typedef struct _AspectImage AspectImage;
typedef struct _AspectImageClass AspectImageClass;

#define TYPE_AVATAR_WIDGET (avatar_widget_get_type ())
#define AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_WIDGET, AvatarWidget))
#define AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_WIDGET, AvatarWidgetClass))
#define IS_AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_WIDGET))
#define IS_AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_WIDGET))
#define AVATAR_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_WIDGET, AvatarWidgetClass))

typedef struct _AvatarWidget AvatarWidget;
typedef struct _AvatarWidgetClass AvatarWidgetClass;

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;

#define TYPE_USER_LISTS_WIDGET (user_lists_widget_get_type ())
#define USER_LISTS_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_LISTS_WIDGET, UserListsWidget))
#define USER_LISTS_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_LISTS_WIDGET, UserListsWidgetClass))
#define IS_USER_LISTS_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_LISTS_WIDGET))
#define IS_USER_LISTS_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_LISTS_WIDGET))
#define USER_LISTS_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_LISTS_WIDGET, UserListsWidgetClass))

typedef struct _UserListsWidget UserListsWidget;
typedef struct _UserListsWidgetClass UserListsWidgetClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;

#define TYPE_ITWITTER_ITEM (itwitter_item_get_type ())
#define ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITWITTER_ITEM, ITwitterItem))
#define IS_ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITWITTER_ITEM))
#define ITWITTER_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITWITTER_ITEM, ITwitterItemIface))

typedef struct _ITwitterItem ITwitterItem;
typedef struct _ITwitterItemIface ITwitterItemIface;
typedef struct _TweetListEntryPrivate TweetListEntryPrivate;

#define TYPE_TWEET (tweet_get_type ())
#define TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET, Tweet))
#define TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET, TweetClass))
#define IS_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET))
#define IS_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET))
#define TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET, TweetClass))

typedef struct _Tweet Tweet;
typedef struct _TweetClass TweetClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_PAGE (page_get_type ())
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block24Data Block24Data;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define SQL_TYPE_SELECT_STATEMENT (sql_select_statement_get_type ())
#define SQL_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatement))
#define SQL_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))
#define SQL_IS_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_SELECT_STATEMENT))
#define SQL_IS_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_SELECT_STATEMENT))
#define SQL_SELECT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))

typedef struct _SqlSelectStatement SqlSelectStatement;
typedef struct _SqlSelectStatementClass SqlSelectStatementClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TWEET_UTILS_TYPE_SEQUENCE (tweet_utils_sequence_get_type ())
typedef struct _TweetUtilsSequence TweetUtilsSequence;
#define _sql_select_statement_unref0(var) ((var == NULL) ? NULL : (var = (sql_select_statement_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
typedef struct _ProfilePageLoadFriendshipData ProfilePageLoadFriendshipData;
typedef struct _Block25Data Block25Data;
#define __g_slist_free__tweet_utils_sequence_free0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__tweet_utils_sequence_free0_ (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))

#define TYPE_USER_COUNTER (user_counter_get_type ())
#define USER_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_COUNTER, UserCounter))
#define USER_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_COUNTER, UserCounterClass))
#define IS_USER_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_COUNTER))
#define IS_USER_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_COUNTER))
#define USER_COUNTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_COUNTER, UserCounterClass))

typedef struct _UserCounter UserCounter;
typedef struct _UserCounterClass UserCounterClass;

#define SQL_TYPE_INSERT_STATEMENT (sql_insert_statement_get_type ())
#define SQL_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatement))
#define SQL_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))
#define SQL_IS_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_INSERT_STATEMENT))
#define SQL_IS_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_INSERT_STATEMENT))
#define SQL_INSERT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))

typedef struct _SqlInsertStatement SqlInsertStatement;
typedef struct _SqlInsertStatementClass SqlInsertStatementClass;
#define _sql_insert_statement_unref0(var) ((var == NULL) ? NULL : (var = (sql_insert_statement_unref (var), NULL)))
typedef struct _ProfilePageLoadProfileDataData ProfilePageLoadProfileDataData;

#define TWEET_UTILS_TYPE_WORKER_RESULT (tweet_utils_worker_result_get_type ())
typedef struct _TweetUtilsWorkerResult TweetUtilsWorkerResult;
typedef struct _ProfilePageLoadTweetsData ProfilePageLoadTweetsData;
typedef struct _ProfilePageLoadOlderTweetsData ProfilePageLoadOlderTweetsData;
typedef struct _Block26Data Block26Data;

#define SQL_TYPE_UPDATE_STATEMENT (sql_update_statement_get_type ())
#define SQL_UPDATE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatement))
#define SQL_UPDATE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatementClass))
#define SQL_IS_UPDATE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_UPDATE_STATEMENT))
#define SQL_IS_UPDATE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_UPDATE_STATEMENT))
#define SQL_UPDATE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatementClass))

typedef struct _SqlUpdateStatement SqlUpdateStatement;
typedef struct _SqlUpdateStatementClass SqlUpdateStatementClass;
#define _sql_update_statement_unref0(var) ((var == NULL) ? NULL : (var = (sql_update_statement_unref (var), NULL)))
typedef struct _Block27Data Block27Data;

#define TYPE_DEFAULT_TIMELINE (default_timeline_get_type ())
#define DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimeline))
#define DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))
#define IS_DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEFAULT_TIMELINE))
#define IS_DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEFAULT_TIMELINE))
#define DEFAULT_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))

typedef struct _DefaultTimeline DefaultTimeline;
typedef struct _DefaultTimelineClass DefaultTimelineClass;

#define TYPE_HOME_TIMELINE (home_timeline_get_type ())
#define HOME_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HOME_TIMELINE, HomeTimeline))
#define HOME_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HOME_TIMELINE, HomeTimelineClass))
#define IS_HOME_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HOME_TIMELINE))
#define IS_HOME_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HOME_TIMELINE))
#define HOME_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HOME_TIMELINE, HomeTimelineClass))

typedef struct _HomeTimeline HomeTimeline;
typedef struct _HomeTimelineClass HomeTimelineClass;

#define TYPE_COMPOSE_TWEET_WINDOW (compose_tweet_window_get_type ())
#define COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindow))
#define COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))
#define IS_COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPOSE_TWEET_WINDOW))
#define IS_COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPOSE_TWEET_WINDOW))
#define COMPOSE_TWEET_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))

typedef struct _ComposeTweetWindow ComposeTweetWindow;
typedef struct _ComposeTweetWindowClass ComposeTweetWindowClass;

#define COMPOSE_TWEET_WINDOW_TYPE_MODE (compose_tweet_window_mode_get_type ())

#define TYPE_USER_LIST_DIALOG (user_list_dialog_get_type ())
#define USER_LIST_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_LIST_DIALOG, UserListDialog))
#define USER_LIST_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_LIST_DIALOG, UserListDialogClass))
#define IS_USER_LIST_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_LIST_DIALOG))
#define IS_USER_LIST_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_LIST_DIALOG))
#define USER_LIST_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_LIST_DIALOG, UserListDialogClass))

typedef struct _UserListDialog UserListDialog;
typedef struct _UserListDialogClass UserListDialogClass;
typedef struct _Block28Data Block28Data;
typedef struct _Block29Data Block29Data;

struct _ScrollWidget {
	GtkScrolledWindow parent_instance;
	ScrollWidgetPrivate * priv;
};

struct _ScrollWidgetClass {
	GtkScrolledWindowClass parent_class;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, Bundle* args);
	void (*on_leave) (IPage* self);
	void (*create_tool_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_tool_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	MainWindow* (*get_main_window) (IPage* self);
	void (*set_main_window) (IPage* self, MainWindow* value);
	Account* (*get_account) (IPage* self);
	void (*set_account) (IPage* self, Account* value);
};

struct _ProfilePage {
	ScrollWidget parent_instance;
	ProfilePagePrivate * priv;
};

struct _ProfilePageClass {
	ScrollWidgetClass parent_class;
};

struct _ProfilePagePrivate {
	MainWindow* _main_window;
	Account* _account;
	gint _id;
	DeltaUpdater* _delta_updater;
	AspectImage* banner_image;
	AvatarWidget* avatar_image;
	GtkLabel* name_label;
	GtkLabel* screen_name_label;
	GtkLabel* description_label;
	GtkLabel* url_label;
	GtkLabel* tweets_label;
	GtkLabel* following_label;
	GtkLabel* followers_label;
	GtkLabel* location_label;
	GtkButton* follow_button;
	TweetListBox* tweet_list;
	GtkSpinner* progress_spinner;
	GtkLabel* follows_you_label;
	UserListsWidget* user_lists;
	GtkStack* user_stack;
	GtkMenuButton* more_button;
	GtkStack* loading_stack;
	GMenuModel* more_menu;
	gboolean following;
	gint64 user_id;
	gchar* name;
	gchar* screen_name;
	gchar* avatar_url;
	gint follower_count;
	GCancellable* data_cancellable;
	gboolean lists_page_inited;
	gulong page_change_signal;
	gboolean block_item_blocked;
	gboolean retweet_item_blocked;
	gboolean tweets_loading;
	gint64 lowest_tweet_id;
	GSimpleActionGroup* actions;
};

struct _ITwitterItemIface {
	GTypeInterface parent_iface;
	gint (*update_time_delta) (ITwitterItem* self, GDateTime* now);
	gint64 (*get_sort_factor) (ITwitterItem* self);
	gboolean (*get_seen) (ITwitterItem* self);
	void (*set_seen) (ITwitterItem* self, gboolean value);
};

struct _TweetListEntry {
	GtkListBoxRow parent_instance;
	TweetListEntryPrivate * priv;
	gchar* notification_id;
	Tweet* tweet;
};

struct _TweetListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _Block24Data {
	int _ref_count_;
	ProfilePage* self;
	gboolean data_in_db;
};

typedef gboolean (*SqlSelectCallback) (gchar** vals, int vals_length1, void* user_data);
struct _TweetUtilsSequence {
	gint start;
	gint end;
	gchar* url;
	gchar* display_url;
	gboolean visual_display_url;
	gchar* title;
};

struct _ProfilePageLoadFriendshipData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ProfilePage* self;
	RestProxyCall* call;
	Account* _tmp0_;
	Account* _tmp1_;
	OAuthProxy* _tmp2_;
	OAuthProxy* _tmp3_;
	RestProxyCall* _tmp4_;
	RestProxyCall* _tmp5_;
	RestProxyCall* _tmp6_;
	RestProxyCall* _tmp7_;
	Account* _tmp8_;
	Account* _tmp9_;
	gint64 _tmp10_;
	gint64 _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	RestProxyCall* _tmp14_;
	gint64 _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	JsonNode* root;
	RestProxyCall* _tmp18_;
	JsonNode* _tmp19_;
	JsonNode* _tmp20_;
	JsonObject* relationship;
	JsonNode* _tmp21_;
	JsonObject* _tmp22_;
	JsonObject* _tmp23_;
	JsonObject* _tmp24_;
	gboolean followed_by;
	JsonObject* _tmp25_;
	JsonObject* _tmp26_;
	gboolean _tmp27_;
	gboolean following;
	JsonObject* _tmp28_;
	JsonObject* _tmp29_;
	gboolean _tmp30_;
	gboolean want_retweets;
	JsonObject* _tmp31_;
	JsonObject* _tmp32_;
	gboolean _tmp33_;
	GtkLabel* _tmp34_;
	gboolean _tmp35_;
	JsonObject* _tmp36_;
	JsonObject* _tmp37_;
	gboolean _tmp38_;
	gboolean _tmp39_;
	gboolean _tmp40_;
	gboolean _tmp41_;
	GSimpleActionGroup* _tmp42_;
	GAction* _tmp43_;
	gboolean _tmp44_;
};

struct _Block25Data {
	int _ref_count_;
	ProfilePage* self;
	gchar* avatar_on_disk;
	GSList* text_urls;
	gboolean show_spinner;
	gpointer _async_data_;
};

struct _ProfilePageLoadProfileDataData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ProfilePage* self;
	gint64 user_id;
	gboolean show_spinner;
	Block25Data* _data25_;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GtkStack* _tmp2_;
	GtkSpinner* _tmp3_;
	GtkButton* _tmp4_;
	RestProxyCall* call;
	Account* _tmp5_;
	Account* _tmp6_;
	OAuthProxy* _tmp7_;
	OAuthProxy* _tmp8_;
	RestProxyCall* _tmp9_;
	RestProxyCall* _tmp10_;
	RestProxyCall* _tmp11_;
	RestProxyCall* _tmp12_;
	gint64 _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	RestProxyCall* _tmp16_;
	JsonNode* root_node;
	RestProxyCall* _tmp17_;
	JsonNode* _tmp18_;
	JsonNode* _tmp19_;
	JsonObject* root;
	JsonNode* _tmp20_;
	JsonObject* _tmp21_;
	JsonObject* _tmp22_;
	gint64 id;
	JsonObject* _tmp23_;
	gint64 _tmp24_;
	gchar* avatar_url;
	JsonObject* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* avatar_name;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	const gchar* _tmp37_;
	gboolean _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	GCancellable* _tmp41_;
	GdkPixbuf* _tmp42_;
	const gchar* _tmp43_;
	GdkPixbuf* _tmp44_;
	AvatarWidget* _tmp45_;
	GError* e;
	GError* _tmp46_;
	const gchar* _tmp47_;
	gboolean _tmp48_;
	GtkSpinner* _tmp49_;
	GtkStack* _tmp50_;
	gchar* name;
	JsonObject* _tmp51_;
	const gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* screen_name;
	JsonObject* _tmp57_;
	const gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* description;
	JsonObject* _tmp60_;
	const gchar* _tmp61_;
	gchar* _tmp62_;
	gint followers;
	JsonObject* _tmp63_;
	gint64 _tmp64_;
	gint following;
	JsonObject* _tmp65_;
	gint64 _tmp66_;
	gint tweets;
	JsonObject* _tmp67_;
	gint64 _tmp68_;
	gboolean is_following;
	JsonObject* _tmp69_;
	gboolean _tmp70_;
	JsonObject* _tmp71_;
	gboolean _tmp72_;
	gboolean has_url;
	JsonObject* _tmp73_;
	JsonObject* _tmp74_;
	gboolean _tmp75_;
	gchar* banner_name;
	gint64 _tmp76_;
	gchar* _tmp77_;
	gboolean verified;
	JsonObject* _tmp78_;
	gboolean _tmp79_;
	gboolean protected_user;
	JsonObject* _tmp80_;
	gboolean _tmp81_;
	gboolean _tmp82_;
	TweetListBox* _tmp83_;
	const gchar* _tmp84_;
	JsonObject* _tmp85_;
	gboolean _tmp86_;
	gchar* banner_base_url;
	JsonObject* _tmp87_;
	const gchar* _tmp88_;
	gchar* _tmp89_;
	const gchar* _tmp90_;
	gint64 _tmp91_;
	gchar* display_url;
	gchar* _tmp92_;
	JsonObject* entities;
	JsonObject* _tmp93_;
	JsonObject* _tmp94_;
	JsonObject* _tmp95_;
	gboolean _tmp96_;
	JsonObject* urls_object;
	JsonObject* _tmp97_;
	JsonObject* _tmp98_;
	JsonArray* _tmp99_;
	JsonNode* _tmp100_;
	JsonObject* _tmp101_;
	JsonObject* _tmp102_;
	gchar* url;
	JsonObject* _tmp103_;
	const gchar* _tmp104_;
	gchar* _tmp105_;
	JsonObject* _tmp106_;
	gboolean _tmp107_;
	JsonObject* _tmp108_;
	const gchar* _tmp109_;
	gchar* _tmp110_;
	JsonObject* _tmp111_;
	const gchar* _tmp112_;
	gchar* _tmp113_;
	const gchar* _tmp114_;
	gchar* _tmp115_;
	gchar* location;
	JsonObject* _tmp116_;
	gboolean _tmp117_;
	JsonObject* _tmp118_;
	const gchar* _tmp119_;
	gchar* _tmp120_;
	JsonObject* _tmp121_;
	gboolean _tmp122_;
	JsonArray* urls;
	JsonObject* _tmp123_;
	JsonObject* _tmp124_;
	JsonArray* _tmp125_;
	JsonArray* _tmp126_;
	JsonArray* _tmp127_;
	Account* _tmp128_;
	Account* _tmp129_;
	UserCounter* _tmp130_;
	UserCounter* _tmp131_;
	gint64 _tmp132_;
	const gchar* _tmp133_;
	const gchar* _tmp134_;
	const gchar* _tmp135_;
	const gchar* _tmp136_;
	const gchar* _tmp137_;
	const gchar* _tmp138_;
	const gchar* _tmp139_;
	gint _tmp140_;
	gint _tmp141_;
	gint _tmp142_;
	const gchar* _tmp143_;
	gboolean _tmp144_;
	GSList* _tmp145_;
	gboolean _tmp146_;
	SqlDatabase* _tmp147_;
	SqlInsertStatement* _tmp148_;
	SqlInsertStatement* _tmp149_;
	gint64 _tmp150_;
	SqlInsertStatement* _tmp151_;
	SqlInsertStatement* _tmp152_;
	const gchar* _tmp153_;
	SqlInsertStatement* _tmp154_;
	SqlInsertStatement* _tmp155_;
	const gchar* _tmp156_;
	SqlInsertStatement* _tmp157_;
	SqlInsertStatement* _tmp158_;
	gint _tmp159_;
	SqlInsertStatement* _tmp160_;
	SqlInsertStatement* _tmp161_;
	gint _tmp162_;
	SqlInsertStatement* _tmp163_;
	SqlInsertStatement* _tmp164_;
	gint _tmp165_;
	SqlInsertStatement* _tmp166_;
	SqlInsertStatement* _tmp167_;
	const gchar* _tmp168_;
	GSList* _tmp169_;
	gchar* _tmp170_;
	gchar* _tmp171_;
	SqlInsertStatement* _tmp172_;
	SqlInsertStatement* _tmp173_;
	const gchar* _tmp174_;
	SqlInsertStatement* _tmp175_;
	SqlInsertStatement* _tmp176_;
	const gchar* _tmp177_;
	SqlInsertStatement* _tmp178_;
	SqlInsertStatement* _tmp179_;
	const gchar* _tmp180_;
	SqlInsertStatement* _tmp181_;
	SqlInsertStatement* _tmp182_;
	gboolean _tmp183_;
	SqlInsertStatement* _tmp184_;
	SqlInsertStatement* _tmp185_;
	const gchar* _tmp186_;
	SqlInsertStatement* _tmp187_;
	SqlInsertStatement* _tmp188_;
	GError * _inner_error_;
};

struct _TweetUtilsWorkerResult {
	gint64 max_id;
	gint64 min_id;
};

struct _ProfilePageLoadTweetsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ProfilePage* self;
	TweetListBox* _tmp0_;
	gint requested_tweet_count;
	RestProxyCall* call;
	Account* _tmp1_;
	Account* _tmp2_;
	OAuthProxy* _tmp3_;
	OAuthProxy* _tmp4_;
	RestProxyCall* _tmp5_;
	RestProxyCall* _tmp6_;
	RestProxyCall* _tmp7_;
	RestProxyCall* _tmp8_;
	gint64 _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	RestProxyCall* _tmp12_;
	gint _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	RestProxyCall* _tmp16_;
	RestProxyCall* _tmp17_;
	JsonNode* root;
	RestProxyCall* _tmp18_;
	JsonNode* _tmp19_;
	JsonNode* _tmp20_;
	TweetListBox* _tmp21_;
	JsonArray* root_array;
	JsonNode* _tmp22_;
	JsonArray* _tmp23_;
	JsonArray* _tmp24_;
	JsonArray* _tmp25_;
	guint _tmp26_;
	TweetListBox* _tmp27_;
	TweetUtilsWorkerResult _result_;
	JsonArray* _tmp28_;
	gint _tmp29_;
	DeltaUpdater* _tmp30_;
	TweetListBox* _tmp31_;
	MainWindow* _tmp32_;
	MainWindow* _tmp33_;
	Account* _tmp34_;
	Account* _tmp35_;
	TweetUtilsWorkerResult _tmp36_;
	TweetUtilsWorkerResult _tmp37_;
	gint64 _tmp38_;
};

struct _ProfilePageLoadOlderTweetsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ProfilePage* self;
	gboolean _tmp0_;
	GtkStack* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	TweetListBox* _tmp4_;
	gint requested_tweet_count;
	RestProxyCall* call;
	Account* _tmp5_;
	Account* _tmp6_;
	OAuthProxy* _tmp7_;
	OAuthProxy* _tmp8_;
	RestProxyCall* _tmp9_;
	RestProxyCall* _tmp10_;
	RestProxyCall* _tmp11_;
	RestProxyCall* _tmp12_;
	gint64 _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	RestProxyCall* _tmp16_;
	gint _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	RestProxyCall* _tmp20_;
	RestProxyCall* _tmp21_;
	RestProxyCall* _tmp22_;
	gint64 _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	JsonNode* root;
	RestProxyCall* _tmp26_;
	JsonNode* _tmp27_;
	JsonNode* _tmp28_;
	JsonArray* root_arr;
	JsonNode* _tmp29_;
	JsonArray* _tmp30_;
	JsonArray* _tmp31_;
	TweetUtilsWorkerResult _result_;
	JsonArray* _tmp32_;
	gint _tmp33_;
	DeltaUpdater* _tmp34_;
	TweetListBox* _tmp35_;
	MainWindow* _tmp36_;
	MainWindow* _tmp37_;
	Account* _tmp38_;
	Account* _tmp39_;
	TweetUtilsWorkerResult _tmp40_;
	TweetUtilsWorkerResult _tmp41_;
	gint64 _tmp42_;
	gint64 _tmp43_;
	TweetUtilsWorkerResult _tmp44_;
	gint64 _tmp45_;
};

struct _Block26Data {
	int _ref_count_;
	ProfilePage* self;
	gchar* banner_on_disk;
};

struct _Block27Data {
	int _ref_count_;
	ProfilePage* self;
	RestProxyCall* call;
};

typedef enum  {
	COMPOSE_TWEET_WINDOW_MODE_NORMAL,
	COMPOSE_TWEET_WINDOW_MODE_REPLY,
	COMPOSE_TWEET_WINDOW_MODE_QUOTE
} ComposeTweetWindowMode;

struct _Block28Data {
	int _ref_count_;
	ProfilePage* self;
	gboolean current_state;
	RestProxyCall* call;
	GSimpleAction* a;
};

struct _Block29Data {
	int _ref_count_;
	ProfilePage* self;
	gboolean current_state;
	RestProxyCall* call;
	GSimpleAction* a;
};


static gpointer profile_page_parent_class = NULL;
extern SqlDatabase* corebird_db;
static IPageIface* profile_page_ipage_parent_iface = NULL;

GType scroll_widget_get_type (void) G_GNUC_CONST;
GType bundle_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType profile_page_get_type (void) G_GNUC_CONST;
GType delta_updater_get_type (void) G_GNUC_CONST;
GType aspect_image_get_type (void) G_GNUC_CONST;
GType avatar_widget_get_type (void) G_GNUC_CONST;
GType tweet_list_box_get_type (void) G_GNUC_CONST;
GType user_lists_widget_get_type (void) G_GNUC_CONST;
#define PROFILE_PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PROFILE_PAGE, ProfilePagePrivate))
enum  {
	PROFILE_PAGE_DUMMY_PROPERTY,
	PROFILE_PAGE_UNREAD_COUNT,
	PROFILE_PAGE_MAIN_WINDOW,
	PROFILE_PAGE_ACCOUNT,
	PROFILE_PAGE_ID,
	PROFILE_PAGE_DELTA_UPDATER
};
#define PROFILE_PAGE_PAGE_TWEETS 0
#define PROFILE_PAGE_PAGE_FOLLOWING 1
#define PROFILE_PAGE_PAGE_FOLLOWERS 2
static void profile_page_write_dm_activated (ProfilePage* self, GSimpleAction* a, GVariant* v);
static void _profile_page_write_dm_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void profile_page_tweet_to_activated (ProfilePage* self, GSimpleAction* a, GVariant* v);
static void _profile_page_tweet_to_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void profile_page_add_remove_list_activated (ProfilePage* self, GSimpleAction* a, GVariant* v);
static void _profile_page_add_remove_list_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
ProfilePage* profile_page_new (gint id);
ProfilePage* profile_page_construct (GType object_type, gint id);
ScrollWidget* scroll_widget_new (void);
ScrollWidget* scroll_widget_construct (GType object_type);
void ipage_set_id (IPage* self, gint value);
static gboolean __lambda186_ (ProfilePage* self, GdkEventScroll* evt);
gdouble aspect_image_get_scale (AspectImage* self);
void aspect_image_set_scale (AspectImage* self, gdouble value);
static gboolean ___lambda186__gtk_widget_scroll_event (GtkWidget* _sender, GdkEventScroll* event, gpointer self);
static void __lambda187_ (ProfilePage* self);
static void profile_page_load_older_tweets (ProfilePage* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void profile_page_load_older_tweets_finish (ProfilePage* self, GAsyncResult* _res_);
static void ___lambda187__scroll_widget_scrolled_to_end (ScrollWidget* _sender, gpointer self);
static void __lambda188_ (ProfilePage* self, GtkListBoxRow* row);
Bundle* bundle_new (void);
Bundle* bundle_construct (GType object_type);
void bundle_put_int (Bundle* self, const gchar* key, gint value);
#define TWEET_INFO_PAGE_BY_INSTANCE 1
void bundle_put_object (Bundle* self, const gchar* key, GObject* object);
GType tweet_list_entry_get_type (void) G_GNUC_CONST;
GType itwitter_item_get_type (void) G_GNUC_CONST;
GType tweet_get_type (void) G_GNUC_CONST;
MainWindow* ipage_get_main_window (IPage* self);
GType main_widget_get_type (void) G_GNUC_CONST;
void main_widget_switch_page (MainWidget* self, gint page_id, Bundle* args);
GType page_get_type (void) G_GNUC_CONST;
static void ___lambda188__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
gint itwitter_item_sort_func (GtkListBoxRow* a, GtkListBoxRow* b);
static gint _itwitter_item_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self);
void user_lists_widget_hide_user_list_entry (UserListsWidget* self);
static void __lambda189_ (ProfilePage* self);
void user_lists_widget_load_lists (UserListsWidget* self, gint64 user_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void user_lists_widget_load_lists_finish (UserListsWidget* self, GAsyncResult* _res_);
static void ___lambda189__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda190_ (ProfilePage* self);
static void ___lambda190__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static void profile_page_toggle_blocked_activated (ProfilePage* self, GSimpleAction* a, GVariant* v);
static void _profile_page_toggle_blocked_activated_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static void profile_page_retweet_action_activated (ProfilePage* self, GSimpleAction* a, GVariant* v);
static void _profile_page_retweet_action_activated_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static void profile_page_set_user_id (ProfilePage* self, gint64 user_id);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (void * _userdata_);
Account* ipage_get_account (IPage* self);
gint64 account_get_id (Account* self);
static void profile_page_load_banner (ProfilePage* self, const gchar* path);
static void profile_page_load_friendship (ProfilePage* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void profile_page_load_friendship_finish (ProfilePage* self, GAsyncResult* _res_);
gpointer sql_database_ref (gpointer instance);
void sql_database_unref (gpointer instance);
GParamSpec* sql_param_spec_database (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_database (GValue* value, gpointer v_object);
void sql_value_take_database (GValue* value, gpointer v_object);
gpointer sql_value_get_database (const GValue* value);
GType sql_database_get_type (void) G_GNUC_CONST;
gpointer sql_select_statement_ref (gpointer instance);
void sql_select_statement_unref (gpointer instance);
GParamSpec* sql_param_spec_select_statement (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_select_statement (GValue* value, gpointer v_object);
void sql_value_take_select_statement (GValue* value, gpointer v_object);
gpointer sql_value_get_select_statement (const GValue* value);
GType sql_select_statement_get_type (void) G_GNUC_CONST;
SqlSelectStatement* sql_database_select (SqlDatabase* self, const gchar* table_name);
SqlSelectStatement* sql_select_statement_cols (SqlSelectStatement* self, const gchar* first, ...);
SqlSelectStatement* sql_select_statement_where_eqi (SqlSelectStatement* self, const gchar* w, gint64 v);
gint sql_select_statement_run (SqlSelectStatement* self, SqlSelectCallback callback, void* callback_target);
static gboolean __lambda193_ (Block24Data* _data24_, gchar** vals, int vals_length1);
gchar* dirs_cache (const gchar* path);
GType tweet_utils_sequence_get_type (void) G_GNUC_CONST;
TweetUtilsSequence* tweet_utils_sequence_dup (const TweetUtilsSequence* self);
void tweet_utils_sequence_free (TweetUtilsSequence* self);
void tweet_utils_sequence_copy (const TweetUtilsSequence* self, TweetUtilsSequence* dest);
void tweet_utils_sequence_destroy (TweetUtilsSequence* self);
static void profile_page_set_data (ProfilePage* self, const gchar* name, const gchar* screen_name, const gchar* url, const gchar* location, const gchar* description, gint tweets, gint following, gint followers, const gchar* avatar_url, gboolean verified, GSList* text_urls);
static void profile_page_set_follow_button_state (ProfilePage* self, gboolean following);
static gboolean ___lambda193__sql_select_callback (gchar** vals, int vals_length1, gpointer self);
static void profile_page_load_profile_data (ProfilePage* self, gint64 user_id, gboolean show_spinner, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void profile_page_load_profile_data_finish (ProfilePage* self, GAsyncResult* _res_);
static void profile_page_load_friendship_data_free (gpointer _data);
static gboolean profile_page_load_friendship_co (ProfilePageLoadFriendshipData* _data_);
OAuthProxy* account_get_proxy (Account* self);
void tweet_utils_load_threaded (RestProxyCall* call, GAsyncReadyCallback _callback_, gpointer _user_data_);
JsonNode* tweet_utils_load_threaded_finish (GAsyncResult* _res_);
static void profile_page_load_friendship_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _vala_JsonNode_free (JsonNode* self);
static void profile_page_set_user_blocked (ProfilePage* self, gboolean blocked);
static void profile_page_set_retweets_disabled (ProfilePage* self, gboolean disabled);
static void profile_page_load_profile_data_data_free (gpointer _data);
static gboolean profile_page_load_profile_data_co (ProfilePageLoadProfileDataData* _data_);
static Block25Data* block25_data_ref (Block25Data* _data25_);
static void _tweet_utils_sequence_free0_ (gpointer var);
static void _g_slist_free__tweet_utils_sequence_free0_ (GSList* self);
static void block25_data_unref (void * _userdata_);
static void profile_page_load_profile_data_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gchar* utils_get_avatar_name (const gchar* path);
void utils_download_file_async (const gchar* url, const gchar* path, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void utils_download_file_finish (GAsyncResult* _res_);
static void ___lambda195_ (Block25Data* _data25_);
static void ____lambda195__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
gboolean utils_usable_json_value (JsonObject* node, const gchar* value_name);
gchar* utils_get_banner_name (gint64 user_id);
void tweet_list_box_set_placeholder_text (TweetListBox* self, const gchar* text);
static void profile_page_load_profile_banner (ProfilePage* self, const gchar* base_url, gint64 user_id);
static void ___lambda197_ (Block25Data* _data25_, JsonArray* arr, guint i, JsonNode* node);
static void ____lambda197__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
GType user_counter_get_type (void) G_GNUC_CONST;
UserCounter* account_get_user_counter (Account* self);
void user_counter_user_seen (UserCounter* self, gint64 id, const gchar* screen_name, const gchar* name);
gpointer sql_insert_statement_ref (gpointer instance);
void sql_insert_statement_unref (gpointer instance);
GParamSpec* sql_param_spec_insert_statement (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_insert_statement (GValue* value, gpointer v_object);
void sql_value_take_insert_statement (GValue* value, gpointer v_object);
gpointer sql_value_get_insert_statement (const GValue* value);
GType sql_insert_statement_get_type (void) G_GNUC_CONST;
SqlInsertStatement* sql_database_replace (SqlDatabase* self, const gchar* table_name);
SqlInsertStatement* sql_insert_statement_vali64 (SqlInsertStatement* self, const gchar* col_name, gint64 col_value);
SqlInsertStatement* sql_insert_statement_val (SqlInsertStatement* self, const gchar* col_name, const gchar* col_value);
SqlInsertStatement* sql_insert_statement_vali (SqlInsertStatement* self, const gchar* col_name, gint col_value);
gchar* tweet_utils_get_formatted_text (const gchar* tweet_text, GSList* urls);
SqlInsertStatement* sql_insert_statement_valb (SqlInsertStatement* self, const gchar* col_name, gboolean col_value);
gint64 sql_insert_statement_run (SqlInsertStatement* self);
static void profile_page_load_tweets_data_free (gpointer _data);
static void profile_page_load_tweets (ProfilePage* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void profile_page_load_tweets_finish (ProfilePage* self, GAsyncResult* _res_);
static gboolean profile_page_load_tweets_co (ProfilePageLoadTweetsData* _data_);
void tweet_list_box_set_unempty (TweetListBox* self);
static void profile_page_load_tweets_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void tweet_list_box_set_empty (TweetListBox* self);
GType tweet_utils_worker_result_get_type (void) G_GNUC_CONST;
TweetUtilsWorkerResult* tweet_utils_worker_result_dup (const TweetUtilsWorkerResult* self);
void tweet_utils_worker_result_free (TweetUtilsWorkerResult* self);
void tweet_utils_work_array (JsonArray* json_array, guint requested_tweet_count, DeltaUpdater* delta_updater, TweetListBox* tweet_list, MainWindow* main_window, Account* account, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_work_array_finish (GAsyncResult* _res_, TweetUtilsWorkerResult* result);
DeltaUpdater* profile_page_get_delta_updater (ProfilePage* self);
static void profile_page_load_older_tweets_data_free (gpointer _data);
static gboolean profile_page_load_older_tweets_co (ProfilePageLoadOlderTweetsData* _data_);
static void profile_page_load_older_tweets_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static Block26Data* block26_data_ref (Block26Data* _data26_);
static void block26_data_unref (void * _userdata_);
static void ___lambda196_ (Block26Data* _data26_);
static void ____lambda196__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
gpointer sql_update_statement_ref (gpointer instance);
void sql_update_statement_unref (gpointer instance);
GParamSpec* sql_param_spec_update_statement (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_update_statement (GValue* value, gpointer v_object);
void sql_value_take_update_statement (GValue* value, gpointer v_object);
gpointer sql_value_get_update_statement (const GValue* value);
GType sql_update_statement_get_type (void) G_GNUC_CONST;
SqlUpdateStatement* sql_database_update (SqlDatabase* self, const gchar* table_name);
SqlUpdateStatement* sql_update_statement_val (SqlUpdateStatement* self, const gchar* col_name, const gchar* col_value);
SqlUpdateStatement* sql_update_statement_where_eqi (SqlUpdateStatement* self, const gchar* col, gint64 iv);
gint64 sql_update_statement_run (SqlUpdateStatement* self);
static gint ___lambda194_ (TweetUtilsSequence* a, TweetUtilsSequence* b);
static gint ____lambda194__gcompare_func (gconstpointer a, gconstpointer b);
static void profile_page_update_follower_label (ProfilePage* self);
void avatar_widget_set_verified (AvatarWidget* self, gboolean value);
static void profile_page_follow_button_clicked_cb (ProfilePage* self);
static Block27Data* block27_data_ref (Block27Data* _data27_);
static void block27_data_unref (void * _userdata_);
GType default_timeline_get_type (void) G_GNUC_CONST;
GType home_timeline_get_type (void) G_GNUC_CONST;
IPage* main_window_get_page (MainWindow* self, gint page_id);
void home_timeline_hide_tweets_from (HomeTimeline* self, gint64 user_id);
void home_timeline_hide_retweets_from (HomeTimeline* self, gint64 user_id);
void account_unfollow_id (Account* self, gint64 user_id);
void home_timeline_show_tweets_from (HomeTimeline* self, gint64 user_id);
void home_timeline_show_retweets_from (HomeTimeline* self, gint64 user_id);
void account_follow_id (Account* self, gint64 user_id);
static void __lambda198_ (Block27Data* _data27_, GObject* obj, GAsyncResult* res);
static void ___lambda198__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _profile_page_follow_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean profile_page_activate_link (ProfilePage* self, const gchar* uri);
gboolean tweet_utils_activate_link (const gchar* uri, MainWindow* window);
static gboolean _profile_page_activate_link_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self);
void aspect_image_set_pixbuf (AspectImage* self, GdkPixbuf* value);
static void profile_page_real_on_join (IPage* base, gint page_id, Bundle* args);
gint64 bundle_get_int64 (Bundle* self, const gchar* key);
gchar* bundle_get_string (Bundle* self, const gchar* key);
static void profile_page_reset_data (ProfilePage* self);
void tweet_list_box_remove_all (TweetListBox* self);
void tweet_list_box_reset_placeholder_text (TweetListBox* self);
void user_lists_widget_clear_lists (UserListsWidget* self);
static void profile_page_real_on_leave (IPage* base);
static void profile_page_real_create_tool_button (IPage* base, GtkRadioButton* group);
static gchar* profile_page_real_get_title (IPage* base);
static GtkRadioButton* profile_page_real_get_tool_button (IPage* base);
void bundle_put_int64 (Bundle* self, const gchar* key, gint64 value);
void bundle_put_string (Bundle* self, const gchar* key, const gchar* value);
GType compose_tweet_window_get_type (void) G_GNUC_CONST;
GType compose_tweet_window_mode_get_type (void) G_GNUC_CONST;
ComposeTweetWindow* compose_tweet_window_new (GtkWindow* parent, Account* acc, Tweet* reply_to, ComposeTweetWindowMode mode, GtkApplication* app);
ComposeTweetWindow* compose_tweet_window_construct (GType object_type, GtkWindow* parent, Account* acc, Tweet* reply_to, ComposeTweetWindowMode mode, GtkApplication* app);
void compose_tweet_window_set_text (ComposeTweetWindow* self, const gchar* text);
GType user_list_dialog_get_type (void) G_GNUC_CONST;
UserListDialog* user_list_dialog_new (MainWindow* parent, Account* account, gint64 user_id);
UserListDialog* user_list_dialog_construct (GType object_type, MainWindow* parent, Account* account, gint64 user_id);
void user_list_dialog_load_lists (UserListDialog* self);
static Block28Data* block28_data_ref (Block28Data* _data28_);
static void block28_data_unref (void * _userdata_);
static gboolean profile_page_get_user_blocked (ProfilePage* self);
static void __lambda191_ (Block28Data* _data28_, GObject* obj, GAsyncResult* res);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file);
static void ___lambda191__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block29Data* block29_data_ref (Block29Data* _data29_);
static void block29_data_unref (void * _userdata_);
void account_remove_disabled_rts_id (Account* self, gint64 user_id);
void account_add_disabled_rts_id (Account* self, gint64 user_id);
static void __lambda192_ (Block29Data* _data29_, GObject* obj, GAsyncResult* res);
static void ___lambda192__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
gint profile_page_get_unread_count (ProfilePage* self);
void profile_page_set_unread_count (ProfilePage* self, gint value);
void user_lists_widget_set_main_window (UserListsWidget* self, MainWindow* value);
void user_lists_widget_set_account (UserListsWidget* self, Account* value);
void profile_page_set_delta_updater (ProfilePage* self, DeltaUpdater* value);
static void profile_page_finalize (GObject* obj);
gint ipage_get_id (IPage* self);
static void _vala_profile_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void ipage_set_main_window (IPage* self, MainWindow* value);
void ipage_set_account (IPage* self, Account* value);
static void _vala_profile_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const GActionEntry PROFILE_PAGE_action_entries[3] = {{"write-dm", _profile_page_write_dm_activated_gsimple_action_activate_callback}, {"tweet-to", _profile_page_tweet_to_activated_gsimple_action_activate_callback}, {"add-remove-list", _profile_page_add_remove_list_activated_gsimple_action_activate_callback}};

static void _profile_page_write_dm_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	profile_page_write_dm_activated ((ProfilePage*) self, action, parameter);
}


static void _profile_page_tweet_to_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	profile_page_tweet_to_activated ((ProfilePage*) self, action, parameter);
}


static void _profile_page_add_remove_list_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	profile_page_add_remove_list_activated ((ProfilePage*) self, action, parameter);
}


static gboolean __lambda186_ (ProfilePage* self, GdkEventScroll* evt) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventScroll* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp1_ = evt;
	_tmp2_ = _tmp1_->delta_y;
	if (_tmp2_ < ((gdouble) 0)) {
		GtkAdjustment* _tmp3_ = NULL;
		GtkAdjustment* _tmp4_ = NULL;
		gdouble _tmp5_ = 0.0;
		gdouble _tmp6_ = 0.0;
		_tmp3_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp4_ = _tmp3_;
		_tmp5_ = gtk_adjustment_get_value (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ == ((gdouble) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		AspectImage* _tmp7_ = NULL;
		gdouble _tmp8_ = 0.0;
		gdouble _tmp9_ = 0.0;
		AspectImage* _tmp11_ = NULL;
		AspectImage* _tmp12_ = NULL;
		gdouble _tmp13_ = 0.0;
		gdouble _tmp14_ = 0.0;
		GdkEventScroll* _tmp15_ = NULL;
		gdouble _tmp16_ = 0.0;
		AspectImage* _tmp17_ = NULL;
		_tmp7_ = self->priv->banner_image;
		_tmp8_ = aspect_image_get_scale (_tmp7_);
		_tmp9_ = _tmp8_;
		if (_tmp9_ >= 1.0) {
			AspectImage* _tmp10_ = NULL;
			_tmp10_ = self->priv->banner_image;
			aspect_image_set_scale (_tmp10_, (gdouble) 1.0f);
			result = FALSE;
			return result;
		}
		_tmp11_ = self->priv->banner_image;
		_tmp12_ = self->priv->banner_image;
		_tmp13_ = aspect_image_get_scale (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = evt;
		_tmp16_ = _tmp15_->delta_y;
		aspect_image_set_scale (_tmp12_, _tmp14_ + (0.25f * (-_tmp16_)));
		_tmp17_ = self->priv->banner_image;
		gtk_widget_queue_resize (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget));
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean ___lambda186__gtk_widget_scroll_event (GtkWidget* _sender, GdkEventScroll* event, gpointer self) {
	gboolean result;
	result = __lambda186_ ((ProfilePage*) self, event);
	return result;
}


static void __lambda187_ (ProfilePage* self) {
	profile_page_load_older_tweets (self, NULL, NULL);
}


static void ___lambda187__scroll_widget_scrolled_to_end (ScrollWidget* _sender, gpointer self) {
	__lambda187_ ((ProfilePage*) self);
}


static void __lambda188_ (ProfilePage* self, GtkListBoxRow* row) {
	Bundle* bundle = NULL;
	Bundle* _tmp0_ = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
	Tweet* _tmp2_ = NULL;
	MainWindow* _tmp3_ = NULL;
	MainWindow* _tmp4_ = NULL;
	MainWidget* _tmp5_ = NULL;
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = bundle_new ();
	bundle = _tmp0_;
	bundle_put_int (bundle, "mode", TWEET_INFO_PAGE_BY_INSTANCE);
	_tmp1_ = row;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TWEET_LIST_ENTRY, TweetListEntry)->tweet;
	bundle_put_object (bundle, "tweet", G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, G_TYPE_OBJECT, GObject));
	_tmp3_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_->main_widget;
	main_widget_switch_page (_tmp5_, (gint) PAGE_TWEET_INFO, bundle);
	_g_object_unref0 (bundle);
}


static void ___lambda188__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	__lambda188_ ((ProfilePage*) self, row);
}


static gint _itwitter_item_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self) {
	gint result;
	result = itwitter_item_sort_func (row1, row2);
	return result;
}


static void __lambda189_ (ProfilePage* self) {
	gboolean _tmp0_ = FALSE;
	GtkStack* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	UserListsWidget* _tmp4_ = NULL;
	_tmp1_ = self->priv->user_stack;
	_tmp2_ = gtk_stack_get_visible_child (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->user_lists;
	if (_tmp3_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget)) {
		gboolean _tmp5_ = FALSE;
		_tmp5_ = self->priv->lists_page_inited;
		_tmp0_ = !_tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		UserListsWidget* _tmp6_ = NULL;
		gint64 _tmp7_ = 0LL;
		_tmp6_ = self->priv->user_lists;
		_tmp7_ = self->priv->user_id;
		user_lists_widget_load_lists (_tmp6_, _tmp7_, NULL, NULL);
		self->priv->lists_page_inited = TRUE;
	}
}


static void ___lambda189__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda189_ ((ProfilePage*) self);
}


static void __lambda190_ (ProfilePage* self) {
	GtkStack* _tmp0_ = NULL;
	gulong _tmp1_ = 0UL;
	_tmp0_ = self->priv->user_stack;
	_tmp1_ = self->priv->page_change_signal;
	g_signal_handler_disconnect (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, G_TYPE_OBJECT, GObject), _tmp1_);
}


static void ___lambda190__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	__lambda190_ ((ProfilePage*) self);
}


static void _profile_page_toggle_blocked_activated_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	profile_page_toggle_blocked_activated ((ProfilePage*) self, _sender, parameter);
}


static void _profile_page_retweet_action_activated_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	profile_page_retweet_action_activated ((ProfilePage*) self, _sender, parameter);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


ProfilePage* profile_page_construct (GType object_type, gint id) {
	ProfilePage * self = NULL;
	gint _tmp0_ = 0;
	TweetListBox* _tmp1_ = NULL;
	TweetListBox* _tmp2_ = NULL;
	UserListsWidget* _tmp3_ = NULL;
	GtkStack* _tmp4_ = NULL;
	gulong _tmp5_ = 0UL;
	GSimpleActionGroup* _tmp6_ = NULL;
	GSimpleActionGroup* _tmp7_ = NULL;
	GSimpleAction* block_action = NULL;
	GVariant* _tmp8_ = NULL;
	GVariant* _tmp9_ = NULL;
	GSimpleAction* _tmp10_ = NULL;
	GSimpleAction* _tmp11_ = NULL;
	GSimpleActionGroup* _tmp12_ = NULL;
	GSimpleAction* rt_action = NULL;
	GVariant* _tmp13_ = NULL;
	GVariant* _tmp14_ = NULL;
	GSimpleAction* _tmp15_ = NULL;
	GSimpleAction* _tmp16_ = NULL;
	GSimpleActionGroup* _tmp17_ = NULL;
	GSimpleActionGroup* _tmp18_ = NULL;
	GtkMenuButton* _tmp19_ = NULL;
	GMenuModel* _tmp20_ = NULL;
	GMenuModel* _tmp21_ = NULL;
	GMenuModel* _tmp22_ = NULL;
	self = (ProfilePage*) scroll_widget_construct (object_type);
	_tmp0_ = id;
	ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), _tmp0_);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "scroll-event", (GCallback) ___lambda186__gtk_widget_scroll_event, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), "scrolled-to-end", (GCallback) ___lambda187__scroll_widget_scrolled_to_end, self, 0);
	_tmp1_ = self->priv->tweet_list;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_list_box_get_type (), GtkListBox), "row-activated", (GCallback) ___lambda188__gtk_list_box_row_activated, self, 0);
	_tmp2_ = self->priv->tweet_list;
	gtk_list_box_set_sort_func (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_list_box_get_type (), GtkListBox), _itwitter_item_sort_func_gtk_list_box_sort_func, NULL, NULL);
	_tmp3_ = self->priv->user_lists;
	user_lists_widget_hide_user_list_entry (_tmp3_);
	_tmp4_ = self->priv->user_stack;
	_tmp5_ = g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, G_TYPE_OBJECT, GObject), "notify::visible-child", (GCallback) ___lambda189__g_object_notify, self, 0);
	self->priv->page_change_signal = _tmp5_;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "destroy", (GCallback) ___lambda190__gtk_widget_destroy, self, 0);
	_tmp6_ = g_simple_action_group_new ();
	_g_object_unref0 (self->priv->actions);
	self->priv->actions = _tmp6_;
	_tmp7_ = self->priv->actions;
	g_action_map_add_action_entries (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_action_map_get_type (), GActionMap), PROFILE_PAGE_action_entries, G_N_ELEMENTS (PROFILE_PAGE_action_entries), self);
	_tmp8_ = g_variant_new_boolean (FALSE);
	g_variant_ref_sink (_tmp8_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_simple_action_new_stateful ("toggle-blocked", NULL, _tmp9_);
	_tmp11_ = _tmp10_;
	_g_variant_unref0 (_tmp9_);
	block_action = _tmp11_;
	g_signal_connect_object (block_action, "activate", (GCallback) _profile_page_toggle_blocked_activated_g_simple_action_activate, self, 0);
	_tmp12_ = self->priv->actions;
	g_action_map_add_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, g_action_map_get_type (), GActionMap), G_TYPE_CHECK_INSTANCE_CAST (block_action, g_action_get_type (), GAction));
	_tmp13_ = g_variant_new_boolean (FALSE);
	g_variant_ref_sink (_tmp13_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_simple_action_new_stateful ("toggle-retweets", NULL, _tmp14_);
	_tmp16_ = _tmp15_;
	_g_variant_unref0 (_tmp14_);
	rt_action = _tmp16_;
	g_signal_connect_object (rt_action, "activate", (GCallback) _profile_page_retweet_action_activated_g_simple_action_activate, self, 0);
	_tmp17_ = self->priv->actions;
	g_action_map_add_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, g_action_map_get_type (), GActionMap), G_TYPE_CHECK_INSTANCE_CAST (rt_action, g_action_get_type (), GAction));
	_tmp18_ = self->priv->actions;
	gtk_widget_insert_action_group (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "user", G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, g_action_group_get_type (), GActionGroup));
	_tmp19_ = self->priv->more_button;
	_tmp20_ = gtk_menu_button_get_menu_model (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = _g_object_ref0 (_tmp21_);
	_g_object_unref0 (self->priv->more_menu);
	self->priv->more_menu = _tmp22_;
	_g_object_unref0 (rt_action);
	_g_object_unref0 (block_action);
	return self;
}


ProfilePage* profile_page_new (gint id) {
	return profile_page_construct (TYPE_PROFILE_PAGE, id);
}


static Block24Data* block24_data_ref (Block24Data* _data24_) {
	g_atomic_int_inc (&_data24_->_ref_count_);
	return _data24_;
}


static void block24_data_unref (void * _userdata_) {
	Block24Data* _data24_;
	_data24_ = (Block24Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
		ProfilePage* self;
		self = _data24_->self;
		_g_object_unref0 (self);
		g_slice_free (Block24Data, _data24_);
	}
}


static gboolean bool_parse (const gchar* str) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	if (g_strcmp0 (_tmp0_, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static gboolean __lambda193_ (Block24Data* _data24_, gchar** vals, int vals_length1) {
	ProfilePage* self;
	gboolean result = FALSE;
	gchar** _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	const gchar* _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	const gchar* _tmp15_ = NULL;
	gchar** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	const gchar* _tmp17_ = NULL;
	gchar** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	const gchar* _tmp19_ = NULL;
	gchar** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	const gchar* _tmp21_ = NULL;
	gchar** _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
	const gchar* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gchar** _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
	const gchar* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	gchar** _tmp28_ = NULL;
	gint _tmp28__length1 = 0;
	const gchar* _tmp29_ = NULL;
	gint _tmp30_ = 0;
	gchar** _tmp31_ = NULL;
	gint _tmp31__length1 = 0;
	const gchar* _tmp32_ = NULL;
	gchar** _tmp33_ = NULL;
	gint _tmp33__length1 = 0;
	const gchar* _tmp34_ = NULL;
	gboolean _tmp35_ = FALSE;
	gchar* banner_name = NULL;
	gchar** _tmp36_ = NULL;
	gint _tmp36__length1 = 0;
	const gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	gboolean _tmp40_ = FALSE;
	const gchar* _tmp41_ = NULL;
	GError * _inner_error_ = NULL;
	self = _data24_->self;
	{
		GdkPixbuf* _tmp0_ = NULL;
		gchar** _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		GdkPixbuf* _tmp7_ = NULL;
		GdkPixbuf* _tmp8_ = NULL;
		AvatarWidget* _tmp9_ = NULL;
		_tmp1_ = vals;
		_tmp1__length1 = vals_length1;
		_tmp2_ = _tmp1_[7];
		_tmp3_ = g_strconcat ("/assets/avatars/", _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = dirs_cache (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = gdk_pixbuf_new_from_file (_tmp6_, &_inner_error_);
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		_tmp0_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch28_g_error;
		}
		_tmp9_ = self->priv->avatar_image;
		g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_image_get_type (), GtkImage), "pixbuf", _tmp0_, NULL);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_warning ("ProfilePage.vala:185: %s", _tmp11_);
		_g_error_free0 (e);
	}
	__finally28:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp12_ = vals;
	_tmp12__length1 = vals_length1;
	_tmp13_ = _tmp12_[2];
	_tmp14_ = vals;
	_tmp14__length1 = vals_length1;
	_tmp15_ = _tmp14_[1];
	_tmp16_ = vals;
	_tmp16__length1 = vals_length1;
	_tmp17_ = _tmp16_[9];
	_tmp18_ = vals;
	_tmp18__length1 = vals_length1;
	_tmp19_ = _tmp18_[10];
	_tmp20_ = vals;
	_tmp20__length1 = vals_length1;
	_tmp21_ = _tmp20_[3];
	_tmp22_ = vals;
	_tmp22__length1 = vals_length1;
	_tmp23_ = _tmp22_[4];
	_tmp24_ = atoi (_tmp23_);
	_tmp25_ = vals;
	_tmp25__length1 = vals_length1;
	_tmp26_ = _tmp25_[5];
	_tmp27_ = atoi (_tmp26_);
	_tmp28_ = vals;
	_tmp28__length1 = vals_length1;
	_tmp29_ = _tmp28_[6];
	_tmp30_ = atoi (_tmp29_);
	_tmp31_ = vals;
	_tmp31__length1 = vals_length1;
	_tmp32_ = _tmp31_[7];
	profile_page_set_data (self, _tmp13_, _tmp15_, _tmp17_, _tmp19_, _tmp21_, _tmp24_, _tmp27_, _tmp30_, _tmp32_, FALSE, NULL);
	_tmp33_ = vals;
	_tmp33__length1 = vals_length1;
	_tmp34_ = _tmp33_[11];
	_tmp35_ = bool_parse (_tmp34_);
	profile_page_set_follow_button_state (self, _tmp35_);
	_tmp36_ = vals;
	_tmp36__length1 = vals_length1;
	_tmp37_ = _tmp36_[12];
	_tmp38_ = g_strdup (_tmp37_);
	banner_name = _tmp38_;
	_tmp39_ = banner_name;
	g_debug ("ProfilePage.vala:193: banner_name: %s", _tmp39_);
	_tmp41_ = banner_name;
	if (_tmp41_ != NULL) {
		const gchar* _tmp42_ = NULL;
		gchar* _tmp43_ = NULL;
		gchar* _tmp44_ = NULL;
		gchar* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		gboolean _tmp47_ = FALSE;
		_tmp42_ = banner_name;
		_tmp43_ = g_strconcat ("assets/banners/", _tmp42_, NULL);
		_tmp44_ = _tmp43_;
		_tmp45_ = dirs_cache (_tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = g_file_test (_tmp46_, G_FILE_TEST_EXISTS);
		_tmp40_ = _tmp47_;
		_g_free0 (_tmp46_);
		_g_free0 (_tmp44_);
	} else {
		_tmp40_ = FALSE;
	}
	if (_tmp40_) {
		const gchar* _tmp48_ = NULL;
		gchar* _tmp49_ = NULL;
		gchar* _tmp50_ = NULL;
		gchar* _tmp51_ = NULL;
		gchar* _tmp52_ = NULL;
		g_debug ("ProfilePage.vala:197: Banner exists, set it directly...");
		_tmp48_ = banner_name;
		_tmp49_ = g_strconcat ("assets/banners/", _tmp48_, NULL);
		_tmp50_ = _tmp49_;
		_tmp51_ = dirs_cache (_tmp50_);
		_tmp52_ = _tmp51_;
		profile_page_load_banner (self, _tmp52_);
		_g_free0 (_tmp52_);
		_g_free0 (_tmp50_);
	} else {
		const gchar* _tmp53_ = NULL;
		_tmp53_ = banner_name;
		g_debug ("ProfilePage.vala:202: Banner %s does not exist, load it first...", _tmp53_);
		profile_page_load_banner (self, NULL);
	}
	_data24_->data_in_db = TRUE;
	result = FALSE;
	_g_free0 (banner_name);
	return result;
}


static gboolean ___lambda193__sql_select_callback (gchar** vals, int vals_length1, gpointer self) {
	gboolean result;
	result = __lambda193_ (self, vals, vals_length1);
	return result;
}


static void profile_page_set_user_id (ProfilePage* self, gint64 user_id) {
	Block24Data* _data24_;
	gint64 _tmp0_ = 0LL;
	GtkButton* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	Account* _tmp3_ = NULL;
	Account* _tmp4_ = NULL;
	gint64 _tmp5_ = 0LL;
	gint64 _tmp6_ = 0LL;
	GSimpleActionGroup* _tmp7_ = NULL;
	GAction* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	Account* _tmp10_ = NULL;
	Account* _tmp11_ = NULL;
	gint64 _tmp12_ = 0LL;
	gint64 _tmp13_ = 0LL;
	GSimpleActionGroup* _tmp14_ = NULL;
	GAction* _tmp15_ = NULL;
	gint64 _tmp16_ = 0LL;
	Account* _tmp17_ = NULL;
	Account* _tmp18_ = NULL;
	gint64 _tmp19_ = 0LL;
	gint64 _tmp20_ = 0LL;
	GSimpleActionGroup* _tmp21_ = NULL;
	GAction* _tmp22_ = NULL;
	gint64 _tmp23_ = 0LL;
	Account* _tmp24_ = NULL;
	Account* _tmp25_ = NULL;
	gint64 _tmp26_ = 0LL;
	gint64 _tmp27_ = 0LL;
	GSimpleActionGroup* _tmp28_ = NULL;
	GAction* _tmp29_ = NULL;
	SqlDatabase* _tmp30_ = NULL;
	SqlSelectStatement* _tmp31_ = NULL;
	SqlSelectStatement* _tmp32_ = NULL;
	SqlSelectStatement* _tmp33_ = NULL;
	SqlSelectStatement* _tmp34_ = NULL;
	gint64 _tmp35_ = 0LL;
	SqlSelectStatement* _tmp36_ = NULL;
	SqlSelectStatement* _tmp37_ = NULL;
	gint64 _tmp38_ = 0LL;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	_data24_ = g_slice_new0 (Block24Data);
	_data24_->_ref_count_ = 1;
	_data24_->self = g_object_ref (self);
	_tmp0_ = user_id;
	self->priv->user_id = _tmp0_;
	_tmp1_ = self->priv->follow_button;
	_tmp2_ = user_id;
	_tmp3_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp4_ = _tmp3_;
	_tmp5_ = account_get_id (_tmp4_);
	_tmp6_ = _tmp5_;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), _tmp2_ != _tmp6_);
	_tmp7_ = self->priv->actions;
	_tmp8_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_action_map_get_type (), GActionMap), "add-remove-list");
	_tmp9_ = user_id;
	_tmp10_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp11_ = _tmp10_;
	_tmp12_ = account_get_id (_tmp11_);
	_tmp13_ = _tmp12_;
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, g_simple_action_get_type (), GSimpleAction), _tmp9_ != _tmp13_);
	_tmp14_ = self->priv->actions;
	_tmp15_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, g_action_map_get_type (), GActionMap), "write-dm");
	_tmp16_ = user_id;
	_tmp17_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp18_ = _tmp17_;
	_tmp19_ = account_get_id (_tmp18_);
	_tmp20_ = _tmp19_;
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, g_simple_action_get_type (), GSimpleAction), _tmp16_ != _tmp20_);
	_tmp21_ = self->priv->actions;
	_tmp22_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, g_action_map_get_type (), GActionMap), "toggle-blocked");
	_tmp23_ = user_id;
	_tmp24_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp25_ = _tmp24_;
	_tmp26_ = account_get_id (_tmp25_);
	_tmp27_ = _tmp26_;
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, g_simple_action_get_type (), GSimpleAction), _tmp23_ != _tmp27_);
	_tmp28_ = self->priv->actions;
	_tmp29_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, g_action_map_get_type (), GActionMap), "toggle-retweets");
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, g_simple_action_get_type (), GSimpleAction), FALSE);
	profile_page_load_banner (self, NULL);
	profile_page_load_friendship (self, NULL, NULL);
	_data24_->data_in_db = FALSE;
	_tmp30_ = corebird_db;
	_tmp31_ = sql_database_select (_tmp30_, "profiles");
	_tmp32_ = _tmp31_;
	_tmp33_ = sql_select_statement_cols (_tmp32_, "id", "screen_name", "name", "description", "tweets", "following", "followers", "avatar_name", "banner_url", "url", "location", "is_following", "banner_name", NULL);
	_tmp34_ = _tmp33_;
	_tmp35_ = user_id;
	_tmp36_ = sql_select_statement_where_eqi (_tmp34_, "id", _tmp35_);
	_tmp37_ = _tmp36_;
	sql_select_statement_run (_tmp37_, ___lambda193__sql_select_callback, _data24_);
	_sql_select_statement_unref0 (_tmp37_);
	_sql_select_statement_unref0 (_tmp34_);
	_sql_select_statement_unref0 (_tmp32_);
	_tmp38_ = user_id;
	profile_page_load_profile_data (self, _tmp38_, !_data24_->data_in_db, NULL, NULL);
	block24_data_unref (_data24_);
	_data24_ = NULL;
}


static void profile_page_load_friendship_data_free (gpointer _data) {
	ProfilePageLoadFriendshipData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ProfilePageLoadFriendshipData, _data_);
}


static void profile_page_load_friendship (ProfilePage* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ProfilePageLoadFriendshipData* _data_;
	ProfilePage* _tmp0_ = NULL;
	_data_ = g_slice_new0 (ProfilePageLoadFriendshipData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, profile_page_load_friendship);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, profile_page_load_friendship_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	profile_page_load_friendship_co (_data_);
}


static void profile_page_load_friendship_finish (ProfilePage* self, GAsyncResult* _res_) {
	ProfilePageLoadFriendshipData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void profile_page_load_friendship_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ProfilePageLoadFriendshipData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	profile_page_load_friendship_co (_data_);
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gboolean profile_page_load_friendship_co (ProfilePageLoadFriendshipData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_IPAGE, IPage));
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = account_get_proxy (_data_->_tmp1_);
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp4_;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->call;
	rest_proxy_call_set_function (_data_->_tmp5_, "1.1/friendships/show.json");
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp6_, "GET");
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->call;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_IPAGE, IPage));
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = 0LL;
	_data_->_tmp10_ = account_get_id (_data_->_tmp9_);
	_data_->_tmp11_ = 0LL;
	_data_->_tmp11_ = _data_->_tmp10_;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp11_);
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->_tmp12_;
	rest_proxy_call_add_param (_data_->_tmp7_, "source_id", _data_->_tmp13_);
	_g_free0 (_data_->_tmp13_);
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->call;
	_data_->_tmp15_ = 0LL;
	_data_->_tmp15_ = _data_->self->priv->user_id;
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp15_);
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = _data_->_tmp16_;
	rest_proxy_call_add_param (_data_->_tmp14_, "target_id", _data_->_tmp17_);
	_g_free0 (_data_->_tmp17_);
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = _data_->call;
	_data_->_state_ = 1;
	tweet_utils_load_threaded (_data_->_tmp18_, profile_page_load_friendship_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = tweet_utils_load_threaded_finish (_data_->_res_);
	_data_->root = _data_->_tmp19_;
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = _data_->root;
	if (_data_->_tmp20_ == NULL) {
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = _data_->root;
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = json_node_get_object (_data_->_tmp21_);
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = json_object_get_object_member (_data_->_tmp22_, "relationship");
	_data_->_tmp24_ = NULL;
	_data_->_tmp24_ = _json_object_ref0 (_data_->_tmp23_);
	_data_->relationship = _data_->_tmp24_;
	_data_->_tmp25_ = NULL;
	_data_->_tmp25_ = _data_->relationship;
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = json_object_get_object_member (_data_->_tmp25_, "target");
	_data_->_tmp27_ = FALSE;
	_data_->_tmp27_ = json_object_get_boolean_member (_data_->_tmp26_, "following");
	_data_->followed_by = _data_->_tmp27_;
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = _data_->relationship;
	_data_->_tmp29_ = NULL;
	_data_->_tmp29_ = json_object_get_object_member (_data_->_tmp28_, "target");
	_data_->_tmp30_ = FALSE;
	_data_->_tmp30_ = json_object_get_boolean_member (_data_->_tmp29_, "followed_by");
	_data_->following = _data_->_tmp30_;
	_data_->_tmp31_ = NULL;
	_data_->_tmp31_ = _data_->relationship;
	_data_->_tmp32_ = NULL;
	_data_->_tmp32_ = json_object_get_object_member (_data_->_tmp31_, "source");
	_data_->_tmp33_ = FALSE;
	_data_->_tmp33_ = json_object_get_boolean_member (_data_->_tmp32_, "want_retweets");
	_data_->want_retweets = _data_->_tmp33_;
	_data_->_tmp34_ = NULL;
	_data_->_tmp34_ = _data_->self->priv->follows_you_label;
	_data_->_tmp35_ = FALSE;
	_data_->_tmp35_ = _data_->followed_by;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp34_, gtk_widget_get_type (), GtkWidget), _data_->_tmp35_);
	_data_->_tmp36_ = NULL;
	_data_->_tmp36_ = _data_->relationship;
	_data_->_tmp37_ = NULL;
	_data_->_tmp37_ = json_object_get_object_member (_data_->_tmp36_, "source");
	_data_->_tmp38_ = FALSE;
	_data_->_tmp38_ = json_object_get_boolean_member (_data_->_tmp37_, "blocking");
	profile_page_set_user_blocked (_data_->self, _data_->_tmp38_);
	_data_->_tmp40_ = FALSE;
	_data_->_tmp40_ = _data_->following;
	if (_data_->_tmp40_) {
		_data_->_tmp41_ = FALSE;
		_data_->_tmp41_ = _data_->want_retweets;
		_data_->_tmp39_ = !_data_->_tmp41_;
	} else {
		_data_->_tmp39_ = FALSE;
	}
	profile_page_set_retweets_disabled (_data_->self, _data_->_tmp39_);
	_data_->_tmp42_ = NULL;
	_data_->_tmp42_ = _data_->self->priv->actions;
	_data_->_tmp43_ = NULL;
	_data_->_tmp43_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp42_, g_action_map_get_type (), GActionMap), "toggle-retweets");
	_data_->_tmp44_ = FALSE;
	_data_->_tmp44_ = _data_->following;
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp43_, g_simple_action_get_type (), GSimpleAction), _data_->_tmp44_);
	_json_object_unref0 (_data_->relationship);
	__vala_JsonNode_free0 (_data_->root);
	_g_object_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void profile_page_load_profile_data_data_free (gpointer _data) {
	ProfilePageLoadProfileDataData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ProfilePageLoadProfileDataData, _data_);
}


static void profile_page_load_profile_data (ProfilePage* self, gint64 user_id, gboolean show_spinner, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ProfilePageLoadProfileDataData* _data_;
	ProfilePage* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gboolean _tmp2_ = FALSE;
	_data_ = g_slice_new0 (ProfilePageLoadProfileDataData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, profile_page_load_profile_data);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, profile_page_load_profile_data_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = user_id;
	_data_->user_id = _tmp1_;
	_tmp2_ = show_spinner;
	_data_->show_spinner = _tmp2_;
	profile_page_load_profile_data_co (_data_);
}


static void profile_page_load_profile_data_finish (ProfilePage* self, GAsyncResult* _res_) {
	ProfilePageLoadProfileDataData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block25Data* block25_data_ref (Block25Data* _data25_) {
	g_atomic_int_inc (&_data25_->_ref_count_);
	return _data25_;
}


static void _tweet_utils_sequence_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (tweet_utils_sequence_free (var), NULL));
}


static void _g_slist_free__tweet_utils_sequence_free0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _tweet_utils_sequence_free0_, NULL);
	g_slist_free (self);
}


static void block25_data_unref (void * _userdata_) {
	Block25Data* _data25_;
	_data25_ = (Block25Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data25_->_ref_count_)) {
		ProfilePage* self;
		self = _data25_->self;
		__g_slist_free__tweet_utils_sequence_free0_0 (_data25_->text_urls);
		_g_free0 (_data25_->avatar_on_disk);
		_g_object_unref0 (self);
		g_slice_free (Block25Data, _data25_);
	}
}


static void profile_page_load_profile_data_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ProfilePageLoadProfileDataData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	profile_page_load_profile_data_co (_data_);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch29_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch29_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally29;
	__catch29_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally29:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void ___lambda195_ (Block25Data* _data25_) {
	ProfilePage* self;
	gboolean _tmp6_ = FALSE;
	GError * _inner_error_ = NULL;
	self = _data25_->self;
	{
		GdkPixbuf* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		GdkPixbuf* _tmp2_ = NULL;
		AvatarWidget* _tmp3_ = NULL;
		_tmp1_ = _data25_->avatar_on_disk;
		_tmp2_ = gdk_pixbuf_new_from_file (_tmp1_, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch30_g_error;
		}
		_tmp3_ = self->priv->avatar_image;
		g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_image_get_type (), GtkImage), "pixbuf", _tmp0_, NULL);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally30;
	__catch30_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("ProfilePage.vala:265: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally30:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = _data25_->show_spinner;
	if (_tmp6_) {
		GtkSpinner* _tmp7_ = NULL;
		GtkStack* _tmp8_ = NULL;
		_tmp7_ = self->priv->progress_spinner;
		gtk_spinner_stop (_tmp7_);
		_tmp8_ = self->priv->loading_stack;
		gtk_stack_set_visible_child_name (_tmp8_, "data");
	}
}


static void ____lambda195__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda195_ (self);
	block25_data_unref (self);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static gpointer _tweet_utils_sequence_dup0 (gpointer self) {
	return self ? tweet_utils_sequence_dup (self) : NULL;
}


static void ___lambda197_ (Block25Data* _data25_, JsonArray* arr, guint i, JsonNode* node) {
	ProfilePage* self;
	JsonObject* ent = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	gchar* expanded_url = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	JsonArray* indices = NULL;
	JsonArray* _tmp7_ = NULL;
	JsonArray* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	gint64 _tmp10_ = 0LL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	TweetUtilsSequence _tmp15_ = {0};
	TweetUtilsSequence _tmp16_ = {0};
	TweetUtilsSequence* _tmp17_ = NULL;
	self = _data25_->self;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	ent = _tmp2_;
	_tmp3_ = json_object_get_string_member (ent, "expanded_url");
	_tmp4_ = g_strdup (_tmp3_);
	expanded_url = _tmp4_;
	_tmp5_ = expanded_url;
	_tmp6_ = string_replace (_tmp5_, "&", "&amp;");
	_g_free0 (expanded_url);
	expanded_url = _tmp6_;
	_tmp7_ = json_object_get_array_member (ent, "indices");
	_tmp8_ = _json_array_ref0 (_tmp7_);
	indices = _tmp8_;
	_tmp9_ = json_array_get_int_element (indices, (guint) 0);
	_tmp10_ = json_array_get_int_element (indices, (guint) 1);
	_tmp11_ = expanded_url;
	_tmp12_ = g_strdup (_tmp11_);
	_tmp13_ = json_object_get_string_member (ent, "display_url");
	_tmp14_ = g_strdup (_tmp13_);
	memset (&_tmp15_, 0, sizeof (TweetUtilsSequence));
	_tmp15_.start = (gint) _tmp9_;
	_tmp15_.end = (gint) _tmp10_;
	_g_free0 (_tmp15_.url);
	_tmp15_.url = _tmp12_;
	_g_free0 (_tmp15_.display_url);
	_tmp15_.display_url = _tmp14_;
	_tmp16_ = _tmp15_;
	_tmp17_ = _tweet_utils_sequence_dup0 (&_tmp16_);
	_data25_->text_urls = g_slist_prepend (_data25_->text_urls, _tmp17_);
	tweet_utils_sequence_destroy (&_tmp16_);
	_json_array_unref0 (indices);
	_g_free0 (expanded_url);
	_json_object_unref0 (ent);
}


static void ____lambda197__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	___lambda197_ (self, array, index_, element_node);
}


static gboolean profile_page_load_profile_data_co (ProfilePageLoadProfileDataData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data25_ = g_slice_new0 (Block25Data);
	_data_->_data25_->_ref_count_ = 1;
	_data_->_data25_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = FALSE;
	_data_->_tmp0_ = _data_->show_spinner;
	_data_->_data25_->show_spinner = _data_->_tmp0_;
	_data_->_data25_->_async_data_ = _data_;
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = _data_->_data25_->show_spinner;
	if (_data_->_tmp1_) {
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _data_->self->priv->loading_stack;
		gtk_stack_set_visible_child_name (_data_->_tmp2_, "progress");
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->self->priv->progress_spinner;
		gtk_spinner_start (_data_->_tmp3_);
	}
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->self->priv->follow_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, gtk_widget_get_type (), GtkWidget), FALSE);
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_IPAGE, IPage));
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = account_get_proxy (_data_->_tmp6_);
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp8_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp9_;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp10_, "GET");
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->call;
	rest_proxy_call_set_function (_data_->_tmp11_, "1.1/users/show.json");
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->call;
	_data_->_tmp13_ = 0LL;
	_data_->_tmp13_ = _data_->user_id;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp13_);
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _data_->_tmp14_;
	rest_proxy_call_add_param (_data_->_tmp12_, "user_id", _data_->_tmp15_);
	_g_free0 (_data_->_tmp15_);
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp16_, "include_entities", "false");
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = _data_->call;
	_data_->_state_ = 1;
	tweet_utils_load_threaded (_data_->_tmp17_, profile_page_load_profile_data_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = tweet_utils_load_threaded_finish (_data_->_res_);
	_data_->root_node = _data_->_tmp18_;
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = _data_->root_node;
	if (_data_->_tmp19_ == NULL) {
		__vala_JsonNode_free0 (_data_->root_node);
		_g_object_unref0 (_data_->call);
		block25_data_unref (_data_->_data25_);
		_data_->_data25_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = _data_->root_node;
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = json_node_get_object (_data_->_tmp20_);
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = _json_object_ref0 (_data_->_tmp21_);
	_data_->root = _data_->_tmp22_;
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = _data_->root;
	_data_->_tmp24_ = 0LL;
	_data_->_tmp24_ = json_object_get_int_member (_data_->_tmp23_, "id");
	_data_->id = _data_->_tmp24_;
	_data_->_tmp25_ = NULL;
	_data_->_tmp25_ = _data_->root;
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = json_object_get_string_member (_data_->_tmp25_, "profile_image_url");
	_data_->_tmp27_ = NULL;
	_data_->_tmp27_ = g_strdup (_data_->_tmp26_);
	_data_->avatar_url = _data_->_tmp27_;
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = _data_->avatar_url;
	_data_->_tmp29_ = NULL;
	_data_->_tmp29_ = string_replace (_data_->_tmp28_, "_normal", "_bigger");
	_g_free0 (_data_->avatar_url);
	_data_->avatar_url = _data_->_tmp29_;
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = _data_->avatar_url;
	_data_->_tmp31_ = NULL;
	_data_->_tmp31_ = utils_get_avatar_name (_data_->_tmp30_);
	_data_->avatar_name = _data_->_tmp31_;
	_data_->_tmp32_ = NULL;
	_data_->_tmp32_ = _data_->avatar_name;
	_data_->_tmp33_ = NULL;
	_data_->_tmp33_ = g_strconcat ("assets/avatars/", _data_->_tmp32_, NULL);
	_data_->_tmp34_ = NULL;
	_data_->_tmp34_ = _data_->_tmp33_;
	_data_->_tmp35_ = NULL;
	_data_->_tmp35_ = dirs_cache (_data_->_tmp34_);
	_data_->_tmp36_ = NULL;
	_data_->_tmp36_ = _data_->_tmp35_;
	_g_free0 (_data_->_tmp34_);
	_data_->_data25_->avatar_on_disk = _data_->_tmp36_;
	_data_->_tmp37_ = NULL;
	_data_->_tmp37_ = _data_->_data25_->avatar_on_disk;
	_data_->_tmp38_ = FALSE;
	_data_->_tmp38_ = g_file_test (_data_->_tmp37_, G_FILE_TEST_EXISTS);
	if (!_data_->_tmp38_) {
		_data_->_tmp39_ = NULL;
		_data_->_tmp39_ = _data_->avatar_url;
		_data_->_tmp40_ = NULL;
		_data_->_tmp40_ = _data_->_data25_->avatar_on_disk;
		_data_->_tmp41_ = NULL;
		_data_->_tmp41_ = _data_->self->priv->data_cancellable;
		utils_download_file_async (_data_->_tmp39_, _data_->_tmp40_, _data_->_tmp41_, ____lambda195__gasync_ready_callback, block25_data_ref (_data_->_data25_));
	} else {
		{
			_data_->_tmp43_ = NULL;
			_data_->_tmp43_ = _data_->_data25_->avatar_on_disk;
			_data_->_tmp44_ = NULL;
			_data_->_tmp44_ = gdk_pixbuf_new_from_file (_data_->_tmp43_, &_data_->_inner_error_);
			_data_->_tmp42_ = _data_->_tmp44_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch31_g_error;
			}
			_data_->_tmp45_ = NULL;
			_data_->_tmp45_ = _data_->self->priv->avatar_image;
			g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp45_, gtk_image_get_type (), GtkImage), "pixbuf", _data_->_tmp42_, NULL);
			_g_object_unref0 (_data_->_tmp42_);
		}
		goto __finally31;
		__catch31_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp46_ = NULL;
			_data_->_tmp46_ = _data_->e;
			_data_->_tmp47_ = NULL;
			_data_->_tmp47_ = _data_->_tmp46_->message;
			g_warning ("ProfilePage.vala:276: %s", _data_->_tmp47_);
			_g_error_free0 (_data_->e);
		}
		__finally31:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_free0 (_data_->avatar_name);
			_g_free0 (_data_->avatar_url);
			_json_object_unref0 (_data_->root);
			__vala_JsonNode_free0 (_data_->root_node);
			_g_object_unref0 (_data_->call);
			block25_data_unref (_data_->_data25_);
			_data_->_data25_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->_tmp48_ = FALSE;
		_data_->_tmp48_ = _data_->_data25_->show_spinner;
		if (_data_->_tmp48_) {
			_data_->_tmp49_ = NULL;
			_data_->_tmp49_ = _data_->self->priv->progress_spinner;
			gtk_spinner_stop (_data_->_tmp49_);
			_data_->_tmp50_ = NULL;
			_data_->_tmp50_ = _data_->self->priv->loading_stack;
			gtk_stack_set_visible_child_name (_data_->_tmp50_, "data");
		}
	}
	_data_->_tmp51_ = NULL;
	_data_->_tmp51_ = _data_->root;
	_data_->_tmp52_ = NULL;
	_data_->_tmp52_ = json_object_get_string_member (_data_->_tmp51_, "name");
	_data_->_tmp53_ = NULL;
	_data_->_tmp53_ = string_replace (_data_->_tmp52_, "&", "&amp;");
	_data_->_tmp54_ = NULL;
	_data_->_tmp54_ = _data_->_tmp53_;
	_data_->_tmp55_ = NULL;
	_data_->_tmp55_ = string_strip (_data_->_tmp54_);
	_data_->_tmp56_ = NULL;
	_data_->_tmp56_ = _data_->_tmp55_;
	_g_free0 (_data_->_tmp54_);
	_data_->name = _data_->_tmp56_;
	_data_->_tmp57_ = NULL;
	_data_->_tmp57_ = _data_->root;
	_data_->_tmp58_ = NULL;
	_data_->_tmp58_ = json_object_get_string_member (_data_->_tmp57_, "screen_name");
	_data_->_tmp59_ = NULL;
	_data_->_tmp59_ = g_strdup (_data_->_tmp58_);
	_data_->screen_name = _data_->_tmp59_;
	_data_->_tmp60_ = NULL;
	_data_->_tmp60_ = _data_->root;
	_data_->_tmp61_ = NULL;
	_data_->_tmp61_ = json_object_get_string_member (_data_->_tmp60_, "description");
	_data_->_tmp62_ = NULL;
	_data_->_tmp62_ = string_replace (_data_->_tmp61_, "&", "&amp;");
	_data_->description = _data_->_tmp62_;
	_data_->_tmp63_ = NULL;
	_data_->_tmp63_ = _data_->root;
	_data_->_tmp64_ = 0LL;
	_data_->_tmp64_ = json_object_get_int_member (_data_->_tmp63_, "followers_count");
	_data_->followers = (gint) _data_->_tmp64_;
	_data_->_tmp65_ = NULL;
	_data_->_tmp65_ = _data_->root;
	_data_->_tmp66_ = 0LL;
	_data_->_tmp66_ = json_object_get_int_member (_data_->_tmp65_, "friends_count");
	_data_->following = (gint) _data_->_tmp66_;
	_data_->_tmp67_ = NULL;
	_data_->_tmp67_ = _data_->root;
	_data_->_tmp68_ = 0LL;
	_data_->_tmp68_ = json_object_get_int_member (_data_->_tmp67_, "statuses_count");
	_data_->tweets = (gint) _data_->_tmp68_;
	_data_->is_following = FALSE;
	_data_->_tmp69_ = NULL;
	_data_->_tmp69_ = _data_->root;
	_data_->_tmp70_ = FALSE;
	_data_->_tmp70_ = utils_usable_json_value (_data_->_tmp69_, "following");
	if (_data_->_tmp70_) {
		_data_->_tmp71_ = NULL;
		_data_->_tmp71_ = _data_->root;
		_data_->_tmp72_ = FALSE;
		_data_->_tmp72_ = json_object_get_boolean_member (_data_->_tmp71_, "following");
		_data_->is_following = _data_->_tmp72_;
	}
	_data_->_tmp73_ = NULL;
	_data_->_tmp73_ = _data_->root;
	_data_->_tmp74_ = NULL;
	_data_->_tmp74_ = json_object_get_object_member (_data_->_tmp73_, "entities");
	_data_->_tmp75_ = FALSE;
	_data_->_tmp75_ = json_object_has_member (_data_->_tmp74_, "url");
	_data_->has_url = _data_->_tmp75_;
	_data_->_tmp76_ = 0LL;
	_data_->_tmp76_ = _data_->user_id;
	_data_->_tmp77_ = NULL;
	_data_->_tmp77_ = utils_get_banner_name (_data_->_tmp76_);
	_data_->banner_name = _data_->_tmp77_;
	_data_->_tmp78_ = NULL;
	_data_->_tmp78_ = _data_->root;
	_data_->_tmp79_ = FALSE;
	_data_->_tmp79_ = json_object_get_boolean_member (_data_->_tmp78_, "verified");
	_data_->verified = _data_->_tmp79_;
	_data_->_tmp80_ = NULL;
	_data_->_tmp80_ = _data_->root;
	_data_->_tmp81_ = FALSE;
	_data_->_tmp81_ = json_object_get_boolean_member (_data_->_tmp80_, "protected");
	_data_->protected_user = _data_->_tmp81_;
	_data_->_tmp82_ = FALSE;
	_data_->_tmp82_ = _data_->protected_user;
	if (_data_->_tmp82_) {
		_data_->_tmp83_ = NULL;
		_data_->_tmp83_ = _data_->self->priv->tweet_list;
		_data_->_tmp84_ = NULL;
		_data_->_tmp84_ = _ ("Protected profile");
		tweet_list_box_set_placeholder_text (_data_->_tmp83_, _data_->_tmp84_);
	}
	_data_->_tmp85_ = NULL;
	_data_->_tmp85_ = _data_->root;
	_data_->_tmp86_ = FALSE;
	_data_->_tmp86_ = json_object_has_member (_data_->_tmp85_, "profile_banner_url");
	if (_data_->_tmp86_) {
		_data_->_tmp87_ = NULL;
		_data_->_tmp87_ = _data_->root;
		_data_->_tmp88_ = NULL;
		_data_->_tmp88_ = json_object_get_string_member (_data_->_tmp87_, "profile_banner_url");
		_data_->_tmp89_ = NULL;
		_data_->_tmp89_ = g_strdup (_data_->_tmp88_);
		_data_->banner_base_url = _data_->_tmp89_;
		_data_->_tmp90_ = NULL;
		_data_->_tmp90_ = _data_->banner_base_url;
		_data_->_tmp91_ = 0LL;
		_data_->_tmp91_ = _data_->user_id;
		profile_page_load_profile_banner (_data_->self, _data_->_tmp90_, _data_->_tmp91_);
		_g_free0 (_data_->banner_base_url);
	}
	_data_->_tmp92_ = NULL;
	_data_->_tmp92_ = g_strdup ("");
	_data_->display_url = _data_->_tmp92_;
	_data_->_tmp93_ = NULL;
	_data_->_tmp93_ = _data_->root;
	_data_->_tmp94_ = NULL;
	_data_->_tmp94_ = json_object_get_object_member (_data_->_tmp93_, "entities");
	_data_->_tmp95_ = NULL;
	_data_->_tmp95_ = _json_object_ref0 (_data_->_tmp94_);
	_data_->entities = _data_->_tmp95_;
	_data_->_tmp96_ = FALSE;
	_data_->_tmp96_ = _data_->has_url;
	if (_data_->_tmp96_) {
		_data_->_tmp97_ = NULL;
		_data_->_tmp97_ = _data_->entities;
		_data_->_tmp98_ = NULL;
		_data_->_tmp98_ = json_object_get_object_member (_data_->_tmp97_, "url");
		_data_->_tmp99_ = NULL;
		_data_->_tmp99_ = json_object_get_array_member (_data_->_tmp98_, "urls");
		_data_->_tmp100_ = NULL;
		_data_->_tmp100_ = json_array_get_element (_data_->_tmp99_, (guint) 0);
		_data_->_tmp101_ = NULL;
		_data_->_tmp101_ = json_node_get_object (_data_->_tmp100_);
		_data_->_tmp102_ = NULL;
		_data_->_tmp102_ = _json_object_ref0 (_data_->_tmp101_);
		_data_->urls_object = _data_->_tmp102_;
		_data_->_tmp103_ = NULL;
		_data_->_tmp103_ = _data_->urls_object;
		_data_->_tmp104_ = NULL;
		_data_->_tmp104_ = json_object_get_string_member (_data_->_tmp103_, "expanded_url");
		_data_->_tmp105_ = NULL;
		_data_->_tmp105_ = g_strdup (_data_->_tmp104_);
		_data_->url = _data_->_tmp105_;
		_data_->_tmp106_ = NULL;
		_data_->_tmp106_ = _data_->urls_object;
		_data_->_tmp107_ = FALSE;
		_data_->_tmp107_ = json_object_has_member (_data_->_tmp106_, "display_url");
		if (_data_->_tmp107_) {
			_data_->_tmp108_ = NULL;
			_data_->_tmp108_ = _data_->urls_object;
			_data_->_tmp109_ = NULL;
			_data_->_tmp109_ = json_object_get_string_member (_data_->_tmp108_, "expanded_url");
			_data_->_tmp110_ = NULL;
			_data_->_tmp110_ = g_strdup (_data_->_tmp109_);
			_g_free0 (_data_->display_url);
			_data_->display_url = _data_->_tmp110_;
		} else {
			_data_->_tmp111_ = NULL;
			_data_->_tmp111_ = _data_->urls_object;
			_data_->_tmp112_ = NULL;
			_data_->_tmp112_ = json_object_get_string_member (_data_->_tmp111_, "url");
			_data_->_tmp113_ = NULL;
			_data_->_tmp113_ = g_strdup (_data_->_tmp112_);
			_g_free0 (_data_->url);
			_data_->url = _data_->_tmp113_;
			_data_->_tmp114_ = NULL;
			_data_->_tmp114_ = _data_->url;
			_data_->_tmp115_ = NULL;
			_data_->_tmp115_ = g_strdup (_data_->_tmp114_);
			_g_free0 (_data_->display_url);
			_data_->display_url = _data_->_tmp115_;
		}
		_g_free0 (_data_->url);
		_json_object_unref0 (_data_->urls_object);
	}
	_data_->location = NULL;
	_data_->_tmp116_ = NULL;
	_data_->_tmp116_ = _data_->root;
	_data_->_tmp117_ = FALSE;
	_data_->_tmp117_ = json_object_has_member (_data_->_tmp116_, "location");
	if (_data_->_tmp117_) {
		_data_->_tmp118_ = NULL;
		_data_->_tmp118_ = _data_->root;
		_data_->_tmp119_ = NULL;
		_data_->_tmp119_ = json_object_get_string_member (_data_->_tmp118_, "location");
		_data_->_tmp120_ = NULL;
		_data_->_tmp120_ = g_strdup (_data_->_tmp119_);
		_g_free0 (_data_->location);
		_data_->location = _data_->_tmp120_;
	}
	_data_->_data25_->text_urls = NULL;
	_data_->_tmp121_ = NULL;
	_data_->_tmp121_ = _data_->root;
	_data_->_tmp122_ = FALSE;
	_data_->_tmp122_ = json_object_has_member (_data_->_tmp121_, "description");
	if (_data_->_tmp122_) {
		_data_->_tmp123_ = NULL;
		_data_->_tmp123_ = _data_->entities;
		_data_->_tmp124_ = NULL;
		_data_->_tmp124_ = json_object_get_object_member (_data_->_tmp123_, "description");
		_data_->_tmp125_ = NULL;
		_data_->_tmp125_ = json_object_get_array_member (_data_->_tmp124_, "urls");
		_data_->_tmp126_ = NULL;
		_data_->_tmp126_ = _json_array_ref0 (_data_->_tmp125_);
		_data_->urls = _data_->_tmp126_;
		__g_slist_free__tweet_utils_sequence_free0_0 (_data_->_data25_->text_urls);
		_data_->_data25_->text_urls = NULL;
		_data_->_tmp127_ = NULL;
		_data_->_tmp127_ = _data_->urls;
		json_array_foreach_element (_data_->_tmp127_, ____lambda197__json_array_foreach, _data_->_data25_);
		_json_array_unref0 (_data_->urls);
	}
	_data_->_tmp128_ = NULL;
	_data_->_tmp128_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_IPAGE, IPage));
	_data_->_tmp129_ = NULL;
	_data_->_tmp129_ = _data_->_tmp128_;
	_data_->_tmp130_ = NULL;
	_data_->_tmp130_ = account_get_user_counter (_data_->_tmp129_);
	_data_->_tmp131_ = NULL;
	_data_->_tmp131_ = _data_->_tmp130_;
	_data_->_tmp132_ = 0LL;
	_data_->_tmp132_ = _data_->id;
	_data_->_tmp133_ = NULL;
	_data_->_tmp133_ = _data_->screen_name;
	_data_->_tmp134_ = NULL;
	_data_->_tmp134_ = _data_->name;
	user_counter_user_seen (_data_->_tmp131_, _data_->_tmp132_, _data_->_tmp133_, _data_->_tmp134_);
	_data_->_tmp135_ = NULL;
	_data_->_tmp135_ = _data_->name;
	_data_->_tmp136_ = NULL;
	_data_->_tmp136_ = _data_->screen_name;
	_data_->_tmp137_ = NULL;
	_data_->_tmp137_ = _data_->display_url;
	_data_->_tmp138_ = NULL;
	_data_->_tmp138_ = _data_->location;
	_data_->_tmp139_ = NULL;
	_data_->_tmp139_ = _data_->description;
	_data_->_tmp140_ = 0;
	_data_->_tmp140_ = _data_->tweets;
	_data_->_tmp141_ = 0;
	_data_->_tmp141_ = _data_->following;
	_data_->_tmp142_ = 0;
	_data_->_tmp142_ = _data_->followers;
	_data_->_tmp143_ = NULL;
	_data_->_tmp143_ = _data_->avatar_url;
	_data_->_tmp144_ = FALSE;
	_data_->_tmp144_ = _data_->verified;
	_data_->_tmp145_ = NULL;
	_data_->_tmp145_ = _data_->_data25_->text_urls;
	profile_page_set_data (_data_->self, _data_->_tmp135_, _data_->_tmp136_, _data_->_tmp137_, _data_->_tmp138_, _data_->_tmp139_, _data_->_tmp140_, _data_->_tmp141_, _data_->_tmp142_, _data_->_tmp143_, _data_->_tmp144_, _data_->_tmp145_);
	_data_->_tmp146_ = FALSE;
	_data_->_tmp146_ = _data_->is_following;
	profile_page_set_follow_button_state (_data_->self, _data_->_tmp146_);
	_data_->_tmp147_ = NULL;
	_data_->_tmp147_ = corebird_db;
	_data_->_tmp148_ = NULL;
	_data_->_tmp148_ = sql_database_replace (_data_->_tmp147_, "profiles");
	_data_->_tmp149_ = NULL;
	_data_->_tmp149_ = _data_->_tmp148_;
	_data_->_tmp150_ = 0LL;
	_data_->_tmp150_ = _data_->id;
	_data_->_tmp151_ = NULL;
	_data_->_tmp151_ = sql_insert_statement_vali64 (_data_->_tmp149_, "id", _data_->_tmp150_);
	_data_->_tmp152_ = NULL;
	_data_->_tmp152_ = _data_->_tmp151_;
	_data_->_tmp153_ = NULL;
	_data_->_tmp153_ = _data_->screen_name;
	_data_->_tmp154_ = NULL;
	_data_->_tmp154_ = sql_insert_statement_val (_data_->_tmp152_, "screen_name", _data_->_tmp153_);
	_data_->_tmp155_ = NULL;
	_data_->_tmp155_ = _data_->_tmp154_;
	_data_->_tmp156_ = NULL;
	_data_->_tmp156_ = _data_->name;
	_data_->_tmp157_ = NULL;
	_data_->_tmp157_ = sql_insert_statement_val (_data_->_tmp155_, "name", _data_->_tmp156_);
	_data_->_tmp158_ = NULL;
	_data_->_tmp158_ = _data_->_tmp157_;
	_data_->_tmp159_ = 0;
	_data_->_tmp159_ = _data_->followers;
	_data_->_tmp160_ = NULL;
	_data_->_tmp160_ = sql_insert_statement_vali (_data_->_tmp158_, "followers", _data_->_tmp159_);
	_data_->_tmp161_ = NULL;
	_data_->_tmp161_ = _data_->_tmp160_;
	_data_->_tmp162_ = 0;
	_data_->_tmp162_ = _data_->following;
	_data_->_tmp163_ = NULL;
	_data_->_tmp163_ = sql_insert_statement_vali (_data_->_tmp161_, "following", _data_->_tmp162_);
	_data_->_tmp164_ = NULL;
	_data_->_tmp164_ = _data_->_tmp163_;
	_data_->_tmp165_ = 0;
	_data_->_tmp165_ = _data_->tweets;
	_data_->_tmp166_ = NULL;
	_data_->_tmp166_ = sql_insert_statement_vali (_data_->_tmp164_, "tweets", _data_->_tmp165_);
	_data_->_tmp167_ = NULL;
	_data_->_tmp167_ = _data_->_tmp166_;
	_data_->_tmp168_ = NULL;
	_data_->_tmp168_ = _data_->description;
	_data_->_tmp169_ = NULL;
	_data_->_tmp169_ = _data_->_data25_->text_urls;
	_data_->_tmp170_ = NULL;
	_data_->_tmp170_ = tweet_utils_get_formatted_text (_data_->_tmp168_, _data_->_tmp169_);
	_data_->_tmp171_ = NULL;
	_data_->_tmp171_ = _data_->_tmp170_;
	_data_->_tmp172_ = NULL;
	_data_->_tmp172_ = sql_insert_statement_val (_data_->_tmp167_, "description", _data_->_tmp171_);
	_data_->_tmp173_ = NULL;
	_data_->_tmp173_ = _data_->_tmp172_;
	_data_->_tmp174_ = NULL;
	_data_->_tmp174_ = _data_->avatar_name;
	_data_->_tmp175_ = NULL;
	_data_->_tmp175_ = sql_insert_statement_val (_data_->_tmp173_, "avatar_name", _data_->_tmp174_);
	_data_->_tmp176_ = NULL;
	_data_->_tmp176_ = _data_->_tmp175_;
	_data_->_tmp177_ = NULL;
	_data_->_tmp177_ = _data_->display_url;
	_data_->_tmp178_ = NULL;
	_data_->_tmp178_ = sql_insert_statement_val (_data_->_tmp176_, "url", _data_->_tmp177_);
	_data_->_tmp179_ = NULL;
	_data_->_tmp179_ = _data_->_tmp178_;
	_data_->_tmp180_ = NULL;
	_data_->_tmp180_ = _data_->location;
	_data_->_tmp181_ = NULL;
	_data_->_tmp181_ = sql_insert_statement_val (_data_->_tmp179_, "location", _data_->_tmp180_);
	_data_->_tmp182_ = NULL;
	_data_->_tmp182_ = _data_->_tmp181_;
	_data_->_tmp183_ = FALSE;
	_data_->_tmp183_ = _data_->is_following;
	_data_->_tmp184_ = NULL;
	_data_->_tmp184_ = sql_insert_statement_valb (_data_->_tmp182_, "is_following", _data_->_tmp183_);
	_data_->_tmp185_ = NULL;
	_data_->_tmp185_ = _data_->_tmp184_;
	_data_->_tmp186_ = NULL;
	_data_->_tmp186_ = _data_->banner_name;
	_data_->_tmp187_ = NULL;
	_data_->_tmp187_ = sql_insert_statement_val (_data_->_tmp185_, "banner_name", _data_->_tmp186_);
	_data_->_tmp188_ = NULL;
	_data_->_tmp188_ = _data_->_tmp187_;
	sql_insert_statement_run (_data_->_tmp188_);
	_sql_insert_statement_unref0 (_data_->_tmp188_);
	_sql_insert_statement_unref0 (_data_->_tmp185_);
	_sql_insert_statement_unref0 (_data_->_tmp182_);
	_sql_insert_statement_unref0 (_data_->_tmp179_);
	_sql_insert_statement_unref0 (_data_->_tmp176_);
	_sql_insert_statement_unref0 (_data_->_tmp173_);
	_g_free0 (_data_->_tmp171_);
	_sql_insert_statement_unref0 (_data_->_tmp167_);
	_sql_insert_statement_unref0 (_data_->_tmp164_);
	_sql_insert_statement_unref0 (_data_->_tmp161_);
	_sql_insert_statement_unref0 (_data_->_tmp158_);
	_sql_insert_statement_unref0 (_data_->_tmp155_);
	_sql_insert_statement_unref0 (_data_->_tmp152_);
	_sql_insert_statement_unref0 (_data_->_tmp149_);
	_g_free0 (_data_->location);
	_json_object_unref0 (_data_->entities);
	_g_free0 (_data_->display_url);
	_g_free0 (_data_->banner_name);
	_g_free0 (_data_->description);
	_g_free0 (_data_->screen_name);
	_g_free0 (_data_->name);
	_g_free0 (_data_->avatar_name);
	_g_free0 (_data_->avatar_url);
	_json_object_unref0 (_data_->root);
	__vala_JsonNode_free0 (_data_->root_node);
	_g_object_unref0 (_data_->call);
	block25_data_unref (_data_->_data25_);
	_data_->_data25_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void profile_page_load_tweets_data_free (gpointer _data) {
	ProfilePageLoadTweetsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ProfilePageLoadTweetsData, _data_);
}


static void profile_page_load_tweets (ProfilePage* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ProfilePageLoadTweetsData* _data_;
	ProfilePage* _tmp0_ = NULL;
	_data_ = g_slice_new0 (ProfilePageLoadTweetsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, profile_page_load_tweets);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, profile_page_load_tweets_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	profile_page_load_tweets_co (_data_);
}


static void profile_page_load_tweets_finish (ProfilePage* self, GAsyncResult* _res_) {
	ProfilePageLoadTweetsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void profile_page_load_tweets_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ProfilePageLoadTweetsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	profile_page_load_tweets_co (_data_);
}


static gboolean profile_page_load_tweets_co (ProfilePageLoadTweetsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->tweet_list;
	tweet_list_box_set_unempty (_data_->_tmp0_);
	_data_->self->priv->tweets_loading = TRUE;
	_data_->requested_tweet_count = 10;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_IPAGE, IPage));
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = account_get_proxy (_data_->_tmp2_);
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp5_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->call;
	rest_proxy_call_set_function (_data_->_tmp6_, "1.1/statuses/user_timeline.json");
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp7_, "GET");
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->call;
	_data_->_tmp9_ = 0LL;
	_data_->_tmp9_ = _data_->self->priv->user_id;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp9_);
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->_tmp10_;
	rest_proxy_call_add_param (_data_->_tmp8_, "user_id", _data_->_tmp11_);
	_g_free0 (_data_->_tmp11_);
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->call;
	_data_->_tmp13_ = 0;
	_data_->_tmp13_ = _data_->requested_tweet_count;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = g_strdup_printf ("%i", _data_->_tmp13_);
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _data_->_tmp14_;
	rest_proxy_call_add_param (_data_->_tmp12_, "count", _data_->_tmp15_);
	_g_free0 (_data_->_tmp15_);
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp16_, "contributor_details", "true");
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp17_, "include_my_retweet", "true");
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = _data_->call;
	_data_->_state_ = 1;
	tweet_utils_load_threaded (_data_->_tmp18_, profile_page_load_tweets_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = tweet_utils_load_threaded_finish (_data_->_res_);
	_data_->root = _data_->_tmp19_;
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = _data_->root;
	if (_data_->_tmp20_ == NULL) {
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = _data_->self->priv->tweet_list;
		tweet_list_box_set_empty (_data_->_tmp21_);
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = _data_->root;
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = json_node_get_array (_data_->_tmp22_);
	_data_->_tmp24_ = NULL;
	_data_->_tmp24_ = _json_array_ref0 (_data_->_tmp23_);
	_data_->root_array = _data_->_tmp24_;
	_data_->_tmp25_ = NULL;
	_data_->_tmp25_ = _data_->root_array;
	_data_->_tmp26_ = 0U;
	_data_->_tmp26_ = json_array_get_length (_data_->_tmp25_);
	if (_data_->_tmp26_ == ((guint) 0)) {
		_data_->_tmp27_ = NULL;
		_data_->_tmp27_ = _data_->self->priv->tweet_list;
		tweet_list_box_set_empty (_data_->_tmp27_);
		_json_array_unref0 (_data_->root_array);
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = _data_->root_array;
	_data_->_tmp29_ = 0;
	_data_->_tmp29_ = _data_->requested_tweet_count;
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = _data_->self->priv->_delta_updater;
	_data_->_tmp31_ = NULL;
	_data_->_tmp31_ = _data_->self->priv->tweet_list;
	_data_->_tmp32_ = NULL;
	_data_->_tmp32_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_IPAGE, IPage));
	_data_->_tmp33_ = NULL;
	_data_->_tmp33_ = _data_->_tmp32_;
	_data_->_tmp34_ = NULL;
	_data_->_tmp34_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_IPAGE, IPage));
	_data_->_tmp35_ = NULL;
	_data_->_tmp35_ = _data_->_tmp34_;
	memset (&_data_->_tmp36_, 0, sizeof (TweetUtilsWorkerResult));
	_data_->_state_ = 2;
	tweet_utils_work_array (_data_->_tmp28_, (guint) _data_->_tmp29_, _data_->_tmp30_, _data_->_tmp31_, _data_->_tmp33_, _data_->_tmp35_, profile_page_load_tweets_ready, _data_);
	return FALSE;
	_state_2:
	tweet_utils_work_array_finish (_data_->_res_, &_data_->_tmp36_);
	_data_->_result_ = _data_->_tmp36_;
	memset (&_data_->_tmp37_, 0, sizeof (TweetUtilsWorkerResult));
	_data_->_tmp37_ = _data_->_result_;
	_data_->_tmp38_ = 0LL;
	_data_->_tmp38_ = _data_->_tmp37_.min_id;
	_data_->self->priv->lowest_tweet_id = _data_->_tmp38_;
	_data_->self->priv->tweets_loading = FALSE;
	_json_array_unref0 (_data_->root_array);
	__vala_JsonNode_free0 (_data_->root);
	_g_object_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void profile_page_load_older_tweets_data_free (gpointer _data) {
	ProfilePageLoadOlderTweetsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ProfilePageLoadOlderTweetsData, _data_);
}


static void profile_page_load_older_tweets (ProfilePage* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ProfilePageLoadOlderTweetsData* _data_;
	ProfilePage* _tmp0_ = NULL;
	_data_ = g_slice_new0 (ProfilePageLoadOlderTweetsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, profile_page_load_older_tweets);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, profile_page_load_older_tweets_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	profile_page_load_older_tweets_co (_data_);
}


static void profile_page_load_older_tweets_finish (ProfilePage* self, GAsyncResult* _res_) {
	ProfilePageLoadOlderTweetsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void profile_page_load_older_tweets_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ProfilePageLoadOlderTweetsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	profile_page_load_older_tweets_co (_data_);
}


static gboolean profile_page_load_older_tweets_co (ProfilePageLoadOlderTweetsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = FALSE;
	_data_->_tmp0_ = _data_->self->priv->tweets_loading;
	if (_data_->_tmp0_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->self->priv->user_stack;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = gtk_stack_get_visible_child (_data_->_tmp1_);
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->self->priv->tweet_list;
	if (_data_->_tmp3_ != G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, gtk_widget_get_type (), GtkWidget)) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->self->priv->tweets_loading = TRUE;
	_data_->requested_tweet_count = 15;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_IPAGE, IPage));
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = account_get_proxy (_data_->_tmp6_);
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp8_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp9_;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->call;
	rest_proxy_call_set_function (_data_->_tmp10_, "1.1/statuses/user_timeline.json");
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp11_, "GET");
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->call;
	_data_->_tmp13_ = 0LL;
	_data_->_tmp13_ = _data_->self->priv->user_id;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp13_);
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _data_->_tmp14_;
	rest_proxy_call_add_param (_data_->_tmp12_, "user_id", _data_->_tmp15_);
	_g_free0 (_data_->_tmp15_);
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = _data_->call;
	_data_->_tmp17_ = 0;
	_data_->_tmp17_ = _data_->requested_tweet_count;
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = g_strdup_printf ("%i", _data_->_tmp17_);
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = _data_->_tmp18_;
	rest_proxy_call_add_param (_data_->_tmp16_, "count", _data_->_tmp19_);
	_g_free0 (_data_->_tmp19_);
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp20_, "contributor_details", "true");
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp21_, "include_my_retweet", "true");
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = _data_->call;
	_data_->_tmp23_ = 0LL;
	_data_->_tmp23_ = _data_->self->priv->lowest_tweet_id;
	_data_->_tmp24_ = NULL;
	_data_->_tmp24_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp23_ - 1);
	_data_->_tmp25_ = NULL;
	_data_->_tmp25_ = _data_->_tmp24_;
	rest_proxy_call_add_param (_data_->_tmp22_, "max_id", _data_->_tmp25_);
	_g_free0 (_data_->_tmp25_);
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = _data_->call;
	_data_->_state_ = 1;
	tweet_utils_load_threaded (_data_->_tmp26_, profile_page_load_older_tweets_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp27_ = NULL;
	_data_->_tmp27_ = tweet_utils_load_threaded_finish (_data_->_res_);
	_data_->root = _data_->_tmp27_;
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = _data_->root;
	if (_data_->_tmp28_ == NULL) {
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp29_ = NULL;
	_data_->_tmp29_ = _data_->root;
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = json_node_get_array (_data_->_tmp29_);
	_data_->_tmp31_ = NULL;
	_data_->_tmp31_ = _json_array_ref0 (_data_->_tmp30_);
	_data_->root_arr = _data_->_tmp31_;
	_data_->_tmp32_ = NULL;
	_data_->_tmp32_ = _data_->root_arr;
	_data_->_tmp33_ = 0;
	_data_->_tmp33_ = _data_->requested_tweet_count;
	_data_->_tmp34_ = NULL;
	_data_->_tmp34_ = _data_->self->priv->_delta_updater;
	_data_->_tmp35_ = NULL;
	_data_->_tmp35_ = _data_->self->priv->tweet_list;
	_data_->_tmp36_ = NULL;
	_data_->_tmp36_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_IPAGE, IPage));
	_data_->_tmp37_ = NULL;
	_data_->_tmp37_ = _data_->_tmp36_;
	_data_->_tmp38_ = NULL;
	_data_->_tmp38_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_IPAGE, IPage));
	_data_->_tmp39_ = NULL;
	_data_->_tmp39_ = _data_->_tmp38_;
	memset (&_data_->_tmp40_, 0, sizeof (TweetUtilsWorkerResult));
	_data_->_state_ = 2;
	tweet_utils_work_array (_data_->_tmp32_, (guint) _data_->_tmp33_, _data_->_tmp34_, _data_->_tmp35_, _data_->_tmp37_, _data_->_tmp39_, profile_page_load_older_tweets_ready, _data_);
	return FALSE;
	_state_2:
	tweet_utils_work_array_finish (_data_->_res_, &_data_->_tmp40_);
	_data_->_result_ = _data_->_tmp40_;
	memset (&_data_->_tmp41_, 0, sizeof (TweetUtilsWorkerResult));
	_data_->_tmp41_ = _data_->_result_;
	_data_->_tmp42_ = 0LL;
	_data_->_tmp42_ = _data_->_tmp41_.min_id;
	_data_->_tmp43_ = 0LL;
	_data_->_tmp43_ = _data_->self->priv->lowest_tweet_id;
	if (_data_->_tmp42_ < _data_->_tmp43_) {
		memset (&_data_->_tmp44_, 0, sizeof (TweetUtilsWorkerResult));
		_data_->_tmp44_ = _data_->_result_;
		_data_->_tmp45_ = 0LL;
		_data_->_tmp45_ = _data_->_tmp44_.min_id;
		_data_->self->priv->lowest_tweet_id = _data_->_tmp45_;
	}
	_data_->self->priv->tweets_loading = FALSE;
	_json_array_unref0 (_data_->root_arr);
	__vala_JsonNode_free0 (_data_->root);
	_g_object_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Loads the user's banner image.
   *
   * @param base_url The "base url" of the banner, obtained from the users/show call from Twitter.
   * @param user_id Foo
   * @param screen_name Bar
   */
static Block26Data* block26_data_ref (Block26Data* _data26_) {
	g_atomic_int_inc (&_data26_->_ref_count_);
	return _data26_;
}


static void block26_data_unref (void * _userdata_) {
	Block26Data* _data26_;
	_data26_ = (Block26Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data26_->_ref_count_)) {
		ProfilePage* self;
		self = _data26_->self;
		_g_free0 (_data26_->banner_on_disk);
		_g_object_unref0 (self);
		g_slice_free (Block26Data, _data26_);
	}
}


static void ___lambda196_ (Block26Data* _data26_) {
	ProfilePage* self;
	const gchar* _tmp0_ = NULL;
	self = _data26_->self;
	_tmp0_ = _data26_->banner_on_disk;
	profile_page_load_banner (self, _tmp0_);
}


static void ____lambda196__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda196_ (self);
	block26_data_unref (self);
}


static void profile_page_load_profile_banner (ProfilePage* self, const gchar* base_url, gint64 user_id) {
	Block26Data* _data26_;
	gchar* saved_banner_url = NULL;
	gint64 _tmp0_ = 0LL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* banner_url = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* banner_name = NULL;
	gint64 _tmp9_ = 0LL;
	gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	const gchar* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	g_return_if_fail (base_url != NULL);
	_data26_ = g_slice_new0 (Block26Data);
	_data26_->_ref_count_ = 1;
	_data26_->self = g_object_ref (self);
	_tmp0_ = user_id;
	_tmp1_ = utils_get_banner_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("assets/banners/", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = dirs_cache (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	saved_banner_url = _tmp6_;
	_tmp7_ = base_url;
	_tmp8_ = g_strconcat (_tmp7_, "/mobile_retina", NULL);
	banner_url = _tmp8_;
	_tmp9_ = user_id;
	_tmp10_ = utils_get_banner_name (_tmp9_);
	banner_name = _tmp10_;
	_tmp11_ = banner_name;
	_tmp12_ = g_strconcat ("assets/banners/", _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = dirs_cache (_tmp13_);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	_data26_->banner_on_disk = _tmp15_;
	_tmp17_ = _data26_->banner_on_disk;
	_tmp18_ = g_file_test (_tmp17_, G_FILE_TEST_EXISTS);
	if (!_tmp18_) {
		_tmp16_ = TRUE;
	} else {
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		_tmp19_ = banner_url;
		_tmp20_ = saved_banner_url;
		_tmp16_ = g_strcmp0 (_tmp19_, _tmp20_) != 0;
	}
	if (_tmp16_) {
		const gchar* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		GCancellable* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		SqlDatabase* _tmp25_ = NULL;
		SqlUpdateStatement* _tmp26_ = NULL;
		SqlUpdateStatement* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		SqlUpdateStatement* _tmp29_ = NULL;
		SqlUpdateStatement* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		SqlUpdateStatement* _tmp32_ = NULL;
		SqlUpdateStatement* _tmp33_ = NULL;
		gint64 _tmp34_ = 0LL;
		SqlUpdateStatement* _tmp35_ = NULL;
		SqlUpdateStatement* _tmp36_ = NULL;
		_tmp21_ = banner_url;
		_tmp22_ = _data26_->banner_on_disk;
		_tmp23_ = self->priv->data_cancellable;
		utils_download_file_async (_tmp21_, _tmp22_, _tmp23_, ____lambda196__gasync_ready_callback, block26_data_ref (_data26_));
		_tmp24_ = banner_name;
		g_debug ("ProfilePage.vala:454: Setting the banner name to %s", _tmp24_);
		_tmp25_ = corebird_db;
		_tmp26_ = sql_database_update (_tmp25_, "profiles");
		_tmp27_ = _tmp26_;
		_tmp28_ = banner_url;
		_tmp29_ = sql_update_statement_val (_tmp27_, "banner_url", _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = banner_name;
		_tmp32_ = sql_update_statement_val (_tmp30_, "banner_name", _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = user_id;
		_tmp35_ = sql_update_statement_where_eqi (_tmp33_, "id", _tmp34_);
		_tmp36_ = _tmp35_;
		sql_update_statement_run (_tmp36_);
		_sql_update_statement_unref0 (_tmp36_);
		_sql_update_statement_unref0 (_tmp33_);
		_sql_update_statement_unref0 (_tmp30_);
		_sql_update_statement_unref0 (_tmp27_);
	} else {
		const gchar* _tmp37_ = NULL;
		_tmp37_ = _data26_->banner_on_disk;
		profile_page_load_banner (self, _tmp37_);
	}
	_g_free0 (banner_name);
	_g_free0 (banner_url);
	_g_free0 (saved_banner_url);
	block26_data_unref (_data26_);
	_data26_ = NULL;
}


static gint ___lambda194_ (TweetUtilsSequence* a, TweetUtilsSequence* b) {
	gint result = 0;
	TweetUtilsSequence* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	TweetUtilsSequence* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	_tmp0_ = a;
	_tmp1_ = (*_tmp0_).start;
	_tmp2_ = b;
	_tmp3_ = (*_tmp2_).start;
	if (_tmp1_ < _tmp3_) {
		result = -1;
		return result;
	}
	result = 1;
	return result;
}


static gint ____lambda194__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = ___lambda194_ ((TweetUtilsSequence*) a, (TweetUtilsSequence*) b);
	return result;
}


static void profile_page_set_data (ProfilePage* self, const gchar* name, const gchar* screen_name, const gchar* url, const gchar* location, const gchar* description, gint tweets, gint following, gint followers, const gchar* avatar_url, gboolean verified, GSList* text_urls) {
	GMenu* section = NULL;
	GMenuModel* _tmp0_ = NULL;
	GMenuModel* _tmp1_ = NULL;
	GMenuItem* user_item = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GMenuItem* _tmp6_ = NULL;
	GMenuItem* _tmp7_ = NULL;
	GMenu* _tmp8_ = NULL;
	GMenu* _tmp9_ = NULL;
	GMenuItem* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	GtkLabel* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* desc = NULL;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	GSList* _tmp23_ = NULL;
	gint _tmp27_ = 0;
	GtkLabel* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	GtkLabel* _tmp34_ = NULL;
	gint _tmp35_ = 0;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	GtkLabel* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	gboolean _tmp42_ = FALSE;
	const gchar* _tmp43_ = NULL;
	AvatarWidget* _tmp49_ = NULL;
	gboolean _tmp50_ = FALSE;
	gboolean _tmp51_ = FALSE;
	const gchar* _tmp52_ = NULL;
	const gchar* _tmp63_ = NULL;
	gchar* _tmp64_ = NULL;
	const gchar* _tmp65_ = NULL;
	gchar* _tmp66_ = NULL;
	const gchar* _tmp67_ = NULL;
	gchar* _tmp68_ = NULL;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	g_return_if_fail (name != NULL);
	g_return_if_fail (screen_name != NULL);
	g_return_if_fail (description != NULL);
	g_return_if_fail (avatar_url != NULL);
	_tmp0_ = self->priv->more_menu;
	_tmp1_ = g_menu_model_get_item_link (_tmp0_, 0, G_MENU_LINK_SECTION);
	section = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_menu_get_type (), GMenu);
	_tmp2_ = _ ("Tweet to @%s");
	_tmp3_ = screen_name;
	_tmp4_ = g_strdup_printf (_tmp2_, _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_menu_item_new (_tmp5_, "user.tweet-to");
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	user_item = _tmp7_;
	_tmp8_ = section;
	g_menu_remove (_tmp8_, 1);
	_tmp9_ = section;
	_tmp10_ = user_item;
	g_menu_insert_item (_tmp9_, 1, _tmp10_);
	_tmp11_ = self->priv->name_label;
	_tmp12_ = name;
	_tmp13_ = string_strip (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strdup_printf ("<b>%s</b>", _tmp14_);
	_tmp16_ = _tmp15_;
	gtk_label_set_markup (_tmp11_, _tmp16_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp14_);
	_tmp17_ = self->priv->screen_name_label;
	_tmp18_ = screen_name;
	_tmp19_ = g_strconcat ("@", _tmp18_, NULL);
	_tmp20_ = _tmp19_;
	gtk_label_set_label (_tmp17_, _tmp20_);
	_g_free0 (_tmp20_);
	_tmp21_ = description;
	_tmp22_ = g_strdup (_tmp21_);
	desc = _tmp22_;
	_tmp23_ = text_urls;
	if (_tmp23_ != NULL) {
		const gchar* _tmp24_ = NULL;
		GSList* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		text_urls = g_slist_sort (text_urls, ____lambda194__gcompare_func);
		_tmp24_ = description;
		_tmp25_ = text_urls;
		_tmp26_ = tweet_utils_get_formatted_text (_tmp24_, _tmp25_);
		_g_free0 (desc);
		desc = _tmp26_;
	}
	_tmp27_ = followers;
	self->priv->follower_count = _tmp27_;
	_tmp28_ = self->priv->description_label;
	_tmp29_ = desc;
	_tmp30_ = g_strconcat ("<big>", _tmp29_, NULL);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_strconcat (_tmp31_, "</big>", NULL);
	_tmp33_ = _tmp32_;
	gtk_label_set_label (_tmp28_, _tmp33_);
	_g_free0 (_tmp33_);
	_g_free0 (_tmp31_);
	_tmp34_ = self->priv->tweets_label;
	_tmp35_ = tweets;
	_tmp36_ = g_strdup_printf ("%'d", _tmp35_);
	_tmp37_ = _tmp36_;
	gtk_label_set_label (_tmp34_, _tmp37_);
	_g_free0 (_tmp37_);
	_tmp38_ = self->priv->following_label;
	_tmp39_ = following;
	_tmp40_ = g_strdup_printf ("%'d", _tmp39_);
	_tmp41_ = _tmp40_;
	gtk_label_set_label (_tmp38_, _tmp41_);
	_g_free0 (_tmp41_);
	profile_page_update_follower_label (self);
	_tmp43_ = location;
	if (_tmp43_ != NULL) {
		const gchar* _tmp44_ = NULL;
		_tmp44_ = location;
		_tmp42_ = g_strcmp0 (_tmp44_, "") != 0;
	} else {
		_tmp42_ = FALSE;
	}
	if (_tmp42_) {
		GtkLabel* _tmp45_ = NULL;
		GtkLabel* _tmp46_ = NULL;
		const gchar* _tmp47_ = NULL;
		_tmp45_ = self->priv->location_label;
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, gtk_widget_get_type (), GtkWidget), TRUE);
		_tmp46_ = self->priv->location_label;
		_tmp47_ = location;
		gtk_label_set_label (_tmp46_, _tmp47_);
	} else {
		GtkLabel* _tmp48_ = NULL;
		_tmp48_ = self->priv->location_label;
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, gtk_widget_get_type (), GtkWidget), FALSE);
	}
	_tmp49_ = self->priv->avatar_image;
	_tmp50_ = verified;
	avatar_widget_set_verified (_tmp49_, _tmp50_);
	_tmp52_ = url;
	if (_tmp52_ != NULL) {
		const gchar* _tmp53_ = NULL;
		_tmp53_ = url;
		_tmp51_ = g_strcmp0 (_tmp53_, "") != 0;
	} else {
		_tmp51_ = FALSE;
	}
	if (_tmp51_) {
		GtkLabel* _tmp54_ = NULL;
		GtkLabel* _tmp55_ = NULL;
		const gchar* _tmp56_ = NULL;
		const gchar* _tmp57_ = NULL;
		gchar* _tmp58_ = NULL;
		gchar* _tmp59_ = NULL;
		GtkLabel* _tmp60_ = NULL;
		_tmp54_ = self->priv->url_label;
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, gtk_widget_get_type (), GtkWidget), TRUE);
		_tmp55_ = self->priv->url_label;
		_tmp56_ = url;
		_tmp57_ = url;
		_tmp58_ = g_strdup_printf ("<span underline='none'><a href='%s'>%s</a></span>", _tmp56_, _tmp57_);
		_tmp59_ = _tmp58_;
		gtk_label_set_markup (_tmp55_, _tmp59_);
		_g_free0 (_tmp59_);
		_tmp60_ = self->priv->description_label;
		gtk_widget_set_margin_bottom (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, gtk_widget_get_type (), GtkWidget), 6);
	} else {
		GtkLabel* _tmp61_ = NULL;
		GtkLabel* _tmp62_ = NULL;
		_tmp61_ = self->priv->url_label;
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, gtk_widget_get_type (), GtkWidget), FALSE);
		_tmp62_ = self->priv->description_label;
		gtk_widget_set_margin_bottom (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, gtk_widget_get_type (), GtkWidget), 12);
	}
	_tmp63_ = name;
	_tmp64_ = g_strdup (_tmp63_);
	_g_free0 (self->priv->name);
	self->priv->name = _tmp64_;
	_tmp65_ = screen_name;
	_tmp66_ = g_strdup (_tmp65_);
	_g_free0 (self->priv->screen_name);
	self->priv->screen_name = _tmp66_;
	_tmp67_ = avatar_url;
	_tmp68_ = g_strdup (_tmp67_);
	_g_free0 (self->priv->avatar_url);
	self->priv->avatar_url = _tmp68_;
	_g_free0 (desc);
	_g_object_unref0 (user_item);
	_g_object_unref0 (section);
}


static Block27Data* block27_data_ref (Block27Data* _data27_) {
	g_atomic_int_inc (&_data27_->_ref_count_);
	return _data27_;
}


static void block27_data_unref (void * _userdata_) {
	Block27Data* _data27_;
	_data27_ = (Block27Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data27_->_ref_count_)) {
		ProfilePage* self;
		self = _data27_->self;
		_g_object_unref0 (_data27_->call);
		_g_object_unref0 (self);
		g_slice_free (Block27Data, _data27_);
	}
}


static void __lambda198_ (Block27Data* _data27_, GObject* obj, GAsyncResult* res) {
	ProfilePage* self;
	GtkButton* _tmp5_ = NULL;
	GtkStack* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	self = _data27_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		gboolean _tmp0_ = FALSE;
		RestProxyCall* _tmp1_ = NULL;
		GAsyncResult* _tmp2_ = NULL;
		_tmp0_ = self->priv->following;
		profile_page_set_follow_button_state (self, !_tmp0_);
		_tmp1_ = _data27_->call;
		_tmp2_ = res;
		rest_proxy_call_invoke_finish (_tmp1_, _tmp2_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch32_g_error;
		}
	}
	goto __finally32;
	__catch32_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_critical ("ProfilePage.vala:554: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally32:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp5_ = self->priv->follow_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp6_ = self->priv->loading_stack;
	gtk_stack_set_visible_child_name (_tmp6_, "data");
}


static void ___lambda198__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda198_ (self, source_object, res);
	block27_data_unref (self);
}


static void profile_page_follow_button_clicked_cb (ProfilePage* self) {
	Block27Data* _data27_;
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	OAuthProxy* _tmp2_ = NULL;
	OAuthProxy* _tmp3_ = NULL;
	RestProxyCall* _tmp4_ = NULL;
	HomeTimeline* ht = NULL;
	MainWindow* _tmp5_ = NULL;
	MainWindow* _tmp6_ = NULL;
	IPage* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	GtkSpinner* _tmp34_ = NULL;
	GtkStack* _tmp35_ = NULL;
	GtkButton* _tmp36_ = NULL;
	RestProxyCall* _tmp37_ = NULL;
	RestProxyCall* _tmp38_ = NULL;
	gint64 _tmp39_ = 0LL;
	gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	RestProxyCall* _tmp42_ = NULL;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	_data27_ = g_slice_new0 (Block27Data);
	_data27_->_ref_count_ = 1;
	_data27_->self = g_object_ref (self);
	_tmp0_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp1_ = _tmp0_;
	_tmp2_ = account_get_proxy (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, rest_proxy_get_type (), RestProxy));
	_data27_->call = _tmp4_;
	_tmp5_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp6_ = _tmp5_;
	_tmp7_ = main_window_get_page (_tmp6_, (gint) PAGE_STREAM);
	ht = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_HOME_TIMELINE, HomeTimeline);
	_tmp8_ = self->priv->following;
	if (_tmp8_) {
		RestProxyCall* _tmp9_ = NULL;
		HomeTimeline* _tmp10_ = NULL;
		gint64 _tmp11_ = 0LL;
		HomeTimeline* _tmp12_ = NULL;
		gint64 _tmp13_ = 0LL;
		gint _tmp14_ = 0;
		Account* _tmp15_ = NULL;
		Account* _tmp16_ = NULL;
		gint64 _tmp17_ = 0LL;
		_tmp9_ = _data27_->call;
		rest_proxy_call_set_function (_tmp9_, "1.1/friendships/destroy.json");
		_tmp10_ = ht;
		_tmp11_ = self->priv->user_id;
		home_timeline_hide_tweets_from (_tmp10_, _tmp11_);
		_tmp12_ = ht;
		_tmp13_ = self->priv->user_id;
		home_timeline_hide_retweets_from (_tmp12_, _tmp13_);
		_tmp14_ = self->priv->follower_count;
		self->priv->follower_count = _tmp14_ - 1;
		_tmp15_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp16_ = _tmp15_;
		_tmp17_ = self->priv->user_id;
		account_unfollow_id (_tmp16_, _tmp17_);
	} else {
		RestProxyCall* _tmp18_ = NULL;
		RestProxyCall* _tmp19_ = NULL;
		HomeTimeline* _tmp20_ = NULL;
		gint64 _tmp21_ = 0LL;
		GSimpleActionGroup* _tmp22_ = NULL;
		GAction* _tmp23_ = NULL;
		GVariant* _tmp24_ = NULL;
		GVariant* _tmp25_ = NULL;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		gint _tmp30_ = 0;
		Account* _tmp31_ = NULL;
		Account* _tmp32_ = NULL;
		gint64 _tmp33_ = 0LL;
		_tmp18_ = _data27_->call;
		rest_proxy_call_set_function (_tmp18_, "1.1/friendships/create.json");
		_tmp19_ = _data27_->call;
		rest_proxy_call_add_param (_tmp19_, "follow", "false");
		_tmp20_ = ht;
		_tmp21_ = self->priv->user_id;
		home_timeline_show_tweets_from (_tmp20_, _tmp21_);
		_tmp22_ = self->priv->actions;
		_tmp23_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, g_action_map_get_type (), GActionMap), "toggle-retweets");
		_tmp24_ = g_action_get_state (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, g_simple_action_get_type (), GSimpleAction), g_action_get_type (), GAction));
		_tmp25_ = _tmp24_;
		_tmp26_ = g_variant_get_boolean (_tmp25_);
		_tmp27_ = !_tmp26_;
		_g_variant_unref0 (_tmp25_);
		if (_tmp27_) {
			HomeTimeline* _tmp28_ = NULL;
			gint64 _tmp29_ = 0LL;
			_tmp28_ = ht;
			_tmp29_ = self->priv->user_id;
			home_timeline_show_retweets_from (_tmp28_, _tmp29_);
		}
		profile_page_set_user_blocked (self, FALSE);
		_tmp30_ = self->priv->follower_count;
		self->priv->follower_count = _tmp30_ + 1;
		_tmp31_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp32_ = _tmp31_;
		_tmp33_ = self->priv->user_id;
		account_follow_id (_tmp32_, _tmp33_);
	}
	profile_page_update_follower_label (self);
	_tmp34_ = self->priv->progress_spinner;
	gtk_spinner_start (_tmp34_);
	_tmp35_ = self->priv->loading_stack;
	gtk_stack_set_visible_child_name (_tmp35_, "progress");
	_tmp36_ = self->priv->follow_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp37_ = _data27_->call;
	rest_proxy_call_set_method (_tmp37_, "POST");
	_tmp38_ = _data27_->call;
	_tmp39_ = self->priv->user_id;
	_tmp40_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp39_);
	_tmp41_ = _tmp40_;
	rest_proxy_call_add_param (_tmp38_, "id", _tmp41_);
	_g_free0 (_tmp41_);
	_tmp42_ = _data27_->call;
	rest_proxy_call_invoke_async (_tmp42_, NULL, ___lambda198__gasync_ready_callback, block27_data_ref (_data27_));
	_g_object_unref0 (ht);
	block27_data_unref (_data27_);
	_data27_ = NULL;
}


static void _profile_page_follow_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	profile_page_follow_button_clicked_cb ((ProfilePage*) self);
}


static gboolean profile_page_activate_link (ProfilePage* self, const gchar* uri) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	MainWindow* _tmp1_ = NULL;
	MainWindow* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (IS_PROFILE_PAGE (self), FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = uri;
	_tmp1_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp2_ = _tmp1_;
	_tmp3_ = tweet_utils_activate_link (_tmp0_, _tmp2_);
	result = _tmp3_;
	return result;
}


static gboolean _profile_page_activate_link_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self) {
	gboolean result;
	result = profile_page_activate_link ((ProfilePage*) self, uri);
	return result;
}


static void profile_page_set_follow_button_state (ProfilePage* self, gboolean following) {
	GtkStyleContext* sc = NULL;
	GtkButton* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_ = NULL;
	GtkButton* _tmp3_ = NULL;
	gint64 _tmp4_ = 0LL;
	Account* _tmp5_ = NULL;
	Account* _tmp6_ = NULL;
	gint64 _tmp7_ = 0LL;
	gint64 _tmp8_ = 0LL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp18_ = FALSE;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	_tmp0_ = self->priv->follow_button;
	_tmp1_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = _g_object_ref0 (_tmp1_);
	sc = _tmp2_;
	_tmp3_ = self->priv->follow_button;
	_tmp4_ = self->priv->user_id;
	_tmp5_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp6_ = _tmp5_;
	_tmp7_ = account_get_id (_tmp6_);
	_tmp8_ = _tmp7_;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), _tmp4_ != _tmp8_);
	_tmp9_ = following;
	if (_tmp9_) {
		GtkStyleContext* _tmp10_ = NULL;
		GtkStyleContext* _tmp11_ = NULL;
		GtkButton* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		_tmp10_ = sc;
		gtk_style_context_remove_class (_tmp10_, "suggested-action");
		_tmp11_ = sc;
		gtk_style_context_add_class (_tmp11_, "destructive-action");
		_tmp12_ = self->priv->follow_button;
		_tmp13_ = _ ("Unfollow");
		gtk_button_set_label (_tmp12_, _tmp13_);
	} else {
		GtkStyleContext* _tmp14_ = NULL;
		GtkStyleContext* _tmp15_ = NULL;
		GtkButton* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		_tmp14_ = sc;
		gtk_style_context_remove_class (_tmp14_, "destructive-action");
		_tmp15_ = sc;
		gtk_style_context_add_class (_tmp15_, "suggested-action");
		_tmp16_ = self->priv->follow_button;
		_tmp17_ = _ ("Follow");
		gtk_button_set_label (_tmp16_, _tmp17_);
	}
	_tmp18_ = following;
	self->priv->following = _tmp18_;
	_g_object_unref0 (sc);
}


static void profile_page_load_banner (ProfilePage* self, const gchar* path) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	{
		const gchar* _tmp0_ = NULL;
		_tmp0_ = path;
		if (_tmp0_ != NULL) {
			GdkPixbuf* _tmp1_ = NULL;
			const gchar* _tmp2_ = NULL;
			GdkPixbuf* _tmp3_ = NULL;
			AspectImage* _tmp4_ = NULL;
			_tmp2_ = path;
			_tmp3_ = gdk_pixbuf_new_from_file (_tmp2_, &_inner_error_);
			_tmp1_ = _tmp3_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch33_g_error;
			}
			_tmp4_ = self->priv->banner_image;
			aspect_image_set_pixbuf (_tmp4_, _tmp1_);
			_g_object_unref0 (_tmp1_);
		} else {
			GdkPixbuf* _tmp5_ = NULL;
			GdkPixbuf* _tmp6_ = NULL;
			AspectImage* _tmp7_ = NULL;
			_tmp6_ = gdk_pixbuf_new_from_resource ("/org/baedert/corebird/assets/no_banner.png", &_inner_error_);
			_tmp5_ = _tmp6_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch33_g_error;
			}
			_tmp7_ = self->priv->banner_image;
			aspect_image_set_pixbuf (_tmp7_, _tmp5_);
			_g_object_unref0 (_tmp5_);
		}
	}
	goto __finally33;
	__catch33_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("ProfilePage.vala:590: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally33:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
   * see IPage#onJoin
   */
static void profile_page_real_on_join (IPage* base, gint page_id, Bundle* args) {
	ProfilePage * self;
	gint64 user_id = 0LL;
	Bundle* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	gchar* screen_name = NULL;
	Bundle* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GCancellable* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	TweetListBox* _tmp10_ = NULL;
	TweetListBox* _tmp11_ = NULL;
	GtkStack* _tmp12_ = NULL;
	TweetListBox* _tmp13_ = NULL;
	UserListsWidget* _tmp14_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PROFILE_PAGE, ProfilePage);
	g_return_if_fail ((args == NULL) || IS_BUNDLE (args));
	_tmp0_ = args;
	_tmp1_ = bundle_get_int64 (_tmp0_, "user_id");
	user_id = _tmp1_;
	_tmp2_ = user_id;
	if (_tmp2_ == ((gint64) (-1))) {
		return;
	} else {
		self->priv->lists_page_inited = FALSE;
	}
	_tmp3_ = args;
	_tmp4_ = bundle_get_string (_tmp3_, "screen_name");
	screen_name = _tmp4_;
	_tmp5_ = screen_name;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_tmp6_ = screen_name;
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (self->priv->screen_name);
		self->priv->screen_name = _tmp7_;
	}
	_tmp8_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->data_cancellable);
	self->priv->data_cancellable = _tmp8_;
	profile_page_reset_data (self);
	_tmp9_ = user_id;
	profile_page_set_user_id (self, _tmp9_);
	_tmp10_ = self->priv->tweet_list;
	tweet_list_box_remove_all (_tmp10_);
	_tmp11_ = self->priv->tweet_list;
	tweet_list_box_reset_placeholder_text (_tmp11_);
	_tmp12_ = self->priv->user_stack;
	_tmp13_ = self->priv->tweet_list;
	gtk_stack_set_visible_child (_tmp12_, G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget));
	_tmp14_ = self->priv->user_lists;
	user_lists_widget_clear_lists (_tmp14_);
	profile_page_load_tweets (self, NULL, NULL);
	_g_free0 (screen_name);
}


static void profile_page_real_on_leave (IPage* base) {
	ProfilePage * self;
	GCancellable* _tmp0_ = NULL;
	AspectImage* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PROFILE_PAGE, ProfilePage);
	_tmp0_ = self->priv->data_cancellable;
	g_cancellable_cancel (_tmp0_);
	_tmp1_ = self->priv->banner_image;
	aspect_image_set_scale (_tmp1_, 0.3);
}


static void profile_page_reset_data (ProfilePage* self) {
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkLabel* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	GtkLabel* _tmp5_ = NULL;
	GtkLabel* _tmp6_ = NULL;
	GtkLabel* _tmp7_ = NULL;
	AvatarWidget* _tmp8_ = NULL;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	_tmp0_ = self->priv->name_label;
	gtk_label_set_label (_tmp0_, " ");
	_tmp1_ = self->priv->screen_name_label;
	gtk_label_set_label (_tmp1_, " ");
	_tmp2_ = self->priv->description_label;
	gtk_label_set_label (_tmp2_, " ");
	_tmp3_ = self->priv->url_label;
	gtk_label_set_label (_tmp3_, " ");
	_tmp4_ = self->priv->location_label;
	gtk_label_set_label (_tmp4_, " ");
	_tmp5_ = self->priv->tweets_label;
	gtk_label_set_label (_tmp5_, " ");
	_tmp6_ = self->priv->following_label;
	gtk_label_set_label (_tmp6_, " ");
	_tmp7_ = self->priv->followers_label;
	gtk_label_set_label (_tmp7_, " ");
	_tmp8_ = self->priv->avatar_image;
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_image_get_type (), GtkImage), "pixbuf", NULL, NULL);
	self->priv->lowest_tweet_id = G_MAXINT64;
}


static void profile_page_real_create_tool_button (IPage* base, GtkRadioButton* group) {
	ProfilePage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PROFILE_PAGE, ProfilePage);
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
}


static gchar* profile_page_real_get_title (IPage* base) {
	ProfilePage * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PROFILE_PAGE, ProfilePage);
	_tmp0_ = self->priv->screen_name;
	_tmp1_ = g_strconcat ("@", _tmp0_, NULL);
	result = _tmp1_;
	return result;
}


static GtkRadioButton* profile_page_real_get_tool_button (IPage* base) {
	ProfilePage * self;
	GtkRadioButton* result = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PROFILE_PAGE, ProfilePage);
	result = NULL;
	return result;
}


static void profile_page_write_dm_activated (ProfilePage* self, GSimpleAction* a, GVariant* v) {
	Bundle* bundle = NULL;
	Bundle* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	MainWindow* _tmp5_ = NULL;
	MainWindow* _tmp6_ = NULL;
	MainWidget* _tmp7_ = NULL;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_tmp0_ = bundle_new ();
	bundle = _tmp0_;
	_tmp1_ = self->priv->user_id;
	bundle_put_int64 (bundle, "sender_id", _tmp1_);
	_tmp2_ = self->priv->screen_name;
	bundle_put_string (bundle, "screen_name", _tmp2_);
	_tmp3_ = self->priv->name;
	bundle_put_string (bundle, "name", _tmp3_);
	_tmp4_ = self->priv->avatar_url;
	bundle_put_string (bundle, "avatar_url", _tmp4_);
	_tmp5_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_->main_widget;
	main_widget_switch_page (_tmp7_, (gint) PAGE_DM, bundle);
	_g_object_unref0 (bundle);
}


static void profile_page_tweet_to_activated (ProfilePage* self, GSimpleAction* a, GVariant* v) {
	ComposeTweetWindow* cw = NULL;
	MainWindow* _tmp0_ = NULL;
	MainWindow* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	Account* _tmp3_ = NULL;
	ComposeTweetWindow* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_tmp0_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp1_ = _tmp0_;
	_tmp2_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp3_ = _tmp2_;
	_tmp4_ = compose_tweet_window_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow), _tmp3_, NULL, COMPOSE_TWEET_WINDOW_MODE_NORMAL, NULL);
	g_object_ref_sink (_tmp4_);
	cw = _tmp4_;
	_tmp5_ = self->priv->screen_name;
	_tmp6_ = g_strconcat ("@", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, " ", NULL);
	_tmp9_ = _tmp8_;
	compose_tweet_window_set_text (cw, _tmp9_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (cw, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (cw);
}


static void profile_page_add_remove_list_activated (ProfilePage* self, GSimpleAction* a, GVariant* v) {
	UserListDialog* uld = NULL;
	MainWindow* _tmp0_ = NULL;
	MainWindow* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	Account* _tmp3_ = NULL;
	gint64 _tmp4_ = 0LL;
	UserListDialog* _tmp5_ = NULL;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_tmp0_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp1_ = _tmp0_;
	_tmp2_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->user_id;
	_tmp5_ = user_list_dialog_new (_tmp1_, _tmp3_, _tmp4_);
	g_object_ref_sink (_tmp5_);
	uld = _tmp5_;
	user_list_dialog_load_lists (uld);
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (uld, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (uld);
}


static Block28Data* block28_data_ref (Block28Data* _data28_) {
	g_atomic_int_inc (&_data28_->_ref_count_);
	return _data28_;
}


static void block28_data_unref (void * _userdata_) {
	Block28Data* _data28_;
	_data28_ = (Block28Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data28_->_ref_count_)) {
		ProfilePage* self;
		self = _data28_->self;
		_g_object_unref0 (_data28_->call);
		_g_object_unref0 (_data28_->a);
		_g_object_unref0 (self);
		g_slice_free (Block28Data, _data28_);
	}
}


static void __lambda191_ (Block28Data* _data28_, GObject* obj, GAsyncResult* res) {
	ProfilePage* self;
	GError * _inner_error_ = NULL;
	self = _data28_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = _data28_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch34_g_error;
		}
	}
	goto __finally34;
	__catch34_g_error:
	{
		GError* e = NULL;
		RestProxyCall* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		GSimpleAction* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		GVariant* _tmp8_ = NULL;
		GVariant* _tmp9_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _data28_->call;
		_tmp3_ = rest_proxy_call_get_payload (_tmp2_);
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		utils_show_error_object (_tmp3_, _tmp5_, 699, "ProfilePage.vala");
		_tmp6_ = _data28_->a;
		_tmp7_ = _data28_->current_state;
		_tmp8_ = g_variant_new_boolean (_tmp7_);
		g_variant_ref_sink (_tmp8_);
		_tmp9_ = _tmp8_;
		g_simple_action_set_state (_tmp6_, _tmp9_);
		_g_variant_unref0 (_tmp9_);
		_g_error_free0 (e);
	}
	__finally34:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	self->priv->block_item_blocked = FALSE;
}


static void ___lambda191__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda191_ (self, source_object, res);
	block28_data_unref (self);
}


static void profile_page_toggle_blocked_activated (ProfilePage* self, GSimpleAction* a, GVariant* v) {
	Block28Data* _data28_;
	GSimpleAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	HomeTimeline* ht = NULL;
	MainWindow* _tmp4_ = NULL;
	MainWindow* _tmp5_ = NULL;
	IPage* _tmp6_ = NULL;
	Account* _tmp7_ = NULL;
	Account* _tmp8_ = NULL;
	OAuthProxy* _tmp9_ = NULL;
	OAuthProxy* _tmp10_ = NULL;
	RestProxyCall* _tmp11_ = NULL;
	RestProxyCall* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp20_ = FALSE;
	RestProxyCall* _tmp21_ = NULL;
	gint64 _tmp22_ = 0LL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	RestProxyCall* _tmp25_ = NULL;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_data28_ = g_slice_new0 (Block28Data);
	_data28_->_ref_count_ = 1;
	_data28_->self = g_object_ref (self);
	_tmp0_ = a;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data28_->a);
	_data28_->a = _tmp1_;
	_tmp2_ = self->priv->block_item_blocked;
	if (_tmp2_) {
		block28_data_unref (_data28_);
		_data28_ = NULL;
		return;
	}
	self->priv->block_item_blocked = TRUE;
	_tmp3_ = profile_page_get_user_blocked (self);
	_data28_->current_state = _tmp3_;
	_tmp4_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp5_ = _tmp4_;
	_tmp6_ = main_window_get_page (_tmp5_, (gint) PAGE_STREAM);
	ht = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_HOME_TIMELINE, HomeTimeline);
	_tmp7_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp8_ = _tmp7_;
	_tmp9_ = account_get_proxy (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, rest_proxy_get_type (), RestProxy));
	_data28_->call = _tmp11_;
	_tmp12_ = _data28_->call;
	rest_proxy_call_set_method (_tmp12_, "POST");
	_tmp13_ = _data28_->current_state;
	if (_tmp13_) {
		RestProxyCall* _tmp14_ = NULL;
		HomeTimeline* _tmp15_ = NULL;
		gint64 _tmp16_ = 0LL;
		_tmp14_ = _data28_->call;
		rest_proxy_call_set_function (_tmp14_, "1.1/blocks/destroy.json");
		_tmp15_ = ht;
		_tmp16_ = self->priv->user_id;
		home_timeline_show_tweets_from (_tmp15_, _tmp16_);
	} else {
		RestProxyCall* _tmp17_ = NULL;
		HomeTimeline* _tmp18_ = NULL;
		gint64 _tmp19_ = 0LL;
		_tmp17_ = _data28_->call;
		rest_proxy_call_set_function (_tmp17_, "1.1/blocks/create.json");
		profile_page_set_follow_button_state (self, FALSE);
		_tmp18_ = ht;
		_tmp19_ = self->priv->user_id;
		home_timeline_hide_tweets_from (_tmp18_, _tmp19_);
	}
	_tmp20_ = _data28_->current_state;
	profile_page_set_user_blocked (self, !_tmp20_);
	_tmp21_ = _data28_->call;
	_tmp22_ = self->priv->user_id;
	_tmp23_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp22_);
	_tmp24_ = _tmp23_;
	rest_proxy_call_add_param (_tmp21_, "user_id", _tmp24_);
	_g_free0 (_tmp24_);
	_tmp25_ = _data28_->call;
	rest_proxy_call_invoke_async (_tmp25_, NULL, ___lambda191__gasync_ready_callback, block28_data_ref (_data28_));
	_g_object_unref0 (ht);
	block28_data_unref (_data28_);
	_data28_ = NULL;
}


static Block29Data* block29_data_ref (Block29Data* _data29_) {
	g_atomic_int_inc (&_data29_->_ref_count_);
	return _data29_;
}


static void block29_data_unref (void * _userdata_) {
	Block29Data* _data29_;
	_data29_ = (Block29Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data29_->_ref_count_)) {
		ProfilePage* self;
		self = _data29_->self;
		_g_object_unref0 (_data29_->call);
		_g_object_unref0 (_data29_->a);
		_g_object_unref0 (self);
		g_slice_free (Block29Data, _data29_);
	}
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_ = NULL;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


static void __lambda192_ (Block29Data* _data29_, GObject* obj, GAsyncResult* res) {
	ProfilePage* self;
	GError * _inner_error_ = NULL;
	self = _data29_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = _data29_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch35_g_error;
		}
	}
	goto __finally35;
	__catch35_g_error:
	{
		GError* e = NULL;
		RestProxyCall* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		GSimpleAction* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		GVariant* _tmp8_ = NULL;
		GVariant* _tmp9_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _data29_->call;
		_tmp3_ = rest_proxy_call_get_payload (_tmp2_);
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		utils_show_error_object (_tmp3_, _tmp5_, 733, "ProfilePage.vala");
		_tmp6_ = _data29_->a;
		_tmp7_ = _data29_->current_state;
		_tmp8_ = g_variant_new_boolean (_tmp7_);
		g_variant_ref_sink (_tmp8_);
		_tmp9_ = _tmp8_;
		g_simple_action_set_state (_tmp6_, _tmp9_);
		_g_variant_unref0 (_tmp9_);
		_g_error_free0 (e);
	}
	__finally35:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	self->priv->retweet_item_blocked = FALSE;
}


static void ___lambda192__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda192_ (self, source_object, res);
	block29_data_unref (self);
}


static void profile_page_retweet_action_activated (ProfilePage* self, GSimpleAction* a, GVariant* v) {
	Block29Data* _data29_;
	GSimpleAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GSimpleAction* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GSimpleAction* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	GVariant* _tmp10_ = NULL;
	GVariant* _tmp11_ = NULL;
	Account* _tmp12_ = NULL;
	Account* _tmp13_ = NULL;
	OAuthProxy* _tmp14_ = NULL;
	OAuthProxy* _tmp15_ = NULL;
	RestProxyCall* _tmp16_ = NULL;
	RestProxyCall* _tmp17_ = NULL;
	RestProxyCall* _tmp18_ = NULL;
	RestProxyCall* _tmp19_ = NULL;
	gint64 _tmp20_ = 0LL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	RestProxyCall* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	HomeTimeline* ht = NULL;
	MainWindow* _tmp27_ = NULL;
	MainWindow* _tmp28_ = NULL;
	IPage* _tmp29_ = NULL;
	gboolean _tmp30_ = FALSE;
	RestProxyCall* _tmp41_ = NULL;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_data29_ = g_slice_new0 (Block29Data);
	_data29_->_ref_count_ = 1;
	_data29_->self = g_object_ref (self);
	_tmp0_ = a;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data29_->a);
	_data29_->a = _tmp1_;
	_tmp2_ = self->priv->retweet_item_blocked;
	if (_tmp2_) {
		block29_data_unref (_data29_);
		_data29_ = NULL;
		return;
	}
	self->priv->retweet_item_blocked = TRUE;
	_tmp3_ = _data29_->a;
	_tmp4_ = g_action_get_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_action_get_type (), GAction));
	_tmp5_ = _tmp4_;
	_tmp6_ = g_variant_get_boolean (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_variant_unref0 (_tmp5_);
	_data29_->current_state = _tmp7_;
	_tmp8_ = _data29_->a;
	_tmp9_ = _data29_->current_state;
	_tmp10_ = g_variant_new_boolean (!_tmp9_);
	g_variant_ref_sink (_tmp10_);
	_tmp11_ = _tmp10_;
	g_simple_action_set_state (_tmp8_, _tmp11_);
	_g_variant_unref0 (_tmp11_);
	_tmp12_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp13_ = _tmp12_;
	_tmp14_ = account_get_proxy (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, rest_proxy_get_type (), RestProxy));
	_data29_->call = _tmp16_;
	_tmp17_ = _data29_->call;
	rest_proxy_call_set_function (_tmp17_, "1.1/friendships/update.json");
	_tmp18_ = _data29_->call;
	rest_proxy_call_set_method (_tmp18_, "POST");
	_tmp19_ = _data29_->call;
	_tmp20_ = self->priv->user_id;
	_tmp21_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp20_);
	_tmp22_ = _tmp21_;
	rest_proxy_call_add_param (_tmp19_, "user_id", _tmp22_);
	_g_free0 (_tmp22_);
	_tmp23_ = _data29_->call;
	_tmp24_ = _data29_->current_state;
	_tmp25_ = bool_to_string (_tmp24_);
	_tmp26_ = _tmp25_;
	rest_proxy_call_add_param (_tmp23_, "retweets", _tmp26_);
	_g_free0 (_tmp26_);
	_tmp27_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp28_ = _tmp27_;
	_tmp29_ = main_window_get_page (_tmp28_, (gint) PAGE_STREAM);
	ht = G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, TYPE_HOME_TIMELINE, HomeTimeline);
	_tmp30_ = _data29_->current_state;
	if (_tmp30_) {
		HomeTimeline* _tmp31_ = NULL;
		gint64 _tmp32_ = 0LL;
		Account* _tmp33_ = NULL;
		Account* _tmp34_ = NULL;
		gint64 _tmp35_ = 0LL;
		_tmp31_ = ht;
		_tmp32_ = self->priv->user_id;
		home_timeline_show_retweets_from (_tmp31_, _tmp32_);
		_tmp33_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp34_ = _tmp33_;
		_tmp35_ = self->priv->user_id;
		account_remove_disabled_rts_id (_tmp34_, _tmp35_);
	} else {
		HomeTimeline* _tmp36_ = NULL;
		gint64 _tmp37_ = 0LL;
		Account* _tmp38_ = NULL;
		Account* _tmp39_ = NULL;
		gint64 _tmp40_ = 0LL;
		_tmp36_ = ht;
		_tmp37_ = self->priv->user_id;
		home_timeline_hide_retweets_from (_tmp36_, _tmp37_);
		_tmp38_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp39_ = _tmp38_;
		_tmp40_ = self->priv->user_id;
		account_add_disabled_rts_id (_tmp39_, _tmp40_);
	}
	_tmp41_ = _data29_->call;
	rest_proxy_call_invoke_async (_tmp41_, NULL, ___lambda192__gasync_ready_callback, block29_data_ref (_data29_));
	_g_object_unref0 (ht);
	block29_data_unref (_data29_);
	_data29_ = NULL;
}


static void profile_page_set_user_blocked (ProfilePage* self, gboolean blocked) {
	GSimpleActionGroup* _tmp0_ = NULL;
	GAction* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GVariant* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	_tmp0_ = self->priv->actions;
	_tmp1_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_action_map_get_type (), GActionMap), "toggle-blocked");
	_tmp2_ = blocked;
	_tmp3_ = g_variant_new_boolean (_tmp2_);
	g_variant_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	g_simple_action_set_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction), _tmp4_);
	_g_variant_unref0 (_tmp4_);
}


static gboolean profile_page_get_user_blocked (ProfilePage* self) {
	gboolean result = FALSE;
	GSimpleActionGroup* _tmp0_ = NULL;
	GAction* _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	GVariant* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (IS_PROFILE_PAGE (self), FALSE);
	_tmp0_ = self->priv->actions;
	_tmp1_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_action_map_get_type (), GActionMap), "toggle-blocked");
	_tmp2_ = g_action_get_state (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction), g_action_get_type (), GAction));
	_tmp3_ = _tmp2_;
	_tmp4_ = g_variant_get_boolean (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_variant_unref0 (_tmp3_);
	result = _tmp5_;
	return result;
}


static void profile_page_set_retweets_disabled (ProfilePage* self, gboolean disabled) {
	GSimpleActionGroup* _tmp0_ = NULL;
	GAction* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GVariant* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	_tmp0_ = self->priv->actions;
	_tmp1_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_action_map_get_type (), GActionMap), "toggle-retweets");
	_tmp2_ = disabled;
	_tmp3_ = g_variant_new_boolean (_tmp2_);
	g_variant_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	g_simple_action_set_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction), _tmp4_);
	_g_variant_unref0 (_tmp4_);
}


static void profile_page_update_follower_label (ProfilePage* self) {
	GtkLabel* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	_tmp0_ = self->priv->followers_label;
	_tmp1_ = self->priv->follower_count;
	_tmp2_ = g_strdup_printf ("%'d", _tmp1_);
	_tmp3_ = _tmp2_;
	gtk_label_set_label (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
}


gint profile_page_get_unread_count (ProfilePage* self) {
	gint result;
	g_return_val_if_fail (IS_PROFILE_PAGE (self), 0);
	result = 0;
	return result;
}


void profile_page_set_unread_count (ProfilePage* self, gint value) {
	g_return_if_fail (IS_PROFILE_PAGE (self));
	g_object_notify ((GObject *) self, "unread-count");
}


static MainWindow* profile_page_real_get_main_window (IPage* base) {
	MainWindow* result;
	ProfilePage* self;
	MainWindow* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PROFILE_PAGE, ProfilePage);
	_tmp0_ = self->priv->_main_window;
	result = _tmp0_;
	return result;
}


static void profile_page_real_set_main_window (IPage* base, MainWindow* value) {
	ProfilePage* self;
	MainWindow* _tmp0_ = NULL;
	UserListsWidget* _tmp1_ = NULL;
	MainWindow* _tmp2_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PROFILE_PAGE, ProfilePage);
	_tmp0_ = value;
	self->priv->_main_window = _tmp0_;
	_tmp1_ = self->priv->user_lists;
	_tmp2_ = value;
	user_lists_widget_set_main_window (_tmp1_, _tmp2_);
	g_object_notify ((GObject *) self, "main-window");
}


static Account* profile_page_real_get_account (IPage* base) {
	Account* result;
	ProfilePage* self;
	Account* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PROFILE_PAGE, ProfilePage);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}


static void profile_page_real_set_account (IPage* base, Account* value) {
	ProfilePage* self;
	Account* _tmp0_ = NULL;
	UserListsWidget* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PROFILE_PAGE, ProfilePage);
	_tmp0_ = value;
	self->priv->_account = _tmp0_;
	_tmp1_ = self->priv->user_lists;
	_tmp2_ = value;
	user_lists_widget_set_account (_tmp1_, _tmp2_);
	g_object_notify ((GObject *) self, "account");
}


static gint profile_page_real_get_id (IPage* base) {
	gint result;
	ProfilePage* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PROFILE_PAGE, ProfilePage);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void profile_page_real_set_id (IPage* base, gint value) {
	ProfilePage* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PROFILE_PAGE, ProfilePage);
	_tmp0_ = value;
	self->priv->_id = _tmp0_;
	g_object_notify ((GObject *) self, "id");
}


DeltaUpdater* profile_page_get_delta_updater (ProfilePage* self) {
	DeltaUpdater* result;
	DeltaUpdater* _tmp0_ = NULL;
	g_return_val_if_fail (IS_PROFILE_PAGE (self), NULL);
	_tmp0_ = self->priv->_delta_updater;
	result = _tmp0_;
	return result;
}


void profile_page_set_delta_updater (ProfilePage* self, DeltaUpdater* value) {
	DeltaUpdater* _tmp0_ = NULL;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	_tmp0_ = value;
	self->priv->_delta_updater = _tmp0_;
	g_object_notify ((GObject *) self, "delta-updater");
}


static void profile_page_class_init (ProfilePageClass * klass) {
	gint ProfilePage_private_offset;
	profile_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ProfilePagePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_profile_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_profile_page_set_property;
	G_OBJECT_CLASS (klass)->finalize = profile_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PROFILE_PAGE_UNREAD_COUNT, g_param_spec_int ("unread-count", "unread-count", "unread-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PROFILE_PAGE_MAIN_WINDOW, g_param_spec_object ("main-window", "main-window", "main-window", TYPE_MAIN_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PROFILE_PAGE_ACCOUNT, g_param_spec_object ("account", "account", "account", TYPE_ACCOUNT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PROFILE_PAGE_ID, g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PROFILE_PAGE_DELTA_UPDATER, g_param_spec_object ("delta-updater", "delta-updater", "delta-updater", TYPE_DELTA_UPDATER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	ProfilePage_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/profile-page.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "banner_image", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, banner_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "avatar_image", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, avatar_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_label", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "screen_name_label", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, screen_name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "description_label", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, description_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "url_label", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, url_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tweets_label", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, tweets_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "following_label", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, following_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "followers_label", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, followers_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "location_label", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, location_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "follow_button", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, follow_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tweet_list", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, tweet_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "progress_spinner", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, progress_spinner));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "follows_you_label", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, follows_you_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "user_lists", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, user_lists));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "user_stack", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, user_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "more_button", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, more_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "loading_stack", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, loading_stack));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "follow_button_clicked_cb", G_CALLBACK(_profile_page_follow_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "activate_link", G_CALLBACK(_profile_page_activate_link_gtk_label_activate_link));
}


static void profile_page_ipage_interface_init (IPageIface * iface) {
	profile_page_ipage_parent_iface = g_type_interface_peek_parent (iface);
	iface->on_join = (void (*)(IPage*, gint, Bundle*)) profile_page_real_on_join;
	iface->on_leave = (void (*)(IPage*)) profile_page_real_on_leave;
	iface->create_tool_button = (void (*)(IPage*, GtkRadioButton*)) profile_page_real_create_tool_button;
	iface->get_title = (gchar* (*)(IPage*)) profile_page_real_get_title;
	iface->get_tool_button = (GtkRadioButton* (*)(IPage*)) profile_page_real_get_tool_button;
	iface->get_main_window = profile_page_real_get_main_window;
	iface->set_main_window = profile_page_real_set_main_window;
	iface->get_account = profile_page_real_get_account;
	iface->set_account = profile_page_real_set_account;
	iface->get_id = profile_page_real_get_id;
	iface->set_id = profile_page_real_set_id;
}


static void profile_page_instance_init (ProfilePage * self) {
	self->priv = PROFILE_PAGE_GET_PRIVATE (self);
	self->priv->follower_count = -1;
	self->priv->lists_page_inited = FALSE;
	self->priv->page_change_signal = (gulong) 0;
	self->priv->block_item_blocked = FALSE;
	self->priv->retweet_item_blocked = FALSE;
	self->priv->tweets_loading = FALSE;
	self->priv->lowest_tweet_id = G_MAXINT64;
	g_type_ensure (TYPE_USER_LISTS_WIDGET);
	g_type_ensure (TYPE_TWEET_LIST_BOX);
	g_type_ensure (TYPE_AVATAR_WIDGET);
	g_type_ensure (TYPE_ASPECT_IMAGE);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void profile_page_finalize (GObject* obj) {
	ProfilePage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROFILE_PAGE, ProfilePage);
	_g_object_unref0 (self->priv->banner_image);
	_g_object_unref0 (self->priv->avatar_image);
	_g_object_unref0 (self->priv->name_label);
	_g_object_unref0 (self->priv->screen_name_label);
	_g_object_unref0 (self->priv->description_label);
	_g_object_unref0 (self->priv->url_label);
	_g_object_unref0 (self->priv->tweets_label);
	_g_object_unref0 (self->priv->following_label);
	_g_object_unref0 (self->priv->followers_label);
	_g_object_unref0 (self->priv->location_label);
	_g_object_unref0 (self->priv->follow_button);
	_g_object_unref0 (self->priv->tweet_list);
	_g_object_unref0 (self->priv->progress_spinner);
	_g_object_unref0 (self->priv->follows_you_label);
	_g_object_unref0 (self->priv->user_lists);
	_g_object_unref0 (self->priv->user_stack);
	_g_object_unref0 (self->priv->more_button);
	_g_object_unref0 (self->priv->loading_stack);
	_g_object_unref0 (self->priv->more_menu);
	_g_free0 (self->priv->name);
	_g_free0 (self->priv->screen_name);
	_g_free0 (self->priv->avatar_url);
	_g_object_unref0 (self->priv->data_cancellable);
	_g_object_unref0 (self->priv->actions);
	G_OBJECT_CLASS (profile_page_parent_class)->finalize (obj);
}


GType profile_page_get_type (void) {
	static volatile gsize profile_page_type_id__volatile = 0;
	if (g_once_init_enter (&profile_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ProfilePageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) profile_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ProfilePage), 0, (GInstanceInitFunc) profile_page_instance_init, NULL };
		static const GInterfaceInfo ipage_info = { (GInterfaceInitFunc) profile_page_ipage_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType profile_page_type_id;
		profile_page_type_id = g_type_register_static (TYPE_SCROLL_WIDGET, "ProfilePage", &g_define_type_info, 0);
		g_type_add_interface_static (profile_page_type_id, TYPE_IPAGE, &ipage_info);
		g_once_init_leave (&profile_page_type_id__volatile, profile_page_type_id);
	}
	return profile_page_type_id__volatile;
}


static void _vala_profile_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ProfilePage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PROFILE_PAGE, ProfilePage);
	switch (property_id) {
		case PROFILE_PAGE_UNREAD_COUNT:
		g_value_set_int (value, profile_page_get_unread_count (self));
		break;
		case PROFILE_PAGE_MAIN_WINDOW:
		g_value_set_object (value, ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		case PROFILE_PAGE_ACCOUNT:
		g_value_set_object (value, ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		case PROFILE_PAGE_ID:
		g_value_set_int (value, ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		case PROFILE_PAGE_DELTA_UPDATER:
		g_value_set_object (value, profile_page_get_delta_updater (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_profile_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ProfilePage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PROFILE_PAGE, ProfilePage);
	switch (property_id) {
		case PROFILE_PAGE_UNREAD_COUNT:
		profile_page_set_unread_count (self, g_value_get_int (value));
		break;
		case PROFILE_PAGE_MAIN_WINDOW:
		ipage_set_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		case PROFILE_PAGE_ACCOUNT:
		ipage_set_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		case PROFILE_PAGE_ID:
		ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_int (value));
		break;
		case PROFILE_PAGE_DELTA_UPDATER:
		profile_page_set_delta_updater (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



