/* DMPage.c generated by valac 0.26.2, the Vala compiler
 * generated from DMPage.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include <float.h>
#include <math.h>
#include <rest/rest-proxy-call.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <rest/oauth-proxy.h>
#include <rest/rest-proxy.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>


#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_IMESSAGE_RECEIVER (imessage_receiver_get_type ())
#define IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiver))
#define IS_IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMESSAGE_RECEIVER))
#define IMESSAGE_RECEIVER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiverIface))

typedef struct _IMessageReceiver IMessageReceiver;
typedef struct _IMessageReceiverIface IMessageReceiverIface;

#define TYPE_STREAM_MESSAGE_TYPE (stream_message_type_get_type ())

#define TYPE_DM_PAGE (dm_page_get_type ())
#define DM_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_PAGE, DMPage))
#define DM_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_PAGE, DMPageClass))
#define IS_DM_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_PAGE))
#define IS_DM_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_PAGE))
#define DM_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_PAGE, DMPageClass))

typedef struct _DMPage DMPage;
typedef struct _DMPageClass DMPageClass;
typedef struct _DMPagePrivate DMPagePrivate;

#define TYPE_DELTA_UPDATER (delta_updater_get_type ())
#define DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELTA_UPDATER, DeltaUpdater))
#define DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELTA_UPDATER, DeltaUpdaterClass))
#define IS_DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELTA_UPDATER))
#define IS_DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELTA_UPDATER))
#define DELTA_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELTA_UPDATER, DeltaUpdaterClass))

typedef struct _DeltaUpdater DeltaUpdater;
typedef struct _DeltaUpdaterClass DeltaUpdaterClass;

#define TYPE_COMPLETION_TEXT_VIEW (completion_text_view_get_type ())
#define COMPLETION_TEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_TEXT_VIEW, CompletionTextView))
#define COMPLETION_TEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_TEXT_VIEW, CompletionTextViewClass))
#define IS_COMPLETION_TEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_TEXT_VIEW))
#define IS_COMPLETION_TEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_TEXT_VIEW))
#define COMPLETION_TEXT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_TEXT_VIEW, CompletionTextViewClass))

typedef struct _CompletionTextView CompletionTextView;
typedef struct _CompletionTextViewClass CompletionTextViewClass;

#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;

#define TYPE_DM_PLACEHOLDER_BOX (dm_placeholder_box_get_type ())
#define DM_PLACEHOLDER_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_PLACEHOLDER_BOX, DMPlaceholderBox))
#define DM_PLACEHOLDER_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_PLACEHOLDER_BOX, DMPlaceholderBoxClass))
#define IS_DM_PLACEHOLDER_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_PLACEHOLDER_BOX))
#define IS_DM_PLACEHOLDER_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_PLACEHOLDER_BOX))
#define DM_PLACEHOLDER_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_PLACEHOLDER_BOX, DMPlaceholderBoxClass))

typedef struct _DMPlaceholderBox DMPlaceholderBox;
typedef struct _DMPlaceholderBoxClass DMPlaceholderBoxClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

#define TWEET_UTILS_TYPE_SEQUENCE (tweet_utils_sequence_get_type ())
typedef struct _TweetUtilsSequence TweetUtilsSequence;
typedef struct _Block9Data Block9Data;
#define __g_slist_free__tweet_utils_sequence_free0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__tweet_utils_sequence_free0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))

#define TYPE_DM_LIST_ENTRY (dm_list_entry_get_type ())
#define DM_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_LIST_ENTRY, DMListEntry))
#define DM_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_LIST_ENTRY, DMListEntryClass))
#define IS_DM_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_LIST_ENTRY))
#define IS_DM_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_LIST_ENTRY))
#define DM_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_LIST_ENTRY, DMListEntryClass))

typedef struct _DMListEntry DMListEntry;
typedef struct _DMListEntryClass DMListEntryClass;

#define TYPE_ITWITTER_ITEM (itwitter_item_get_type ())
#define ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITWITTER_ITEM, ITwitterItem))
#define IS_ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITWITTER_ITEM))
#define ITWITTER_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITWITTER_ITEM, ITwitterItemIface))

typedef struct _ITwitterItem ITwitterItem;
typedef struct _ITwitterItemIface ITwitterItemIface;
typedef struct _DMListEntryPrivate DMListEntryPrivate;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block10Data Block10Data;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define SQL_TYPE_SELECT_STATEMENT (sql_select_statement_get_type ())
#define SQL_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatement))
#define SQL_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))
#define SQL_IS_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_SELECT_STATEMENT))
#define SQL_IS_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_SELECT_STATEMENT))
#define SQL_SELECT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))

typedef struct _SqlSelectStatement SqlSelectStatement;
typedef struct _SqlSelectStatementClass SqlSelectStatementClass;
#define _sql_select_statement_unref0(var) ((var == NULL) ? NULL : (var = (sql_select_statement_unref (var), NULL)))
typedef struct _Block11Data Block11Data;
typedef struct _DMPlaceholderBoxPrivate DMPlaceholderBoxPrivate;

#define TYPE_DM_THREADS_PAGE (dm_threads_page_get_type ())
#define DM_THREADS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_THREADS_PAGE, DMThreadsPage))
#define DM_THREADS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_THREADS_PAGE, DMThreadsPageClass))
#define IS_DM_THREADS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_THREADS_PAGE))
#define IS_DM_THREADS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_THREADS_PAGE))
#define DM_THREADS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_THREADS_PAGE, DMThreadsPageClass))

typedef struct _DMThreadsPage DMThreadsPage;
typedef struct _DMThreadsPageClass DMThreadsPageClass;

#define TYPE_PAGE (page_get_type ())

#define TYPE_USER_COUNTER (user_counter_get_type ())
#define USER_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_COUNTER, UserCounter))
#define USER_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_COUNTER, UserCounterClass))
#define IS_USER_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_COUNTER))
#define IS_USER_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_COUNTER))
#define USER_COUNTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_COUNTER, UserCounterClass))

typedef struct _UserCounter UserCounter;
typedef struct _UserCounterClass UserCounterClass;
typedef struct _Block12Data Block12Data;

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, Bundle* args);
	void (*on_leave) (IPage* self);
	void (*create_tool_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_tool_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	MainWindow* (*get_main_window) (IPage* self);
	void (*set_main_window) (IPage* self, MainWindow* value);
	Account* (*get_account) (IPage* self);
	void (*set_account) (IPage* self, Account* value);
};

typedef enum  {
	STREAM_MESSAGE_TYPE_UNSUPPORTED,
	STREAM_MESSAGE_TYPE_DELETE,
	STREAM_MESSAGE_TYPE_SCRUB_GEO,
	STREAM_MESSAGE_TYPE_LIMIT,
	STREAM_MESSAGE_TYPE_DISCONNECT,
	STREAM_MESSAGE_TYPE_FRIENDS,
	STREAM_MESSAGE_TYPE_EVENT,
	STREAM_MESSAGE_TYPE_WARNING,
	STREAM_MESSAGE_TYPE_DIRECT_MESSAGE,
	STREAM_MESSAGE_TYPE_TWEET,
	STREAM_MESSAGE_TYPE_EVENT_LIST_CREATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_DESTROYED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UPDATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UNSUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_SUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_ADDED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_REMOVED,
	STREAM_MESSAGE_TYPE_EVENT_FAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_FOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_UNFOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_BLOCK,
	STREAM_MESSAGE_TYPE_EVENT_UNBLOCK,
	STREAM_MESSAGE_TYPE_EVENT_MUTE,
	STREAM_MESSAGE_TYPE_EVENT_UNMUTE,
	STREAM_MESSAGE_TYPE_EVENT_USER_UPDATE
} StreamMessageType;

struct _IMessageReceiverIface {
	GTypeInterface parent_iface;
	void (*stream_message_received) (IMessageReceiver* self, StreamMessageType type, JsonNode* root_node);
};

struct _DMPage {
	GtkBox parent_instance;
	DMPagePrivate * priv;
	gint64 user_id;
};

struct _DMPageClass {
	GtkBoxClass parent_class;
};

struct _DMPagePrivate {
	MainWindow* _main_window;
	Account* _account;
	DeltaUpdater* _delta_updater;
	gint _id;
	GtkButton* send_button;
	CompletionTextView* text_view;
	GtkListBox* messages_list;
	ScrollWidget* scroll_widget;
	DMPlaceholderBox* placeholder_box;
	gint64 lowest_id;
};

struct _TweetUtilsSequence {
	gint start;
	gint end;
	gchar* url;
	gchar* display_url;
	gboolean visual_display_url;
	gchar* title;
};

struct _Block9Data {
	int _ref_count_;
	DMPage* self;
	GSList* url_list;
};

struct _ITwitterItemIface {
	GTypeInterface parent_iface;
	gint (*update_time_delta) (ITwitterItem* self, GDateTime* now);
	gint64 (*get_sort_factor) (ITwitterItem* self);
	gboolean (*get_seen) (ITwitterItem* self);
	void (*set_seen) (ITwitterItem* self, gboolean value);
};

struct _DMListEntry {
	GtkListBoxRow parent_instance;
	DMListEntryPrivate * priv;
	gchar* avatar_url;
	gint64 timestamp;
	gint64 id;
	gint64 user_id;
	MainWindow* main_window;
};

struct _DMListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _Block10Data {
	int _ref_count_;
	DMPage* self;
	GDateTime* now;
};

typedef gboolean (*SqlSelectCallback) (gchar** vals, int vals_length1, void* user_data);
struct _Block11Data {
	int _ref_count_;
	DMPage* self;
	gchar* screen_name;
	gchar* name;
	GDateTime* now;
};

struct _DMPlaceholderBox {
	GtkBox parent_instance;
	DMPlaceholderBoxPrivate * priv;
	gchar* avatar_url;
};

struct _DMPlaceholderBoxClass {
	GtkBoxClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _Block12Data {
	int _ref_count_;
	DMPage* self;
	RestProxyCall* call;
};


static gpointer dm_page_parent_class = NULL;
static IPageIface* dm_page_ipage_parent_iface = NULL;
static IMessageReceiverIface* dm_page_imessage_receiver_parent_iface = NULL;

GType bundle_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType stream_message_type_get_type (void) G_GNUC_CONST;
GType imessage_receiver_get_type (void) G_GNUC_CONST;
GType dm_page_get_type (void) G_GNUC_CONST;
GType delta_updater_get_type (void) G_GNUC_CONST;
GType completion_text_view_get_type (void) G_GNUC_CONST;
GType scroll_widget_get_type (void) G_GNUC_CONST;
GType dm_placeholder_box_get_type (void) G_GNUC_CONST;
#define DM_PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DM_PAGE, DMPagePrivate))
enum  {
	DM_PAGE_DUMMY_PROPERTY,
	DM_PAGE_UNREAD_COUNT,
	DM_PAGE_MAIN_WINDOW,
	DM_PAGE_ACCOUNT,
	DM_PAGE_DELTA_UPDATER,
	DM_PAGE_ID
};
DMPlaceholderBox* dm_placeholder_box_new (void);
DMPlaceholderBox* dm_placeholder_box_construct (GType object_type);
DMPage* dm_page_new (gint id);
DMPage* dm_page_construct (GType object_type, gint id);
void ipage_set_id (IPage* self, gint value);
static void dm_page_recalc_length (DMPage* self);
static void _dm_page_recalc_length_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self);
gint itwitter_item_sort_func_inv (GtkListBoxRow* a, GtkListBoxRow* b);
static gint _itwitter_item_sort_func_inv_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self);
static void dm_page_load_older (DMPage* self);
static void _dm_page_load_older_scroll_widget_scrolled_to_start (ScrollWidget* _sender, gdouble value, gpointer self);
static void dm_page_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root);
GType tweet_utils_sequence_get_type (void) G_GNUC_CONST;
TweetUtilsSequence* tweet_utils_sequence_dup (const TweetUtilsSequence* self);
void tweet_utils_sequence_free (TweetUtilsSequence* self);
void tweet_utils_sequence_copy (const TweetUtilsSequence* self, TweetUtilsSequence* dest);
void tweet_utils_sequence_destroy (TweetUtilsSequence* self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void _tweet_utils_sequence_free0_ (gpointer var);
static void _g_slist_free__tweet_utils_sequence_free0_ (GSList* self);
static void block9_data_unref (void * _userdata_);
static void ____lambda122_ (Block9Data* _data9_, JsonArray* arr, guint index, JsonNode* node);
static void _____lambda122__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
gchar* tweet_utils_get_formatted_text (const gchar* tweet_text, GSList* urls);
GType dm_list_entry_get_type (void) G_GNUC_CONST;
DMListEntry* dm_list_entry_new (void);
DMListEntry* dm_list_entry_construct (GType object_type);
void dm_list_entry_set_text (DMListEntry* self, const gchar* value);
void dm_list_entry_set_name (DMListEntry* self, const gchar* value);
void dm_list_entry_set_screen_name (DMListEntry* self, const gchar* value);
GType itwitter_item_get_type (void) G_GNUC_CONST;
GDateTime* utils_parse_date (const gchar* input);
MainWindow* ipage_get_main_window (IPage* self);
void dm_list_entry_load_avatar (DMListEntry* self);
gint itwitter_item_update_time_delta (ITwitterItem* self, GDateTime* now);
DeltaUpdater* dm_page_get_delta_updater (DMPage* self);
void delta_updater_add (DeltaUpdater* self, ITwitterItem* entry);
gboolean scroll_widget_get_scrolled_down (ScrollWidget* self);
void scroll_widget_scroll_down_next (ScrollWidget* self, gboolean animate, gboolean force_wait);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
void scroll_widget_balance_next_upper_change (ScrollWidget* self, gint mode);
#define TOP 1
Account* ipage_get_account (IPage* self);
gpointer sql_database_ref (gpointer instance);
void sql_database_unref (gpointer instance);
GParamSpec* sql_param_spec_database (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_database (GValue* value, gpointer v_object);
void sql_value_take_database (GValue* value, gpointer v_object);
gpointer sql_value_get_database (const GValue* value);
GType sql_database_get_type (void) G_GNUC_CONST;
SqlDatabase* account_get_db (Account* self);
gpointer sql_select_statement_ref (gpointer instance);
void sql_select_statement_unref (gpointer instance);
GParamSpec* sql_param_spec_select_statement (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_select_statement (GValue* value, gpointer v_object);
void sql_value_take_select_statement (GValue* value, gpointer v_object);
gpointer sql_value_get_select_statement (const GValue* value);
GType sql_select_statement_get_type (void) G_GNUC_CONST;
SqlSelectStatement* sql_database_select (SqlDatabase* self, const gchar* table_name);
SqlSelectStatement* sql_select_statement_cols (SqlSelectStatement* self, const gchar* first, ...);
SqlSelectStatement* sql_select_statement_where (SqlSelectStatement* self, const gchar* stmt);
SqlSelectStatement* sql_select_statement_order (SqlSelectStatement* self, const gchar* order_by);
SqlSelectStatement* sql_select_statement_limit (SqlSelectStatement* self, gint limit);
gint sql_select_statement_run (SqlSelectStatement* self, SqlSelectCallback callback, void* callback_target);
static gboolean __lambda119_ (Block10Data* _data10_, gchar** vals, int vals_length1);
static gboolean ___lambda119__sql_select_callback (gchar** vals, int vals_length1, gpointer self);
static void dm_page_real_on_join (IPage* base, gint page_id, Bundle* args);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
gint64 bundle_get_int64 (Bundle* self, const gchar* key);
gchar* bundle_get_string (Bundle* self, const gchar* key);
void dm_placeholder_box_set_screen_name (DMPlaceholderBox* self, const gchar* value);
void dm_placeholder_box_set_name (DMPlaceholderBox* self, const gchar* value);
void dm_placeholder_box_load_avatar (DMPlaceholderBox* self);
void completion_text_view_set_account (CompletionTextView* self, Account* account);
static void __lambda123_ (DMPage* self, GtkWidget* w);
static void ___lambda123__gtk_callback (GtkWidget* widget, gpointer self);
GType dm_threads_page_get_type (void) G_GNUC_CONST;
IPage* main_window_get_page (MainWindow* self, gint page_id);
GType page_get_type (void) G_GNUC_CONST;
void dm_threads_page_adjust_unread_count_for_user_id (DMThreadsPage* self, gint64 user_id);
static gboolean __lambda124_ (Block11Data* _data11_, gchar** vals, int vals_length1);
static gboolean ___lambda124__sql_select_callback (gchar** vals, int vals_length1, gpointer self);
GType user_counter_get_type (void) G_GNUC_CONST;
UserCounter* account_get_user_counter (Account* self);
void user_counter_user_seen (UserCounter* self, gint64 id, const gchar* screen_name, const gchar* name);
static void dm_page_real_on_leave (IPage* base);
static void dm_page_send_button_clicked_cb (DMPage* self);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
#define TWEET_MAX_LENGTH 140
gchar* dm_threads_page_get_notification_id_for_user_id (DMThreadsPage* self, gint64 user_id);
const gchar* account_get_screen_name (Account* self);
const gchar* account_get_name (Account* self);
GdkPixbuf* account_get_avatar (Account* self);
void dm_list_entry_set_avatar (DMListEntry* self, GdkPixbuf* value);
OAuthProxy* account_get_proxy (Account* self);
static void __lambda125_ (Block12Data* _data12_, GObject* obj, GAsyncResult* res);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file);
static void ___lambda125__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _dm_page_send_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean dm_page_text_view_key_press_cb (DMPage* self, GdkEventKey* evt);
static gboolean _dm_page_text_view_key_press_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static gchar* dm_page_real_get_title (IPage* base);
static void dm_page_real_create_tool_button (IPage* base, GtkRadioButton* group);
static GtkRadioButton* dm_page_real_get_tool_button (IPage* base);
gint dm_page_get_unread_count (DMPage* self);
void dm_page_set_delta_updater (DMPage* self, DeltaUpdater* value);
static void dm_page_finalize (GObject* obj);
gint ipage_get_id (IPage* self);
static void _vala_dm_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void ipage_set_main_window (IPage* self, MainWindow* value);
void ipage_set_account (IPage* self, Account* value);
static void _vala_dm_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _dm_page_recalc_length_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self) {
	dm_page_recalc_length ((DMPage*) self);
}


static gint _itwitter_item_sort_func_inv_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self) {
	gint result;
	result = itwitter_item_sort_func_inv (row1, row2);
	return result;
}


static void _dm_page_load_older_scroll_widget_scrolled_to_start (ScrollWidget* _sender, gdouble value, gpointer self) {
	dm_page_load_older ((DMPage*) self);
}


DMPage* dm_page_construct (GType object_type, gint id) {
	DMPage * self = NULL;
	gint _tmp0_ = 0;
	CompletionTextView* _tmp1_ = NULL;
	GtkTextBuffer* _tmp2_ = NULL;
	GtkTextBuffer* _tmp3_ = NULL;
	GtkListBox* _tmp4_ = NULL;
	DMPlaceholderBox* _tmp5_ = NULL;
	GtkListBox* _tmp6_ = NULL;
	DMPlaceholderBox* _tmp7_ = NULL;
	ScrollWidget* _tmp8_ = NULL;
	self = (DMPage*) g_object_new (object_type, NULL);
	_tmp0_ = id;
	ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), _tmp0_);
	_tmp1_ = self->priv->text_view;
	_tmp2_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_text_view_get_type (), GtkTextView));
	_tmp3_ = _tmp2_;
	g_signal_connect_object (_tmp3_, "changed", (GCallback) _dm_page_recalc_length_gtk_text_buffer_changed, self, 0);
	_tmp4_ = self->priv->messages_list;
	gtk_list_box_set_sort_func (_tmp4_, _itwitter_item_sort_func_inv_gtk_list_box_sort_func, NULL, NULL);
	_tmp5_ = self->priv->placeholder_box;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
	_tmp6_ = self->priv->messages_list;
	_tmp7_ = self->priv->placeholder_box;
	gtk_list_box_set_placeholder (_tmp6_, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	_tmp8_ = self->priv->scroll_widget;
	g_signal_connect_object (_tmp8_, "scrolled-to-start", (GCallback) _dm_page_load_older_scroll_widget_scrolled_to_start, self, 0);
	return self;
}


DMPage* dm_page_new (gint id) {
	return dm_page_construct (TYPE_DM_PAGE, id);
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void _tweet_utils_sequence_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (tweet_utils_sequence_free (var), NULL));
}


static void _g_slist_free__tweet_utils_sequence_free0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _tweet_utils_sequence_free0_, NULL);
	g_slist_free (self);
}


static void block9_data_unref (void * _userdata_) {
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		DMPage* self;
		self = _data9_->self;
		__g_slist_free__tweet_utils_sequence_free0_0 (_data9_->url_list);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally5;
	__catch5_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gpointer _tweet_utils_sequence_dup0 (gpointer self) {
	return self ? tweet_utils_sequence_dup (self) : NULL;
}


static void ____lambda122_ (Block9Data* _data9_, JsonArray* arr, guint index, JsonNode* node) {
	DMPage* self;
	JsonObject* url = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	gchar* expanded_url = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	JsonArray* indices = NULL;
	JsonArray* _tmp5_ = NULL;
	JsonArray* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	gint64 _tmp10_ = 0LL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	TweetUtilsSequence _tmp15_ = {0};
	TweetUtilsSequence _tmp16_ = {0};
	TweetUtilsSequence* _tmp17_ = NULL;
	self = _data9_->self;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	url = _tmp2_;
	_tmp3_ = json_object_get_string_member (url, "expanded_url");
	_tmp4_ = g_strdup (_tmp3_);
	expanded_url = _tmp4_;
	_tmp5_ = json_object_get_array_member (url, "indices");
	_tmp6_ = _json_array_ref0 (_tmp5_);
	indices = _tmp6_;
	_tmp7_ = expanded_url;
	_tmp8_ = string_replace (_tmp7_, "&", "&amp;");
	_g_free0 (expanded_url);
	expanded_url = _tmp8_;
	_tmp9_ = json_array_get_int_element (indices, (guint) 0);
	_tmp10_ = json_array_get_int_element (indices, (guint) 1);
	_tmp11_ = expanded_url;
	_tmp12_ = g_strdup (_tmp11_);
	_tmp13_ = json_object_get_string_member (url, "display_url");
	_tmp14_ = g_strdup (_tmp13_);
	memset (&_tmp15_, 0, sizeof (TweetUtilsSequence));
	_tmp15_.start = (gint) _tmp9_;
	_tmp15_.end = (gint) _tmp10_;
	_g_free0 (_tmp15_.url);
	_tmp15_.url = _tmp12_;
	_g_free0 (_tmp15_.display_url);
	_tmp15_.display_url = _tmp14_;
	_tmp15_.visual_display_url = FALSE;
	_tmp16_ = _tmp15_;
	_tmp17_ = _tweet_utils_sequence_dup0 (&_tmp16_);
	_data9_->url_list = g_slist_prepend (_data9_->url_list, _tmp17_);
	tweet_utils_sequence_destroy (&_tmp16_);
	_json_array_unref0 (indices);
	_g_free0 (expanded_url);
	_json_object_unref0 (url);
}


static void _____lambda122__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	____lambda122_ (self, array, index_, element_node);
}


static void dm_page_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root) {
	DMPage * self;
	StreamMessageType _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_PAGE, DMPage);
	g_return_if_fail (root != NULL);
	_tmp0_ = type;
	if (_tmp0_ == STREAM_MESSAGE_TYPE_DIRECT_MESSAGE) {
		JsonObject* obj = NULL;
		JsonNode* _tmp1_ = NULL;
		JsonObject* _tmp2_ = NULL;
		JsonObject* _tmp3_ = NULL;
		JsonObject* _tmp4_ = NULL;
		JsonObject* _tmp5_ = NULL;
		gint64 _tmp6_ = 0LL;
		gint64 _tmp7_ = 0LL;
		gchar* text = NULL;
		JsonObject* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		JsonObject* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		JsonObject* sender = NULL;
		JsonObject* _tmp21_ = NULL;
		JsonObject* _tmp22_ = NULL;
		JsonObject* _tmp23_ = NULL;
		DMListEntry* new_msg = NULL;
		DMListEntry* _tmp24_ = NULL;
		DMListEntry* _tmp25_ = NULL;
		JsonObject* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		DMListEntry* _tmp28_ = NULL;
		JsonObject* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		DMListEntry* _tmp31_ = NULL;
		JsonObject* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		DMListEntry* _tmp34_ = NULL;
		JsonObject* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		DMListEntry* _tmp38_ = NULL;
		JsonObject* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		GDateTime* _tmp41_ = NULL;
		GDateTime* _tmp42_ = NULL;
		gint64 _tmp43_ = 0LL;
		DMListEntry* _tmp44_ = NULL;
		MainWindow* _tmp45_ = NULL;
		MainWindow* _tmp46_ = NULL;
		DMListEntry* _tmp47_ = NULL;
		JsonObject* _tmp48_ = NULL;
		gint64 _tmp49_ = 0LL;
		DMListEntry* _tmp50_ = NULL;
		DMListEntry* _tmp51_ = NULL;
		DeltaUpdater* _tmp52_ = NULL;
		DMListEntry* _tmp53_ = NULL;
		GtkListBox* _tmp54_ = NULL;
		DMListEntry* _tmp55_ = NULL;
		ScrollWidget* _tmp56_ = NULL;
		gboolean _tmp57_ = FALSE;
		gboolean _tmp58_ = FALSE;
		_tmp1_ = root;
		_tmp2_ = json_node_get_object (_tmp1_);
		_tmp3_ = json_object_get_object_member (_tmp2_, "direct_message");
		_tmp4_ = _json_object_ref0 (_tmp3_);
		obj = _tmp4_;
		_tmp5_ = obj;
		_tmp6_ = json_object_get_int_member (_tmp5_, "sender_id");
		_tmp7_ = self->user_id;
		if (_tmp6_ != _tmp7_) {
			_json_object_unref0 (obj);
			return;
		}
		_tmp8_ = obj;
		_tmp9_ = json_object_get_string_member (_tmp8_, "text");
		_tmp10_ = g_strdup (_tmp9_);
		text = _tmp10_;
		_tmp11_ = obj;
		_tmp12_ = json_object_has_member (_tmp11_, "entities");
		if (_tmp12_) {
			Block9Data* _data9_;
			JsonArray* urls = NULL;
			JsonObject* _tmp13_ = NULL;
			JsonObject* _tmp14_ = NULL;
			JsonArray* _tmp15_ = NULL;
			JsonArray* _tmp16_ = NULL;
			JsonArray* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			GSList* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			_data9_ = g_slice_new0 (Block9Data);
			_data9_->_ref_count_ = 1;
			_data9_->self = g_object_ref (self);
			_tmp13_ = obj;
			_tmp14_ = json_object_get_object_member (_tmp13_, "entities");
			_tmp15_ = json_object_get_array_member (_tmp14_, "urls");
			_tmp16_ = _json_array_ref0 (_tmp15_);
			urls = _tmp16_;
			_data9_->url_list = NULL;
			_tmp17_ = urls;
			json_array_foreach_element (_tmp17_, _____lambda122__json_array_foreach, _data9_);
			_tmp18_ = text;
			_tmp19_ = _data9_->url_list;
			_tmp20_ = tweet_utils_get_formatted_text (_tmp18_, _tmp19_);
			_g_free0 (text);
			text = _tmp20_;
			_json_array_unref0 (urls);
			block9_data_unref (_data9_);
			_data9_ = NULL;
		}
		_tmp21_ = obj;
		_tmp22_ = json_object_get_object_member (_tmp21_, "sender");
		_tmp23_ = _json_object_ref0 (_tmp22_);
		sender = _tmp23_;
		_tmp24_ = dm_list_entry_new ();
		g_object_ref_sink (_tmp24_);
		new_msg = _tmp24_;
		_tmp25_ = new_msg;
		_tmp26_ = obj;
		_tmp27_ = json_object_get_string_member (_tmp26_, "text");
		dm_list_entry_set_text (_tmp25_, _tmp27_);
		_tmp28_ = new_msg;
		_tmp29_ = sender;
		_tmp30_ = json_object_get_string_member (_tmp29_, "name");
		dm_list_entry_set_name (_tmp28_, _tmp30_);
		_tmp31_ = new_msg;
		_tmp32_ = sender;
		_tmp33_ = json_object_get_string_member (_tmp32_, "screen_name");
		dm_list_entry_set_screen_name (_tmp31_, _tmp33_);
		_tmp34_ = new_msg;
		_tmp35_ = sender;
		_tmp36_ = json_object_get_string_member (_tmp35_, "profile_image_url");
		_tmp37_ = g_strdup (_tmp36_);
		_g_free0 (_tmp34_->avatar_url);
		_tmp34_->avatar_url = _tmp37_;
		_tmp38_ = new_msg;
		_tmp39_ = obj;
		_tmp40_ = json_object_get_string_member (_tmp39_, "created_at");
		_tmp41_ = utils_parse_date (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = g_date_time_to_unix (_tmp42_);
		_tmp38_->timestamp = _tmp43_;
		_g_date_time_unref0 (_tmp42_);
		_tmp44_ = new_msg;
		_tmp45_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp46_ = _tmp45_;
		_tmp44_->main_window = _tmp46_;
		_tmp47_ = new_msg;
		_tmp48_ = sender;
		_tmp49_ = json_object_get_int_member (_tmp48_, "id");
		_tmp47_->user_id = _tmp49_;
		_tmp50_ = new_msg;
		dm_list_entry_load_avatar (_tmp50_);
		_tmp51_ = new_msg;
		itwitter_item_update_time_delta (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, TYPE_ITWITTER_ITEM, ITwitterItem), NULL);
		_tmp52_ = self->priv->_delta_updater;
		_tmp53_ = new_msg;
		delta_updater_add (_tmp52_, G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, TYPE_ITWITTER_ITEM, ITwitterItem));
		_tmp54_ = self->priv->messages_list;
		_tmp55_ = new_msg;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, gtk_widget_get_type (), GtkWidget));
		_tmp56_ = self->priv->scroll_widget;
		_tmp57_ = scroll_widget_get_scrolled_down (_tmp56_);
		_tmp58_ = _tmp57_;
		if (_tmp58_) {
			ScrollWidget* _tmp59_ = NULL;
			_tmp59_ = self->priv->scroll_widget;
			scroll_widget_scroll_down_next (_tmp59_, TRUE, FALSE);
		}
		_g_object_unref0 (new_msg);
		_json_object_unref0 (sender);
		_g_free0 (text);
		_json_object_unref0 (obj);
	}
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}


static void block10_data_unref (void * _userdata_) {
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		DMPage* self;
		self = _data10_->self;
		_g_date_time_unref0 (_data10_->now);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}


static gint64 int64_parse (const gchar* str) {
	gint64 result = 0LL;
	const gchar* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoll (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static gboolean __lambda119_ (Block10Data* _data10_, gchar** vals, int vals_length1) {
	DMPage* self;
	gboolean result = FALSE;
	gint64 id = 0LL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	const gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
	DMListEntry* entry = NULL;
	DMListEntry* _tmp6_ = NULL;
	gint64 _tmp7_ = 0LL;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	const gchar* _tmp9_ = NULL;
	gint64 _tmp10_ = 0LL;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	const gchar* _tmp12_ = NULL;
	gint64 _tmp13_ = 0LL;
	gchar** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	const gchar* _tmp15_ = NULL;
	gchar** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	const gchar* _tmp17_ = NULL;
	gchar** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	const gchar* _tmp19_ = NULL;
	gchar** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	MainWindow* _tmp23_ = NULL;
	MainWindow* _tmp24_ = NULL;
	DeltaUpdater* _tmp25_ = NULL;
	GtkListBox* _tmp26_ = NULL;
	self = _data10_->self;
	_tmp0_ = vals;
	_tmp0__length1 = vals_length1;
	_tmp1_ = _tmp0_[7];
	_tmp2_ = int64_parse (_tmp1_);
	id = _tmp2_;
	_tmp3_ = id;
	_tmp4_ = self->priv->lowest_id;
	if (_tmp3_ < _tmp4_) {
		gint64 _tmp5_ = 0LL;
		_tmp5_ = id;
		self->priv->lowest_id = _tmp5_;
	}
	_tmp6_ = dm_list_entry_new ();
	g_object_ref_sink (_tmp6_);
	entry = _tmp6_;
	_tmp7_ = id;
	entry->id = _tmp7_;
	_tmp8_ = vals;
	_tmp8__length1 = vals_length1;
	_tmp9_ = _tmp8_[0];
	_tmp10_ = int64_parse (_tmp9_);
	entry->user_id = _tmp10_;
	_tmp11_ = vals;
	_tmp11__length1 = vals_length1;
	_tmp12_ = _tmp11_[6];
	_tmp13_ = int64_parse (_tmp12_);
	entry->timestamp = _tmp13_;
	_tmp14_ = vals;
	_tmp14__length1 = vals_length1;
	_tmp15_ = _tmp14_[2];
	dm_list_entry_set_text (entry, _tmp15_);
	_tmp16_ = vals;
	_tmp16__length1 = vals_length1;
	_tmp17_ = _tmp16_[3];
	dm_list_entry_set_name (entry, _tmp17_);
	_tmp18_ = vals;
	_tmp18__length1 = vals_length1;
	_tmp19_ = _tmp18_[4];
	dm_list_entry_set_screen_name (entry, _tmp19_);
	_tmp20_ = vals;
	_tmp20__length1 = vals_length1;
	_tmp21_ = _tmp20_[5];
	_tmp22_ = g_strdup (_tmp21_);
	_g_free0 (entry->avatar_url);
	entry->avatar_url = _tmp22_;
	_tmp23_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp24_ = _tmp23_;
	entry->main_window = _tmp24_;
	dm_list_entry_load_avatar (entry);
	itwitter_item_update_time_delta (G_TYPE_CHECK_INSTANCE_CAST (entry, TYPE_ITWITTER_ITEM, ITwitterItem), _data10_->now);
	_tmp25_ = self->priv->_delta_updater;
	delta_updater_add (_tmp25_, G_TYPE_CHECK_INSTANCE_CAST (entry, TYPE_ITWITTER_ITEM, ITwitterItem));
	_tmp26_ = self->priv->messages_list;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (entry, gtk_widget_get_type (), GtkWidget));
	result = TRUE;
	_g_object_unref0 (entry);
	return result;
}


static gboolean ___lambda119__sql_select_callback (gchar** vals, int vals_length1, gpointer self) {
	gboolean result;
	result = __lambda119_ (self, vals, vals_length1);
	return result;
}


static void dm_page_load_older (DMPage* self) {
	Block10Data* _data10_;
	GDateTime* _tmp0_ = NULL;
	ScrollWidget* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	Account* _tmp3_ = NULL;
	SqlDatabase* _tmp4_ = NULL;
	SqlDatabase* _tmp5_ = NULL;
	SqlSelectStatement* _tmp6_ = NULL;
	SqlSelectStatement* _tmp7_ = NULL;
	SqlSelectStatement* _tmp8_ = NULL;
	SqlSelectStatement* _tmp9_ = NULL;
	gint64 _tmp10_ = 0LL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gint64 _tmp13_ = 0LL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gint64 _tmp16_ = 0LL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	SqlSelectStatement* _tmp21_ = NULL;
	SqlSelectStatement* _tmp22_ = NULL;
	SqlSelectStatement* _tmp23_ = NULL;
	SqlSelectStatement* _tmp24_ = NULL;
	SqlSelectStatement* _tmp25_ = NULL;
	SqlSelectStatement* _tmp26_ = NULL;
	g_return_if_fail (IS_DM_PAGE (self));
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = g_date_time_new_now_local ();
	_data10_->now = _tmp0_;
	_tmp1_ = self->priv->scroll_widget;
	scroll_widget_balance_next_upper_change (_tmp1_, TOP);
	_tmp2_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp3_ = _tmp2_;
	_tmp4_ = account_get_db (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = sql_database_select (_tmp5_, "dms");
	_tmp7_ = _tmp6_;
	_tmp8_ = sql_select_statement_cols (_tmp7_, "from_id", "to_id", "text", "from_name", "from_screen_name", "avatar_url", "timestamp", "id", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->user_id;
	_tmp11_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->user_id;
	_tmp14_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = self->priv->lowest_id;
	_tmp17_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat ("(`from_id`='", _tmp12_, "' OR `to_id`='", _tmp15_, "') AND `id` < '", _tmp18_, "'", NULL);
	_tmp20_ = _tmp19_;
	_tmp21_ = sql_select_statement_where (_tmp9_, _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = sql_select_statement_order (_tmp22_, "timestamp DESC");
	_tmp24_ = _tmp23_;
	_tmp25_ = sql_select_statement_limit (_tmp24_, 35);
	_tmp26_ = _tmp25_;
	sql_select_statement_run (_tmp26_, ___lambda119__sql_select_callback, _data10_);
	_sql_select_statement_unref0 (_tmp26_);
	_sql_select_statement_unref0 (_tmp24_);
	_sql_select_statement_unref0 (_tmp22_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp12_);
	_sql_select_statement_unref0 (_tmp9_);
	_sql_select_statement_unref0 (_tmp7_);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}


static Block11Data* block11_data_ref (Block11Data* _data11_) {
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}


static void block11_data_unref (void * _userdata_) {
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		DMPage* self;
		self = _data11_->self;
		_g_date_time_unref0 (_data11_->now);
		_g_free0 (_data11_->name);
		_g_free0 (_data11_->screen_name);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}


static void __lambda123_ (DMPage* self, GtkWidget* w) {
	GtkListBox* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = self->priv->messages_list;
	_tmp1_ = w;
	gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer), _tmp1_);
}


static void ___lambda123__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda123_ ((DMPage*) self, widget);
}


static gboolean __lambda124_ (Block11Data* _data11_, gchar** vals, int vals_length1) {
	DMPage* self;
	gboolean result = FALSE;
	gint64 id = 0LL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	const gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
	DMListEntry* entry = NULL;
	DMListEntry* _tmp6_ = NULL;
	gint64 _tmp7_ = 0LL;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	const gchar* _tmp9_ = NULL;
	gint64 _tmp10_ = 0LL;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	const gchar* _tmp12_ = NULL;
	gint64 _tmp13_ = 0LL;
	gchar** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	const gchar* _tmp15_ = NULL;
	gchar** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	const gchar* _tmp17_ = NULL;
	gchar** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	const gchar* _tmp22_ = NULL;
	gchar** _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	const gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar** _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	const gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	MainWindow* _tmp29_ = NULL;
	MainWindow* _tmp30_ = NULL;
	GDateTime* _tmp31_ = NULL;
	DeltaUpdater* _tmp32_ = NULL;
	GtkListBox* _tmp33_ = NULL;
	self = _data11_->self;
	_tmp0_ = vals;
	_tmp0__length1 = vals_length1;
	_tmp1_ = _tmp0_[7];
	_tmp2_ = int64_parse (_tmp1_);
	id = _tmp2_;
	_tmp3_ = id;
	_tmp4_ = self->priv->lowest_id;
	if (_tmp3_ < _tmp4_) {
		gint64 _tmp5_ = 0LL;
		_tmp5_ = id;
		self->priv->lowest_id = _tmp5_;
	}
	_tmp6_ = dm_list_entry_new ();
	g_object_ref_sink (_tmp6_);
	entry = _tmp6_;
	_tmp7_ = id;
	entry->id = _tmp7_;
	_tmp8_ = vals;
	_tmp8__length1 = vals_length1;
	_tmp9_ = _tmp8_[0];
	_tmp10_ = int64_parse (_tmp9_);
	entry->user_id = _tmp10_;
	_tmp11_ = vals;
	_tmp11__length1 = vals_length1;
	_tmp12_ = _tmp11_[6];
	_tmp13_ = int64_parse (_tmp12_);
	entry->timestamp = _tmp13_;
	_tmp14_ = vals;
	_tmp14__length1 = vals_length1;
	_tmp15_ = _tmp14_[2];
	dm_list_entry_set_text (entry, _tmp15_);
	_tmp16_ = vals;
	_tmp16__length1 = vals_length1;
	_tmp17_ = _tmp16_[3];
	dm_list_entry_set_name (entry, _tmp17_);
	_tmp18_ = vals;
	_tmp18__length1 = vals_length1;
	_tmp19_ = _tmp18_[3];
	_tmp20_ = g_strdup (_tmp19_);
	_g_free0 (_data11_->name);
	_data11_->name = _tmp20_;
	_tmp21_ = vals;
	_tmp21__length1 = vals_length1;
	_tmp22_ = _tmp21_[4];
	dm_list_entry_set_screen_name (entry, _tmp22_);
	_tmp23_ = vals;
	_tmp23__length1 = vals_length1;
	_tmp24_ = _tmp23_[4];
	_tmp25_ = g_strdup (_tmp24_);
	_g_free0 (_data11_->screen_name);
	_data11_->screen_name = _tmp25_;
	_tmp26_ = vals;
	_tmp26__length1 = vals_length1;
	_tmp27_ = _tmp26_[5];
	_tmp28_ = g_strdup (_tmp27_);
	_g_free0 (entry->avatar_url);
	entry->avatar_url = _tmp28_;
	_tmp29_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp30_ = _tmp29_;
	entry->main_window = _tmp30_;
	dm_list_entry_load_avatar (entry);
	_tmp31_ = _data11_->now;
	itwitter_item_update_time_delta (G_TYPE_CHECK_INSTANCE_CAST (entry, TYPE_ITWITTER_ITEM, ITwitterItem), _tmp31_);
	_tmp32_ = self->priv->_delta_updater;
	delta_updater_add (_tmp32_, G_TYPE_CHECK_INSTANCE_CAST (entry, TYPE_ITWITTER_ITEM, ITwitterItem));
	_tmp33_ = self->priv->messages_list;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (entry, gtk_widget_get_type (), GtkWidget));
	result = TRUE;
	_g_object_unref0 (entry);
	return result;
}


static gboolean ___lambda124__sql_select_callback (gchar** vals, int vals_length1, gpointer self) {
	gboolean result;
	result = __lambda124_ (self, vals, vals_length1);
	return result;
}


static void dm_page_real_on_join (IPage* base, gint page_id, Bundle* args) {
	DMPage * self;
	Block11Data* _data11_;
	gint64 user_id = 0LL;
	Bundle* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	Bundle* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	CompletionTextView* _tmp17_ = NULL;
	Account* _tmp18_ = NULL;
	Account* _tmp19_ = NULL;
	GtkListBox* _tmp20_ = NULL;
	DMThreadsPage* threads_page = NULL;
	MainWindow* _tmp21_ = NULL;
	MainWindow* _tmp22_ = NULL;
	IPage* _tmp23_ = NULL;
	DMThreadsPage* _tmp24_ = NULL;
	gint64 _tmp25_ = 0LL;
	GDateTime* _tmp26_ = NULL;
	Account* _tmp27_ = NULL;
	Account* _tmp28_ = NULL;
	SqlDatabase* _tmp29_ = NULL;
	SqlDatabase* _tmp30_ = NULL;
	SqlSelectStatement* _tmp31_ = NULL;
	SqlSelectStatement* _tmp32_ = NULL;
	SqlSelectStatement* _tmp33_ = NULL;
	SqlSelectStatement* _tmp34_ = NULL;
	gint64 _tmp35_ = 0LL;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gint64 _tmp38_ = 0LL;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	SqlSelectStatement* _tmp43_ = NULL;
	SqlSelectStatement* _tmp44_ = NULL;
	SqlSelectStatement* _tmp45_ = NULL;
	SqlSelectStatement* _tmp46_ = NULL;
	SqlSelectStatement* _tmp47_ = NULL;
	SqlSelectStatement* _tmp48_ = NULL;
	Account* _tmp49_ = NULL;
	Account* _tmp50_ = NULL;
	UserCounter* _tmp51_ = NULL;
	UserCounter* _tmp52_ = NULL;
	gint64 _tmp53_ = 0LL;
	const gchar* _tmp54_ = NULL;
	const gchar* _tmp55_ = NULL;
	ScrollWidget* _tmp56_ = NULL;
	CompletionTextView* _tmp57_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_PAGE, DMPage);
	g_return_if_fail ((args == NULL) || IS_BUNDLE (args));
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_tmp0_ = args;
	_tmp1_ = bundle_get_int64 (_tmp0_, "sender_id");
	user_id = _tmp1_;
	_tmp2_ = user_id;
	if (_tmp2_ == ((gint64) 0)) {
		block11_data_unref (_data11_);
		_data11_ = NULL;
		return;
	}
	self->priv->lowest_id = G_MAXINT64;
	_tmp3_ = user_id;
	self->user_id = _tmp3_;
	_data11_->name = NULL;
	_tmp4_ = args;
	_tmp5_ = bundle_get_string (_tmp4_, "screen_name");
	_g_free0 (_data11_->screen_name);
	_data11_->screen_name = _tmp5_;
	_tmp6_ = _data11_->screen_name;
	if (_tmp6_ != NULL) {
		Bundle* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		DMPlaceholderBox* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		DMPlaceholderBox* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		DMPlaceholderBox* _tmp13_ = NULL;
		Bundle* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		DMPlaceholderBox* _tmp16_ = NULL;
		_tmp7_ = args;
		_tmp8_ = bundle_get_string (_tmp7_, "name");
		_g_free0 (_data11_->name);
		_data11_->name = _tmp8_;
		_tmp9_ = self->priv->placeholder_box;
		_tmp10_ = _data11_->screen_name;
		dm_placeholder_box_set_screen_name (_tmp9_, _tmp10_);
		_tmp11_ = self->priv->placeholder_box;
		_tmp12_ = _data11_->name;
		dm_placeholder_box_set_name (_tmp11_, _tmp12_);
		_tmp13_ = self->priv->placeholder_box;
		_tmp14_ = args;
		_tmp15_ = bundle_get_string (_tmp14_, "avatar_url");
		_g_free0 (_tmp13_->avatar_url);
		_tmp13_->avatar_url = _tmp15_;
		_tmp16_ = self->priv->placeholder_box;
		dm_placeholder_box_load_avatar (_tmp16_);
	}
	_tmp17_ = self->priv->text_view;
	_tmp18_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp19_ = _tmp18_;
	completion_text_view_set_account (_tmp17_, _tmp19_);
	_tmp20_ = self->priv->messages_list;
	gtk_container_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_container_get_type (), GtkContainer), ___lambda123__gtk_callback, self);
	_tmp21_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp22_ = _tmp21_;
	_tmp23_ = main_window_get_page (_tmp22_, (gint) PAGE_DM_THREADS);
	threads_page = G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	_tmp24_ = threads_page;
	_tmp25_ = user_id;
	dm_threads_page_adjust_unread_count_for_user_id (_tmp24_, _tmp25_);
	_tmp26_ = g_date_time_new_now_local ();
	_data11_->now = _tmp26_;
	_tmp27_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp28_ = _tmp27_;
	_tmp29_ = account_get_db (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = sql_database_select (_tmp30_, "dms");
	_tmp32_ = _tmp31_;
	_tmp33_ = sql_select_statement_cols (_tmp32_, "from_id", "to_id", "text", "from_name", "from_screen_name", "avatar_url", "timestamp", "id", NULL);
	_tmp34_ = _tmp33_;
	_tmp35_ = user_id;
	_tmp36_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = user_id;
	_tmp39_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = g_strconcat ("`from_id`='", _tmp37_, "' OR `to_id`='", _tmp40_, "'", NULL);
	_tmp42_ = _tmp41_;
	_tmp43_ = sql_select_statement_where (_tmp34_, _tmp42_);
	_tmp44_ = _tmp43_;
	_tmp45_ = sql_select_statement_order (_tmp44_, "timestamp DESC");
	_tmp46_ = _tmp45_;
	_tmp47_ = sql_select_statement_limit (_tmp46_, 35);
	_tmp48_ = _tmp47_;
	sql_select_statement_run (_tmp48_, ___lambda124__sql_select_callback, _data11_);
	_sql_select_statement_unref0 (_tmp48_);
	_sql_select_statement_unref0 (_tmp46_);
	_sql_select_statement_unref0 (_tmp44_);
	_g_free0 (_tmp42_);
	_g_free0 (_tmp40_);
	_g_free0 (_tmp37_);
	_sql_select_statement_unref0 (_tmp34_);
	_sql_select_statement_unref0 (_tmp32_);
	_tmp49_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp50_ = _tmp49_;
	_tmp51_ = account_get_user_counter (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = user_id;
	_tmp54_ = _data11_->screen_name;
	_tmp55_ = _data11_->name;
	user_counter_user_seen (_tmp52_, _tmp53_, _tmp54_, _tmp55_);
	_tmp56_ = self->priv->scroll_widget;
	scroll_widget_scroll_down_next (_tmp56_, FALSE, TRUE);
	_tmp57_ = self->priv->text_view;
	gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (threads_page);
	block11_data_unref (_data11_);
	_data11_ = NULL;
}


static void dm_page_real_on_leave (IPage* base) {
	DMPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_PAGE, DMPage);
}


static Block12Data* block12_data_ref (Block12Data* _data12_) {
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}


static void block12_data_unref (void * _userdata_) {
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		DMPage* self;
		self = _data12_->self;
		_g_object_unref0 (_data12_->call);
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}


static void __lambda125_ (Block12Data* _data12_, GObject* obj, GAsyncResult* res) {
	DMPage* self;
	GError * _inner_error_ = NULL;
	self = _data12_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = _data12_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		RestProxyCall* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _data12_->call;
		_tmp3_ = rest_proxy_call_get_payload (_tmp2_);
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		utils_show_error_object (_tmp3_, _tmp5_, 226, "DMPage.vala");
		_g_error_free0 (e);
		return;
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda125__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda125_ (self, source_object, res);
	block12_data_unref (self);
}


static void dm_page_send_button_clicked_cb (DMPage* self) {
	Block12Data* _data12_;
	gboolean _tmp0_ = FALSE;
	CompletionTextView* _tmp1_ = NULL;
	GtkTextBuffer* _tmp2_ = NULL;
	GtkTextBuffer* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
	DMThreadsPage* threads_page = NULL;
	MainWindow* _tmp18_ = NULL;
	MainWindow* _tmp19_ = NULL;
	IPage* _tmp20_ = NULL;
	gchar* notification_id = NULL;
	DMThreadsPage* _tmp21_ = NULL;
	gint64 _tmp22_ = 0LL;
	gchar* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	DMListEntry* entry = NULL;
	DMListEntry* _tmp27_ = NULL;
	DMListEntry* _tmp28_ = NULL;
	Account* _tmp29_ = NULL;
	Account* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	DMListEntry* _tmp33_ = NULL;
	GDateTime* _tmp34_ = NULL;
	GDateTime* _tmp35_ = NULL;
	gint64 _tmp36_ = 0LL;
	DMListEntry* _tmp37_ = NULL;
	CompletionTextView* _tmp38_ = NULL;
	GtkTextBuffer* _tmp39_ = NULL;
	GtkTextBuffer* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	DMListEntry* _tmp44_ = NULL;
	Account* _tmp45_ = NULL;
	Account* _tmp46_ = NULL;
	const gchar* _tmp47_ = NULL;
	const gchar* _tmp48_ = NULL;
	DMListEntry* _tmp49_ = NULL;
	Account* _tmp50_ = NULL;
	Account* _tmp51_ = NULL;
	GdkPixbuf* _tmp52_ = NULL;
	GdkPixbuf* _tmp53_ = NULL;
	DMListEntry* _tmp54_ = NULL;
	DeltaUpdater* _tmp55_ = NULL;
	DMListEntry* _tmp56_ = NULL;
	GtkListBox* _tmp57_ = NULL;
	DMListEntry* _tmp58_ = NULL;
	Account* _tmp59_ = NULL;
	Account* _tmp60_ = NULL;
	OAuthProxy* _tmp61_ = NULL;
	OAuthProxy* _tmp62_ = NULL;
	RestProxyCall* _tmp63_ = NULL;
	RestProxyCall* _tmp64_ = NULL;
	RestProxyCall* _tmp65_ = NULL;
	RestProxyCall* _tmp66_ = NULL;
	gint64 _tmp67_ = 0LL;
	gchar* _tmp68_ = NULL;
	gchar* _tmp69_ = NULL;
	RestProxyCall* _tmp70_ = NULL;
	CompletionTextView* _tmp71_ = NULL;
	GtkTextBuffer* _tmp72_ = NULL;
	GtkTextBuffer* _tmp73_ = NULL;
	gchar* _tmp74_ = NULL;
	gchar* _tmp75_ = NULL;
	gchar* _tmp76_ = NULL;
	RestProxyCall* _tmp77_ = NULL;
	CompletionTextView* _tmp78_ = NULL;
	GtkTextBuffer* _tmp79_ = NULL;
	GtkTextBuffer* _tmp80_ = NULL;
	ScrollWidget* _tmp81_ = NULL;
	gboolean _tmp82_ = FALSE;
	gboolean _tmp83_ = FALSE;
	g_return_if_fail (IS_DM_PAGE (self));
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	_tmp1_ = self->priv->text_view;
	_tmp2_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_text_view_get_type (), GtkTextView));
	_tmp3_ = _tmp2_;
	g_object_get (_tmp3_, "text", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = strlen (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_ == 0;
	_g_free0 (_tmp6_);
	if (_tmp9_) {
		_tmp0_ = TRUE;
	} else {
		CompletionTextView* _tmp10_ = NULL;
		GtkTextBuffer* _tmp11_ = NULL;
		GtkTextBuffer* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		_tmp10_ = self->priv->text_view;
		_tmp11_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_text_view_get_type (), GtkTextView));
		_tmp12_ = _tmp11_;
		g_object_get (_tmp12_, "text", &_tmp13_, NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_;
		_tmp16_ = strlen (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp0_ = _tmp17_ > TWEET_MAX_LENGTH;
		_g_free0 (_tmp15_);
	}
	if (_tmp0_) {
		block12_data_unref (_data12_);
		_data12_ = NULL;
		return;
	}
	_tmp18_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp19_ = _tmp18_;
	_tmp20_ = main_window_get_page (_tmp19_, (gint) PAGE_DM_THREADS);
	threads_page = G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	_tmp21_ = threads_page;
	_tmp22_ = self->user_id;
	_tmp23_ = dm_threads_page_get_notification_id_for_user_id (_tmp21_, _tmp22_);
	notification_id = _tmp23_;
	_tmp24_ = notification_id;
	if (_tmp24_ != NULL) {
		GApplication* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		_tmp25_ = g_application_get_default ();
		_tmp26_ = notification_id;
		g_application_withdraw_notification (_tmp25_, _tmp26_);
	}
	_tmp27_ = dm_list_entry_new ();
	g_object_ref_sink (_tmp27_);
	entry = _tmp27_;
	_tmp28_ = entry;
	_tmp29_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp30_ = _tmp29_;
	_tmp31_ = account_get_screen_name (_tmp30_);
	_tmp32_ = _tmp31_;
	dm_list_entry_set_screen_name (_tmp28_, _tmp32_);
	_tmp33_ = entry;
	_tmp34_ = g_date_time_new_now_local ();
	_tmp35_ = _tmp34_;
	_tmp36_ = g_date_time_to_unix (_tmp35_);
	_tmp33_->timestamp = _tmp36_;
	_g_date_time_unref0 (_tmp35_);
	_tmp37_ = entry;
	_tmp38_ = self->priv->text_view;
	_tmp39_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, gtk_text_view_get_type (), GtkTextView));
	_tmp40_ = _tmp39_;
	g_object_get (_tmp40_, "text", &_tmp41_, NULL);
	_tmp42_ = _tmp41_;
	_tmp43_ = _tmp42_;
	dm_list_entry_set_text (_tmp37_, _tmp43_);
	_g_free0 (_tmp43_);
	_tmp44_ = entry;
	_tmp45_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp46_ = _tmp45_;
	_tmp47_ = account_get_name (_tmp46_);
	_tmp48_ = _tmp47_;
	dm_list_entry_set_name (_tmp44_, _tmp48_);
	_tmp49_ = entry;
	_tmp50_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp51_ = _tmp50_;
	_tmp52_ = account_get_avatar (_tmp51_);
	_tmp53_ = _tmp52_;
	dm_list_entry_set_avatar (_tmp49_, _tmp53_);
	_tmp54_ = entry;
	itwitter_item_update_time_delta (G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, TYPE_ITWITTER_ITEM, ITwitterItem), NULL);
	_tmp55_ = self->priv->_delta_updater;
	_tmp56_ = entry;
	delta_updater_add (_tmp55_, G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, TYPE_ITWITTER_ITEM, ITwitterItem));
	_tmp57_ = self->priv->messages_list;
	_tmp58_ = entry;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, gtk_widget_get_type (), GtkWidget));
	_tmp59_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp60_ = _tmp59_;
	_tmp61_ = account_get_proxy (_tmp60_);
	_tmp62_ = _tmp61_;
	_tmp63_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, rest_proxy_get_type (), RestProxy));
	_data12_->call = _tmp63_;
	_tmp64_ = _data12_->call;
	rest_proxy_call_set_function (_tmp64_, "1.1/direct_messages/new.json");
	_tmp65_ = _data12_->call;
	rest_proxy_call_set_method (_tmp65_, "POST");
	_tmp66_ = _data12_->call;
	_tmp67_ = self->user_id;
	_tmp68_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp67_);
	_tmp69_ = _tmp68_;
	rest_proxy_call_add_param (_tmp66_, "user_id", _tmp69_);
	_g_free0 (_tmp69_);
	_tmp70_ = _data12_->call;
	_tmp71_ = self->priv->text_view;
	_tmp72_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, gtk_text_view_get_type (), GtkTextView));
	_tmp73_ = _tmp72_;
	g_object_get (_tmp73_, "text", &_tmp74_, NULL);
	_tmp75_ = _tmp74_;
	_tmp76_ = _tmp75_;
	rest_proxy_call_add_param (_tmp70_, "text", _tmp76_);
	_g_free0 (_tmp76_);
	_tmp77_ = _data12_->call;
	rest_proxy_call_invoke_async (_tmp77_, NULL, ___lambda125__gasync_ready_callback, block12_data_ref (_data12_));
	_tmp78_ = self->priv->text_view;
	_tmp79_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, gtk_text_view_get_type (), GtkTextView));
	_tmp80_ = _tmp79_;
	g_object_set (_tmp80_, "text", "", NULL);
	_tmp81_ = self->priv->scroll_widget;
	_tmp82_ = scroll_widget_get_scrolled_down (_tmp81_);
	_tmp83_ = _tmp82_;
	if (_tmp83_) {
		ScrollWidget* _tmp84_ = NULL;
		_tmp84_ = self->priv->scroll_widget;
		scroll_widget_scroll_down_next (_tmp84_, TRUE, FALSE);
	}
	_g_object_unref0 (entry);
	_g_free0 (notification_id);
	_g_object_unref0 (threads_page);
	block12_data_unref (_data12_);
	_data12_ = NULL;
}


static void _dm_page_send_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	dm_page_send_button_clicked_cb ((DMPage*) self);
}


static gboolean dm_page_text_view_key_press_cb (DMPage* self, GdkEventKey* evt) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventKey* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	g_return_val_if_fail (IS_DM_PAGE (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp1_ = evt;
	_tmp2_ = _tmp1_->keyval;
	if (_tmp2_ == ((guint) GDK_KEY_Return)) {
		GdkEventKey* _tmp3_ = NULL;
		GdkModifierType _tmp4_ = 0;
		_tmp3_ = evt;
		_tmp4_ = _tmp3_->state;
		_tmp0_ = (_tmp4_ & GDK_CONTROL_MASK) == GDK_CONTROL_MASK;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		dm_page_send_button_clicked_cb (self);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean _dm_page_text_view_key_press_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = dm_page_text_view_key_press_cb ((DMPage*) self, event);
	return result;
}


static void dm_page_recalc_length (DMPage* self) {
	guint text_length = 0U;
	CompletionTextView* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkTextBuffer* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	guint _tmp8_ = 0U;
	gboolean _tmp9_ = FALSE;
	guint _tmp10_ = 0U;
	GtkButton* _tmp12_ = NULL;
	g_return_if_fail (IS_DM_PAGE (self));
	_tmp0_ = self->priv->text_view;
	_tmp1_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_text_view_get_type (), GtkTextView));
	_tmp2_ = _tmp1_;
	g_object_get (_tmp2_, "text", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = (guint) _tmp7_;
	_g_free0 (_tmp5_);
	text_length = _tmp8_;
	_tmp10_ = text_length;
	if (_tmp10_ > ((guint) 0)) {
		guint _tmp11_ = 0U;
		_tmp11_ = text_length;
		_tmp9_ = _tmp11_ < ((guint) 140);
	} else {
		_tmp9_ = FALSE;
	}
	_tmp12_ = self->priv->send_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget), _tmp9_);
}


static gchar* dm_page_real_get_title (IPage* base) {
	DMPage * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_PAGE, DMPage);
	_tmp0_ = _ ("Direct Conversation");
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void dm_page_real_create_tool_button (IPage* base, GtkRadioButton* group) {
	DMPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_PAGE, DMPage);
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
}


static GtkRadioButton* dm_page_real_get_tool_button (IPage* base) {
	DMPage * self;
	GtkRadioButton* result = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_PAGE, DMPage);
	result = NULL;
	return result;
}


gint dm_page_get_unread_count (DMPage* self) {
	gint result;
	g_return_val_if_fail (IS_DM_PAGE (self), 0);
	result = 0;
	return result;
}


static MainWindow* dm_page_real_get_main_window (IPage* base) {
	MainWindow* result;
	DMPage* self;
	MainWindow* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_PAGE, DMPage);
	_tmp0_ = self->priv->_main_window;
	result = _tmp0_;
	return result;
}


static void dm_page_real_set_main_window (IPage* base, MainWindow* value) {
	DMPage* self;
	MainWindow* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_PAGE, DMPage);
	_tmp0_ = value;
	self->priv->_main_window = _tmp0_;
	g_object_notify ((GObject *) self, "main-window");
}


static Account* dm_page_real_get_account (IPage* base) {
	Account* result;
	DMPage* self;
	Account* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_PAGE, DMPage);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}


static void dm_page_real_set_account (IPage* base, Account* value) {
	DMPage* self;
	Account* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_PAGE, DMPage);
	_tmp0_ = value;
	self->priv->_account = _tmp0_;
	g_object_notify ((GObject *) self, "account");
}


DeltaUpdater* dm_page_get_delta_updater (DMPage* self) {
	DeltaUpdater* result;
	DeltaUpdater* _tmp0_ = NULL;
	g_return_val_if_fail (IS_DM_PAGE (self), NULL);
	_tmp0_ = self->priv->_delta_updater;
	result = _tmp0_;
	return result;
}


void dm_page_set_delta_updater (DMPage* self, DeltaUpdater* value) {
	DeltaUpdater* _tmp0_ = NULL;
	g_return_if_fail (IS_DM_PAGE (self));
	_tmp0_ = value;
	self->priv->_delta_updater = _tmp0_;
	g_object_notify ((GObject *) self, "delta-updater");
}


static gint dm_page_real_get_id (IPage* base) {
	gint result;
	DMPage* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_PAGE, DMPage);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void dm_page_real_set_id (IPage* base, gint value) {
	DMPage* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_PAGE, DMPage);
	_tmp0_ = value;
	self->priv->_id = _tmp0_;
	g_object_notify ((GObject *) self, "id");
}


static void dm_page_class_init (DMPageClass * klass) {
	gint DMPage_private_offset;
	dm_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DMPagePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dm_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dm_page_set_property;
	G_OBJECT_CLASS (klass)->finalize = dm_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_PAGE_UNREAD_COUNT, g_param_spec_int ("unread-count", "unread-count", "unread-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_PAGE_MAIN_WINDOW, g_param_spec_object ("main-window", "main-window", "main-window", TYPE_MAIN_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_PAGE_ACCOUNT, g_param_spec_object ("account", "account", "account", TYPE_ACCOUNT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_PAGE_DELTA_UPDATER, g_param_spec_object ("delta-updater", "delta-updater", "delta-updater", TYPE_DELTA_UPDATER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_PAGE_ID, g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	DMPage_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/dm-page.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "send_button", FALSE, DMPage_private_offset + G_STRUCT_OFFSET (DMPagePrivate, send_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "text_view", FALSE, DMPage_private_offset + G_STRUCT_OFFSET (DMPagePrivate, text_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "messages_list", FALSE, DMPage_private_offset + G_STRUCT_OFFSET (DMPagePrivate, messages_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scroll_widget", FALSE, DMPage_private_offset + G_STRUCT_OFFSET (DMPagePrivate, scroll_widget));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "send_button_clicked_cb", G_CALLBACK(_dm_page_send_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "text_view_key_press_cb", G_CALLBACK(_dm_page_text_view_key_press_cb_gtk_widget_key_press_event));
}


static void dm_page_ipage_interface_init (IPageIface * iface) {
	dm_page_ipage_parent_iface = g_type_interface_peek_parent (iface);
	iface->on_join = (void (*)(IPage*, gint, Bundle*)) dm_page_real_on_join;
	iface->on_leave = (void (*)(IPage*)) dm_page_real_on_leave;
	iface->get_title = (gchar* (*)(IPage*)) dm_page_real_get_title;
	iface->create_tool_button = (void (*)(IPage*, GtkRadioButton*)) dm_page_real_create_tool_button;
	iface->get_tool_button = (GtkRadioButton* (*)(IPage*)) dm_page_real_get_tool_button;
	iface->get_main_window = dm_page_real_get_main_window;
	iface->set_main_window = dm_page_real_set_main_window;
	iface->get_account = dm_page_real_get_account;
	iface->set_account = dm_page_real_set_account;
	iface->get_id = dm_page_real_get_id;
	iface->set_id = dm_page_real_set_id;
}


static void dm_page_imessage_receiver_interface_init (IMessageReceiverIface * iface) {
	dm_page_imessage_receiver_parent_iface = g_type_interface_peek_parent (iface);
	iface->stream_message_received = (void (*)(IMessageReceiver*, StreamMessageType, JsonNode*)) dm_page_real_stream_message_received;
}


static void dm_page_instance_init (DMPage * self) {
	DMPlaceholderBox* _tmp0_ = NULL;
	self->priv = DM_PAGE_GET_PRIVATE (self);
	_tmp0_ = dm_placeholder_box_new ();
	g_object_ref_sink (_tmp0_);
	self->priv->placeholder_box = _tmp0_;
	self->priv->lowest_id = G_MAXINT64;
	g_type_ensure (TYPE_SCROLL_WIDGET);
	g_type_ensure (TYPE_COMPLETION_TEXT_VIEW);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void dm_page_finalize (GObject* obj) {
	DMPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DM_PAGE, DMPage);
	_g_object_unref0 (self->priv->send_button);
	_g_object_unref0 (self->priv->text_view);
	_g_object_unref0 (self->priv->messages_list);
	_g_object_unref0 (self->priv->scroll_widget);
	_g_object_unref0 (self->priv->placeholder_box);
	G_OBJECT_CLASS (dm_page_parent_class)->finalize (obj);
}


GType dm_page_get_type (void) {
	static volatile gsize dm_page_type_id__volatile = 0;
	if (g_once_init_enter (&dm_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DMPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dm_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DMPage), 0, (GInstanceInitFunc) dm_page_instance_init, NULL };
		static const GInterfaceInfo ipage_info = { (GInterfaceInitFunc) dm_page_ipage_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo imessage_receiver_info = { (GInterfaceInitFunc) dm_page_imessage_receiver_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dm_page_type_id;
		dm_page_type_id = g_type_register_static (gtk_box_get_type (), "DMPage", &g_define_type_info, 0);
		g_type_add_interface_static (dm_page_type_id, TYPE_IPAGE, &ipage_info);
		g_type_add_interface_static (dm_page_type_id, TYPE_IMESSAGE_RECEIVER, &imessage_receiver_info);
		g_once_init_leave (&dm_page_type_id__volatile, dm_page_type_id);
	}
	return dm_page_type_id__volatile;
}


static void _vala_dm_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DMPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DM_PAGE, DMPage);
	switch (property_id) {
		case DM_PAGE_UNREAD_COUNT:
		g_value_set_int (value, dm_page_get_unread_count (self));
		break;
		case DM_PAGE_MAIN_WINDOW:
		g_value_set_object (value, ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		case DM_PAGE_ACCOUNT:
		g_value_set_object (value, ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		case DM_PAGE_DELTA_UPDATER:
		g_value_set_object (value, dm_page_get_delta_updater (self));
		break;
		case DM_PAGE_ID:
		g_value_set_int (value, ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dm_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DMPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DM_PAGE, DMPage);
	switch (property_id) {
		case DM_PAGE_MAIN_WINDOW:
		ipage_set_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		case DM_PAGE_ACCOUNT:
		ipage_set_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		case DM_PAGE_DELTA_UPDATER:
		dm_page_set_delta_updater (self, g_value_get_object (value));
		break;
		case DM_PAGE_ID:
		ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



