/* user-segment-dictionary.c generated by valac 0.38.8, the Vala compiler
 * generated from user-segment-dictionary.vala, do not modify */

/*
 * Copyright (C) 2011-2014 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2014 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib/gstdio.h>


#define KKC_TYPE_DICTIONARY (kkc_dictionary_get_type ())
#define KKC_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_DICTIONARY, KkcDictionary))
#define KKC_IS_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_DICTIONARY))
#define KKC_DICTIONARY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_DICTIONARY, KkcDictionaryIface))

typedef struct _KkcDictionary KkcDictionary;
typedef struct _KkcDictionaryIface KkcDictionaryIface;

#define KKC_TYPE_SEGMENT_DICTIONARY (kkc_segment_dictionary_get_type ())
#define KKC_SEGMENT_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_SEGMENT_DICTIONARY, KkcSegmentDictionary))
#define KKC_IS_SEGMENT_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_SEGMENT_DICTIONARY))
#define KKC_SEGMENT_DICTIONARY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_SEGMENT_DICTIONARY, KkcSegmentDictionaryIface))

typedef struct _KkcSegmentDictionary KkcSegmentDictionary;
typedef struct _KkcSegmentDictionaryIface KkcSegmentDictionaryIface;

#define KKC_TYPE_CANDIDATE (kkc_candidate_get_type ())
#define KKC_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_CANDIDATE, KkcCandidate))
#define KKC_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_CANDIDATE, KkcCandidateClass))
#define KKC_IS_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_CANDIDATE))
#define KKC_IS_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_CANDIDATE))
#define KKC_CANDIDATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_CANDIDATE, KkcCandidateClass))

typedef struct _KkcCandidate KkcCandidate;
typedef struct _KkcCandidateClass KkcCandidateClass;

#define KKC_TYPE_USER_SEGMENT_DICTIONARY (kkc_user_segment_dictionary_get_type ())
#define KKC_USER_SEGMENT_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_USER_SEGMENT_DICTIONARY, KkcUserSegmentDictionary))
#define KKC_USER_SEGMENT_DICTIONARY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_USER_SEGMENT_DICTIONARY, KkcUserSegmentDictionaryClass))
#define KKC_IS_USER_SEGMENT_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_USER_SEGMENT_DICTIONARY))
#define KKC_IS_USER_SEGMENT_DICTIONARY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_USER_SEGMENT_DICTIONARY))
#define KKC_USER_SEGMENT_DICTIONARY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_USER_SEGMENT_DICTIONARY, KkcUserSegmentDictionaryClass))

typedef struct _KkcUserSegmentDictionary KkcUserSegmentDictionary;
typedef struct _KkcUserSegmentDictionaryClass KkcUserSegmentDictionaryClass;
typedef struct _KkcUserSegmentDictionaryPrivate KkcUserSegmentDictionaryPrivate;
enum  {
	KKC_USER_SEGMENT_DICTIONARY_0_PROPERTY,
	KKC_USER_SEGMENT_DICTIONARY_NUM_PROPERTIES
};
static GParamSpec* kkc_user_segment_dictionary_properties[KKC_USER_SEGMENT_DICTIONARY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _KkcDictionaryIface {
	GTypeInterface parent_iface;
	void (*reload) (KkcDictionary* self, GError** error);
	void (*save) (KkcDictionary* self, GError** error);
};

struct _KkcSegmentDictionaryIface {
	GTypeInterface parent_iface;
	gboolean (*lookup_candidates) (KkcSegmentDictionary* self, const gchar* midasi, gboolean okuri, KkcCandidate*** candidates, int* candidates_length1);
	gchar** (*complete) (KkcSegmentDictionary* self, const gchar* midasi, int* result_length1);
	gboolean (*select_candidate) (KkcSegmentDictionary* self, KkcCandidate* candidate);
	gboolean (*purge_candidate) (KkcSegmentDictionary* self, KkcCandidate* candidate);
};

struct _KkcUserSegmentDictionary {
	GObject parent_instance;
	KkcUserSegmentDictionaryPrivate * priv;
};

struct _KkcUserSegmentDictionaryClass {
	GObjectClass parent_class;
};

struct _KkcUserSegmentDictionaryPrivate {
	GFile* file;
	gchar* etag;
	GeeMap* okuri_ari_entries;
	GeeMap* okuri_nasi_entries;
	gboolean is_dirty;
};

typedef enum  {
	KKC_DICTIONARY_ERROR_NOT_READABLE,
	KKC_DICTIONARY_ERROR_MALFORMED_INPUT
} KkcDictionaryError;
#define KKC_DICTIONARY_ERROR kkc_dictionary_error_quark ()

static gpointer kkc_user_segment_dictionary_parent_class = NULL;
static KkcDictionaryIface * kkc_user_segment_dictionary_kkc_dictionary_parent_iface = NULL;
static KkcSegmentDictionaryIface * kkc_user_segment_dictionary_kkc_segment_dictionary_parent_iface = NULL;

GType kkc_dictionary_get_type (void) G_GNUC_CONST;
GType kkc_candidate_get_type (void) G_GNUC_CONST;
GType kkc_segment_dictionary_get_type (void) G_GNUC_CONST;
GType kkc_user_segment_dictionary_get_type (void) G_GNUC_CONST;
#define KKC_USER_SEGMENT_DICTIONARY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KKC_TYPE_USER_SEGMENT_DICTIONARY, KkcUserSegmentDictionaryPrivate))
static void kkc_user_segment_dictionary_load (KkcUserSegmentDictionary* self, GError** error);
static guint8* _vala_array_dup3 (guint8* self, int length);
GQuark kkc_dictionary_error_quark (void);
gchar* kkc_dictionary_utils_unescape (const gchar* input);
KkcCandidate** kkc_dictionary_utils_split_candidates (const gchar* midasi, gboolean okuri, const gchar* line, int* result_length1);
static void kkc_user_segment_dictionary_real_reload (KkcDictionary* base, GError** error);
static gint kkc_user_segment_dictionary_compare_entry_asc (GeeMapEntry* a, GeeMapEntry* b);
static gint kkc_user_segment_dictionary_compare_entry_dsc (GeeMapEntry* a, GeeMapEntry* b);
static void kkc_user_segment_dictionary_write_entries (KkcUserSegmentDictionary* self, GString* builder, GeeList* entries);
gchar* kkc_dictionary_utils_escape (const gchar* input);
gchar* kkc_dictionary_utils_join_candidates (KkcCandidate** candidates, int candidates_length1);
static void kkc_user_segment_dictionary_real_save (KkcDictionary* base, GError** error);
static gint _kkc_user_segment_dictionary_compare_entry_dsc_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
static gint _kkc_user_segment_dictionary_compare_entry_asc_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
static GeeMap* kkc_user_segment_dictionary_get_entries (KkcUserSegmentDictionary* self, gboolean okuri);
static gboolean kkc_user_segment_dictionary_real_lookup_candidates (KkcSegmentDictionary* base, const gchar* midasi, gboolean okuri, KkcCandidate*** candidates, int* candidates_length1);
static gchar** kkc_user_segment_dictionary_real_complete (KkcSegmentDictionary* base, const gchar* midasi, int* result_length1);
static gboolean kkc_user_segment_dictionary_real_select_candidate (KkcSegmentDictionary* base, KkcCandidate* candidate);
gboolean kkc_candidate_get_okuri (KkcCandidate* self);
const gchar* kkc_candidate_get_midasi (KkcCandidate* self);
static gboolean kkc_user_segment_dictionary_real_purge_candidate (KkcSegmentDictionary* base, KkcCandidate* candidate);
const gchar* kkc_candidate_get_text (KkcCandidate* self);
KkcUserSegmentDictionary* kkc_user_segment_dictionary_new (const gchar* path, GError** error);
KkcUserSegmentDictionary* kkc_user_segment_dictionary_construct (GType object_type, const gchar* path, GError** error);
void kkc_dictionary_reload (KkcDictionary* self, GError** error);
static void kkc_user_segment_dictionary_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static guint8* _vala_array_dup3 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void kkc_user_segment_dictionary_load (KkcUserSegmentDictionary* self, GError** error) {
	guint8* contents = NULL;
	gint contents_length1 = 0;
	gint _contents_size_ = 0;
	GFile* _tmp0_;
	guint8* _tmp1_ = NULL;
	gsize _tmp2_;
	gchar* _tmp3_ = NULL;
	GMemoryInputStream* memory = NULL;
	guint8* _tmp4_;
	gint _tmp4__length1;
	guint8* _tmp5_;
	gint _tmp5__length1;
	GDestroyNotify _tmp6_;
	GMemoryInputStream* _tmp7_;
	GDataInputStream* data = NULL;
	GMemoryInputStream* _tmp8_;
	GDataInputStream* _tmp9_;
	gchar* line = NULL;
	gsize length = 0UL;
	gchar* _tmp10_ = NULL;
	GDataInputStream* _tmp11_;
	gsize _tmp12_ = 0UL;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	GeeMap* entries = NULL;
	GeeMap* _tmp27_;
	gboolean okuri = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->file;
	g_file_load_contents (_tmp0_, NULL, &_tmp1_, &_tmp2_, &_tmp3_, &_inner_error_);
	contents = (g_free (contents), NULL);
	contents = _tmp1_;
	contents_length1 = _tmp2_;
	_contents_size_ = contents_length1;
	_g_free0 (self->priv->etag);
	self->priv->etag = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		contents = (g_free (contents), NULL);
		return;
	}
	_tmp4_ = contents;
	_tmp4__length1 = contents_length1;
	_tmp5_ = (_tmp4_ != NULL) ? _vala_array_dup3 (_tmp4_, _tmp4__length1) : ((gpointer) _tmp4_);
	_tmp5__length1 = _tmp4__length1;
	_tmp6_ = g_free;
	_tmp7_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp5_, _tmp5__length1, _tmp6_);
	memory = _tmp7_;
	_tmp8_ = memory;
	_tmp9_ = g_data_input_stream_new ((GInputStream*) _tmp8_);
	data = _tmp9_;
	line = NULL;
	_tmp11_ = data;
	_tmp13_ = g_data_input_stream_read_line (_tmp11_, &_tmp12_, NULL, &_inner_error_);
	length = _tmp12_;
	_tmp10_ = _tmp13_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (line);
		_g_object_unref0 (data);
		_g_object_unref0 (memory);
		contents = (g_free (contents), NULL);
		return;
	}
	_tmp14_ = _tmp10_;
	_tmp10_ = NULL;
	_g_free0 (line);
	line = _tmp14_;
	_tmp15_ = line;
	if (_tmp15_ == NULL) {
		_g_free0 (_tmp10_);
		_g_free0 (line);
		_g_object_unref0 (data);
		_g_object_unref0 (memory);
		contents = (g_free (contents), NULL);
		return;
	}
	entries = NULL;
	while (TRUE) {
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gboolean _tmp18_;
		gchar* _tmp21_ = NULL;
		GDataInputStream* _tmp22_;
		gsize _tmp23_ = 0UL;
		gchar* _tmp24_;
		gchar* _tmp25_;
		const gchar* _tmp26_;
		_tmp16_ = line;
		if (!(_tmp16_ != NULL)) {
			break;
		}
		_tmp17_ = line;
		_tmp18_ = g_str_has_prefix (_tmp17_, ";; okuri-ari entries.");
		if (_tmp18_) {
			GeeMap* _tmp19_;
			GeeMap* _tmp20_;
			_tmp19_ = self->priv->okuri_ari_entries;
			_tmp20_ = _g_object_ref0 (_tmp19_);
			_g_object_unref0 (entries);
			entries = _tmp20_;
			break;
		}
		_tmp22_ = data;
		_tmp24_ = g_data_input_stream_read_line (_tmp22_, &_tmp23_, NULL, &_inner_error_);
		length = _tmp23_;
		_tmp21_ = _tmp24_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (entries);
			_g_free0 (_tmp10_);
			_g_free0 (line);
			_g_object_unref0 (data);
			_g_object_unref0 (memory);
			contents = (g_free (contents), NULL);
			return;
		}
		_tmp25_ = _tmp21_;
		_tmp21_ = NULL;
		_g_free0 (line);
		line = _tmp25_;
		_tmp26_ = line;
		if (_tmp26_ == NULL) {
			_g_free0 (_tmp21_);
			break;
		}
		_g_free0 (_tmp21_);
	}
	_tmp27_ = entries;
	if (_tmp27_ == NULL) {
		GError* _tmp28_;
		_tmp28_ = g_error_new_literal (KKC_DICTIONARY_ERROR, KKC_DICTIONARY_ERROR_MALFORMED_INPUT, "no okuri-ari boundary");
		_inner_error_ = _tmp28_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (entries);
		_g_free0 (_tmp10_);
		_g_free0 (line);
		_g_object_unref0 (data);
		_g_object_unref0 (memory);
		contents = (g_free (contents), NULL);
		return;
	}
	okuri = TRUE;
	while (TRUE) {
		const gchar* _tmp29_;
		gchar* _tmp30_ = NULL;
		GDataInputStream* _tmp31_;
		gsize _tmp32_ = 0UL;
		gchar* _tmp33_;
		gchar* _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		gboolean _tmp37_;
		gchar** strv = NULL;
		const gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar** _tmp43_;
		gchar** _tmp44_;
		gchar** _tmp45_;
		gint _tmp45__length1;
		gint strv_length1;
		gint _strv_size_;
		gchar** _tmp46_;
		gint _tmp46__length1;
		gchar* midasi = NULL;
		gchar** _tmp49_;
		gint _tmp49__length1;
		const gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* candidates_str = NULL;
		gchar** _tmp52_;
		gint _tmp52__length1;
		const gchar* _tmp53_;
		gchar* _tmp54_;
		gboolean _tmp55_ = FALSE;
		const gchar* _tmp56_;
		gboolean _tmp57_;
		KkcCandidate** candidates = NULL;
		const gchar* _tmp62_;
		gboolean _tmp63_;
		const gchar* _tmp64_;
		gint _tmp65_;
		KkcCandidate** _tmp66_;
		gint candidates_length1;
		gint _candidates_size_;
		GeeArrayList* list = NULL;
		GeeArrayList* _tmp67_;
		KkcCandidate** _tmp68_;
		gint _tmp68__length1;
		GeeMap* _tmp72_;
		const gchar* _tmp73_;
		GeeArrayList* _tmp74_;
		_tmp29_ = line;
		if (!(_tmp29_ != NULL)) {
			break;
		}
		_tmp31_ = data;
		_tmp33_ = g_data_input_stream_read_line (_tmp31_, &_tmp32_, NULL, &_inner_error_);
		length = _tmp32_;
		_tmp30_ = _tmp33_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (entries);
			_g_free0 (_tmp10_);
			_g_free0 (line);
			_g_object_unref0 (data);
			_g_object_unref0 (memory);
			contents = (g_free (contents), NULL);
			return;
		}
		_tmp34_ = _tmp30_;
		_tmp30_ = NULL;
		_g_free0 (line);
		line = _tmp34_;
		_tmp35_ = line;
		if (_tmp35_ == NULL) {
			_g_free0 (_tmp30_);
			break;
		}
		_tmp36_ = line;
		_tmp37_ = g_str_has_prefix (_tmp36_, ";; okuri-nasi entries.");
		if (_tmp37_) {
			GeeMap* _tmp38_;
			GeeMap* _tmp39_;
			_tmp38_ = self->priv->okuri_nasi_entries;
			_tmp39_ = _g_object_ref0 (_tmp38_);
			_g_object_unref0 (entries);
			entries = _tmp39_;
			okuri = FALSE;
			_g_free0 (_tmp30_);
			continue;
		}
		_tmp40_ = line;
		_tmp41_ = string_strip (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp44_ = _tmp43_ = g_strsplit_set (_tmp42_, " \t", 2);
		_tmp45_ = _tmp44_;
		_tmp45__length1 = _vala_array_length (_tmp43_);
		_g_free0 (_tmp42_);
		strv = _tmp45_;
		strv_length1 = _tmp45__length1;
		_strv_size_ = strv_length1;
		_tmp46_ = strv;
		_tmp46__length1 = strv_length1;
		if (_tmp46__length1 < 2) {
			const gchar* _tmp47_;
			GError* _tmp48_;
			_tmp47_ = line;
			_tmp48_ = g_error_new (KKC_DICTIONARY_ERROR, KKC_DICTIONARY_ERROR_MALFORMED_INPUT, "can't extract midasi from line %s", _tmp47_);
			_inner_error_ = _tmp48_;
			g_propagate_error (error, _inner_error_);
			strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (_tmp30_);
			_g_object_unref0 (entries);
			_g_free0 (_tmp10_);
			_g_free0 (line);
			_g_object_unref0 (data);
			_g_object_unref0 (memory);
			contents = (g_free (contents), NULL);
			return;
		}
		_tmp49_ = strv;
		_tmp49__length1 = strv_length1;
		_tmp50_ = _tmp49_[0];
		_tmp51_ = kkc_dictionary_utils_unescape (_tmp50_);
		midasi = _tmp51_;
		_tmp52_ = strv;
		_tmp52__length1 = strv_length1;
		_tmp53_ = _tmp52_[1];
		_tmp54_ = g_strdup (_tmp53_);
		candidates_str = _tmp54_;
		_tmp56_ = candidates_str;
		_tmp57_ = g_str_has_prefix (_tmp56_, "/");
		if (!_tmp57_) {
			_tmp55_ = TRUE;
		} else {
			const gchar* _tmp58_;
			gboolean _tmp59_;
			_tmp58_ = candidates_str;
			_tmp59_ = g_str_has_suffix (_tmp58_, "/");
			_tmp55_ = !_tmp59_;
		}
		if (_tmp55_) {
			const gchar* _tmp60_;
			GError* _tmp61_;
			_tmp60_ = candidates_str;
			_tmp61_ = g_error_new (KKC_DICTIONARY_ERROR, KKC_DICTIONARY_ERROR_MALFORMED_INPUT, "can't parse candidates list %s", _tmp60_);
			_inner_error_ = _tmp61_;
			g_propagate_error (error, _inner_error_);
			_g_free0 (candidates_str);
			_g_free0 (midasi);
			strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (_tmp30_);
			_g_object_unref0 (entries);
			_g_free0 (_tmp10_);
			_g_free0 (line);
			_g_object_unref0 (data);
			_g_object_unref0 (memory);
			contents = (g_free (contents), NULL);
			return;
		}
		_tmp62_ = midasi;
		_tmp63_ = okuri;
		_tmp64_ = candidates_str;
		_tmp66_ = kkc_dictionary_utils_split_candidates (_tmp62_, _tmp63_, _tmp64_, &_tmp65_);
		candidates = _tmp66_;
		candidates_length1 = _tmp65_;
		_candidates_size_ = candidates_length1;
		_tmp67_ = gee_array_list_new (KKC_TYPE_CANDIDATE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		list = _tmp67_;
		_tmp68_ = candidates;
		_tmp68__length1 = candidates_length1;
		{
			KkcCandidate** c_collection = NULL;
			gint c_collection_length1 = 0;
			gint _c_collection_size_ = 0;
			gint c_it = 0;
			c_collection = _tmp68_;
			c_collection_length1 = _tmp68__length1;
			for (c_it = 0; c_it < _tmp68__length1; c_it = c_it + 1) {
				KkcCandidate* _tmp69_;
				KkcCandidate* c = NULL;
				_tmp69_ = _g_object_ref0 (c_collection[c_it]);
				c = _tmp69_;
				{
					GeeArrayList* _tmp70_;
					KkcCandidate* _tmp71_;
					_tmp70_ = list;
					_tmp71_ = c;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp70_, _tmp71_);
					_g_object_unref0 (c);
				}
			}
		}
		_tmp72_ = entries;
		_tmp73_ = midasi;
		_tmp74_ = list;
		gee_map_set (_tmp72_, _tmp73_, (GeeList*) _tmp74_);
		_g_object_unref0 (list);
		candidates = (_vala_array_free (candidates, candidates_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_free0 (candidates_str);
		_g_free0 (midasi);
		strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_tmp30_);
	}
	_g_object_unref0 (entries);
	_g_free0 (_tmp10_);
	_g_free0 (line);
	_g_object_unref0 (data);
	_g_object_unref0 (memory);
	contents = (g_free (contents), NULL);
}


/**
         * {@inheritDoc}
         */
static void kkc_user_segment_dictionary_real_reload (KkcDictionary* base, GError** error) {
	KkcUserSegmentDictionary * self;
	gchar* attributes = NULL;
	gchar* _tmp0_;
	GFileInfo* info = NULL;
	GFile* _tmp1_;
	const gchar* _tmp2_;
	GFileInfo* _tmp3_;
	GFileInfo* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GError * _inner_error_ = NULL;
	self = (KkcUserSegmentDictionary*) base;
	_tmp0_ = g_strdup (G_FILE_ATTRIBUTE_ETAG_VALUE);
	attributes = _tmp0_;
	_tmp1_ = self->priv->file;
	_tmp2_ = attributes;
	_tmp3_ = g_file_query_info (_tmp1_, _tmp2_, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	info = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (attributes);
		return;
	}
	_tmp4_ = info;
	_tmp5_ = g_file_info_get_etag (_tmp4_);
	_tmp6_ = self->priv->etag;
	if (g_strcmp0 (_tmp5_, _tmp6_) != 0) {
		GeeMap* _tmp7_;
		GeeMap* _tmp8_;
		_tmp7_ = self->priv->okuri_ari_entries;
		gee_map_clear (_tmp7_);
		_tmp8_ = self->priv->okuri_nasi_entries;
		gee_map_clear (_tmp8_);
		kkc_user_segment_dictionary_load (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (info);
			_g_free0 (attributes);
			return;
		}
	}
	self->priv->is_dirty = FALSE;
	_g_object_unref0 (info);
	_g_free0 (attributes);
}


static gint kkc_user_segment_dictionary_compare_entry_asc (GeeMapEntry* a, GeeMapEntry* b) {
	gint result = 0;
	GCompareFunc _tmp0_;
	GeeMapEntry* _tmp1_;
	gconstpointer _tmp2_;
	const gchar* _tmp3_;
	GeeMapEntry* _tmp4_;
	gconstpointer _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = g_strcmp0;
	_tmp1_ = a;
	_tmp2_ = gee_map_entry_get_key (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = b;
	_tmp5_ = gee_map_entry_get_key (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp0_ ((const gchar*) _tmp3_, (const gchar*) _tmp6_);
	result = _tmp7_;
	return result;
}


static gint kkc_user_segment_dictionary_compare_entry_dsc (GeeMapEntry* a, GeeMapEntry* b) {
	gint result = 0;
	GCompareFunc _tmp0_;
	GeeMapEntry* _tmp1_;
	gconstpointer _tmp2_;
	const gchar* _tmp3_;
	GeeMapEntry* _tmp4_;
	gconstpointer _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = g_strcmp0;
	_tmp1_ = b;
	_tmp2_ = gee_map_entry_get_key (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = a;
	_tmp5_ = gee_map_entry_get_key (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp0_ ((const gchar*) _tmp3_, (const gchar*) _tmp6_);
	result = _tmp7_;
	return result;
}


static void kkc_user_segment_dictionary_write_entries (KkcUserSegmentDictionary* self, GString* builder, GeeList* entries) {
	GeeIterator* iter = NULL;
	GeeList* _tmp0_;
	GeeIterator* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	g_return_if_fail (entries != NULL);
	_tmp0_ = entries;
	_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
	iter = _tmp1_;
	while (TRUE) {
		GeeIterator* _tmp2_;
		gboolean _tmp3_;
		GeeMapEntry* entry = NULL;
		GeeIterator* _tmp4_;
		gpointer _tmp5_;
		gchar* line = NULL;
		GeeMapEntry* _tmp6_;
		gconstpointer _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GeeMapEntry* _tmp11_;
		gconstpointer _tmp12_;
		GeeList* _tmp13_;
		gint _tmp14_;
		gpointer* _tmp15_;
		KkcCandidate** _tmp16_;
		gint _tmp16__length1;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		GString* _tmp21_;
		const gchar* _tmp22_;
		_tmp2_ = iter;
		_tmp3_ = gee_iterator_next (_tmp2_);
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = iter;
		_tmp5_ = gee_iterator_get (_tmp4_);
		entry = (GeeMapEntry*) _tmp5_;
		_tmp6_ = entry;
		_tmp7_ = gee_map_entry_get_key (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = kkc_dictionary_utils_escape ((const gchar*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = entry;
		_tmp12_ = gee_map_entry_get_value (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp15_ = gee_collection_to_array ((GeeCollection*) ((GeeList*) _tmp13_), &_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp16__length1 = _tmp14_;
		_tmp17_ = kkc_dictionary_utils_join_candidates (_tmp16_, _tmp14_);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strdup_printf ("%s %s\n", _tmp10_, _tmp18_);
		_tmp20_ = _tmp19_;
		_g_free0 (_tmp18_);
		_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_object_unref), NULL);
		_g_free0 (_tmp10_);
		line = _tmp20_;
		_tmp21_ = builder;
		_tmp22_ = line;
		g_string_append (_tmp21_, _tmp22_);
		_g_free0 (line);
		_g_object_unref0 (entry);
	}
	_g_object_unref0 (iter);
}


/**
         * {@inheritDoc}
         */
static gint _kkc_user_segment_dictionary_compare_entry_dsc_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = kkc_user_segment_dictionary_compare_entry_dsc ((GeeMapEntry*) a, (GeeMapEntry*) b);
	return result;
}


static gint _kkc_user_segment_dictionary_compare_entry_asc_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = kkc_user_segment_dictionary_compare_entry_asc ((GeeMapEntry*) a, (GeeMapEntry*) b);
	return result;
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static void kkc_user_segment_dictionary_real_save (KkcDictionary* base, GError** error) {
	KkcUserSegmentDictionary * self;
	gboolean _tmp0_;
	GString* builder = NULL;
	GString* _tmp1_;
	GString* _tmp2_;
	GeeArrayList* entries = NULL;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeMap* _tmp5_;
	GeeSet* _tmp6_;
	GeeSet* _tmp7_;
	GeeSet* _tmp8_;
	GeeArrayList* _tmp9_;
	GString* _tmp10_;
	GeeArrayList* _tmp11_;
	GeeArrayList* _tmp12_;
	GString* _tmp13_;
	GeeArrayList* _tmp14_;
	GeeMap* _tmp15_;
	GeeSet* _tmp16_;
	GeeSet* _tmp17_;
	GeeSet* _tmp18_;
	GeeArrayList* _tmp19_;
	GString* _tmp20_;
	GeeArrayList* _tmp21_;
	GeeArrayList* _tmp22_;
	GFile* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GFile* _tmp28_;
	GString* _tmp29_;
	const gchar* _tmp30_;
	guint8* _tmp31_;
	gint _tmp31__length1;
	guint8* _tmp32_;
	gint _tmp32__length1;
	const gchar* _tmp33_;
	gchar* _tmp34_ = NULL;
	GError * _inner_error_ = NULL;
	self = (KkcUserSegmentDictionary*) base;
	_tmp0_ = self->priv->is_dirty;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = g_string_new ("");
	builder = _tmp1_;
	_tmp2_ = builder;
	g_string_append (_tmp2_, ";; okuri-ari entries.\n");
	_tmp3_ = gee_array_list_new (GEE_MAP_TYPE_ENTRY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	entries = _tmp3_;
	_tmp4_ = entries;
	_tmp5_ = self->priv->okuri_ari_entries;
	_tmp6_ = gee_map_get_entries (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	gee_array_list_add_all (_tmp4_, (GeeCollection*) _tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = entries;
	gee_list_sort ((GeeList*) _tmp9_, _kkc_user_segment_dictionary_compare_entry_dsc_gcompare_data_func, NULL, NULL);
	_tmp10_ = builder;
	_tmp11_ = entries;
	kkc_user_segment_dictionary_write_entries (self, _tmp10_, (GeeList*) _tmp11_);
	_tmp12_ = entries;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp12_);
	_tmp13_ = builder;
	g_string_append (_tmp13_, ";; okuri-nasi entries.\n");
	_tmp14_ = entries;
	_tmp15_ = self->priv->okuri_nasi_entries;
	_tmp16_ = gee_map_get_entries (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = _tmp17_;
	gee_array_list_add_all (_tmp14_, (GeeCollection*) _tmp18_);
	_g_object_unref0 (_tmp18_);
	_tmp19_ = entries;
	gee_list_sort ((GeeList*) _tmp19_, _kkc_user_segment_dictionary_compare_entry_asc_gcompare_data_func, NULL, NULL);
	_tmp20_ = builder;
	_tmp21_ = entries;
	kkc_user_segment_dictionary_write_entries (self, _tmp20_, (GeeList*) _tmp21_);
	_tmp22_ = entries;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp22_);
	_tmp23_ = self->priv->file;
	_tmp24_ = g_file_get_path (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_path_get_dirname (_tmp25_);
	_tmp27_ = _tmp26_;
	g_mkdir_with_parents (_tmp27_, 448);
	_g_free0 (_tmp27_);
	_g_free0 (_tmp25_);
	_tmp28_ = self->priv->file;
	_tmp29_ = builder;
	_tmp30_ = _tmp29_->str;
	_tmp31_ = string_get_data (_tmp30_, &_tmp31__length1);
	_tmp32_ = _tmp31_;
	_tmp32__length1 = _tmp31__length1;
	_tmp33_ = self->priv->etag;
	g_file_replace_contents (_tmp28_, _tmp32_, (gsize) _tmp32__length1, _tmp33_, FALSE, G_FILE_CREATE_PRIVATE, &_tmp34_, NULL, &_inner_error_);
	_g_free0 (self->priv->etag);
	self->priv->etag = _tmp34_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (entries);
		_g_string_free0 (builder);
		return;
	}
	self->priv->is_dirty = FALSE;
	_g_object_unref0 (entries);
	_g_string_free0 (builder);
}


static GeeMap* kkc_user_segment_dictionary_get_entries (KkcUserSegmentDictionary* self, gboolean okuri) {
	GeeMap* result = NULL;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = okuri;
	if (_tmp0_) {
		GeeMap* _tmp1_;
		GeeMap* _tmp2_;
		_tmp1_ = self->priv->okuri_ari_entries;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	} else {
		GeeMap* _tmp3_;
		GeeMap* _tmp4_;
		_tmp3_ = self->priv->okuri_nasi_entries;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		result = _tmp4_;
		return result;
	}
}


/**
         * {@inheritDoc}
         */
static gboolean kkc_user_segment_dictionary_real_lookup_candidates (KkcSegmentDictionary* base, const gchar* midasi, gboolean okuri, KkcCandidate*** candidates, int* candidates_length1) {
	KkcUserSegmentDictionary * self;
	KkcCandidate** _vala_candidates = NULL;
	int _vala_candidates_length1 = 0;
	gboolean result = FALSE;
	GeeMap* entries = NULL;
	gboolean _tmp0_;
	GeeMap* _tmp1_;
	GeeMap* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	self = (KkcUserSegmentDictionary*) base;
	g_return_val_if_fail (midasi != NULL, FALSE);
	_tmp0_ = okuri;
	_tmp1_ = kkc_user_segment_dictionary_get_entries (self, _tmp0_);
	entries = _tmp1_;
	_tmp2_ = entries;
	_tmp3_ = midasi;
	_tmp4_ = gee_map_has_key (_tmp2_, _tmp3_);
	if (_tmp4_) {
		GeeMap* _tmp5_;
		const gchar* _tmp6_;
		gpointer _tmp7_;
		GeeList* _tmp8_;
		gint _tmp9_;
		gpointer* _tmp10_;
		_tmp5_ = entries;
		_tmp6_ = midasi;
		_tmp7_ = gee_map_get (_tmp5_, _tmp6_);
		_tmp8_ = (GeeList*) _tmp7_;
		_tmp10_ = gee_collection_to_array ((GeeCollection*) _tmp8_, &_tmp9_);
		_vala_candidates = (_vala_array_free (_vala_candidates, _vala_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
		_vala_candidates = _tmp10_;
		_vala_candidates_length1 = _tmp9_;
		_g_object_unref0 (_tmp8_);
		result = TRUE;
		_g_object_unref0 (entries);
		if (candidates) {
			*candidates = _vala_candidates;
		} else {
			_vala_candidates = (_vala_array_free (_vala_candidates, _vala_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
		}
		if (candidates_length1) {
			*candidates_length1 = _vala_candidates_length1;
		}
		return result;
	} else {
		KkcCandidate** _tmp11_;
		_tmp11_ = g_new0 (KkcCandidate*, 0 + 1);
		_vala_candidates = (_vala_array_free (_vala_candidates, _vala_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
		_vala_candidates = _tmp11_;
		_vala_candidates_length1 = 0;
		result = FALSE;
		_g_object_unref0 (entries);
		if (candidates) {
			*candidates = _vala_candidates;
		} else {
			_vala_candidates = (_vala_array_free (_vala_candidates, _vala_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
		}
		if (candidates_length1) {
			*candidates_length1 = _vala_candidates_length1;
		}
		return result;
	}
	_g_object_unref0 (entries);
	if (candidates) {
		*candidates = _vala_candidates;
	} else {
		_vala_candidates = (_vala_array_free (_vala_candidates, _vala_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
	}
	if (candidates_length1) {
		*candidates_length1 = _vala_candidates_length1;
	}
}


/**
         * {@inheritDoc}
         */
static gchar** kkc_user_segment_dictionary_real_complete (KkcSegmentDictionary* base, const gchar* midasi, int* result_length1) {
	KkcUserSegmentDictionary * self;
	gchar** result = NULL;
	GeeList* completion = NULL;
	GeeArrayList* _tmp0_;
	GeeList* keys = NULL;
	GeeArrayList* _tmp1_;
	GeeList* _tmp2_;
	GeeMap* _tmp3_;
	GeeSet* _tmp4_;
	GeeSet* _tmp5_;
	GeeSet* _tmp6_;
	GeeList* _tmp7_;
	GeeIterator* iter = NULL;
	GeeList* _tmp8_;
	GeeIterator* _tmp9_;
	GeeList* _tmp32_;
	gint _tmp33_;
	gpointer* _tmp34_;
	gchar** _tmp35_;
	gint _tmp35__length1;
	self = (KkcUserSegmentDictionary*) base;
	g_return_val_if_fail (midasi != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	completion = (GeeList*) _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	keys = (GeeList*) _tmp1_;
	_tmp2_ = keys;
	_tmp3_ = self->priv->okuri_nasi_entries;
	_tmp4_ = gee_map_get_keys (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	gee_collection_add_all ((GeeCollection*) _tmp2_, (GeeCollection*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = keys;
	gee_list_sort (_tmp7_, NULL, NULL, NULL);
	_tmp8_ = keys;
	_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
	iter = _tmp9_;
	while (TRUE) {
		GeeIterator* _tmp10_;
		gboolean _tmp11_;
		gchar* key = NULL;
		GeeIterator* _tmp12_;
		gpointer _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gboolean _tmp16_;
		_tmp10_ = iter;
		_tmp11_ = gee_iterator_next (_tmp10_);
		if (!_tmp11_) {
			break;
		}
		_tmp12_ = iter;
		_tmp13_ = gee_iterator_get (_tmp12_);
		key = (gchar*) _tmp13_;
		_tmp14_ = key;
		_tmp15_ = midasi;
		_tmp16_ = g_str_has_prefix (_tmp14_, _tmp15_);
		if (_tmp16_) {
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			_tmp17_ = key;
			_tmp18_ = midasi;
			if (g_strcmp0 (_tmp17_, _tmp18_) != 0) {
				GeeList* _tmp19_;
				const gchar* _tmp20_;
				_tmp19_ = completion;
				_tmp20_ = key;
				gee_collection_add ((GeeCollection*) _tmp19_, _tmp20_);
			}
			_g_free0 (key);
			break;
		}
		_g_free0 (key);
	}
	while (TRUE) {
		GeeIterator* _tmp21_;
		gboolean _tmp22_;
		gchar* key = NULL;
		GeeIterator* _tmp23_;
		gpointer _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		gboolean _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		_tmp21_ = iter;
		_tmp22_ = gee_iterator_next (_tmp21_);
		if (!_tmp22_) {
			break;
		}
		_tmp23_ = iter;
		_tmp24_ = gee_iterator_get (_tmp23_);
		key = (gchar*) _tmp24_;
		_tmp25_ = key;
		_tmp26_ = midasi;
		_tmp27_ = g_str_has_prefix (_tmp25_, _tmp26_);
		if (!_tmp27_) {
			_g_free0 (key);
			break;
		}
		_tmp28_ = key;
		_tmp29_ = midasi;
		if (g_strcmp0 (_tmp28_, _tmp29_) != 0) {
			GeeList* _tmp30_;
			const gchar* _tmp31_;
			_tmp30_ = completion;
			_tmp31_ = key;
			gee_collection_add ((GeeCollection*) _tmp30_, _tmp31_);
		}
		_g_free0 (key);
	}
	_tmp32_ = completion;
	_tmp34_ = gee_collection_to_array ((GeeCollection*) _tmp32_, &_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp35__length1 = _tmp33_;
	if (result_length1) {
		*result_length1 = _tmp35__length1;
	}
	result = _tmp35_;
	_g_object_unref0 (iter);
	_g_object_unref0 (keys);
	_g_object_unref0 (completion);
	return result;
}


/**
         * {@inheritDoc}
         */
static gboolean kkc_user_segment_dictionary_real_select_candidate (KkcSegmentDictionary* base, KkcCandidate* candidate) {
	KkcUserSegmentDictionary * self;
	gboolean result = FALSE;
	GeeMap* entries = NULL;
	KkcCandidate* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GeeMap* _tmp3_;
	GeeMap* _tmp4_;
	KkcCandidate* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp8_;
	GeeList* candidates = NULL;
	GeeMap* _tmp15_;
	KkcCandidate* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gpointer _tmp19_;
	gint index = 0;
	GeeList* _tmp20_;
	KkcCandidate* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	GeeList* _tmp29_;
	KkcCandidate* _tmp30_;
	self = (KkcUserSegmentDictionary*) base;
	g_return_val_if_fail (candidate != NULL, FALSE);
	_tmp0_ = candidate;
	_tmp1_ = kkc_candidate_get_okuri (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = kkc_user_segment_dictionary_get_entries (self, _tmp2_);
	entries = _tmp3_;
	_tmp4_ = entries;
	_tmp5_ = candidate;
	_tmp6_ = kkc_candidate_get_midasi (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = gee_map_has_key (_tmp4_, _tmp7_);
	if (!_tmp8_) {
		GeeMap* _tmp9_;
		KkcCandidate* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		GeeArrayList* _tmp13_;
		GeeArrayList* _tmp14_;
		_tmp9_ = entries;
		_tmp10_ = candidate;
		_tmp11_ = kkc_candidate_get_midasi (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = gee_array_list_new (KKC_TYPE_CANDIDATE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		_tmp14_ = _tmp13_;
		gee_map_set (_tmp9_, _tmp12_, (GeeList*) _tmp14_);
		_g_object_unref0 (_tmp14_);
	}
	_tmp15_ = entries;
	_tmp16_ = candidate;
	_tmp17_ = kkc_candidate_get_midasi (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = gee_map_get (_tmp15_, _tmp18_);
	candidates = (GeeList*) _tmp19_;
	_tmp20_ = candidates;
	_tmp21_ = candidate;
	_tmp22_ = gee_list_index_of (_tmp20_, _tmp21_);
	index = _tmp22_;
	_tmp23_ = index;
	if (_tmp23_ == 0) {
		result = FALSE;
		_g_object_unref0 (candidates);
		_g_object_unref0 (entries);
		return result;
	}
	_tmp24_ = index;
	if (_tmp24_ > 0) {
		GeeList* _tmp25_;
		gint _tmp26_;
		gpointer _tmp27_;
		KkcCandidate* _tmp28_;
		_tmp25_ = candidates;
		_tmp26_ = index;
		_tmp27_ = gee_list_remove_at (_tmp25_, _tmp26_);
		_tmp28_ = (KkcCandidate*) _tmp27_;
		_g_object_unref0 (_tmp28_);
	}
	_tmp29_ = candidates;
	_tmp30_ = candidate;
	gee_list_insert (_tmp29_, 0, _tmp30_);
	self->priv->is_dirty = TRUE;
	result = TRUE;
	_g_object_unref0 (candidates);
	_g_object_unref0 (entries);
	return result;
}


/**
         * {@inheritDoc}
         */
static gboolean kkc_user_segment_dictionary_real_purge_candidate (KkcSegmentDictionary* base, KkcCandidate* candidate) {
	KkcUserSegmentDictionary * self;
	gboolean result = FALSE;
	gboolean modified = FALSE;
	GeeMap* entries = NULL;
	KkcCandidate* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GeeMap* _tmp3_;
	GeeMap* _tmp4_;
	KkcCandidate* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp37_;
	self = (KkcUserSegmentDictionary*) base;
	g_return_val_if_fail (candidate != NULL, FALSE);
	modified = FALSE;
	_tmp0_ = candidate;
	_tmp1_ = kkc_candidate_get_okuri (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = kkc_user_segment_dictionary_get_entries (self, _tmp2_);
	entries = _tmp3_;
	_tmp4_ = entries;
	_tmp5_ = candidate;
	_tmp6_ = kkc_candidate_get_midasi (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = gee_map_has_key (_tmp4_, _tmp7_);
	if (_tmp8_) {
		GeeList* candidates = NULL;
		GeeMap* _tmp9_;
		KkcCandidate* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gpointer _tmp13_;
		GeeList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		_tmp9_ = entries;
		_tmp10_ = candidate;
		_tmp11_ = kkc_candidate_get_midasi (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = gee_map_get (_tmp9_, _tmp12_);
		candidates = (GeeList*) _tmp13_;
		_tmp14_ = candidates;
		_tmp15_ = gee_collection_get_size ((GeeCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		if (_tmp16_ > 0) {
			GeeIterator* iter = NULL;
			GeeList* _tmp17_;
			GeeIterator* _tmp18_;
			GeeList* _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			_tmp17_ = candidates;
			_tmp18_ = gee_iterable_iterator ((GeeIterable*) _tmp17_);
			iter = _tmp18_;
			while (TRUE) {
				GeeIterator* _tmp19_;
				gboolean _tmp20_;
				KkcCandidate* c = NULL;
				GeeIterator* _tmp21_;
				gpointer _tmp22_;
				KkcCandidate* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				KkcCandidate* _tmp26_;
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				_tmp19_ = iter;
				_tmp20_ = gee_iterator_next (_tmp19_);
				if (!_tmp20_) {
					break;
				}
				_tmp21_ = iter;
				_tmp22_ = gee_iterator_get (_tmp21_);
				c = (KkcCandidate*) _tmp22_;
				_tmp23_ = c;
				_tmp24_ = kkc_candidate_get_text (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = candidate;
				_tmp27_ = kkc_candidate_get_text (_tmp26_);
				_tmp28_ = _tmp27_;
				if (g_strcmp0 (_tmp25_, _tmp28_) == 0) {
					GeeIterator* _tmp29_;
					_tmp29_ = iter;
					gee_iterator_remove (_tmp29_);
					modified = TRUE;
				}
				_g_object_unref0 (c);
			}
			_tmp30_ = candidates;
			_tmp31_ = gee_collection_get_size ((GeeCollection*) _tmp30_);
			_tmp32_ = _tmp31_;
			if (_tmp32_ == 0) {
				GeeMap* _tmp33_;
				KkcCandidate* _tmp34_;
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				_tmp33_ = entries;
				_tmp34_ = candidate;
				_tmp35_ = kkc_candidate_get_midasi (_tmp34_);
				_tmp36_ = _tmp35_;
				gee_map_unset (_tmp33_, _tmp36_, NULL);
			}
			_g_object_unref0 (iter);
		}
		_g_object_unref0 (candidates);
	}
	_tmp37_ = modified;
	if (_tmp37_) {
		self->priv->is_dirty = TRUE;
	}
	result = modified;
	_g_object_unref0 (entries);
	return result;
}


/**
         * Create a new UserSegmentDictionary.
         *
         * @param path a path to the file
         *
         * @return a new UserSegmentDictionary
         * @throws GLib.Error if opening the file is failed
         */
KkcUserSegmentDictionary* kkc_user_segment_dictionary_construct (GType object_type, const gchar* path, GError** error) {
	KkcUserSegmentDictionary * self = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	self = (KkcUserSegmentDictionary*) g_object_new (object_type, NULL);
	_tmp0_ = path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp1_;
	_tmp2_ = g_strdup ("");
	_g_free0 (self->priv->etag);
	self->priv->etag = _tmp2_;
	_tmp3_ = path;
	_tmp4_ = g_file_test (_tmp3_, G_FILE_TEST_EXISTS);
	if (_tmp4_) {
		kkc_dictionary_reload ((KkcDictionary*) self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		}
	}
	return self;
}


KkcUserSegmentDictionary* kkc_user_segment_dictionary_new (const gchar* path, GError** error) {
	return kkc_user_segment_dictionary_construct (KKC_TYPE_USER_SEGMENT_DICTIONARY, path, error);
}


static void kkc_user_segment_dictionary_class_init (KkcUserSegmentDictionaryClass * klass) {
	kkc_user_segment_dictionary_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcUserSegmentDictionaryPrivate));
	G_OBJECT_CLASS (klass)->finalize = kkc_user_segment_dictionary_finalize;
}


static void kkc_user_segment_dictionary_kkc_dictionary_interface_init (KkcDictionaryIface * iface) {
	kkc_user_segment_dictionary_kkc_dictionary_parent_iface = g_type_interface_peek_parent (iface);
	iface->reload = (void (*) (KkcDictionary *, GError**)) kkc_user_segment_dictionary_real_reload;
	iface->save = (void (*) (KkcDictionary *, GError**)) kkc_user_segment_dictionary_real_save;
}


static void kkc_user_segment_dictionary_kkc_segment_dictionary_interface_init (KkcSegmentDictionaryIface * iface) {
	kkc_user_segment_dictionary_kkc_segment_dictionary_parent_iface = g_type_interface_peek_parent (iface);
	iface->lookup_candidates = (gboolean (*) (KkcSegmentDictionary *, const gchar*, gboolean, KkcCandidate***, int*)) kkc_user_segment_dictionary_real_lookup_candidates;
	iface->complete = (gchar** (*) (KkcSegmentDictionary *, const gchar*, int*)) kkc_user_segment_dictionary_real_complete;
	iface->select_candidate = (gboolean (*) (KkcSegmentDictionary *, KkcCandidate*)) kkc_user_segment_dictionary_real_select_candidate;
	iface->purge_candidate = (gboolean (*) (KkcSegmentDictionary *, KkcCandidate*)) kkc_user_segment_dictionary_real_purge_candidate;
}


static void kkc_user_segment_dictionary_instance_init (KkcUserSegmentDictionary * self) {
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	self->priv = KKC_USER_SEGMENT_DICTIONARY_GET_PRIVATE (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->okuri_ari_entries = (GeeMap*) _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->okuri_nasi_entries = (GeeMap*) _tmp1_;
}


static void kkc_user_segment_dictionary_finalize (GObject * obj) {
	KkcUserSegmentDictionary * self;
	GeeMapIterator* okuri_ari_iter = NULL;
	GeeMap* _tmp0_;
	GeeMapIterator* _tmp1_;
	GeeMap* _tmp7_;
	GeeMapIterator* okuri_nasi_iter = NULL;
	GeeMap* _tmp8_;
	GeeMapIterator* _tmp9_;
	GeeMap* _tmp15_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_USER_SEGMENT_DICTIONARY, KkcUserSegmentDictionary);
	_tmp0_ = self->priv->okuri_ari_entries;
	_tmp1_ = gee_map_map_iterator (_tmp0_);
	okuri_ari_iter = _tmp1_;
	while (TRUE) {
		GeeMapIterator* _tmp2_;
		gboolean _tmp3_;
		GeeMapIterator* _tmp4_;
		gpointer _tmp5_;
		GeeList* _tmp6_;
		_tmp2_ = okuri_ari_iter;
		_tmp3_ = gee_map_iterator_next (_tmp2_);
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = okuri_ari_iter;
		_tmp5_ = gee_map_iterator_get_value (_tmp4_);
		_tmp6_ = (GeeList*) _tmp5_;
		gee_collection_clear ((GeeCollection*) _tmp6_);
		_g_object_unref0 (_tmp6_);
	}
	_tmp7_ = self->priv->okuri_ari_entries;
	gee_map_clear (_tmp7_);
	_tmp8_ = self->priv->okuri_nasi_entries;
	_tmp9_ = gee_map_map_iterator (_tmp8_);
	okuri_nasi_iter = _tmp9_;
	while (TRUE) {
		GeeMapIterator* _tmp10_;
		gboolean _tmp11_;
		GeeMapIterator* _tmp12_;
		gpointer _tmp13_;
		GeeList* _tmp14_;
		_tmp10_ = okuri_nasi_iter;
		_tmp11_ = gee_map_iterator_next (_tmp10_);
		if (!_tmp11_) {
			break;
		}
		_tmp12_ = okuri_nasi_iter;
		_tmp13_ = gee_map_iterator_get_value (_tmp12_);
		_tmp14_ = (GeeList*) _tmp13_;
		gee_collection_clear ((GeeCollection*) _tmp14_);
		_g_object_unref0 (_tmp14_);
	}
	_tmp15_ = self->priv->okuri_nasi_entries;
	gee_map_clear (_tmp15_);
	_g_object_unref0 (okuri_nasi_iter);
	_g_object_unref0 (okuri_ari_iter);
	_g_object_unref0 (self->priv->file);
	_g_free0 (self->priv->etag);
	_g_object_unref0 (self->priv->okuri_ari_entries);
	_g_object_unref0 (self->priv->okuri_nasi_entries);
	G_OBJECT_CLASS (kkc_user_segment_dictionary_parent_class)->finalize (obj);
}


/**
     * File based implementation of SegmentDictionary with write access.
     */
GType kkc_user_segment_dictionary_get_type (void) {
	static volatile gsize kkc_user_segment_dictionary_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_user_segment_dictionary_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcUserSegmentDictionaryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_user_segment_dictionary_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcUserSegmentDictionary), 0, (GInstanceInitFunc) kkc_user_segment_dictionary_instance_init, NULL };
		static const GInterfaceInfo kkc_dictionary_info = { (GInterfaceInitFunc) kkc_user_segment_dictionary_kkc_dictionary_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo kkc_segment_dictionary_info = { (GInterfaceInitFunc) kkc_user_segment_dictionary_kkc_segment_dictionary_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType kkc_user_segment_dictionary_type_id;
		kkc_user_segment_dictionary_type_id = g_type_register_static (G_TYPE_OBJECT, "KkcUserSegmentDictionary", &g_define_type_info, 0);
		g_type_add_interface_static (kkc_user_segment_dictionary_type_id, KKC_TYPE_DICTIONARY, &kkc_dictionary_info);
		g_type_add_interface_static (kkc_user_segment_dictionary_type_id, KKC_TYPE_SEGMENT_DICTIONARY, &kkc_segment_dictionary_info);
		g_once_init_leave (&kkc_user_segment_dictionary_type_id__volatile, kkc_user_segment_dictionary_type_id);
	}
	return kkc_user_segment_dictionary_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



