/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternSet
extends DataType
implements Cloneable {
    private List<NameEntry> includeList = new ArrayList<NameEntry>();
    private List<NameEntry> excludeList = new ArrayList<NameEntry>();
    private List<NameEntry> includesFileList = new ArrayList<NameEntry>();
    private List<NameEntry> excludesFileList = new ArrayList<NameEntry>();

    @Override
    public void setRefid(Reference r) throws BuildException {
        if (!this.includeList.isEmpty() || !this.excludeList.isEmpty()) {
            throw this.tooManyAttributes();
        }
        super.setRefid(r);
    }

    public void addConfiguredPatternset(PatternSet p) {
        int i;
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        String[] nestedIncludes = p.getIncludePatterns(this.getProject());
        String[] nestedExcludes = p.getExcludePatterns(this.getProject());
        if (nestedIncludes != null) {
            for (i = 0; i < nestedIncludes.length; ++i) {
                this.createInclude().setName(nestedIncludes[i]);
            }
        }
        if (nestedExcludes != null) {
            for (i = 0; i < nestedExcludes.length; ++i) {
                this.createExclude().setName(nestedExcludes[i]);
            }
        }
    }

    public NameEntry createInclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.addPatternToList(this.includeList);
    }

    public NameEntry createIncludesFile() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.addPatternToList(this.includesFileList);
    }

    public NameEntry createExclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.addPatternToList(this.excludeList);
    }

    public NameEntry createExcludesFile() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.addPatternToList(this.excludesFileList);
    }

    public void setIncludes(String includes) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (includes != null && includes.length() > 0) {
            StringTokenizer tok = new StringTokenizer(includes, ", ", false);
            while (tok.hasMoreTokens()) {
                this.createInclude().setName(tok.nextToken());
            }
        }
    }

    public void setExcludes(String excludes) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (excludes != null && excludes.length() > 0) {
            StringTokenizer tok = new StringTokenizer(excludes, ", ", false);
            while (tok.hasMoreTokens()) {
                this.createExclude().setName(tok.nextToken());
            }
        }
    }

    private NameEntry addPatternToList(List<NameEntry> list) {
        NameEntry result = new NameEntry();
        list.add(result);
        return result;
    }

    public void setIncludesfile(File includesFile) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createIncludesFile().setName(includesFile.getAbsolutePath());
    }

    public void setExcludesfile(File excludesFile) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createExcludesFile().setName(excludesFile.getAbsolutePath());
    }

    private void readPatterns(File patternfile, List<NameEntry> patternlist, Project p) throws BuildException {
        BufferedReader patternReader = null;
        try {
            patternReader = new BufferedReader(new FileReader(patternfile));
            String line = patternReader.readLine();
            while (line != null) {
                if (line.length() > 0) {
                    line = p.replaceProperties(line);
                    this.addPatternToList(patternlist).setName(line);
                }
                line = patternReader.readLine();
            }
        }
        catch (IOException ioe) {
            try {
                throw new BuildException("An error occurred while reading from pattern file: " + patternfile, ioe);
            }
            catch (Throwable throwable) {
                FileUtils.close(patternReader);
                throw throwable;
            }
        }
        FileUtils.close(patternReader);
    }

    public void append(PatternSet other, Project p) {
        String[] excl;
        if (this.isReference()) {
            throw new BuildException("Cannot append to a reference");
        }
        this.dieOnCircularReference(p);
        String[] incl = other.getIncludePatterns(p);
        if (incl != null) {
            for (int i = 0; i < incl.length; ++i) {
                this.createInclude().setName(incl[i]);
            }
        }
        if ((excl = other.getExcludePatterns(p)) != null) {
            for (int i = 0; i < excl.length; ++i) {
                this.createExclude().setName(excl[i]);
            }
        }
    }

    public String[] getIncludePatterns(Project p) {
        if (this.isReference()) {
            return this.getRef(p).getIncludePatterns(p);
        }
        this.dieOnCircularReference(p);
        this.readFiles(p);
        return this.makeArray(this.includeList, p);
    }

    public String[] getExcludePatterns(Project p) {
        if (this.isReference()) {
            return this.getRef(p).getExcludePatterns(p);
        }
        this.dieOnCircularReference(p);
        this.readFiles(p);
        return this.makeArray(this.excludeList, p);
    }

    public boolean hasPatterns(Project p) {
        if (this.isReference()) {
            return this.getRef(p).hasPatterns(p);
        }
        this.dieOnCircularReference(p);
        return this.includesFileList.size() > 0 || this.excludesFileList.size() > 0 || this.includeList.size() > 0 || this.excludeList.size() > 0;
    }

    private PatternSet getRef(Project p) {
        return (PatternSet)this.getCheckedRef(p);
    }

    private String[] makeArray(List<NameEntry> list, Project p) {
        if (list.size() == 0) {
            return null;
        }
        ArrayList<String> tmpNames = new ArrayList<String>();
        for (NameEntry ne : list) {
            String pattern = ne.evalName(p);
            if (pattern == null || pattern.length() <= 0) continue;
            tmpNames.add(pattern);
        }
        return tmpNames.toArray(new String[tmpNames.size()]);
    }

    private void readFiles(Project p) {
        String fileName;
        if (this.includesFileList.size() > 0) {
            for (NameEntry ne : this.includesFileList) {
                fileName = ne.evalName(p);
                if (fileName == null) continue;
                File inclFile = p.resolveFile(fileName);
                if (!inclFile.exists()) {
                    throw new BuildException("Includesfile " + inclFile.getAbsolutePath() + " not found.");
                }
                this.readPatterns(inclFile, this.includeList, p);
            }
            this.includesFileList.clear();
        }
        if (this.excludesFileList.size() > 0) {
            for (NameEntry ne : this.excludesFileList) {
                fileName = ne.evalName(p);
                if (fileName == null) continue;
                File exclFile = p.resolveFile(fileName);
                if (!exclFile.exists()) {
                    throw new BuildException("Excludesfile " + exclFile.getAbsolutePath() + " not found.");
                }
                this.readPatterns(exclFile, this.excludeList, p);
            }
            this.excludesFileList.clear();
        }
    }

    @Override
    public String toString() {
        return "patternSet{ includes: " + this.includeList + " excludes: " + this.excludeList + " }";
    }

    @Override
    public Object clone() {
        try {
            PatternSet ps = (PatternSet)super.clone();
            ps.includeList = new ArrayList<NameEntry>(this.includeList);
            ps.excludeList = new ArrayList<NameEntry>(this.excludeList);
            ps.includesFileList = new ArrayList<NameEntry>(this.includesFileList);
            ps.excludesFileList = new ArrayList<NameEntry>(this.excludesFileList);
            return ps;
        }
        catch (CloneNotSupportedException e) {
            throw new BuildException(e);
        }
    }

    public void addConfiguredInvert(PatternSet p) {
        this.addConfiguredPatternset(new InvertedPatternSet(p));
    }

    private static final class InvertedPatternSet
    extends PatternSet {
        private InvertedPatternSet(PatternSet p) {
            this.setProject(p.getProject());
            this.addConfiguredPatternset(p);
        }

        public String[] getIncludePatterns(Project p) {
            return super.getExcludePatterns(p);
        }

        public String[] getExcludePatterns(Project p) {
            return super.getIncludePatterns(p);
        }
    }

    public class NameEntry {
        private String name;
        private Object ifCond;
        private Object unlessCond;

        public void setName(String name) {
            this.name = name;
        }

        public void setIf(Object cond) {
            this.ifCond = cond;
        }

        public void setIf(String cond) {
            this.setIf((Object)cond);
        }

        public void setUnless(Object cond) {
            this.unlessCond = cond;
        }

        public void setUnless(String cond) {
            this.setUnless((Object)cond);
        }

        public String getName() {
            return this.name;
        }

        public String evalName(Project p) {
            return this.valid(p) ? this.name : null;
        }

        private boolean valid(Project p) {
            PropertyHelper ph = PropertyHelper.getPropertyHelper(p);
            return ph.testIfCondition(this.ifCond) && ph.testUnlessCondition(this.unlessCond);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            if (this.name == null) {
                buf.append("noname");
            } else {
                buf.append(this.name);
            }
            if (this.ifCond != null || this.unlessCond != null) {
                buf.append(":");
                String connector = "";
                if (this.ifCond != null) {
                    buf.append("if->");
                    buf.append(this.ifCond);
                    connector = ";";
                }
                if (this.unlessCond != null) {
                    buf.append(connector);
                    buf.append("unless->");
                    buf.append(this.unlessCond);
                }
            }
            return buf.toString();
        }
    }
}

