/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.model;

import org.apache.wicket.Component;
import org.apache.wicket.core.util.lang.PropertyResolver;
import org.apache.wicket.model.IComponentAssignedModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IWrapModel;

public class ComponentPropertyModel<T>
implements IComponentAssignedModel<T> {
    private static final long serialVersionUID = 1L;
    private final String propertyName;

    public ComponentPropertyModel(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public T getObject() {
        throw new IllegalStateException("Wrapper should have been called");
    }

    @Override
    public final void setObject(T object) {
        IComponentAssignedModel.super.setObject(object);
    }

    @Override
    public IWrapModel<T> wrapOnAssignment(Component component) {
        return new AssignmentWrapper(component, this.propertyName);
    }

    private class AssignmentWrapper<P>
    implements IWrapModel<P> {
        private static final long serialVersionUID = 1L;
        private final Component component;
        private final String propertyName;

        AssignmentWrapper(Component component, String propertyName) {
            this.component = component;
            this.propertyName = propertyName;
        }

        @Override
        public IModel<T> getWrappedModel() {
            return ComponentPropertyModel.this;
        }

        protected String propertyExpression() {
            return this.propertyName;
        }

        @Override
        public P getObject() {
            return (P)PropertyResolver.getValue(this.propertyName, this.component.getParent().getInnermostModel().getObject());
        }

        @Override
        public void detach() {
            ComponentPropertyModel.this.detach();
        }
    }
}

