/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.statistics;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.caseditor.editor.AnnotationEditor;
import org.apache.uima.caseditor.editor.ICasDocument;
import org.apache.uima.ruta.statistics.EntryComparator;
import org.apache.uima.ruta.statistics.StatisticsContentProvider;
import org.apache.uima.ruta.statistics.StatisticsEntry;
import org.apache.uima.ruta.statistics.StatisticsLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.Page;

public class StatisticsViewPage
extends Page
implements IDoubleClickListener,
ISelectionChangedListener,
ISelectionListener {
    private static final String TYPE = "org.apache.uima.ruta.type.Statistics";
    private int current;
    private Map<String, Image> images;
    private TableViewer viewer;
    private AnnotationEditor editor;
    private ICasDocument document;

    public StatisticsViewPage(AnnotationEditor editor) {
        this.editor = editor;
        this.document = editor.getDocument();
    }

    public void dispose() {
        if (this.images != null) {
            for (Image each : this.images.values()) {
                each.dispose();
            }
        }
        super.dispose();
    }

    private void initImages() {
        this.images = new HashMap<String, Image>();
    }

    public Image getImage(String name) {
        if (this.images == null) {
            this.initImages();
        }
        return this.images.get(name);
    }

    public void createControl(Composite parent) {
        FSIterator allIndexedFS;
        this.createViewer(parent);
        CAS cas = this.document.getCAS();
        Type type = cas.getTypeSystem().getType(TYPE);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        if (type != null && (allIndexedFS = cas.getIndexRepository().getAllIndexedFS(type)).isValid()) {
            this.inputChange(allIndexedFS.get());
        }
        this.viewer.refresh();
    }

    private void createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 66306);
        this.createColumns(this.viewer);
        this.viewer.setContentProvider((IContentProvider)new StatisticsContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new StatisticsLabelProvider(this));
    }

    private void createColumns(final TableViewer viewer) {
        Listener sortListener = new Listener(){

            public void handleEvent(Event e) {
                TableColumn sortColumn = viewer.getTable().getSortColumn();
                TableColumn currentColumn = (TableColumn)e.widget;
                int dir = viewer.getTable().getSortDirection();
                if (sortColumn == currentColumn) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    viewer.getTable().setSortColumn(currentColumn);
                    dir = 128;
                }
                int index = Arrays.asList(viewer.getTable().getColumns()).indexOf(currentColumn);
                List input = (List)viewer.getInput();
                Collections.sort(input, new EntryComparator(index, dir == 128));
                viewer.getTable().setSortDirection(dir);
                viewer.getTable().clearAll();
                viewer.setInput((Object)input);
            }
        };
        String[] titles = new String[]{"Name", "Total", "Amount", "Each"};
        int[] bounds = new int[]{100, 100, 75, 100};
        TableViewerColumn column = null;
        for (int i = 0; i < titles.length; ++i) {
            column = new TableViewerColumn(viewer, 0);
            TableColumn tc = column.getColumn();
            tc.setText(titles[i]);
            tc.setWidth(bounds[i]);
            tc.setResizable(true);
            tc.setMoveable(true);
            tc.addListener(13, sortListener);
        }
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setSortColumn(column.getColumn());
        table.setSortDirection(128);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public void doubleClick(DoubleClickEvent event) {
    }

    public void inputChange(Object newInput) {
        if (newInput instanceof FeatureStructure) {
            this.viewer.setInput(StatisticsEntry.createEntries((FeatureStructure)newInput));
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
    }

    public void selectionChanged(IWorkbenchPart arg0, ISelection arg1) {
    }
}

