/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.cde.utils;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;
import org.apache.commons.math3.stat.correlation.SpearmansCorrelation;

public class EvaluationMeasures {
    public static String getMeasureReport(ArrayList<Double[]> results) {
        double[] x = new double[results.size()];
        double[] y = new double[results.size()];
        int index = 0;
        for (Double[] resultPair : results) {
            x[index] = resultPair[0];
            y[index] = resultPair[1];
            ++index;
        }
        double mse = EvaluationMeasures.meanSquareError(x, y);
        double spearmans = new SpearmansCorrelation().correlation(x, y);
        double pearsons = new PearsonsCorrelation().correlation(x, y);
        double cosine = EvaluationMeasures.cosine(x, y);
        mse = EvaluationMeasures.round(mse);
        spearmans = EvaluationMeasures.round(spearmans);
        pearsons = EvaluationMeasures.round(pearsons);
        cosine = EvaluationMeasures.round(cosine);
        String report = "mse=" + mse + "  spearmans=" + spearmans + "  pearsons=" + pearsons + "  cosine=" + cosine;
        return report;
    }

    public static double round(double d) {
        DecimalFormat instance = (DecimalFormat)DecimalFormat.getInstance(Locale.US);
        instance.applyPattern("#.####");
        String format = instance.format(d);
        try {
            return Double.valueOf(format);
        }
        catch (Exception e) {
            return d;
        }
    }

    public static double cosine(double[] a1, double[] a2) {
        ArrayRealVector v1 = new ArrayRealVector(a1);
        ArrayRealVector v2 = new ArrayRealVector(a2);
        return v1.dotProduct((RealVector)v2) / (v1.getNorm() * v2.getNorm());
    }

    public static double cosine(ArrayList<Double[]> results) {
        double[] x = new double[results.size()];
        double[] y = new double[results.size()];
        int index = 0;
        for (Double[] resultPair : results) {
            x[index] = resultPair[0];
            y[index] = resultPair[1];
            ++index;
        }
        return EvaluationMeasures.cosine(x, y);
    }

    public static double meanSquareError(double[] x, double[] y) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double xi = x[i];
            double yi = y[i];
            double diff = xi - yi;
            sum += diff * diff;
        }
        return sum / (double)x.length;
    }
}

