/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.event;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import org.apache.openjpa.event.TCPRemoteCommitProvider;
import org.apache.openjpa.lib.util.J2DoPrivHelper;

public abstract class DynamicTCPRemoteCommitProvider
extends TCPRemoteCommitProvider {
    private int _cacheDurationMillis = 30000;

    public int getCacheDurationMillis() {
        return this._cacheDurationMillis;
    }

    public void setCacheDurationMillis(int _cacheDurationMillis) {
        this._cacheDurationMillis = _cacheDurationMillis;
    }

    @Override
    public final void setAddresses(String names) throws UnknownHostException {
        throw new UnknownHostException("Do not set Addresses on this instance; did you expect " + TCPRemoteCommitProvider.class.getSimpleName() + " ?");
    }

    @Override
    public void endConfiguration() {
        TcpAddressesUpdater updater = new TcpAddressesUpdater();
        updater.run();
        Timer timer = new Timer(true);
        timer.scheduleAtFixedRate((TimerTask)updater, 0L, (long)this._cacheDurationMillis);
        super.endConfiguration();
    }

    protected abstract List<String> fetchDynamicAddresses();

    private class TcpAddressesUpdater
    extends TimerTask {
        private TcpAddressesUpdater() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            List<String> dynamicAddresses = DynamicTCPRemoteCommitProvider.this.fetchDynamicAddresses();
            DynamicTCPRemoteCommitProvider.this._addressesLock.lock();
            try {
                String localhostAddress = InetAddress.getLocalHost().getHostAddress();
                for (String dynamic : dynamicAddresses) {
                    InetAddress tmpAddress = AccessController.doPrivileged(J2DoPrivHelper.getByNameAction(dynamic));
                    if (localhostAddress.equals(dynamic)) {
                        if (!DynamicTCPRemoteCommitProvider.this.log.isTraceEnabled()) continue;
                        DynamicTCPRemoteCommitProvider.this.log.trace(TCPRemoteCommitProvider.s_loc.get("tcp-address-asself", tmpAddress.getHostAddress() + ":" + DynamicTCPRemoteCommitProvider.this._port));
                        continue;
                    }
                    TCPRemoteCommitProvider.HostAddress podAddress = new TCPRemoteCommitProvider.HostAddress(DynamicTCPRemoteCommitProvider.this, dynamic);
                    if (DynamicTCPRemoteCommitProvider.this._addresses.contains(podAddress)) {
                        if (!DynamicTCPRemoteCommitProvider.this.log.isTraceEnabled()) continue;
                        DynamicTCPRemoteCommitProvider.this.log.trace(TCPRemoteCommitProvider.s_loc.get("dyntcp-address-not-set", podAddress.getAddress().getHostAddress() + ":" + podAddress.getPort()));
                        continue;
                    }
                    DynamicTCPRemoteCommitProvider.this._addresses.add(podAddress);
                    if (!DynamicTCPRemoteCommitProvider.this.log.isTraceEnabled()) continue;
                    DynamicTCPRemoteCommitProvider.this.log.trace(TCPRemoteCommitProvider.s_loc.get("dyntcp-address-set", podAddress.getAddress().getHostAddress() + ":" + podAddress.getPort()));
                }
                List<TCPRemoteCommitProvider.HostAddress> toCloseAndRemove = DynamicTCPRemoteCommitProvider.this._addresses.stream().filter(address -> !dynamicAddresses.contains(address.getAddress().getHostAddress())).collect(Collectors.toList());
                toCloseAndRemove.forEach(address -> {
                    address.close();
                    DynamicTCPRemoteCommitProvider.this._addresses.remove(address);
                    if (DynamicTCPRemoteCommitProvider.this.log.isTraceEnabled()) {
                        DynamicTCPRemoteCommitProvider.this.log.trace(TCPRemoteCommitProvider.s_loc.get("tcp-address-unset", address.getAddress().getHostAddress() + ":" + address.getPort()));
                    }
                });
            }
            catch (Exception e) {
                if (DynamicTCPRemoteCommitProvider.this.log.isErrorEnabled()) {
                    DynamicTCPRemoteCommitProvider.this.log.error(TCPRemoteCommitProvider.s_loc.get("dyntcp-updater-error"), e);
                }
            }
            finally {
                DynamicTCPRemoteCommitProvider.this._addressesLock.unlock();
            }
        }
    }
}

