/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io;

import io.smallrye.openapi.api.models.ExternalDocumentationImpl;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.ModelIO;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.extensions.ExtensionIO;
import java.util.Optional;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.jboss.jandex.AnnotationInstance;

public class ExternalDocumentationIO<V, A extends V, O extends V, AB, OB>
extends ModelIO<ExternalDocumentation, V, A, O, AB, OB> {
    private static final String PROP_DESCRIPTION = "description";
    private static final String PROP_URL = "url";
    private final ExtensionIO<V, A, O, AB, OB> extensionIO;

    public ExternalDocumentationIO(IOContext<V, A, O, AB, OB> context, ExtensionIO<V, A, O, AB, OB> extensionIO) {
        super(context, Names.EXTERNAL_DOCUMENTATION, Names.create(ExternalDocumentation.class));
        this.extensionIO = extensionIO;
    }

    @Override
    public ExternalDocumentation read(AnnotationInstance annotation) {
        IoLogging.logger.annotation("@ExternalDocumentation");
        ExternalDocumentationImpl model = new ExternalDocumentationImpl();
        model.setDescription((String)this.value(annotation, PROP_DESCRIPTION));
        model.setUrl((String)this.value(annotation, PROP_URL));
        model.setExtensions(this.extensionIO.readExtensible(annotation));
        return model;
    }

    @Override
    public ExternalDocumentation readObject(O node) {
        ExternalDocumentationImpl model = new ExternalDocumentationImpl();
        this.jsonIO().getString(node, PROP_DESCRIPTION);
        model.setDescription(this.jsonIO().getString(node, PROP_DESCRIPTION));
        model.setUrl(this.jsonIO().getString(node, PROP_URL));
        model.setExtensions(this.extensionIO.readMap(node));
        return model;
    }

    @Override
    public Optional<O> write(ExternalDocumentation model) {
        return this.optionalJsonObject(model).map(node -> {
            this.setIfPresent(node, PROP_DESCRIPTION, this.jsonIO().toJson(model.getDescription()));
            this.setIfPresent(node, PROP_URL, this.jsonIO().toJson(model.getUrl()));
            this.setAllIfPresent(node, this.extensionIO.write((Extensible<?>)model));
            return node;
        }).map(this.jsonIO()::buildObject);
    }
}

