/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import javax.security.auth.Subject;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.Jre20Compat;
import org.apache.tomcat.util.res.StringManager;

public class Jre21Compat
extends Jre20Compat {
    private static final Log log = LogFactory.getLog(Jre21Compat.class);
    private static final StringManager sm = StringManager.getManager(Jre21Compat.class);
    private static final boolean supported;
    private static final Method nameMethod;
    private static final Method startMethod;
    private static final Method ofVirtualMethod;
    private static final Method callAsMethod;

    static boolean isSupported() {
        return supported;
    }

    @Override
    public Object createVirtualThreadBuilder(String name) {
        try {
            Object threadBuilder = ofVirtualMethod.invoke(null, (Object[])null);
            nameMethod.invoke(threadBuilder, name, 0L);
            return threadBuilder;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public void threadBuilderStart(Object threadBuilder, Runnable command) {
        try {
            startMethod.invoke(threadBuilder, command);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public <T> T callAs(Subject subject, Callable<T> action) throws CompletionException {
        try {
            return (T)callAsMethod.invoke(null, subject, action);
        }
        catch (IllegalAccessException e) {
            throw new CompletionException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof CompletionException) {
                throw (CompletionException)cause;
            }
            throw new CompletionException(e);
        }
    }

    @Override
    public boolean isCanonCachesDisabled() {
        return true;
    }

    @Override
    public boolean disableCanonCaches() {
        return true;
    }

    static {
        Class<?> c1 = null;
        Method m1 = null;
        Method m2 = null;
        Method m3 = null;
        Method m4 = null;
        try {
            c1 = Class.forName("java.util.SequencedCollection");
            Class<?> c2 = Class.forName("java.lang.Thread$Builder");
            m1 = c2.getMethod("name", String.class, Long.TYPE);
            m2 = c2.getMethod("start", Runnable.class);
            m3 = Thread.class.getMethod("ofVirtual", null);
            m4 = Subject.class.getMethod("callAs", Subject.class, Callable.class);
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)sm.getString("jre21Compat.javaPre21"), (Throwable)e);
        }
        catch (ReflectiveOperationException e) {
            log.error((Object)sm.getString("jre21Compat.unexpected"), (Throwable)e);
        }
        supported = c1 != null;
        nameMethod = m1;
        startMethod = m2;
        ofVirtualMethod = m3;
        callAsMethod = m4;
    }
}

