/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.context;

import io.opentelemetry.context.Context;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

abstract class ForwardingExecutorService
implements ExecutorService {
    private final ExecutorService delegate;

    protected ForwardingExecutorService(ExecutorService delegate) {
        this.delegate = delegate;
    }

    ExecutorService delegate() {
        return this.delegate;
    }

    @Override
    public final void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public final List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public final boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public final boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public final boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    protected static <T> Collection<? extends Callable<T>> wrap(Context context, Collection<? extends Callable<T>> tasks) {
        ArrayList<Callable<T>> wrapped = new ArrayList<Callable<T>>();
        for (Callable<T> task : tasks) {
            wrapped.add(context.wrap(task));
        }
        return wrapped;
    }
}

