/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import jakarta.ejb.EJBContext;
import jakarta.ejb.EntityContext;
import jakarta.ejb.MessageDrivenContext;
import jakarta.ejb.SessionContext;
import jakarta.ejb.TimerService;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import jakarta.transaction.UserTransaction;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.xml.ws.WebServiceContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.jee.ApplicationClient;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.JndiReference;

public class LinkBuiltInTypes
implements DynamicDeployer {
    @Override
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        ApplicationClient consumer;
        for (ClientModule clientModule : appModule.getClientModules()) {
            consumer = clientModule.getApplicationClient();
            if (consumer == null) continue;
            this.link((JndiConsumer)consumer);
        }
        for (WebModule webModule : appModule.getWebModules()) {
            consumer = webModule.getWebApp();
            if (consumer == null) continue;
            this.link((JndiConsumer)consumer);
        }
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            EjbJar ejbJar = ejbModule.getEjbJar();
            if (ejbJar == null) continue;
            for (EnterpriseBean consumer2 : ejbJar.getEnterpriseBeans()) {
                this.link((JndiConsumer)consumer2);
            }
        }
        return appModule;
    }

    private void link(JndiConsumer consumer) {
        HashMap<String, String> links = new HashMap<String, String>();
        this.add(links, BeanManager.class, new Class[0]);
        this.add(links, Validator.class, new Class[0]);
        this.add(links, ValidatorFactory.class, new Class[0]);
        this.add(links, EJBContext.class, EntityContext.class, SessionContext.class, MessageDrivenContext.class);
        this.add(links, UserTransaction.class, new Class[0]);
        this.add(links, TransactionManager.class, new Class[0]);
        this.add(links, TransactionSynchronizationRegistry.class, new Class[0]);
        this.add(links, TimerService.class, new Class[0]);
        this.add(links, WebServiceContext.class, new Class[0]);
        ArrayList refs = new ArrayList();
        refs.addAll(consumer.getResourceRef());
        refs.addAll(consumer.getResourceEnvRef());
        for (JndiReference ref : refs) {
            String link = (String)links.get(ref.getType());
            if (link == null) continue;
            if (ref.getName().equals(link)) {
                ref.setLookupName(null);
                continue;
            }
            ref.setLookupName(link);
        }
    }

    private void add(Map<String, String> links, Class<?> type, Class ... aliases) {
        links.put(type.getName(), "java:comp/" + type.getSimpleName());
        for (Class clazz : aliases) {
            links.put(clazz.getName(), "java:comp/" + type.getSimpleName());
        }
    }
}

