/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.openejb.cipher.PasswordCipher;
import org.apache.openejb.cipher.PasswordCipherException;
import org.apache.openejb.cipher.PasswordCipherFactory;
import org.apache.openejb.cipher.SafePasswordCipher;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.JavaSecurityManagers;
import org.apache.openejb.util.SuperProperties;

public final class PropertyPlaceHolderHelper {
    private static final String PREFIX = "${";
    private static final String SUFFIX = "}";
    private static final String VALUE_DELIMITER;
    private static final Properties CACHE;
    private static final PropertiesLookup RESOLVER_TO_NULL_IF_MISSING;
    private static final PropertiesLookup RESOLVER_TO_KEY_IF_MISSING;
    private static final StrSubstitutor DEFAULT_SUBSTITUTOR;
    private static final StrSubstitutor VALUE_DELIMITER_SUBSTITUTOR;
    private static final String CIPHER_PREFIX = "cipher:";
    private static final String JAVA_PREFIX = "java:";

    private PropertyPlaceHolderHelper() {
    }

    public static void reset() {
        CACHE.clear();
        RESOLVER_TO_NULL_IF_MISSING.reload();
        RESOLVER_TO_KEY_IF_MISSING.reload();
    }

    public static String simpleValue(String raw) {
        return (String)String.class.cast(PropertyPlaceHolderHelper.simpleValueAsStringOrCharArray(raw, false));
    }

    public static Object simpleValueAsStringOrCharArray(String raw) {
        return PropertyPlaceHolderHelper.simpleValueAsStringOrCharArray(raw, true);
    }

    private static Object simpleValueAsStringOrCharArray(String raw, boolean acceptCharArray) {
        if (raw == null) {
            return null;
        }
        if (!raw.contains(PREFIX) || !raw.contains(SUFFIX)) {
            return PropertyPlaceHolderHelper.decryptIfNeeded(raw, acceptCharArray);
        }
        String value = PropertyPlaceHolderHelper.replace(raw);
        if (!value.equals(raw) && value.startsWith(JAVA_PREFIX)) {
            value = value.substring(5);
        }
        return PropertyPlaceHolderHelper.decryptIfNeeded(value, acceptCharArray);
    }

    private static Object decryptIfNeeded(String replace, boolean acceptCharArray) {
        if (replace.startsWith(CIPHER_PREFIX)) {
            PasswordCipher cipher;
            String algo = replace.substring(CIPHER_PREFIX.length(), replace.indexOf(58, CIPHER_PREFIX.length() + 1));
            try {
                cipher = PasswordCipherFactory.getPasswordCipher(algo);
            }
            catch (PasswordCipherException ex) {
                try {
                    cipher = (PasswordCipher)PasswordCipher.class.cast(Thread.currentThread().getContextClassLoader().loadClass(algo).newInstance());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
            char[] input = replace.substring(CIPHER_PREFIX.length() + algo.length() + 1).toCharArray();
            return acceptCharArray && SafePasswordCipher.class.isInstance(cipher) ? (Object)((SafePasswordCipher)SafePasswordCipher.class.cast(cipher)).decryptAsCharArray(input) : cipher.decrypt(input);
        }
        return replace;
    }

    public static String value(String raw) {
        if (raw == null) {
            return null;
        }
        if (!raw.contains(PREFIX) || !raw.contains(SUFFIX)) {
            return (String)String.class.cast(PropertyPlaceHolderHelper.decryptIfNeeded(raw, false));
        }
        String value = CACHE.getProperty(raw);
        if (value != null) {
            return value;
        }
        value = PropertyPlaceHolderHelper.simpleValue(raw);
        CACHE.setProperty(raw, value);
        return value;
    }

    public static Properties simpleHolds(Properties properties) {
        return PropertyPlaceHolderHelper.holds(properties, false);
    }

    public static Properties holds(Properties properties) {
        return PropertyPlaceHolderHelper.holds(properties, true);
    }

    private static Properties holds(Properties properties, boolean cache) {
        SuperProperties updated = new SuperProperties();
        if (properties == null) {
            return updated;
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object rawValue = entry.getValue();
            if (rawValue instanceof String) {
                String value = (String)rawValue;
                ((Properties)updated).put(entry.getKey(), cache ? PropertyPlaceHolderHelper.value(value) : PropertyPlaceHolderHelper.simpleValueAsStringOrCharArray(value));
                continue;
            }
            ((Properties)updated).put(entry.getKey(), rawValue);
        }
        return updated;
    }

    public static void holdsWithUpdate(Properties props) {
        Properties toUpdate = PropertyPlaceHolderHelper.holds(props);
        props.putAll((Map<?, ?>)toUpdate);
    }

    public static String replace(String raw) {
        if (raw == null) {
            return null;
        }
        if (raw.contains(VALUE_DELIMITER)) {
            return DEFAULT_SUBSTITUTOR.replace(VALUE_DELIMITER_SUBSTITUTOR.replace(raw));
        }
        return DEFAULT_SUBSTITUTOR.replace(raw);
    }

    static {
        CACHE = new Properties();
        RESOLVER_TO_NULL_IF_MISSING = new PropertiesLookup(false);
        RESOLVER_TO_KEY_IF_MISSING = new PropertiesLookup(true);
        DEFAULT_SUBSTITUTOR = new StrSubstitutor((StrLookup)RESOLVER_TO_KEY_IF_MISSING);
        VALUE_DELIMITER_SUBSTITUTOR = new StrSubstitutor((StrLookup)RESOLVER_TO_NULL_IF_MISSING);
        VALUE_DELIMITER = JavaSecurityManagers.getSystemProperty("openejb.placeholder.delimiter", ":-");
        DEFAULT_SUBSTITUTOR.setEnableSubstitutionInVariables(true);
        DEFAULT_SUBSTITUTOR.setValueDelimiter(VALUE_DELIMITER);
        VALUE_DELIMITER_SUBSTITUTOR.setPreserveEscapes(true);
        VALUE_DELIMITER_SUBSTITUTOR.setEnableSubstitutionInVariables(true);
        VALUE_DELIMITER_SUBSTITUTOR.setValueDelimiter(VALUE_DELIMITER);
    }

    private static class PropertiesLookup
    extends StrLookup<Object> {
        private static final Map<String, String> ENV = System.getenv();
        private final boolean resolveToKey;

        public PropertiesLookup(boolean resolveToKey) {
            this.resolveToKey = resolveToKey;
        }

        public synchronized String lookup(String key) {
            String value = SystemInstance.get().getProperties().getProperty(key);
            if (value != null) {
                return value;
            }
            value = ENV.get(key);
            if (value != null) {
                return value;
            }
            return this.resolveToKey ? key : null;
        }

        public synchronized void reload() {
        }
    }
}

