/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.syncope.client.console.pages;

import org.apache.syncope.client.ui.commons.Constants;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.wicketstuff.kendo.ui.widget.notification.Notification;

public class OIDCClientSelfReg extends WebPage {

    private static final long serialVersionUID = 864538706654644353L;

    private static final String OIDC_ACCESS_ERROR =
            "OpenID Connect error - Admin Console does not support Self Registration";

    public OIDCClientSelfReg(final PageParameters parameters) {
        super(parameters);

        PageParameters loginParameters = new PageParameters();
        loginParameters.add(Constants.NOTIFICATION_MSG_PARAM, OIDC_ACCESS_ERROR);
        loginParameters.add(Constants.NOTIFICATION_LEVEL_PARAM, Notification.ERROR);
        setResponsePage(Login.class, loginParameters);
    }
}
