/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.core.definition.pattern;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tiles.api.Definition;
import org.apache.tiles.api.Expression;
import org.apache.tiles.core.definition.pattern.AbstractPatternDefinitionResolver;
import org.apache.tiles.core.definition.pattern.DefinitionPatternMatcher;
import org.apache.tiles.core.definition.pattern.DefinitionPatternMatcherFactory;
import org.apache.tiles.core.definition.pattern.PatternUtil;

public class PrefixedPatternDefinitionResolver<T>
extends AbstractPatternDefinitionResolver<T> {
    private static final Logger LOG = LogManager.getLogger(PrefixedPatternDefinitionResolver.class);
    private final Map<String, DefinitionPatternMatcherFactory> language2matcherFactory = new HashMap<String, DefinitionPatternMatcherFactory>();

    public void registerDefinitionPatternMatcherFactory(String language, DefinitionPatternMatcherFactory factory) {
        this.language2matcherFactory.put(language, factory);
    }

    @Override
    protected Map<String, Definition> addDefinitionsAsPatternMatchers(List<DefinitionPatternMatcher> matchers, Map<String, Definition> defsMap) {
        LinkedHashSet<String> excludedKeys = new LinkedHashSet<String>();
        for (Map.Entry<String, Definition> entry : defsMap.entrySet()) {
            String key = entry.getKey();
            Expression expression = Expression.createExpressionFromDescribedExpression(key);
            if (expression.getLanguage() != null) {
                DefinitionPatternMatcherFactory factory = this.language2matcherFactory.get(expression.getLanguage());
                if (factory != null) {
                    DefinitionPatternMatcher matcher = factory.createDefinitionPatternMatcher(expression.getExpression(), new Definition(entry.getValue()));
                    matchers.add(matcher);
                    continue;
                }
                LOG.warn("Cannot find a DefinitionPatternMatcherFactory for expression '{}'", (Object)key);
                continue;
            }
            excludedKeys.add(key);
        }
        return PatternUtil.createExtractedMap(defsMap, excludedKeys);
    }
}

