% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/mllib_regression.R
\name{spark.fmRegressor}
\alias{spark.fmRegressor}
\alias{spark.fmRegressor,SparkDataFrame,formula-method}
\alias{summary,FMRegressionModel-method}
\alias{predict,FMRegressionModel-method}
\alias{predict,FMRegressionModel,SparkDataFrame-method}
\alias{write.ml,FMRegressionModel,character-method}
\title{Factorization Machines Regression Model}
\usage{
spark.fmRegressor(data, formula, ...)

\S4method{spark.fmRegressor}{SparkDataFrame,formula}(
  data,
  formula,
  factorSize = 8,
  fitLinear = TRUE,
  regParam = 0,
  miniBatchFraction = 1,
  initStd = 0.01,
  maxIter = 100,
  stepSize = 1,
  tol = 1e-06,
  solver = c("adamW", "gd"),
  seed = NULL,
  stringIndexerOrderType = c("frequencyDesc", "frequencyAsc", "alphabetDesc",
    "alphabetAsc")
)

\S4method{summary}{FMRegressionModel}(object)

\S4method{predict}{FMRegressionModel}(object, newData)

\S4method{write.ml}{FMRegressionModel,character}(object, path, overwrite = FALSE)
}
\arguments{
\item{data}{a \code{SparkDataFrame} of observations and labels for model fitting.}

\item{formula}{a symbolic description of the model to be fitted. Currently only a few formula
operators are supported, including '~', '.', ':', '+', and '-'.}

\item{...}{additional arguments passed to the method.}

\item{factorSize}{dimensionality of the factors.}

\item{fitLinear}{whether to fit linear term.  # TODO Can we express this with formula?}

\item{regParam}{the regularization parameter.}

\item{miniBatchFraction}{the mini-batch fraction parameter.}

\item{initStd}{the standard deviation of initial coefficients.}

\item{maxIter}{maximum iteration number.}

\item{stepSize}{stepSize parameter.}

\item{tol}{convergence tolerance of iterations.}

\item{solver}{solver parameter, supported options: "gd" (minibatch gradient descent) or "adamW".}

\item{seed}{seed parameter for weights initialization.}

\item{stringIndexerOrderType}{how to order categories of a string feature column. This is used to
decide the base level of a string feature as the last category
after ordering is dropped when encoding strings. Supported options
are "frequencyDesc", "frequencyAsc", "alphabetDesc", and
"alphabetAsc". The default value is "frequencyDesc". When the
ordering is set to "alphabetDesc", this drops the same category
as R when encoding strings.}

\item{object}{a FM Regression Model model fitted by \code{spark.fmRegressor}.}

\item{newData}{a SparkDataFrame for testing.}

\item{path}{The directory where the model is saved.}

\item{overwrite}{Overwrites or not if the output path already exists. Default is FALSE
which means throw exception if the output path exists.}
}
\value{
\code{spark.fmRegressor} returns a fitted Factorization Machines Regression Model.

\code{summary} returns summary information of the fitted model, which is a list.

\code{predict} returns the predicted values based on an FMRegressionModel.
}
\description{
\code{spark.fmRegressor} fits a factorization regression model against a SparkDataFrame.
Users can call \code{summary} to print a summary of the fitted model, \code{predict} to make
predictions on new data, and \code{write.ml}/\code{read.ml} to save/load fitted models.
}
\note{
spark.fmRegressor since 3.1.0

summary(FMRegressionModel) since 3.1.0

predict(FMRegressionModel) since 3.1.0

write.ml(FMRegressionModel, character) since 3.1.0
}
\examples{
\dontrun{
df <- read.df("data/mllib/sample_linear_regression_data.txt", source = "libsvm")

# fit Factorization Machines Regression Model
model <- spark.fmRegressor(
  df, label ~ features,
  regParam = 0.01, maxIter = 10, fitLinear = TRUE
)

# get the summary of the model
summary(model)

# make predictions
predictions <- predict(model, df)

# save and load the model
path <- "path/to/model"
write.ml(model, path)
savedModel <- read.ml(path)
summary(savedModel)
}
}
\seealso{
\link{read.ml}
}
