/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.jdbc.connection;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.security.auth.login.Configuration;
import org.apache.spark.internal.Logging;
import org.apache.spark.security.SecurityConfigurationLock$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.jdbc.JdbcConnectionProvider;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001}3QAB\u0004\u0002\u0012aAQ!\n\u0001\u0005\u0002\u0019Bq!\u000b\u0001C\u0002\u0013E!\u0006\u0003\u0004=\u0001\u0001\u0006Ia\u000b\u0005\u0006{\u0001!\tA\u0010\u0005\u0006\u007f\u0001!\t\u0001\u0011\u0002\u0017\u0007>tg.Z2uS>t\u0007K]8wS\u0012,'OQ1tK*\u0011\u0001\"C\u0001\u000bG>tg.Z2uS>t'B\u0001\u0006\f\u0003\u0011QGMY2\u000b\u00051i\u0011a\u00033bi\u0006\u001cx.\u001e:dKNT!AD\b\u0002\u0013\u0015DXmY;uS>t'B\u0001\t\u0012\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003%M\tQa\u001d9be.T!\u0001F\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0012aA8sO\u000e\u00011c\u0001\u0001\u001a?A\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t1\u0011I\\=SK\u001a\u0004\"\u0001I\u0012\u000e\u0003\u0005R!AI\t\u0002\u0011%tG/\u001a:oC2L!\u0001J\u0011\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012a\n\t\u0003Q\u0001i\u0011aB\u0001\naJ|g/\u001b3feN,\u0012a\u000b\t\u0004YQ:dBA\u00173\u001d\tq\u0013'D\u00010\u0015\t\u0001t#\u0001\u0004=e>|GOP\u0005\u00029%\u00111gG\u0001\ba\u0006\u001c7.Y4f\u0013\t)dGA\u0002TKFT!aM\u000e\u0011\u0005aRT\"A\u001d\u000b\u0005)y\u0011BA\u001e:\u0005YQEMY2D_:tWm\u0019;j_:\u0004&o\u001c<jI\u0016\u0014\u0018A\u00039s_ZLG-\u001a:tA\u0005iAn\\1e!J|g/\u001b3feN$\u0012aK\u0001\u0007GJ,\u0017\r^3\u0015\t\u0005CUJ\u0017\t\u0003\u0005\u001ak\u0011a\u0011\u0006\u0003!\u0011S\u0011!R\u0001\u0005U\u00064\u0018-\u0003\u0002H\u0007\nQ1i\u001c8oK\u000e$\u0018n\u001c8\t\u000b%+\u0001\u0019\u0001&\u0002\r\u0011\u0014\u0018N^3s!\t\u00115*\u0003\u0002M\u0007\n1AI]5wKJDQAT\u0003A\u0002=\u000bqa\u001c9uS>t7\u000f\u0005\u0003Q)^;fBA)S!\tq3$\u0003\u0002T7\u00051\u0001K]3eK\u001aL!!\u0016,\u0003\u00075\u000b\u0007O\u0003\u0002T7A\u0011\u0001\u000bW\u0005\u00033Z\u0013aa\u0015;sS:<\u0007\"B.\u0006\u0001\u0004a\u0016AF2p]:,7\r^5p]B\u0013xN^5eKJt\u0015-\\3\u0011\u0007iiv+\u0003\u0002_7\t1q\n\u001d;j_:\u0004")
public abstract class ConnectionProviderBase
implements Logging {
    private final Seq<JdbcConnectionProvider> providers;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Seq<JdbcConnectionProvider> providers() {
        return this.providers;
    }

    public Seq<JdbcConnectionProvider> loadProviders() {
        ServiceLoader<JdbcConnectionProvider> loader = ServiceLoader.load(JdbcConnectionProvider.class, Utils$.MODULE$.getContextOrSparkClassLoader());
        ArrayBuffer providers = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Iterator<JdbcConnectionProvider> iterator = loader.iterator();
        while (iterator.hasNext()) {
            BoxedUnit boxedUnit;
            try {
                JdbcConnectionProvider provider = iterator.next();
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Loaded built-in provider: ").append(provider).toString());
                boxedUnit = providers.$plus$eq((Object)provider);
            }
            catch (Throwable t) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to load built-in provider.");
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Loading of the provider failed with the exception:", t);
                boxedUnit = BoxedUnit.UNIT;
            }
        }
        Seq disabledProviders = Utils$.MODULE$.stringToSeq(SQLConf$.MODULE$.get().disabledJdbcConnectionProviders());
        return ((SeqLike)providers.filterNot((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)disabledProviders.contains((Object)p.name())))).toSeq();
    }

    public Connection create(Driver driver, Map<String, String> options, Option<String> connectionProviderName) {
        JdbcConnectionProvider jdbcConnectionProvider;
        Seq filteredProviders = (Seq)this.providers().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.canHandle(driver, (Map<String, String>)options)));
        if (filteredProviders.isEmpty()) {
            throw new IllegalArgumentException("Empty list of JDBC connection providers for the specified driver and options");
        }
        Option<String> option = connectionProviderName;
        if (option instanceof Some) {
            Some some = (Some)option;
            String providerName = (String)some.value();
            jdbcConnectionProvider = (JdbcConnectionProvider)filteredProviders.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ConnectionProviderBase.$anonfun$create$2(providerName, x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(129).append("Could not find a JDBC connection provider with name '").append(providerName).append("' ").append("that can handle the specified driver and options. ").append("Available providers are ").append(this.providers().mkString("[", ", ", "]")).toString());
            });
        } else if (None$.MODULE$.equals(option)) {
            if (filteredProviders.size() != 1) {
                throw new IllegalArgumentException(new StringBuilder(143).append("JDBC connection initiated but more than one connection provider was found. Use ").append("'").append(JDBCOptions$.MODULE$.JDBC_CONNECTION_PROVIDER()).append("' option to select a specific provider. ").append("Found active providers ").append(filteredProviders.mkString("[", ", ", "]")).toString());
            }
            jdbcConnectionProvider = (JdbcConnectionProvider)filteredProviders.head();
        } else {
            throw new MatchError(option);
        }
        JdbcConnectionProvider selectedProvider = jdbcConnectionProvider;
        if (selectedProvider.modifiesSecurityContext(driver, options)) {
            Connection connection;
            SecurityConfigurationLock$ securityConfigurationLock$ = SecurityConfigurationLock$.MODULE$;
            synchronized (securityConfigurationLock$) {
                Connection connection2;
                Configuration parent = Configuration.getConfiguration();
                try {
                    connection2 = selectedProvider.getConnection(driver, options);
                }
                finally {
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Restoring original security configuration");
                    Configuration.setConfiguration(parent);
                }
                connection = connection2;
            }
            return connection;
        }
        return selectedProvider.getConnection(driver, options);
    }

    public static final /* synthetic */ boolean $anonfun$create$2(String providerName$1, JdbcConnectionProvider x$2) {
        String string = x$2.name();
        String string2 = providerName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public ConnectionProviderBase() {
        Logging.$init$((Logging)this);
        this.providers = this.loadProviders();
    }
}

