/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.starter.access.models;

import java.security.Principal;
import org.apache.jackrabbit.api.security.principal.GroupPrincipal;
import org.jetbrains.annotations.NotNull;

public class PrincipalPrivilege {
    private String principalName;
    private boolean isAllow;
    private boolean isDeny;
    private boolean isGroup;

    public PrincipalPrivilege(@NotNull Principal principal) {
        this.principalName = principal.getName();
        this.isGroup = principal instanceof GroupPrincipal;
    }

    public String getName() {
        return this.principalName;
    }

    public String getPrivilegesDisplayName() {
        StringBuilder buffer = new StringBuilder();
        if (this.isAllow) {
            buffer.append("allow");
        }
        if (this.isDeny) {
            if (buffer.length() > 0) {
                buffer.append(" / ");
            }
            buffer.append("deny");
        }
        return buffer.toString();
    }

    public boolean isAllow() {
        return this.isAllow;
    }

    public void setAllow(boolean isAllow) {
        this.isAllow = isAllow;
    }

    public boolean isDeny() {
        return this.isDeny;
    }

    public void setDeny(boolean isDeny) {
        this.isDeny = isDeny;
    }

    public boolean getIsGroup() {
        return this.isGroup;
    }
}

