/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.ImplicitLinkedHashCollection;

public class ImplicitLinkedHashMultiCollection<E extends ImplicitLinkedHashCollection.Element>
extends ImplicitLinkedHashCollection<E> {
    public ImplicitLinkedHashMultiCollection() {
        super(0);
    }

    public ImplicitLinkedHashMultiCollection(int expectedNumElements) {
        super(expectedNumElements);
    }

    public ImplicitLinkedHashMultiCollection(Iterator<E> iter) {
        super(iter);
    }

    @Override
    int addInternal(ImplicitLinkedHashCollection.Element newElement, ImplicitLinkedHashCollection.Element[] addElements) {
        int slot = this.slot(addElements, newElement);
        for (int seen = 0; seen < addElements.length; ++seen) {
            ImplicitLinkedHashCollection.Element element = addElements[slot];
            if (element == null) {
                addElements[slot] = newElement;
                return slot;
            }
            if (element == newElement) {
                return -2;
            }
            slot = (slot + 1) % addElements.length;
        }
        throw new RuntimeException("Not enough hash table slots to add a new element.");
    }

    @Override
    int findElementToRemove(Object key) {
        if (key == null || this.size() == 0) {
            return -2;
        }
        int slot = this.slot(this.elements, key);
        int bestSlot = -2;
        for (int seen = 0; seen < this.elements.length; ++seen) {
            ImplicitLinkedHashCollection.Element element = this.elements[slot];
            if (element == null) {
                return bestSlot;
            }
            if (key == element) {
                return slot;
            }
            if (element.elementKeysAreEqual(key)) {
                bestSlot = slot;
            }
            slot = (slot + 1) % this.elements.length;
        }
        return -2;
    }

    public final List<E> findAll(E key) {
        ImplicitLinkedHashCollection.Element element;
        if (key == null || this.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<ImplicitLinkedHashCollection.Element> results = new ArrayList<ImplicitLinkedHashCollection.Element>();
        int slot = this.slot(this.elements, key);
        for (int seen = 0; seen < this.elements.length && (element = this.elements[slot]) != null; ++seen) {
            if (key.elementKeysAreEqual(element)) {
                ImplicitLinkedHashCollection.Element result = this.elements[slot];
                results.add(result);
            }
            slot = (slot + 1) % this.elements.length;
        }
        return results;
    }
}

