/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.util.Arrays;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridCoverageProcessor;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.PixelInCell;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.referencing.operation.builder.LinearTransformBuilder;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class DomainLinearizer {
    private boolean gridStartsAtZero;
    private double scale = 1.0;
    private GridCoverageProcessor processor;

    public boolean getGridStartsAtZero() {
        return this.gridStartsAtZero;
    }

    public void setGridStartsAtZero(boolean force) {
        this.gridStartsAtZero = force;
    }

    public double getScaleFactor() {
        return this.scale;
    }

    public void setScaleFactor(double factor) {
        ArgumentChecks.ensureStrictlyPositive((String)"factor", (double)factor);
        this.scale = factor;
    }

    private GridCoverageProcessor processor() {
        if (this.processor == null) {
            this.processor = new GridCoverageProcessor();
        }
        return this.processor;
    }

    public GridCoverage apply(GridCoverage coverage) throws TransformException {
        GridGeometry linearized;
        GridGeometry gg = coverage.getGridGeometry();
        if (gg.equals(linearized = this.apply(gg))) {
            return coverage;
        }
        return this.processor().resample(coverage, linearized);
    }

    public GridGeometry apply(GridGeometry gg) throws TransformException {
        if (gg.nonLinears != 0L) {
            try {
                MathTransform gridToCRS = gg.requireGridToCRS(true);
                GeneralEnvelope domain = gg.extent.toEnvelope(true);
                MathTransform approximate = this.modify(LinearTransformBuilder.approximate((MathTransform)gridToCRS, (Envelope)domain));
                MathTransform gridToGrid = MathTransforms.concatenate((MathTransform)gridToCRS, (MathTransform)approximate.inverse());
                domain = Envelopes.transform((MathTransform)gridToGrid, (Envelope)domain);
                int dimension = domain.getDimension();
                long[] coordinates = new long[dimension * 2];
                double[] shift = new double[dimension];
                for (int i = 0; i < dimension; ++i) {
                    long low = Math.round(domain.getMinimum(i));
                    long high = Math.round(domain.getMaximum(i));
                    high = Math.max(low, Math.decrementExact(high));
                    if (this.gridStartsAtZero) {
                        high = Math.subtractExact(high, low);
                        shift[i] = low;
                    } else {
                        coordinates[i] = low;
                    }
                    coordinates[i + dimension] = high;
                }
                approximate = MathTransforms.concatenate((MathTransform)MathTransforms.translation((double[])shift), (MathTransform)approximate);
                if (!approximate.equals((Object)gridToCRS)) {
                    return new GridGeometry(new GridExtent(gg.extent, coordinates), PixelInCell.CELL_CENTER, approximate, gg.envelope.getCoordinateReferenceSystem());
                }
            }
            catch (FactoryException e) {
                Throwable cause = e.getCause();
                if (cause instanceof TransformException) {
                    throw (TransformException)cause;
                }
                throw new TransformException(e.getMessage(), (Throwable)e);
            }
        }
        return gg;
    }

    private MathTransform modify(LinearTransform gridToCRS) {
        double[] factors = new double[gridToCRS.getTargetDimensions()];
        Arrays.fill(factors, this.scale);
        return MathTransforms.concatenate((MathTransform)MathTransforms.scale((double[])factors), (MathTransform)gridToCRS);
    }
}

