/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.image;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.Query;
import org.apache.sis.storage.RasterLoadingStrategy;
import org.apache.sis.storage.UnsupportedQueryException;
import org.apache.sis.storage.image.FormatFinder;
import org.apache.sis.storage.image.WorldFileResource;
import org.apache.sis.storage.image.WorldFileStore;
import org.apache.sis.util.collection.BackingStoreException;
import org.opengis.geometry.Envelope;

final class SingleImageStore
extends WorldFileStore
implements GridCoverageResource {
    private volatile WorldFileResource delegate;

    SingleImageStore(FormatFinder format) throws DataStoreException, IOException {
        super(format);
    }

    @Override
    final boolean isComponentHidden() {
        return true;
    }

    final WorldFileResource delegate() throws DataStoreException {
        WorldFileResource r = this.delegate;
        if (r == null) {
            try {
                this.delegate = r = ((WorldFileStore.Components)((Object)this.components())).get(0);
            }
            catch (BackingStoreException e) {
                throw (DataStoreException)e.unwrapOrRethrow(DataStoreException.class);
            }
        }
        return r;
    }

    @Override
    public final GridGeometry getGridGeometry() throws DataStoreException {
        return this.delegate().getGridGeometry();
    }

    @Override
    public final Optional<Envelope> getEnvelope() throws DataStoreException {
        return this.delegate().getEnvelope();
    }

    @Override
    public final List<double[]> getResolutions() throws DataStoreException {
        return this.delegate().getResolutions();
    }

    @Override
    public final List<SampleDimension> getSampleDimensions() throws DataStoreException {
        return this.delegate().getSampleDimensions();
    }

    @Override
    public final GridCoverageResource subset(Query query) throws UnsupportedQueryException, DataStoreException {
        return this.delegate().subset(query);
    }

    @Override
    public final GridCoverage read(GridGeometry domain, int ... ranges) throws DataStoreException {
        return this.delegate().read(domain, ranges);
    }

    @Override
    public final RasterLoadingStrategy getLoadingStrategy() throws DataStoreException {
        return this.delegate().getLoadingStrategy();
    }

    @Override
    public final boolean setLoadingStrategy(RasterLoadingStrategy strategy) throws DataStoreException {
        return this.delegate().setLoadingStrategy(strategy);
    }
}

