/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.server.upgrade;

import java.net.URI;
import java.util.function.Supplier;
import org.springframework.core.io.buffer.Netty5DataBufferFactory;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.adapter.ReactorNetty2WebSocketSession;
import org.springframework.web.reactive.socket.server.RequestUpgradeStrategy;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.netty5.http.server.HttpServerResponse;
import reactor.netty5.http.server.WebsocketServerSpec;
import reactor.netty5.http.websocket.WebsocketInbound;
import reactor.netty5.http.websocket.WebsocketOutbound;

public class ReactorNetty2RequestUpgradeStrategy
implements RequestUpgradeStrategy {
    private final Supplier<WebsocketServerSpec.Builder> specBuilderSupplier;

    public ReactorNetty2RequestUpgradeStrategy() {
        this(WebsocketServerSpec::builder);
    }

    public ReactorNetty2RequestUpgradeStrategy(Supplier<WebsocketServerSpec.Builder> builderSupplier) {
        Assert.notNull(builderSupplier, (String)"WebsocketServerSpec.Builder is required");
        this.specBuilderSupplier = builderSupplier;
    }

    public WebsocketServerSpec getWebsocketServerSpec() {
        return this.buildSpec(null);
    }

    WebsocketServerSpec buildSpec(@Nullable String subProtocol) {
        WebsocketServerSpec.Builder builder = this.specBuilderSupplier.get();
        if (subProtocol != null) {
            builder.protocols(subProtocol);
        }
        return builder.build();
    }

    @Override
    public Mono<Void> upgrade(ServerWebExchange exchange2, WebSocketHandler handler, @Nullable String subProtocol, Supplier<HandshakeInfo> handshakeInfoFactory) {
        ServerHttpResponse response = exchange2.getResponse();
        HttpServerResponse reactorResponse = (HttpServerResponse)ServerHttpResponseDecorator.getNativeResponse((ServerHttpResponse)response);
        HandshakeInfo handshakeInfo = handshakeInfoFactory.get();
        Netty5DataBufferFactory bufferFactory = (Netty5DataBufferFactory)response.bufferFactory();
        URI uri = exchange2.getRequest().getURI();
        return response.setComplete().then(Mono.defer(() -> {
            WebsocketServerSpec spec = this.buildSpec(subProtocol);
            return reactorResponse.sendWebsocket((in, out) -> {
                ReactorNetty2WebSocketSession session = new ReactorNetty2WebSocketSession((WebsocketInbound)in, (WebsocketOutbound)out, handshakeInfo, bufferFactory, spec.maxFramePayloadLength());
                return handler.handle(session).checkpoint(uri + " [ReactorNetty2RequestUpgradeStrategy]");
            }, spec);
        }));
    }
}

