/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.lang;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.function.ThrowableAction;
import org.apache.dubbo.common.lang.ShutdownHookCallback;
import org.apache.dubbo.common.resource.Disposable;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ShutdownHookCallbacks
implements Disposable {
    private final List<ShutdownHookCallback> callbacks = new LinkedList<ShutdownHookCallback>();
    private final ApplicationModel applicationModel;

    public ShutdownHookCallbacks(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        this.loadCallbacks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShutdownHookCallbacks addCallback(ShutdownHookCallback callback) {
        ShutdownHookCallbacks shutdownHookCallbacks = this;
        synchronized (shutdownHookCallbacks) {
            if (!this.callbacks.contains(callback)) {
                this.callbacks.add(callback);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ShutdownHookCallback> getCallbacks() {
        ShutdownHookCallbacks shutdownHookCallbacks = this;
        synchronized (shutdownHookCallbacks) {
            Collections.sort(this.callbacks);
            return this.callbacks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        ShutdownHookCallbacks shutdownHookCallbacks = this;
        synchronized (shutdownHookCallbacks) {
            this.callbacks.clear();
        }
    }

    private void loadCallbacks() {
        ExtensionLoader<ShutdownHookCallback> loader = this.applicationModel.getExtensionLoader(ShutdownHookCallback.class);
        loader.getSupportedExtensionInstances().forEach(this::addCallback);
    }

    public void callback() {
        this.getCallbacks().forEach(callback -> ThrowableAction.execute(callback::callback));
    }
}

