/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.event;

import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.context.RpcRunningState;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.event.ClientEndInvokeEvent;
import com.alipay.sofa.rpc.event.ConsumerSubEvent;
import com.alipay.sofa.rpc.event.Event;
import com.alipay.sofa.rpc.event.ProviderPubEvent;
import com.alipay.sofa.rpc.event.ServerSendEvent;
import com.alipay.sofa.rpc.event.ServerStartedEvent;
import com.alipay.sofa.rpc.event.ServerStoppedEvent;
import com.alipay.sofa.rpc.event.Subscriber;
import com.alipay.sofa.rpc.metrics.lookout.RpcClientLookoutModel;
import com.alipay.sofa.rpc.metrics.lookout.RpcLookout;
import com.alipay.sofa.rpc.metrics.lookout.RpcServerLookoutModel;

public class LookoutSubscriber
extends Subscriber {
    public static boolean lookoutCollectDisable = RpcConfigs.getBooleanValue("lookout.collect.disable");
    private final RpcLookout rpcMetrics = new RpcLookout();

    public LookoutSubscriber() {
        super(false);
    }

    @Override
    public void onEvent(Event event) {
        if (RpcRunningState.isUnitTestMode() || lookoutCollectDisable) {
            return;
        }
        Class<?> eventClass = event.getClass();
        if (eventClass == ClientEndInvokeEvent.class) {
            ClientEndInvokeEvent clientEndInvokeEvent = (ClientEndInvokeEvent)event;
            RpcClientLookoutModel rpcClientMetricsModel = this.createClientMetricsModel(clientEndInvokeEvent.getRequest(), clientEndInvokeEvent.getResponse());
            this.rpcMetrics.collectClient(rpcClientMetricsModel);
        } else if (eventClass == ServerSendEvent.class) {
            ServerSendEvent serverSendEvent = (ServerSendEvent)event;
            RpcServerLookoutModel rpcServerMetricsModel = this.createServerMetricsModel(serverSendEvent.getRequest(), serverSendEvent.getResponse());
            this.rpcMetrics.collectServer(rpcServerMetricsModel);
        } else if (eventClass == ServerStartedEvent.class) {
            ServerStartedEvent serverStartedEvent = (ServerStartedEvent)event;
            if (serverStartedEvent.getThreadPoolExecutor() != null) {
                this.rpcMetrics.collectThreadPool(serverStartedEvent.getServerConfig(), serverStartedEvent.getThreadPoolExecutor());
            }
        } else if (eventClass == ServerStoppedEvent.class) {
            ServerStoppedEvent serverStartedEvent = (ServerStoppedEvent)event;
            this.rpcMetrics.removeThreadPool(serverStartedEvent.getServerConfig());
        } else if (eventClass == ProviderPubEvent.class) {
            ProviderPubEvent providerPubEvent = (ProviderPubEvent)event;
            this.rpcMetrics.collectProvderPubInfo(providerPubEvent.getProviderConfig());
        } else if (eventClass == ConsumerSubEvent.class) {
            ConsumerSubEvent consumerSubEvent = (ConsumerSubEvent)event;
            this.rpcMetrics.collectConsumerSubInfo(consumerSubEvent.getConsumerConfig());
        }
    }

    private RpcClientLookoutModel createClientMetricsModel(SofaRequest request, SofaResponse response) {
        RpcClientLookoutModel clientMetricsModel = new RpcClientLookoutModel();
        RpcInternalContext context = RpcInternalContext.getContext();
        String app = this.getStringAvoidNull(context.getAttachment("_app_name"));
        String service = request.getTargetServiceUniqueName();
        String method = request.getMethodName();
        String protocol = this.getStringAvoidNull(context.getAttachment("_protocol_name"));
        String invokeType = request.getInvokeType();
        String targetApp = request.getTargetAppName();
        Long requestSize = this.getLongAvoidNull(context.getAttachment("_req_size"));
        Long responseSize = this.getLongAvoidNull(context.getAttachment("_resp_size"));
        Long elapsedTime = this.getLongAvoidNull(context.getAttachment("_client_elapse"));
        Boolean success = response != null && !response.isError() && response.getErrorMsg() == null && !(response.getAppResponse() instanceof Throwable);
        clientMetricsModel.setApp(app);
        clientMetricsModel.setService(service);
        clientMetricsModel.setMethod(method);
        clientMetricsModel.setProtocol(protocol);
        clientMetricsModel.setInvokeType(invokeType);
        clientMetricsModel.setTargetApp(targetApp);
        clientMetricsModel.setRequestSize(requestSize);
        clientMetricsModel.setResponseSize(responseSize);
        clientMetricsModel.setElapsedTime(elapsedTime);
        clientMetricsModel.setSuccess(success);
        return clientMetricsModel;
    }

    private RpcServerLookoutModel createServerMetricsModel(SofaRequest request, SofaResponse response) {
        RpcServerLookoutModel rpcServerMetricsModel = new RpcServerLookoutModel();
        RpcInternalContext context = RpcInternalContext.getContext();
        String app = request.getTargetAppName();
        String service = request.getTargetServiceUniqueName();
        String method = request.getMethodName();
        String protocol = this.getStringAvoidNull(request.getRequestProp("protocol"));
        String invokeType = request.getInvokeType();
        String callerApp = this.getStringAvoidNull(request.getRequestProp("app"));
        Long elapsedTime = this.getLongAvoidNull(context.getAttachment("_impl_elapse"));
        boolean success = response != null && !response.isError() && response.getErrorMsg() == null && !(response.getAppResponse() instanceof Throwable);
        rpcServerMetricsModel.setApp(app);
        rpcServerMetricsModel.setService(service);
        rpcServerMetricsModel.setMethod(method);
        rpcServerMetricsModel.setProtocol(protocol);
        rpcServerMetricsModel.setInvokeType(invokeType);
        rpcServerMetricsModel.setCallerApp(callerApp);
        rpcServerMetricsModel.setElapsedTime(elapsedTime);
        rpcServerMetricsModel.setSuccess(success);
        return rpcServerMetricsModel;
    }

    private String getStringAvoidNull(Object object) {
        if (object == null) {
            return null;
        }
        return (String)object;
    }

    private Long getLongAvoidNull(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Integer) {
            return Long.parseLong(object.toString());
        }
        return (Long)object;
    }

    public static boolean isLookoutCollectDisable() {
        return lookoutCollectDisable;
    }

    public static void setLookoutCollectDisable(boolean lookoutCollectDisable) {
        LookoutSubscriber.lookoutCollectDisable = lookoutCollectDisable;
    }
}

