/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.lightweight;

import com.google.common.eventbus.EventBus;
import org.apache.servicecomb.registry.api.Discovery;
import org.apache.servicecomb.registry.api.DiscoveryInstance;
import org.apache.servicecomb.registry.lightweight.store.Store;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public abstract class AbstractLightweightDiscovery<D extends DiscoveryInstance>
implements Discovery<D> {
    public static final String ZERO_DISCOVERY_ENABLED = "servicecomb.registry.zero-config.%s.%s.enabled";
    protected EventBus eventBus;
    protected Store store;
    private Environment environment;

    @Autowired
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Autowired
    public AbstractLightweightDiscovery<D> setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
        return this;
    }

    @Autowired
    public AbstractLightweightDiscovery<D> setStore(Store store) {
        this.store = store;
        return this;
    }

    public void init() {
        this.eventBus.register((Object)this);
    }

    public void destroy() {
    }

    public boolean enabled(String application, String serviceName) {
        return (Boolean)this.environment.getProperty(String.format(ZERO_DISCOVERY_ENABLED, application, serviceName), Boolean.TYPE, (Object)true);
    }
}

