/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.header;

import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.common.rest.codec.header.HeaderCodec;
import org.apache.servicecomb.common.rest.codec.header.HeaderCodecCsv;
import org.apache.servicecomb.common.rest.codec.header.HeaderCodecMulti;
import org.apache.servicecomb.common.rest.codec.header.HeaderCodecPipes;
import org.apache.servicecomb.common.rest.codec.header.HeaderCodecSimple;
import org.apache.servicecomb.common.rest.codec.header.HeaderCodecSsv;
import org.apache.servicecomb.common.rest.codec.header.HeaderCodecTsv;

public class HeaderCodecsUtils {
    private static final Map<String, HeaderCodec> CODECS = new HashMap<String, HeaderCodec>();

    private HeaderCodecsUtils() {
    }

    public static HeaderCodec find(String collectionFormat) {
        return CODECS.get(HeaderCodecsUtils.formatName(collectionFormat));
    }

    private static String formatName(String collectionFormat) {
        if (collectionFormat == null) {
            return "simple";
        }
        return collectionFormat;
    }

    static {
        CODECS.put("simple", new HeaderCodecSimple());
        CODECS.put("multi", new HeaderCodecMulti());
        CODECS.put("csv", new HeaderCodecCsv());
        CODECS.put("tsv", new HeaderCodecTsv());
        CODECS.put("pipes", new HeaderCodecPipes());
        CODECS.put("ssv", new HeaderCodecSsv());
    }
}

