/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.metrics;

import com.google.common.collect.Lists;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.sdk.metrics.Aggregation;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.View;
import io.opentelemetry.sdk.metrics.ViewBuilder;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.metrics.PopReviveMessageType;
import org.apache.rocketmq.broker.processor.PopBufferMergeService;
import org.apache.rocketmq.broker.processor.PopReviveService;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.metrics.NopLongCounter;
import org.apache.rocketmq.common.metrics.NopLongHistogram;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.PutMessageStatus;
import org.apache.rocketmq.store.exception.ConsumeQueueException;
import org.apache.rocketmq.store.pop.AckMsg;
import org.apache.rocketmq.store.pop.PopCheckPoint;

public class PopMetricsManager {
    private static final Logger log = LoggerFactory.getLogger(PopMetricsManager.class);
    private Supplier<AttributesBuilder> attributesBuilderSupplier;
    private LongHistogram popBufferScanTimeConsume = new NopLongHistogram();
    private LongCounter popRevivePutTotal = new NopLongCounter();
    private LongCounter popReviveGetTotal = new NopLongCounter();
    private LongCounter popReviveRetryMessageTotal = new NopLongCounter();

    public List<Pair<InstrumentSelector, ViewBuilder>> getMetricsView() {
        List<Double> rpcCostTimeBuckets = Arrays.asList(Duration.ofMillis(1L).toMillis(), Duration.ofMillis(10L).toMillis(), Duration.ofMillis(100L).toMillis(), Duration.ofSeconds(1L).toMillis(), Duration.ofSeconds(2L).toMillis(), Duration.ofSeconds(3L).toMillis());
        InstrumentSelector popBufferScanTimeConsumeSelector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setName("rocketmq_pop_buffer_scan_time_consume").build();
        ViewBuilder popBufferScanTimeConsumeViewBuilder = View.builder().setAggregation(Aggregation.explicitBucketHistogram(rpcCostTimeBuckets));
        return Lists.newArrayList((Object[])new Pair[]{new Pair((Object)popBufferScanTimeConsumeSelector, (Object)popBufferScanTimeConsumeViewBuilder)});
    }

    public void initMetrics(Meter meter, BrokerController brokerController, Supplier<AttributesBuilder> attributesBuilderSupplier) {
        this.attributesBuilderSupplier = attributesBuilderSupplier;
        this.popBufferScanTimeConsume = meter.histogramBuilder("rocketmq_pop_buffer_scan_time_consume").setDescription("Time consuming of pop buffer scan").setUnit("milliseconds").ofLongs().build();
        this.popRevivePutTotal = meter.counterBuilder("rocketmq_pop_revive_in_message_total").setDescription("Total number of put message to revive topic").build();
        this.popReviveGetTotal = meter.counterBuilder("rocketmq_pop_revive_out_message_total").setDescription("Total number of get message from revive topic").build();
        this.popReviveRetryMessageTotal = meter.counterBuilder("rocketmq_pop_revive_retry_messages_total").setDescription("Total number of put message to pop retry topic").build();
        meter.gaugeBuilder("rocketmq_pop_offset_buffer_size").setDescription("Time number of buffered offset").ofLongs().buildWithCallback(measurement -> this.calculatePopBufferOffsetSize(brokerController, (ObservableLongMeasurement)measurement));
        meter.gaugeBuilder("rocketmq_pop_checkpoint_buffer_size").setDescription("The number of buffered checkpoint").ofLongs().buildWithCallback(measurement -> this.calculatePopBufferCkSize(brokerController, (ObservableLongMeasurement)measurement));
        meter.gaugeBuilder("rocketmq_pop_revive_lag").setDescription("The processing lag of revive topic").setUnit("milliseconds").ofLongs().buildWithCallback(measurement -> this.calculatePopReviveLag(brokerController, (ObservableLongMeasurement)measurement));
        meter.gaugeBuilder("rocketmq_pop_revive_latency").setDescription("The processing latency of revive topic").setUnit("milliseconds").ofLongs().buildWithCallback(measurement -> this.calculatePopReviveLatency(brokerController, (ObservableLongMeasurement)measurement));
    }

    private void calculatePopBufferOffsetSize(BrokerController brokerController, ObservableLongMeasurement measurement) {
        PopBufferMergeService popBufferMergeService = brokerController.getPopMessageProcessor().getPopBufferMergeService();
        measurement.record((long)popBufferMergeService.getOffsetTotalSize(), this.newAttributesBuilder().build());
    }

    private void calculatePopBufferCkSize(BrokerController brokerController, ObservableLongMeasurement measurement) {
        PopBufferMergeService popBufferMergeService = brokerController.getPopMessageProcessor().getPopBufferMergeService();
        measurement.record((long)popBufferMergeService.getBufferedCKSize(), this.newAttributesBuilder().build());
    }

    private void calculatePopReviveLatency(BrokerController brokerController, ObservableLongMeasurement measurement) {
        PopReviveService[] popReviveServices;
        for (PopReviveService popReviveService : popReviveServices = brokerController.getAckMessageProcessor().getPopReviveServices()) {
            try {
                measurement.record(popReviveService.getReviveBehindMillis(), this.newAttributesBuilder().put("queue_id", (long)popReviveService.getQueueId()).build());
            }
            catch (ConsumeQueueException e) {
                log.error("Failed to get revive behind duration", (Throwable)e);
            }
        }
    }

    private void calculatePopReviveLag(BrokerController brokerController, ObservableLongMeasurement measurement) {
        PopReviveService[] popReviveServices;
        for (PopReviveService popReviveService : popReviveServices = brokerController.getAckMessageProcessor().getPopReviveServices()) {
            try {
                measurement.record(popReviveService.getReviveBehindMessages(), this.newAttributesBuilder().put("queue_id", (long)popReviveService.getQueueId()).build());
            }
            catch (ConsumeQueueException e) {
                log.error("Failed to get revive behind message count", (Throwable)e);
            }
        }
    }

    public void incPopReviveAckPutCount(AckMsg ackMsg, PutMessageStatus status) {
        this.incPopRevivePutCount(ackMsg.getConsumerGroup(), ackMsg.getTopic(), PopReviveMessageType.ACK, status, 1);
    }

    public void incPopReviveCkPutCount(PopCheckPoint checkPoint, PutMessageStatus status) {
        this.incPopRevivePutCount(checkPoint.getCId(), checkPoint.getTopic(), PopReviveMessageType.CK, status, 1);
    }

    public void incPopRevivePutCount(String group, String topic, PopReviveMessageType messageType, PutMessageStatus status, int num) {
        Attributes attributes = this.newAttributesBuilder().put("consumer_group", group).put("topic", topic).put("revive_message_type", messageType.name()).put("put_status", status.name()).build();
        this.popRevivePutTotal.add((long)num, attributes);
    }

    public void incPopReviveAckGetCount(AckMsg ackMsg, int queueId) {
        this.incPopReviveGetCount(ackMsg.getConsumerGroup(), ackMsg.getTopic(), PopReviveMessageType.ACK, queueId, 1);
    }

    public void incPopReviveCkGetCount(PopCheckPoint checkPoint, int queueId) {
        this.incPopReviveGetCount(checkPoint.getCId(), checkPoint.getTopic(), PopReviveMessageType.CK, queueId, 1);
    }

    public void incPopReviveGetCount(String group, String topic, PopReviveMessageType messageType, int queueId, int num) {
        AttributesBuilder builder = this.newAttributesBuilder();
        Attributes attributes = builder.put("consumer_group", group).put("topic", topic).put("queue_id", (long)queueId).put("revive_message_type", messageType.name()).build();
        this.popReviveGetTotal.add((long)num, attributes);
    }

    public void incPopReviveRetryMessageCount(PopCheckPoint checkPoint, PutMessageStatus status) {
        AttributesBuilder builder = this.newAttributesBuilder();
        Attributes attributes = builder.put("consumer_group", checkPoint.getCId()).put("topic", checkPoint.getTopic()).put("put_status", status.name()).build();
        this.popReviveRetryMessageTotal.add(1L, attributes);
    }

    public void recordPopBufferScanTimeConsume(long time) {
        this.popBufferScanTimeConsume.record(time, this.newAttributesBuilder().build());
    }

    public AttributesBuilder newAttributesBuilder() {
        return this.attributesBuilderSupplier != null ? this.attributesBuilderSupplier.get() : Attributes.builder();
    }

    public LongHistogram getPopBufferScanTimeConsume() {
        return this.popBufferScanTimeConsume;
    }

    public LongCounter getPopRevivePutTotal() {
        return this.popRevivePutTotal;
    }

    public LongCounter getPopReviveGetTotal() {
        return this.popReviveGetTotal;
    }

    public LongCounter getPopReviveRetryMessageTotal() {
        return this.popReviveRetryMessageTotal;
    }

    public Supplier<AttributesBuilder> getAttributesBuilderSupplier() {
        return this.attributesBuilderSupplier;
    }

    public void setAttributesBuilderSupplier(Supplier<AttributesBuilder> attributesBuilderSupplier) {
        this.attributesBuilderSupplier = attributesBuilderSupplier;
    }
}

