/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.xml;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.security.AccessController;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.validation.ValidationException;
import org.apache.bval.jsr.ConstraintAnnotationAttributes;
import org.apache.bval.jsr.metadata.ContainerElementKey;
import org.apache.bval.jsr.metadata.Meta;
import org.apache.bval.jsr.metadata.Signature;
import org.apache.bval.jsr.util.Methods;
import org.apache.bval.jsr.xml.BeanType;
import org.apache.bval.jsr.xml.ClassType;
import org.apache.bval.jsr.xml.ConstraintMappingsType;
import org.apache.bval.jsr.xml.ConstraintType;
import org.apache.bval.jsr.xml.ConstructorType;
import org.apache.bval.jsr.xml.ContainerElementTypeType;
import org.apache.bval.jsr.xml.ElementType;
import org.apache.bval.jsr.xml.FieldType;
import org.apache.bval.jsr.xml.GetterType;
import org.apache.bval.jsr.xml.MappingValidator$org_apache_bval_util_reflection_Reflection$$find$$Ljava_lang_Class$Ljava_util_function_Function$_ACTION;
import org.apache.bval.jsr.xml.MappingValidator$org_apache_bval_util_reflection_Reflection$$getDeclaredConstructor$$Ljava_lang_Class$arrayOfLjava_lang_Class$_ACTION;
import org.apache.bval.jsr.xml.MappingValidator$org_apache_bval_util_reflection_Reflection$$getDeclaredField$$Ljava_lang_Class$Ljava_lang_String$_ACTION;
import org.apache.bval.jsr.xml.MappingValidator$org_apache_bval_util_reflection_Reflection$$getDeclaredMethod$$Ljava_lang_Class$Ljava_lang_String$arrayOfLjava_lang_Class$_ACTION;
import org.apache.bval.jsr.xml.MappingValidator$org_apache_bval_util_reflection_Reflection$$getDeclaredMethods$$Ljava_lang_Class$_ACTION;
import org.apache.bval.jsr.xml.MappingValidator$org_apache_bval_util_reflection_Reflection$$hierarchy$$Ljava_lang_Class$Lorg_apache_bval_util_reflection_Reflection$Interfaces$_ACTION;
import org.apache.bval.jsr.xml.MethodType;
import org.apache.bval.jsr.xml.ParameterType;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.Validate;
import org.apache.bval.util.reflection.Reflection;
import org.apache.bval.util.reflection.TypeUtils;
import org.apache.commons.weaver.privilizer.Privileged;
import org.apache.commons.weaver.privilizer.Privilized;
import org.apache.commons.weaver.privilizer.Privilizing;

@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
@Privilized(value="DYNAMIC")
public class MappingValidator {
    private static final Set<ConstraintAnnotationAttributes> RESERVED_CONSTRAINT_ELEMENT_NAMES;
    private final ConstraintMappingsType constraintMappings;
    private final Function<String, Class<?>> resolveClass;

    private static <T> BinaryOperator<T> enforceUniqueness(String message, Function<? super T, ?> describe) {
        return (t, u) -> {
            throw Exceptions.create(ValidationException::new, message, describe.apply(t));
        };
    }

    public MappingValidator(ConstraintMappingsType constraintMappings, Function<String, Class<?>> resolveClass) {
        this.constraintMappings = Validate.notNull(constraintMappings, "constraintMappings", new Object[0]);
        this.resolveClass = Validate.notNull(resolveClass, "resolveClass", new Object[0]);
    }

    public void validateMappings() {
        this.constraintMappings.getBean().stream().map(this::applyChecks).collect(Collectors.toMap(Function.identity(), Function.identity(), MappingValidator.enforceUniqueness("Duplicate XML constrained bean %s", Class::getName)));
    }

    private Class<?> applyChecks(BeanType bean) {
        Class<?> t = this.resolveClass.apply(bean.getClazz());
        ClassType classType = bean.getClassType();
        if (classType != null) {
            this.constraints(new Meta.ForClass(t), classType.getConstraint());
        }
        Set<String> fieldProperties = this.fieldProperties(t, bean.getField());
        Set<String> getterProperties = this.getterProperties(t, bean.getGetter());
        Set<Signature> methods = this.methods(t, bean.getMethod());
        Set<Signature> constructors = this.constructors(t, bean.getConstructor());
        HashSet<String> propertyOverlap = new HashSet<String>(fieldProperties);
        propertyOverlap.retainAll(getterProperties);
        if (!propertyOverlap.isEmpty()) {
            Exceptions.raise(ValidationException::new, "The following %s properties were specified via XML field and getter: %s", bean.getClazz(), propertyOverlap);
        }
        Set getterMethodOverlap = methods.stream().filter(s -> s.getParameterTypes().length == 0).map(Signature::getName).filter(Methods::isGetter).map(Methods::propertyName).filter(getterProperties::contains).collect(Collectors.toSet());
        if (!getterMethodOverlap.isEmpty()) {
            Exceptions.raise(ValidationException::new, "The following %s getters were specified via XML getter and method: %s", bean.getClazz(), getterMethodOverlap);
        }
        return t;
    }

    private Set<String> fieldProperties(Class<?> t, List<FieldType> fields) {
        return fields.stream().peek(f -> {
            Field fld = MappingValidator.org_apache_bval_util_reflection_Reflection$$find(t, c -> MappingValidator.org_apache_bval_util_reflection_Reflection$$getDeclaredField(c, f.getName()));
            if (fld == null) {
                Exceptions.raise(ValidationException::new, "Unknown XML constrained field %s of %s", f.getName(), t);
            }
            Meta.ForField metaField = new Meta.ForField(fld);
            this.constraints(metaField, f.getConstraint());
            this.containerElements(metaField, f.getContainerElementType());
        }).collect(Collectors.toMap(FieldType::getName, Function.identity(), MappingValidator.enforceUniqueness("Duplicate XML constrained field %s of " + t, FieldType::getName))).keySet();
    }

    private Set<String> getterProperties(Class<?> t, List<GetterType> getters) {
        return getters.stream().peek(g -> {
            Method getter = Methods.getter(t, g.getName());
            if (getter == null) {
                Exceptions.raise(ValidationException::new, "Unknown XML constrained getter for property %s of %s", g.getName(), t);
            }
            Meta.ForMethod metaGetter = new Meta.ForMethod(getter);
            this.constraints(metaGetter, g.getConstraint());
            this.containerElements(metaGetter, g.getContainerElementType());
        }).collect(Collectors.toMap(GetterType::getName, Function.identity(), MappingValidator.enforceUniqueness("Duplicate XML constrained getter %s of " + t, GetterType::getName))).keySet();
    }

    private Set<Signature> methods(Class<?> t, List<MethodType> methods) {
        return methods.stream().map(mt -> {
            Class[] parameterTypes = this.getParameterTypes(mt.getParameter());
            Signature result = new Signature(mt.getName(), parameterTypes);
            Method m = MappingValidator.org_apache_bval_util_reflection_Reflection$$find(t, c -> MappingValidator.org_apache_bval_util_reflection_Reflection$$getDeclaredMethod(c, mt.getName(), parameterTypes));
            Exceptions.raiseIf(m == null, ValidationException::new, "Unknown method %s of %s", result, t);
            Optional.of(mt).map(MethodType::getReturnValue).ifPresent(rv -> {
                Meta.ForMethod metaMethod = new Meta.ForMethod(m);
                this.constraints(metaMethod, rv.getConstraint());
                this.containerElements(metaMethod, rv.getContainerElementType());
            });
            Parameter[] params = m.getParameters();
            IntStream.range(0, parameterTypes.length).forEach(n -> {
                Meta.ForParameter metaParam = new Meta.ForParameter(params[n], params[n].getName());
                ParameterType parameterType = mt.getParameter().get(n);
                this.constraints(metaParam, parameterType.getConstraint());
                this.containerElements(metaParam, parameterType.getContainerElementType());
            });
            return result;
        }).collect(Collectors.toSet());
    }

    private Set<Signature> constructors(Class<?> t, List<ConstructorType> ctors) {
        return ctors.stream().map(ctor -> {
            Class<?>[] parameterTypes = this.getParameterTypes(ctor.getParameter());
            Signature result = new Signature(t.getSimpleName(), parameterTypes);
            Constructor dc = MappingValidator.org_apache_bval_util_reflection_Reflection$$getDeclaredConstructor(t, parameterTypes);
            Exceptions.raiseIf(dc == null, ValidationException::new, "Unknown %s constructor %s", t, result);
            Optional.of(ctor).map(ConstructorType::getReturnValue).ifPresent(rv -> {
                Meta.ForConstructor metaCtor = new Meta.ForConstructor(dc);
                this.constraints(metaCtor, rv.getConstraint());
                this.containerElements(metaCtor, rv.getContainerElementType());
            });
            Parameter[] params = dc.getParameters();
            IntStream.range(0, parameterTypes.length).forEach(n -> {
                Meta.ForParameter metaParam = new Meta.ForParameter(params[n], params[n].getName());
                ParameterType parameterType = ctor.getParameter().get(n);
                this.constraints(metaParam, parameterType.getConstraint());
                this.containerElements(metaParam, parameterType.getContainerElementType());
            });
            return result;
        }).collect(Collectors.toSet());
    }

    private Class<?>[] getParameterTypes(List<ParameterType> paramElements) {
        return (Class[])paramElements.stream().map(ParameterType::getType).map(this.resolveClass).toArray(Class[]::new);
    }

    private Set<ContainerElementKey> containerElements(Meta<?> meta, List<ContainerElementTypeType> containerElementTypes) {
        if (containerElementTypes.isEmpty()) {
            return Collections.emptySet();
        }
        Class<?> containerType = TypeUtils.getRawType(meta.getType(), null);
        int typeParameterCount = containerType.getTypeParameters().length;
        if (typeParameterCount == 0) {
            Exceptions.raise(ValidationException::new, "Cannot specify container element types for %s", meta.describeHost());
        }
        return containerElementTypes.stream().map(e -> {
            Integer typeArgumentIndex = e.getTypeArgumentIndex();
            if (typeArgumentIndex == null) {
                if (typeParameterCount > 1) {
                    Exceptions.raise(ValidationException::new, "Unable to resolve unspecified type argument index for %s", meta.describeHost());
                }
                typeArgumentIndex = 0;
            }
            ContainerElementKey result = new ContainerElementKey(containerType, typeArgumentIndex);
            Meta.ForContainerElement elementMeta = new Meta.ForContainerElement(meta, result);
            this.constraints(elementMeta, e.getConstraint());
            this.containerElements(elementMeta, e.getContainerElementType());
            return result;
        }).collect(Collectors.toMap(Function.identity(), ContainerElementKey::getTypeArgumentIndex, MappingValidator.enforceUniqueness("Duplicate XML constrained container element %d of " + meta.describeHost(), Function.identity()))).keySet();
    }

    private void constraints(Meta<?> meta, List<ConstraintType> constraints) {
        constraints.forEach(constraint -> {
            Class<?> annotation = this.resolveClass.apply(constraint.getAnnotation());
            Exceptions.raiseUnless(annotation.isAnnotation(), ValidationException::new, "%s is not an annotation", annotation);
            Set missingElements = Stream.of(MappingValidator.org_apache_bval_util_reflection_Reflection$$getDeclaredMethods(annotation)).filter(m -> m.getParameterCount() == 0 && m.getDefaultValue() == null).map(Method::getName).collect(Collectors.toSet());
            for (ElementType elementType : constraint.getElement()) {
                String name = elementType.getName();
                if (RESERVED_CONSTRAINT_ELEMENT_NAMES.stream().map(ConstraintAnnotationAttributes::getAttributeName).anyMatch(Predicate.isEqual(name))) {
                    Exceptions.raise(ValidationException::new, "Constraint of %s declares reserved parameter name %s.", meta.describeHost(), name);
                }
                missingElements.remove(name);
            }
            Exceptions.raiseUnless(missingElements.isEmpty(), ValidationException::new, "Missing required elements of %s: %s", annotation, missingElements);
        });
    }

    @Privileged
    private static /* synthetic */ Method[] org_apache_bval_util_reflection_Reflection$$getDeclaredMethods(Class<?> clazz) {
        if (!(System.getSecurityManager() != null)) {
            return clazz.getDeclaredMethods();
        }
        return (Method[])AccessController.doPrivileged(new MappingValidator$org_apache_bval_util_reflection_Reflection$$getDeclaredMethods$$Ljava_lang_Class$_ACTION(clazz));
    }

    static /* synthetic */ Method[] __privileged_access$0(Class clazz) {
        return clazz.getDeclaredMethods();
    }

    @Privileged
    private static /* synthetic */ <T> Constructor<T> org_apache_bval_util_reflection_Reflection$$getDeclaredConstructor(Class<T> clazz, Class<?>[] classArray) {
        if (!(System.getSecurityManager() != null)) {
            return MappingValidator.__privileged_org_apache_bval_util_reflection_Reflection$$getDeclaredConstructor(clazz, classArray);
        }
        return (Constructor)AccessController.doPrivileged(new MappingValidator$org_apache_bval_util_reflection_Reflection$$getDeclaredConstructor$$Ljava_lang_Class$arrayOfLjava_lang_Class$_ACTION(clazz, classArray));
    }

    static /* synthetic */ Constructor __privileged_access$1(Class clazz, Class[] classArray) {
        return MappingValidator.__privileged_org_apache_bval_util_reflection_Reflection$$getDeclaredConstructor(clazz, classArray);
    }

    private static /* synthetic */ <T> Constructor<T> __privileged_org_apache_bval_util_reflection_Reflection$$getDeclaredConstructor(Class<T> clazz, Class<?>[] classArray) {
        try {
            return clazz.getDeclaredConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    @Privileged
    private static /* synthetic */ Iterable<Class<?>> org_apache_bval_util_reflection_Reflection$$hierarchy(Class<?> clazz, Reflection.Interfaces interfaces) {
        if (!(System.getSecurityManager() != null)) {
            return MappingValidator.__privileged_org_apache_bval_util_reflection_Reflection$$hierarchy(clazz, interfaces);
        }
        return (Iterable)AccessController.doPrivileged(new MappingValidator$org_apache_bval_util_reflection_Reflection$$hierarchy$$Ljava_lang_Class$Lorg_apache_bval_util_reflection_Reflection$Interfaces$_ACTION(clazz, interfaces));
    }

    static /* synthetic */ Iterable __privileged_access$2(Class clazz, Reflection.Interfaces interfaces) {
        return MappingValidator.__privileged_org_apache_bval_util_reflection_Reflection$$hierarchy(clazz, interfaces);
    }

    private static /* synthetic */ Iterable<Class<?>> __privileged_org_apache_bval_util_reflection_Reflection$$hierarchy(Class<?> clazz, Reflection.Interfaces interfaces) {
        if (clazz == null) {
            return Collections.emptySet();
        }
        Reflection.ClassHierarchy classHierarchy = new Reflection.ClassHierarchy(clazz);
        return interfaces == Reflection.Interfaces.INCLUDE ? new Reflection.FullHierarchy(classHierarchy) : classHierarchy;
    }

    @Privileged
    private static /* synthetic */ <T> T org_apache_bval_util_reflection_Reflection$$find(Class<?> clazz, Function<Class<?>, T> function) {
        if (!(System.getSecurityManager() != null)) {
            return MappingValidator.__privileged_org_apache_bval_util_reflection_Reflection$$find(clazz, function);
        }
        return AccessController.doPrivileged(new MappingValidator$org_apache_bval_util_reflection_Reflection$$find$$Ljava_lang_Class$Ljava_util_function_Function$_ACTION(clazz, function));
    }

    static /* synthetic */ Object __privileged_access$3(Class clazz, Function function) {
        return MappingValidator.__privileged_org_apache_bval_util_reflection_Reflection$$find(clazz, function);
    }

    private static /* synthetic */ <T> T __privileged_org_apache_bval_util_reflection_Reflection$$find(Class<?> clazz, Function<Class<?>, T> function) {
        for (Class<?> clazz2 : MappingValidator.__privileged_org_apache_bval_util_reflection_Reflection$$hierarchy(clazz, Reflection.Interfaces.INCLUDE)) {
            T t = function.apply(clazz2);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @Privileged
    private static /* synthetic */ Method org_apache_bval_util_reflection_Reflection$$getDeclaredMethod(Class<?> clazz, String string, Class<?>[] classArray) {
        if (!(System.getSecurityManager() != null)) {
            return MappingValidator.__privileged_org_apache_bval_util_reflection_Reflection$$getDeclaredMethod(clazz, string, classArray);
        }
        return (Method)AccessController.doPrivileged(new MappingValidator$org_apache_bval_util_reflection_Reflection$$getDeclaredMethod$$Ljava_lang_Class$Ljava_lang_String$arrayOfLjava_lang_Class$_ACTION(clazz, string, classArray));
    }

    static /* synthetic */ Method __privileged_access$4(Class clazz, String string, Class[] classArray) {
        return MappingValidator.__privileged_org_apache_bval_util_reflection_Reflection$$getDeclaredMethod(clazz, string, classArray);
    }

    private static /* synthetic */ Method __privileged_org_apache_bval_util_reflection_Reflection$$getDeclaredMethod(Class<?> clazz, String string, Class<?>[] classArray) {
        try {
            return clazz.getDeclaredMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    @Privileged
    private static /* synthetic */ Field org_apache_bval_util_reflection_Reflection$$getDeclaredField(Class<?> clazz, String string) {
        if (!(System.getSecurityManager() != null)) {
            return MappingValidator.__privileged_org_apache_bval_util_reflection_Reflection$$getDeclaredField(clazz, string);
        }
        return (Field)AccessController.doPrivileged(new MappingValidator$org_apache_bval_util_reflection_Reflection$$getDeclaredField$$Ljava_lang_Class$Ljava_lang_String$_ACTION(clazz, string));
    }

    static /* synthetic */ Field __privileged_access$5(Class clazz, String string) {
        return MappingValidator.__privileged_org_apache_bval_util_reflection_Reflection$$getDeclaredField(clazz, string);
    }

    private static /* synthetic */ Field __privileged_org_apache_bval_util_reflection_Reflection$$getDeclaredField(Class<?> clazz, String string) {
        try {
            return clazz.getDeclaredField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    private static void __privileged_clinit0() {
        RESERVED_CONSTRAINT_ELEMENT_NAMES = Collections.unmodifiableSet(EnumSet.of(ConstraintAnnotationAttributes.GROUPS, ConstraintAnnotationAttributes.MESSAGE, ConstraintAnnotationAttributes.PAYLOAD, ConstraintAnnotationAttributes.VALIDATION_APPLIES_TO));
    }

    static {
        MappingValidator.__privileged_clinit0();
    }
}

