/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.schema;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.pulsar.common.protocol.schema.SchemaVersion;

public class LongSchemaVersion
implements SchemaVersion {
    private final long version;

    public LongSchemaVersion(long version) {
        this.version = version;
    }

    public long getVersion() {
        return this.version;
    }

    @Override
    public byte[] bytes() {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(this.version);
        buffer.rewind();
        return buffer.array();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongSchemaVersion that = (LongSchemaVersion)o;
        return this.version == that.version;
    }

    public int hashCode() {
        return Objects.hash(this.version);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", this.version).toString();
    }
}

