/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataFileType is the corresponding interface of BACnetConstructedDataFileType
type BACnetConstructedDataFileType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetFileType returns FileType (property field)
	GetFileType() BACnetApplicationTagCharacterString
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagCharacterString
	// IsBACnetConstructedDataFileType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataFileType()
	// CreateBuilder creates a BACnetConstructedDataFileTypeBuilder
	CreateBACnetConstructedDataFileTypeBuilder() BACnetConstructedDataFileTypeBuilder
}

// _BACnetConstructedDataFileType is the data-structure of this message
type _BACnetConstructedDataFileType struct {
	BACnetConstructedDataContract
	FileType BACnetApplicationTagCharacterString
}

var _ BACnetConstructedDataFileType = (*_BACnetConstructedDataFileType)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataFileType)(nil)

// NewBACnetConstructedDataFileType factory function for _BACnetConstructedDataFileType
func NewBACnetConstructedDataFileType(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, fileType BACnetApplicationTagCharacterString, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataFileType {
	if fileType == nil {
		panic("fileType of type BACnetApplicationTagCharacterString for BACnetConstructedDataFileType must not be nil")
	}
	_result := &_BACnetConstructedDataFileType{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		FileType:                      fileType,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataFileTypeBuilder is a builder for BACnetConstructedDataFileType
type BACnetConstructedDataFileTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(fileType BACnetApplicationTagCharacterString) BACnetConstructedDataFileTypeBuilder
	// WithFileType adds FileType (property field)
	WithFileType(BACnetApplicationTagCharacterString) BACnetConstructedDataFileTypeBuilder
	// WithFileTypeBuilder adds FileType (property field) which is build by the builder
	WithFileTypeBuilder(func(BACnetApplicationTagCharacterStringBuilder) BACnetApplicationTagCharacterStringBuilder) BACnetConstructedDataFileTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataFileType or returns an error if something is wrong
	Build() (BACnetConstructedDataFileType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataFileType
}

// NewBACnetConstructedDataFileTypeBuilder() creates a BACnetConstructedDataFileTypeBuilder
func NewBACnetConstructedDataFileTypeBuilder() BACnetConstructedDataFileTypeBuilder {
	return &_BACnetConstructedDataFileTypeBuilder{_BACnetConstructedDataFileType: new(_BACnetConstructedDataFileType)}
}

type _BACnetConstructedDataFileTypeBuilder struct {
	*_BACnetConstructedDataFileType

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataFileTypeBuilder) = (*_BACnetConstructedDataFileTypeBuilder)(nil)

func (b *_BACnetConstructedDataFileTypeBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataFileType
}

func (b *_BACnetConstructedDataFileTypeBuilder) WithMandatoryFields(fileType BACnetApplicationTagCharacterString) BACnetConstructedDataFileTypeBuilder {
	return b.WithFileType(fileType)
}

func (b *_BACnetConstructedDataFileTypeBuilder) WithFileType(fileType BACnetApplicationTagCharacterString) BACnetConstructedDataFileTypeBuilder {
	b.FileType = fileType
	return b
}

func (b *_BACnetConstructedDataFileTypeBuilder) WithFileTypeBuilder(builderSupplier func(BACnetApplicationTagCharacterStringBuilder) BACnetApplicationTagCharacterStringBuilder) BACnetConstructedDataFileTypeBuilder {
	builder := builderSupplier(b.FileType.CreateBACnetApplicationTagCharacterStringBuilder())
	var err error
	b.FileType, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagCharacterStringBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataFileTypeBuilder) Build() (BACnetConstructedDataFileType, error) {
	if b.FileType == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'fileType' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataFileType.deepCopy(), nil
}

func (b *_BACnetConstructedDataFileTypeBuilder) MustBuild() BACnetConstructedDataFileType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataFileTypeBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataFileTypeBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataFileTypeBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataFileTypeBuilder().(*_BACnetConstructedDataFileTypeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataFileTypeBuilder creates a BACnetConstructedDataFileTypeBuilder
func (b *_BACnetConstructedDataFileType) CreateBACnetConstructedDataFileTypeBuilder() BACnetConstructedDataFileTypeBuilder {
	if b == nil {
		return NewBACnetConstructedDataFileTypeBuilder()
	}
	return &_BACnetConstructedDataFileTypeBuilder{_BACnetConstructedDataFileType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataFileType) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataFileType) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_FILE_TYPE
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataFileType) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataFileType) GetFileType() BACnetApplicationTagCharacterString {
	return m.FileType
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataFileType) GetActualValue() BACnetApplicationTagCharacterString {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagCharacterString(m.GetFileType())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataFileType(structType any) BACnetConstructedDataFileType {
	if casted, ok := structType.(BACnetConstructedDataFileType); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataFileType); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataFileType) GetTypeName() string {
	return "BACnetConstructedDataFileType"
}

func (m *_BACnetConstructedDataFileType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (fileType)
	lengthInBits += m.FileType.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataFileType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataFileType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataFileType BACnetConstructedDataFileType, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataFileType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataFileType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	fileType, err := ReadSimpleField[BACnetApplicationTagCharacterString](ctx, "fileType", ReadComplex[BACnetApplicationTagCharacterString](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagCharacterString](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'fileType' field"))
	}
	m.FileType = fileType

	actualValue, err := ReadVirtualField[BACnetApplicationTagCharacterString](ctx, "actualValue", (*BACnetApplicationTagCharacterString)(nil), fileType)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataFileType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataFileType")
	}

	return m, nil
}

func (m *_BACnetConstructedDataFileType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataFileType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataFileType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataFileType")
		}

		if err := WriteSimpleField[BACnetApplicationTagCharacterString](ctx, "fileType", m.GetFileType(), WriteComplex[BACnetApplicationTagCharacterString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'fileType' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataFileType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataFileType")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataFileType) IsBACnetConstructedDataFileType() {}

func (m *_BACnetConstructedDataFileType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataFileType) deepCopy() *_BACnetConstructedDataFileType {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataFileTypeCopy := &_BACnetConstructedDataFileType{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagCharacterString](m.FileType),
	}
	_BACnetConstructedDataFileTypeCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataFileTypeCopy
}

func (m *_BACnetConstructedDataFileType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
