/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.nifi.bundle.Bundle;

public class ExtensionDefinition {
    private final String implementationClassName;
    private final Bundle bundle;
    private final Class<?> extensionType;
    private final String description;
    private final List<String> tags;
    private final String version;
    private final ExtensionRuntime runtime;

    private ExtensionDefinition(Builder builder) {
        this.implementationClassName = builder.implementationClassName;
        this.bundle = builder.bundle;
        this.extensionType = builder.extensionType;
        this.description = builder.description;
        this.tags = builder.tags;
        this.version = builder.version;
        this.runtime = builder.runtime;
    }

    public String getImplementationClassName() {
        return this.implementationClassName;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public Class<?> getExtensionType() {
        return this.extensionType;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getVersion() {
        return this.version;
    }

    public ExtensionRuntime getRuntime() {
        return this.runtime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionDefinition that = (ExtensionDefinition)o;
        return Objects.equals(this.implementationClassName, that.implementationClassName) && Objects.equals(this.bundle, that.bundle) && Objects.equals(this.extensionType, that.extensionType) && Objects.equals(this.version, that.version) && Objects.equals((Object)this.runtime, (Object)that.runtime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.implementationClassName, this.bundle, this.extensionType, this.version, this.runtime});
    }

    public String toString() {
        return "ExtensionDefinition[type=" + this.extensionType.getSimpleName() + ", implementation=" + this.implementationClassName + ", bundle=" + String.valueOf(this.bundle) + "]";
    }

    public static class Builder {
        private String implementationClassName;
        private Bundle bundle;
        private Class<?> extensionType;
        private String description;
        private List<String> tags;
        private String version;
        private ExtensionRuntime runtime;

        public Builder implementationClassName(String className) {
            this.implementationClassName = className;
            return this;
        }

        public Builder runtime(ExtensionRuntime runtime) {
            this.runtime = runtime;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder bundle(Bundle bundle) {
            this.bundle = bundle;
            return this;
        }

        public Builder extensionType(Class<?> extensionType) {
            this.extensionType = extensionType;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder tags(List<String> tags) {
            this.tags = new ArrayList<String>(tags);
            return this;
        }

        public ExtensionDefinition build() {
            this.requireSet(this.implementationClassName, "Implementation Class Name");
            this.requireSet(this.extensionType, "Extension Type");
            this.requireSet(this.bundle, "Bundle");
            return new ExtensionDefinition(this);
        }

        private void requireSet(Object value, String fieldName) {
            if (value == null) {
                throw new IllegalArgumentException(fieldName + " must be specified");
            }
        }
    }

    public static enum ExtensionRuntime {
        JAVA,
        PYTHON;

    }
}

