/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvnsh.builtin;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.maven.api.Lifecycle;
import org.apache.maven.api.cli.InvokerException;
import org.apache.maven.api.cli.Logger;
import org.apache.maven.api.cli.ParserRequest;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.LifecycleRegistry;
import org.apache.maven.api.services.LookupException;
import org.apache.maven.api.services.MessageBuilderFactory;
import org.apache.maven.cling.invoker.LookupContext;
import org.apache.maven.cling.invoker.mvn.MavenInvoker;
import org.apache.maven.cling.invoker.mvn.MavenParser;
import org.apache.maven.cling.invoker.mvnenc.EncryptInvoker;
import org.apache.maven.cling.invoker.mvnenc.EncryptParser;
import org.apache.maven.cling.invoker.mvnenc.Goal;
import org.apache.maven.cling.invoker.mvnsh.ShellCommandRegistryFactory;
import org.apache.maven.impl.util.Os;
import org.jline.builtins.Completers;
import org.jline.console.CmdDesc;
import org.jline.console.CommandInput;
import org.jline.console.CommandMethods;
import org.jline.console.CommandRegistry;
import org.jline.console.impl.JlineCommandRegistry;
import org.jline.reader.Completer;
import org.jline.reader.impl.completer.ArgumentCompleter;
import org.jline.reader.impl.completer.StringsCompleter;

@Named(value="builtin")
@Singleton
public class BuiltinShellCommandRegistryFactory
implements ShellCommandRegistryFactory {
    @Override
    public CommandRegistry createShellCommandRegistry(LookupContext context) {
        return new BuiltinShellCommandRegistry(context);
    }

    private static class BuiltinShellCommandRegistry
    extends JlineCommandRegistry
    implements AutoCloseable {
        private final LookupContext shellContext;
        private final MavenInvoker shellMavenInvoker;
        private final MavenParser mavenParser;
        private final EncryptInvoker shellEncryptInvoker;
        private final EncryptParser encryptParser;

        private BuiltinShellCommandRegistry(LookupContext shellContext) {
            this.shellContext = Objects.requireNonNull(shellContext, "shellContext");
            this.shellMavenInvoker = new MavenInvoker(shellContext.invokerRequest.lookup(), this.contextCopier());
            this.mavenParser = new MavenParser();
            this.shellEncryptInvoker = new EncryptInvoker(shellContext.invokerRequest.lookup(), this.contextCopier());
            this.encryptParser = new EncryptParser();
            HashMap<String, CommandMethods> commandExecute = new HashMap<String, CommandMethods>();
            commandExecute.put("!", new CommandMethods(this::shell, arg_0 -> ((BuiltinShellCommandRegistry)this).defaultCompleter(arg_0)));
            commandExecute.put("cd", new CommandMethods(this::cd, this::cdCompleter));
            commandExecute.put("pwd", new CommandMethods(this::pwd, arg_0 -> ((BuiltinShellCommandRegistry)this).defaultCompleter(arg_0)));
            commandExecute.put("mvn", new CommandMethods(this::mvn, this::mvnCompleter));
            commandExecute.put("mvnenc", new CommandMethods(this::mvnenc, this::mvnencCompleter));
            this.registerCommands(commandExecute);
        }

        private Consumer<LookupContext> contextCopier() {
            return result -> {
                result.logger = this.shellContext.logger;
                result.loggerFactory = this.shellContext.loggerFactory;
                result.slf4jConfiguration = this.shellContext.slf4jConfiguration;
                result.loggerLevel = this.shellContext.loggerLevel;
                result.coloredOutput = this.shellContext.coloredOutput;
                result.terminal = this.shellContext.terminal;
                result.writer = this.shellContext.writer;
                result.installationSettingsPath = this.shellContext.installationSettingsPath;
                result.projectSettingsPath = this.shellContext.projectSettingsPath;
                result.userSettingsPath = this.shellContext.userSettingsPath;
                result.interactive = this.shellContext.interactive;
                result.localRepositoryPath = this.shellContext.localRepositoryPath;
                result.effectiveSettings = this.shellContext.effectiveSettings;
                result.containerCapsule = this.shellContext.containerCapsule;
                result.lookup = this.shellContext.lookup;
                result.eventSpyDispatcher = this.shellContext.eventSpyDispatcher;
            };
        }

        @Override
        public void close() throws Exception {
            this.shellMavenInvoker.close();
            this.shellEncryptInvoker.close();
        }

        public List<String> commandInfo(String command) {
            return List.of();
        }

        public CmdDesc commandDescription(List<String> args) {
            return null;
        }

        public String name() {
            return "Builtin Maven Shell commands";
        }

        private void shell(CommandInput input) {
            if (input.args().length > 0) {
                try {
                    ProcessBuilder builder = new ProcessBuilder(new String[0]);
                    ArrayList<String> processArgs = new ArrayList<String>();
                    if (Os.IS_WINDOWS) {
                        processArgs.add("cmd.exe");
                        processArgs.add("/c");
                    } else {
                        processArgs.add("sh");
                        processArgs.add("-c");
                    }
                    processArgs.add(String.join((CharSequence)" ", Arrays.asList(input.args())));
                    builder.command(processArgs);
                    builder.directory(this.shellContext.cwd.get().toFile());
                    Process process = builder.start();
                    Thread out = new Thread(new StreamGobbler(process.getInputStream(), this.shellContext.writer));
                    Thread err = new Thread(new StreamGobbler(process.getErrorStream(), arg_0 -> ((Logger)this.shellContext.logger).error(arg_0)));
                    out.start();
                    err.start();
                    int exitCode = process.waitFor();
                    out.join();
                    err.join();
                    if (exitCode != 0) {
                        this.shellContext.logger.error("Shell command exited with code " + exitCode);
                    }
                }
                catch (Exception e) {
                    this.saveException(e);
                }
            }
        }

        private void cd(CommandInput input) {
            try {
                if (input.args().length == 1) {
                    this.shellContext.cwd.change(input.args()[0]);
                } else {
                    this.shellContext.logger.error("Command accepts only one argument");
                }
            }
            catch (Exception e) {
                this.saveException(e);
            }
        }

        private List<Completer> cdCompleter(String name) {
            return List.of(new ArgumentCompleter(new Completer[]{new Completers.DirectoriesCompleter((Supplier)this.shellContext.cwd)}));
        }

        private void pwd(CommandInput input) {
            try {
                this.shellContext.writer.accept(this.shellContext.cwd.get().toString());
            }
            catch (Exception e) {
                this.saveException(e);
            }
        }

        private void mvn(CommandInput input) {
            try {
                this.shellMavenInvoker.invoke(this.mavenParser.parseInvocation(ParserRequest.mvn((String[])input.args(), (MessageBuilderFactory)this.shellContext.invokerRequest.messageBuilderFactory()).cwd(this.shellContext.cwd.get()).build()));
            }
            catch (InvokerException.ExitException e) {
                this.shellContext.logger.error("mvn command exited with exit code " + e.getExitCode());
            }
            catch (Exception e) {
                this.saveException(e);
            }
        }

        private List<Completer> mvnCompleter(String name) {
            List<String> names;
            try {
                List<String> phases = ((LifecycleRegistry)this.shellContext.lookup.lookup(LifecycleRegistry.class)).stream().flatMap(Lifecycle::allPhases).map(Lifecycle.Phase::name).toList();
                List<String> goals = List.of("wrapper:wrapper");
                names = Stream.concat(phases.stream(), goals.stream()).toList();
            }
            catch (LookupException e) {
                names = List.of("clean", "validate", "compile", "test", "package", "verify", "install", "deploy", "wrapper:wrapper");
            }
            return List.of(new ArgumentCompleter(new Completer[]{new StringsCompleter(names)}));
        }

        private void mvnenc(CommandInput input) {
            try {
                this.shellEncryptInvoker.invoke(this.encryptParser.parseInvocation(ParserRequest.mvnenc((String[])input.args(), (MessageBuilderFactory)this.shellContext.invokerRequest.messageBuilderFactory()).cwd(this.shellContext.cwd.get()).build()));
            }
            catch (InvokerException.ExitException e) {
                this.shellContext.logger.error("mvnenc command exited with exit code " + e.getExitCode());
            }
            catch (Exception e) {
                this.saveException(e);
            }
        }

        private List<Completer> mvnencCompleter(String name) {
            return List.of(new ArgumentCompleter(new Completer[]{new StringsCompleter(this.shellContext.lookup.lookupMap(Goal.class).keySet())}));
        }
    }

    private static class StreamGobbler
    implements Runnable {
        private final InputStream inputStream;
        private final Consumer<String> consumer;

        private StreamGobbler(InputStream inputStream, Consumer<String> consumer) {
            this.inputStream = inputStream;
            this.consumer = consumer;
        }

        @Override
        public void run() {
            new BufferedReader(new InputStreamReader(this.inputStream, StandardCharsets.UTF_8)).lines().forEach(this.consumer);
        }
    }
}

