/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.models;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.luke.models.LukeException;
import org.apache.lucene.luke.models.util.IndexUtils;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Bits;

public abstract class LukeModel {
    protected Directory dir;
    protected IndexReader reader;
    protected Bits liveDocs;
    protected IndexCommit commit;

    protected LukeModel(IndexReader reader) {
        this.reader = Objects.requireNonNull(reader);
        if (reader instanceof DirectoryReader) {
            DirectoryReader dr = (DirectoryReader)reader;
            this.dir = dr.directory();
            try {
                this.commit = dr.getIndexCommit();
            }
            catch (IOException e) {
                throw new LukeException(e.getMessage(), e);
            }
        } else {
            this.dir = null;
            this.commit = null;
        }
        this.liveDocs = IndexUtils.getLiveDocs(reader);
    }

    protected LukeModel(Directory dir) {
        this.dir = Objects.requireNonNull(dir);
    }

    public Collection<String> getFieldNames() {
        return IndexUtils.getFieldNames(this.reader);
    }
}

