/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util.urltemplate;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.knox.gateway.util.urltemplate.Evaluator;
import org.apache.knox.gateway.util.urltemplate.Function;
import org.apache.knox.gateway.util.urltemplate.Host;
import org.apache.knox.gateway.util.urltemplate.Params;
import org.apache.knox.gateway.util.urltemplate.Parser;
import org.apache.knox.gateway.util.urltemplate.Password;
import org.apache.knox.gateway.util.urltemplate.Path;
import org.apache.knox.gateway.util.urltemplate.Port;
import org.apache.knox.gateway.util.urltemplate.Query;
import org.apache.knox.gateway.util.urltemplate.Scheme;
import org.apache.knox.gateway.util.urltemplate.Segment;
import org.apache.knox.gateway.util.urltemplate.Template;
import org.apache.knox.gateway.util.urltemplate.Username;

public class Expander {
    private static Params EMPTY_PARAMS = new EmptyParams();

    public static URI expand(Template template, Params params, Evaluator evaluator) throws URISyntaxException {
        return Expander.expandToUri(template, params, evaluator);
    }

    public static URI expandToUri(Template template, Params params, Evaluator evaluator) throws URISyntaxException {
        return new URI(Expander.expandToString(template, params, evaluator));
    }

    public static Template expandToTemplate(Template template, Params params, Evaluator evaluator) throws URISyntaxException {
        return Parser.parseLiteral(Expander.expandToString(template, params, evaluator));
    }

    public static String expandToString(Template template, Params params, Evaluator evaluator) {
        StringBuilder builder = new StringBuilder();
        if (params == null) {
            params = EMPTY_PARAMS;
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>(params.getNames());
        Expander.expandScheme(template, names, params, evaluator, builder);
        Expander.expandAuthority(template, names, params, evaluator, builder);
        Expander.expandPath(template, names, params, evaluator, builder);
        if (template.hasFragment()) {
            StringBuilder fragment = new StringBuilder();
            Expander.expandFragment(template, names, params, evaluator, fragment);
            Expander.expandQuery(template, names, params, evaluator, builder);
            builder.append((CharSequence)fragment);
        } else {
            Expander.expandQuery(template, names, params, evaluator, builder);
        }
        return builder.toString();
    }

    private static void expandScheme(Template template, Set<String> names, Params params, Evaluator evaluator, StringBuilder builder) {
        Scheme segment = template.getScheme();
        if (segment != null) {
            Expander.expandSingleValue(template.getScheme(), names, params, evaluator, builder);
            builder.append(':');
        }
    }

    private static void expandAuthority(Template template, Set<String> names, Params params, Evaluator evaluator, StringBuilder builder) {
        if (template.hasAuthority()) {
            if (!template.isAuthorityOnly()) {
                builder.append("//");
            }
            Username username = template.getUsername();
            Password password = template.getPassword();
            Host host = template.getHost();
            Port port = template.getPort();
            Expander.expandSingleValue(username, names, params, evaluator, builder);
            if (password != null) {
                builder.append(':');
                Expander.expandSingleValue(password, names, params, evaluator, builder);
            }
            if (username != null || password != null) {
                builder.append('@');
            }
            if (host != null) {
                Expander.expandSingleValue(host, names, params, evaluator, builder);
            }
            if (port != null) {
                builder.append(':');
                Expander.expandSingleValue(port, names, params, evaluator, builder);
            }
        }
    }

    private static void expandPath(Template template, Set<String> names, Params params, Evaluator evaluator, StringBuilder builder) {
        if (template.isAbsolute()) {
            builder.append('/');
        }
        List<Path> path = template.getPath();
        int n = path.size();
        block4: for (int i = 0; i < n; ++i) {
            if (i > 0) {
                builder.append('/');
            }
            Path segment = path.get(i);
            String name = segment.getParamName();
            Function function = new Function(name);
            names.remove(function.getParameterName());
            Segment.Value value = segment.getFirstValue();
            switch (value.getType()) {
                case 1: {
                    String pattern = value.getOriginalPattern();
                    builder.append(pattern);
                    continue block4;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    List<String> values = function.evaluate(params, evaluator);
                    Expander.expandPathValues(segment, values, builder);
                }
            }
        }
        if (template.isDirectory() && !path.isEmpty()) {
            builder.append('/');
        }
    }

    private static void expandPathValues(Path segment, List<String> values, StringBuilder builder) {
        if (values != null && !values.isEmpty()) {
            int type = segment.getFirstValue().getType();
            if (type == 5 || type == 4) {
                int n = values.size();
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        builder.append('/');
                    }
                    builder.append(values.get(i));
                }
            } else {
                builder.append(values.get(0));
            }
        } else {
            builder.append(segment.getFirstValue().getOriginalPattern());
        }
    }

    private static void expandQuery(Template template, Set<String> names, Params params, Evaluator evaluator, StringBuilder builder) {
        AtomicInteger index = new AtomicInteger(0);
        Expander.expandExplicitQuery(template, names, params, evaluator, builder, index);
        Expander.expandExtraQuery(template, names, params, builder, index);
    }

    private static void expandExplicitQuery(Template template, Set<String> names, Params params, Evaluator evaluator, StringBuilder builder, AtomicInteger index) {
        Collection<Query> query = template.getQuery().values();
        if (!query.isEmpty()) {
            for (Query query1 : query) {
                int i = index.incrementAndGet();
                if (i == 1) {
                    builder.append('?');
                } else {
                    builder.append('&');
                }
                String queryName = query1.getQueryName();
                String paramName = query1.getParamName();
                Function function = new Function(paramName);
                names.remove(function.getParameterName());
                for (Segment.Value value : query1.getValues()) {
                    switch (value.getType()) {
                        case 1: {
                            builder.append(queryName);
                            String pattern = value.getOriginalPattern();
                            if (pattern == null) break;
                            builder.append('=');
                            builder.append(Expander.unescape(pattern));
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            List<String> values = function.evaluate(params, evaluator);
                            Expander.expandQueryValues(query1, queryName, values, builder);
                            break;
                        }
                    }
                }
            }
        }
    }

    private static String unescape(String pattern) {
        if (pattern == null) {
            return null;
        }
        return pattern.replace("\\{", String.valueOf('{')).replace("\\}", String.valueOf('}'));
    }

    private static void expandExtraQuery(Template template, Set<String> names, Params params, StringBuilder builder, AtomicInteger index) {
        Query extra = template.getExtra();
        if (extra != null) {
            String[] array = new String[names.size()];
            names.toArray(array);
            for (String name : array) {
                names.remove(name);
                List<String> values = params.resolve(name);
                if (values == null) continue;
                for (String value : values) {
                    int i = index.incrementAndGet();
                    if (i == 1) {
                        builder.append('?');
                    } else {
                        builder.append('&');
                    }
                    Expander.appendQueryPart(name, builder);
                    if (value == null) continue;
                    builder.append('=');
                    Expander.appendQueryPart(value, builder);
                }
            }
        }
    }

    private static void expandQueryValues(Query segment, String queryName, List<String> values, StringBuilder builder) {
        if (values == null || values.isEmpty()) {
            builder.append(queryName);
        } else {
            int type = segment.getFirstValue().getType();
            if (type == 5 || type == 4) {
                int n = values.size();
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        builder.append('&');
                    }
                    Expander.appendQueryPart(queryName, builder);
                    String value = values.get(i);
                    if (value == null) continue;
                    builder.append('=');
                    Expander.appendQueryPart(value, builder);
                }
            } else {
                Expander.appendQueryPart(queryName, builder);
                String value = values.get(0);
                if (value != null) {
                    builder.append('=');
                    Expander.appendQueryPart(value, builder);
                }
            }
        }
    }

    private static void appendQueryPart(String part, StringBuilder builder) {
        try {
            builder.append(URLEncoder.encode(part, StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            builder.append(part);
        }
    }

    private static void expandFragment(Template template, Set<String> names, Params params, Evaluator evaluator, StringBuilder builder) {
        if (template.hasFragment()) {
            builder.append('#');
        }
        Expander.expandSingleValue(template.getFragment(), names, params, evaluator, builder);
    }

    private static void expandSingleValue(Segment segment, Set<String> names, Params params, Evaluator evaluator, StringBuilder builder) {
        if (segment != null) {
            String str;
            String paramName = segment.getParamName();
            Function function = new Function(paramName);
            names.remove(function.getParameterName());
            Segment.Value value = segment.getFirstValue();
            switch (value.getType()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    List<String> values = function.evaluate(params, evaluator);
                    if (values != null && !values.isEmpty()) {
                        str = values.get(0);
                        break;
                    }
                    if (function.getFunctionName() != null) {
                        str = paramName;
                        break;
                    }
                    str = value.getOriginalPattern();
                    break;
                }
                default: {
                    str = value.getOriginalPattern();
                }
            }
            builder.append(str);
        }
    }

    private static class EmptyParams
    implements Params {
        private EmptyParams() {
        }

        @Override
        public Set<String> getNames() {
            return Collections.emptySet();
        }

        @Override
        public List<String> resolve(String name) {
            return Collections.emptyList();
        }
    }
}

