/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.filter;

import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.filter.AssertionType;
import org.apache.directory.api.ldap.model.filter.SimpleNode;
import org.apache.directory.api.ldap.model.schema.AttributeType;

public class ApproximateNode<T>
extends SimpleNode<T> {
    public ApproximateNode(AttributeType attributeType, Value value) {
        super(attributeType, value, AssertionType.APPROXIMATE);
    }

    public ApproximateNode(String attribute, String value) {
        super(attribute, value, AssertionType.APPROXIMATE);
    }

    public ApproximateNode(String attribute, byte[] value) {
        super(attribute, value, AssertionType.APPROXIMATE);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        if (this.attributeType != null) {
            buf.append(this.attributeType.getName());
        } else {
            buf.append(this.attribute);
        }
        buf.append("~=");
        String escapedValue = this.getEscapedValue();
        if (escapedValue != null) {
            buf.append(escapedValue);
        }
        buf.append(super.toString());
        buf.append(')');
        return buf.toString();
    }
}

