/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.build.Container;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Resource;
import aQute.lib.strings.Strings;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Classpath {
    List<File> entries = new ArrayList<File>();
    private Reporter project;
    private String name;

    public Classpath(Reporter project, String name) {
        this.project = project;
        this.name = name;
    }

    public void add(Collection<Container> testpath) throws Exception {
        for (Container c : Container.flatten(testpath)) {
            if (c.getError() != null) {
                this.project.error("Adding %s to %s, got error: %s", c, this.name, c.getError());
                continue;
            }
            this.entries.add(c.getFile().getAbsoluteFile());
        }
    }

    public List<File> getEntries() {
        return this.entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(ClassVisitor visitor) throws Exception {
        Analyzer analyzer = new Analyzer();
        try {
            for (File f : this.entries) {
                Jar jar = new Jar(f);
                try {
                    for (String path : jar.getResources().keySet()) {
                        if (!path.endsWith(".class")) continue;
                        Resource r = jar.getResource(path);
                        Clazz c = new Clazz(analyzer, path, r);
                        c.parseClassFile();
                        visitor.visit(c);
                    }
                }
                finally {
                    jar.close();
                }
            }
        }
        finally {
            analyzer.close();
        }
    }

    public String toString() {
        return Strings.join(File.pathSeparator, this.entries);
    }

    public static interface ClassVisitor {
        public boolean visit(Clazz var1) throws Exception;
    }
}

