/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.net.InetAddress;
import java.net.UnknownHostException;

public final class InetAddressUtil {
    private InetAddressUtil() {
    }

    public static String getLocalHostName() throws UnknownHostException {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            int colon;
            String host = uhe.getMessage();
            if (host != null && (colon = host.indexOf(58)) > 0) {
                return host.substring(0, colon);
            }
            throw uhe;
        }
    }

    public static String getLocalHostNameSafe() {
        try {
            return InetAddressUtil.getLocalHostName();
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

