/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.logback.internal;

import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.WarnStatus;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Dictionary;
import java.util.Hashtable;
import org.ops4j.pax.logging.EventAdminPoster;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingConstants;
import org.ops4j.pax.logging.PaxLoggingService;
import org.ops4j.pax.logging.logback.internal.LoggingManagedService;
import org.ops4j.pax.logging.logback.internal.PaxLoggingServiceImpl;
import org.ops4j.pax.logging.spi.support.BackendSupport;
import org.ops4j.pax.logging.spi.support.ConfigurationNotifier;
import org.ops4j.pax.logging.spi.support.DefaultServiceLog;
import org.ops4j.pax.logging.spi.support.FallbackLogFactory;
import org.ops4j.pax.logging.spi.support.LogReaderServiceImpl;
import org.ops4j.pax.logging.spi.support.RegisteredService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogReaderService;

public class Activator
implements BundleActivator {
    private ServiceRegistration<?> m_RegistrationPaxLogging;
    private PaxLoggingServiceImpl m_paxLogging;
    private RegisteredService<LogReaderService, LogReaderServiceImpl> logReaderInfo;
    private RegisteredService<EventAdminPoster, EventAdminPoster> eventAdminInfo;
    private RegisteredService<ConfigurationNotifier, ConfigurationNotifier> eventAdminConfigurationNotifierInfo;
    private PaxLogger logLog;

    public void start(BundleContext bundleContext) throws Exception {
        Hashtable<String, Object> serviceProperties;
        Path configFilePath;
        this.sanityCheck();
        String levelName = BackendSupport.defaultLogLevel(bundleContext);
        DefaultServiceLog.setLogLevel(levelName);
        this.logReaderInfo = BackendSupport.createAndRegisterLogReaderService(bundleContext);
        this.eventAdminInfo = BackendSupport.eventAdminSupport(bundleContext);
        this.eventAdminConfigurationNotifierInfo = BackendSupport.eventAdminConfigurationNotifier(bundleContext);
        this.logLog = FallbackLogFactory.createFallbackLog(bundleContext.getBundle(), "logback");
        boolean cm = BackendSupport.isConfigurationAdminAvailable();
        if (!cm) {
            this.logLog.info("Configuration Admin is not available.");
        }
        this.m_paxLogging = new PaxLoggingServiceImpl(bundleContext, this.logReaderInfo.getService(), this.eventAdminInfo.getService(), this.eventAdminConfigurationNotifierInfo.getService(), this.logLog);
        String externalFile = BackendSupport.externalFile(bundleContext, null);
        Path path = configFilePath = externalFile == null ? null : Paths.get(externalFile, new String[0]);
        if (configFilePath == null || !configFilePath.toFile().isFile()) {
            this.logLog.info("Initializing Logback using default configuration");
            this.m_paxLogging.configureDefaults();
        } else {
            this.logLog.info("Initializing Logback using " + configFilePath.toAbsolutePath());
            Hashtable<String, String> config = new Hashtable<String, String>();
            ((Dictionary)config).put("org.ops4j.pax.logging.logback.config.file", configFilePath.toAbsolutePath().toString());
            this.m_paxLogging.setDefaultConfiguration(config);
            this.m_paxLogging.updated(null);
        }
        if (cm) {
            serviceProperties = new Hashtable<String, Object>();
            ((Dictionary)serviceProperties).put("service.pid", "org.ops4j.pax.logging");
            this.m_RegistrationPaxLogging = bundleContext.registerService("org.osgi.service.cm.ManagedService", (Object)new LoggingManagedService(this.m_paxLogging), serviceProperties);
        }
        serviceProperties = new Hashtable();
        ((Dictionary)serviceProperties).put("service.ranking", BackendSupport.paxLoggingServiceRanking(bundleContext));
        this.m_RegistrationPaxLogging = bundleContext.registerService(PaxLoggingConstants.LOGGING_LOGSERVICE_NAMES, (Object)this.m_paxLogging, serviceProperties);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.eventAdminInfo != null) {
            this.eventAdminInfo.close();
        }
        if (this.logReaderInfo != null) {
            this.logReaderInfo.close();
        }
        if (this.eventAdminConfigurationNotifierInfo != null) {
            this.eventAdminConfigurationNotifierInfo.close();
        }
        this.m_RegistrationPaxLogging.unregister();
        this.m_RegistrationPaxLogging = null;
        if (this.m_paxLogging != null) {
            this.m_paxLogging.shutdown();
            this.m_paxLogging = null;
        }
        FallbackLogFactory.cleanup();
    }

    private void sanityCheck() {
        Bundle paxLoggingApi = FrameworkUtil.getBundle(PaxLoggingService.class);
        Bundle paxLoggingLogback = FrameworkUtil.getBundle(this.getClass());
        FrameworkUtil.getBundle(ErrorStatus.class);
        FrameworkUtil.getBundle(WarnStatus.class);
        Bundle b1 = FrameworkUtil.getBundle(InfoStatus.class);
        if (paxLoggingLogback != b1) {
            String b1Bundle = b1 == null ? "system classloader" : b1.toString();
            throw new IllegalStateException("ch.qos.logback.core.status.InfoStatus class was loaded from " + b1Bundle + ". It should be loaded from " + paxLoggingLogback + ".");
        }
    }
}

