/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.metatype.internal;

import org.apache.felix.metatype.internal.Activator;
import org.apache.felix.metatype.internal.l10n.Resources;

abstract class LocalizedBase {
    private final Resources resources;

    protected LocalizedBase(Resources resources) {
        if (resources == null) {
            throw new NullPointerException("resources");
        }
        this.resources = resources;
    }

    protected Resources getResources() {
        return this.resources;
    }

    protected String[] localize(String[] strings) {
        if (strings == null) {
            return null;
        }
        String[] localized = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            localized[i] = this.localize(strings[i]);
        }
        return localized;
    }

    protected String localize(String string) {
        if (string != null && string.startsWith("%")) {
            string = string.substring(1);
            try {
                return this.getResources().getResource(string);
            }
            catch (Exception e) {
                Activator.log(4, "localize: Failed getting resource '" + string + "'", e);
            }
        }
        return string;
    }
}

