/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.main;

import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.startlevel.FrameworkStartLevel;

class StartupListener
implements FrameworkListener,
SynchronousBundleListener {
    private Logger log;
    private static final String SYSTEM_PROP_KARAF_CONSOLE_STARTED = "karaf.console.started";
    private long startTime;
    private int currentPercentage;
    private final BundleContext context;

    StartupListener(Logger log, BundleContext context) {
        this.log = log;
        this.context = context;
        this.currentPercentage = 0;
        this.startTime = System.currentTimeMillis();
        context.addBundleListener((BundleListener)this);
        context.addFrameworkListener((FrameworkListener)this);
    }

    public BundleStats getBundleStats() {
        Bundle[] bundles = this.context.getBundles();
        int numActive = 0;
        int numBundles = bundles.length;
        for (Bundle bundle : bundles) {
            if (bundle.getHeaders().get("Fragment-Host") != null) {
                --numBundles;
                continue;
            }
            if (bundle.getState() != 32) continue;
            ++numActive;
        }
        BundleStats stats = new BundleStats();
        stats.numActive = numActive;
        stats.numTotal = numBundles;
        return stats;
    }

    public synchronized void bundleChanged(BundleEvent bundleEvent) {
        BundleStats stats = this.getBundleStats();
        if (!this.isConsoleStarted()) {
            this.showProgressBar(stats.numActive, stats.numTotal);
        }
    }

    private boolean isConsoleStarted() {
        return Boolean.parseBoolean(System.getProperty(SYSTEM_PROP_KARAF_CONSOLE_STARTED, "false"));
    }

    public synchronized void frameworkEvent(FrameworkEvent frameworkEvent) {
        if (frameworkEvent.getType() == 8) {
            int defStartLevel = Integer.parseInt(System.getProperty("org.osgi.framework.startlevel.beginning"));
            int startLevel = ((FrameworkStartLevel)this.context.getBundle(0L).adapt(FrameworkStartLevel.class)).getStartLevel();
            if (startLevel >= defStartLevel) {
                this.context.removeBundleListener((BundleListener)this);
                this.context.removeFrameworkListener((FrameworkListener)this);
                long startTimeSeconds = (System.currentTimeMillis() - this.startTime) / 1000L;
                BundleStats stats = this.getBundleStats();
                String message = "Karaf started in " + startTimeSeconds + "s. Bundle stats: " + stats.numActive + " active, " + stats.numTotal + " total";
                this.log.info(message);
                if (!this.isConsoleStarted()) {
                    this.showProgressBar(100, 100);
                    System.out.println(message);
                }
            }
        }
    }

    public void showProgressBar(int done, int total) {
        int percent = done * 100 / total;
        int scaledPercent = (int)(72.0 * ((double)percent / 100.0));
        if (percent > this.currentPercentage) {
            this.currentPercentage = percent;
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("\r%3d%% [", percent));
            for (int i = 0; i < 72; ++i) {
                if (i < scaledPercent) {
                    sb.append('=');
                    continue;
                }
                if (i == scaledPercent) {
                    sb.append('>');
                    continue;
                }
                sb.append(' ');
            }
            sb.append(']');
            System.out.print(sb.toString());
            System.out.flush();
        }
        if (done == total) {
            System.out.println();
        }
    }

    class BundleStats {
        int numActive;
        int numTotal;

        BundleStats() {
        }
    }
}

