/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Optional;
import org.apache.camel.NamedNode;
import org.apache.camel.impl.engine.DefaultNodeIdFactory;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.VerbDefinition;
import org.apache.camel.spi.NodeIdFactory;

public class RouteIdFactory
implements NodeIdFactory {
    private static final char SEPARATOR = '-';
    private NodeIdFactory defaultNodeIdFactory;

    public RouteIdFactory() {
        this.defaultNodeIdFactory = new DefaultNodeIdFactory();
    }

    public RouteIdFactory(NodeIdFactory defaultNodeIdFactory) {
        this.defaultNodeIdFactory = defaultNodeIdFactory;
    }

    public String createId(NamedNode definition) {
        Optional<String> id;
        if (definition instanceof RouteDefinition) {
            id = this.extractId((RouteDefinition)definition);
            if (id.isPresent()) {
                return id.get();
            }
            id = this.extractIdFromRestDefinition((RouteDefinition)definition);
            if (id.isPresent()) {
                return id.get();
            }
        }
        if (definition instanceof VerbDefinition && (id = this.extractIdFromVerb((VerbDefinition)definition)).isPresent()) {
            return id.get();
        }
        return this.defaultNodeIdFactory.createId(definition);
    }

    private Optional<String> extractId(RouteDefinition routeDefinition) {
        if (routeDefinition.getRestDefinition() != null) {
            return Optional.empty();
        }
        if (routeDefinition.getInput() == null) {
            return Optional.empty();
        }
        FromDefinition from = routeDefinition.getInput();
        String uri = from.getEndpointUri();
        int colon = uri.indexOf(58);
        if (colon > 0) {
            String name = uri.substring(colon + 1);
            int questionMark = name.indexOf(63);
            if (questionMark > 0) {
                return Optional.of(name.substring(0, questionMark));
            }
            return Optional.of(name);
        }
        return Optional.empty();
    }

    private Optional<String> extractIdFromRestDefinition(RouteDefinition route) {
        if (route.getRestDefinition() != null) {
            return this.extractIdFromInput(route);
        }
        return Optional.empty();
    }

    private Optional<String> extractIdFromVerb(VerbDefinition verb) {
        RestDefinition restDefinition = verb.getRest();
        if (restDefinition != null) {
            StringBuilder routeId = new StringBuilder();
            routeId.append(verb.asVerb());
            this.appendWithSeparator(routeId, this.prepareUri(restDefinition.getPath()));
            if (verb.getUri() != null && verb.getUri().length() > 0) {
                this.appendWithSeparator(routeId, this.prepareUri(verb.getUri()));
            }
            verb.setUsedForGeneratingNodeId(true);
            return Optional.of(routeId.toString());
        }
        return Optional.empty();
    }

    private Optional<String> extractIdFromInput(RouteDefinition route) {
        if (route.getInput() == null) {
            return Optional.empty();
        }
        FromDefinition from = route.getInput();
        String uri = from.getEndpointUri();
        String[] uriSplitted = uri.split(":");
        if (uriSplitted.length < 3) {
            return Optional.empty();
        }
        String verb = uriSplitted[1];
        String contextPath = uriSplitted[2];
        String additionalUri = "";
        if (uriSplitted.length > 3 && uriSplitted[3].startsWith("/")) {
            additionalUri = uriSplitted[3];
        }
        StringBuilder routeId = new StringBuilder(verb.length() + contextPath.length() + additionalUri.length());
        routeId.append(verb);
        this.appendWithSeparator(routeId, this.prepareUri(contextPath));
        if (additionalUri.length() > 0) {
            this.appendWithSeparator(routeId, this.prepareUri(additionalUri));
        }
        return Optional.of(routeId.toString());
    }

    private String prepareUri(String uri) {
        if (uri == null) {
            return "";
        }
        if (uri.contains("?")) {
            uri = uri.substring(0, uri.indexOf(63));
        }
        return uri.replace('/', '-');
    }

    private void appendWithSeparator(StringBuilder builder, String str) {
        if (builder.charAt(builder.length() - 1) == '-') {
            if (str.startsWith(String.valueOf('-'))) {
                builder.append(str.replaceFirst(String.valueOf('-'), ""));
            } else {
                builder.append(str);
            }
        } else {
            if (!str.startsWith(String.valueOf('-'))) {
                builder.append('-');
            }
            builder.append(str);
        }
    }
}

