/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import jakarta.inject.Inject;
import org.apache.james.rrt.cassandra.CassandraMappingsSourcesDAO;
import org.apache.james.rrt.cassandra.migration.MappingsSourcesMigration;
import org.apache.james.task.Task;
import org.apache.james.webadmin.service.CassandraMappingsSolveInconsistenciesTask;

public class CassandraMappingsService {
    private final MappingsSourcesMigration mappingsSourcesMigration;
    private final CassandraMappingsSourcesDAO cassandraMappingsSourcesDAO;

    @Inject
    public CassandraMappingsService(MappingsSourcesMigration mappingsSourcesMigration, CassandraMappingsSourcesDAO cassandraMappingsSourcesDAO) {
        this.mappingsSourcesMigration = mappingsSourcesMigration;
        this.cassandraMappingsSourcesDAO = cassandraMappingsSourcesDAO;
    }

    public Task solveMappingsSourcesInconsistencies() {
        return new CassandraMappingsSolveInconsistenciesTask(this.mappingsSourcesMigration, this.cassandraMappingsSourcesDAO);
    }
}

