/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.parameter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.execution.operator.window.WindowType;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByParameter;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class GroupByConditionParameter
extends GroupByParameter {
    private final Expression keepExpression;
    private final boolean ignoringNull;

    public GroupByConditionParameter(boolean ignoringNull, Expression keepExpression) {
        super(WindowType.CONDITION_WINDOW);
        this.keepExpression = keepExpression;
        this.ignoringNull = ignoringNull;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((Boolean)this.ignoringNull, (ByteBuffer)byteBuffer);
        Expression.serialize(this.keepExpression, byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((Boolean)this.ignoringNull, (OutputStream)stream);
        Expression.serialize(this.keepExpression, stream);
    }

    public static GroupByParameter deserialize(ByteBuffer buffer) {
        boolean ignoringNull = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        Expression keepExpression = Expression.deserialize(buffer);
        return new GroupByConditionParameter(ignoringNull, keepExpression);
    }

    public Expression getKeepExpression() {
        return this.keepExpression;
    }

    public boolean isIgnoringNull() {
        return this.ignoringNull;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.keepExpression == ((GroupByConditionParameter)obj).getKeepExpression() && this.ignoringNull == ((GroupByConditionParameter)obj).ignoringNull;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.keepExpression, this.ignoringNull);
    }
}

