/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceNode;
import org.eclipse.milo.opcua.stack.core.types.structured.TypeNode;

public class DataTypeNode
extends TypeNode
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=282");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=284");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=283");
    private final Boolean isAbstract;
    private final ExtensionObject dataTypeDefinition;

    public DataTypeNode(NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, ReferenceNode[] references, Boolean isAbstract, ExtensionObject dataTypeDefinition) {
        super(nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, references);
        this.isAbstract = isAbstract;
        this.dataTypeDefinition = dataTypeDefinition;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public Boolean getIsAbstract() {
        return this.isAbstract;
    }

    public ExtensionObject getDataTypeDefinition() {
        return this.dataTypeDefinition;
    }

    protected DataTypeNode(DataTypeNodeBuilder<?, ?> b) {
        super((TypeNode.TypeNodeBuilder<?, ?>)b);
        this.isAbstract = ((DataTypeNodeBuilder)b).isAbstract;
        this.dataTypeDefinition = ((DataTypeNodeBuilder)b).dataTypeDefinition;
    }

    public static DataTypeNodeBuilder<?, ?> builder() {
        return new DataTypeNodeBuilderImpl();
    }

    @Override
    public DataTypeNodeBuilder<?, ?> toBuilder() {
        return new DataTypeNodeBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataTypeNode)) {
            return false;
        }
        DataTypeNode other = (DataTypeNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isAbstract = this.getIsAbstract();
        Boolean other$isAbstract = other.getIsAbstract();
        if (this$isAbstract == null ? other$isAbstract != null : !((Object)this$isAbstract).equals(other$isAbstract)) {
            return false;
        }
        ExtensionObject this$dataTypeDefinition = this.getDataTypeDefinition();
        ExtensionObject other$dataTypeDefinition = other.getDataTypeDefinition();
        return !(this$dataTypeDefinition == null ? other$dataTypeDefinition != null : !((Object)this$dataTypeDefinition).equals(other$dataTypeDefinition));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DataTypeNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isAbstract = this.getIsAbstract();
        result = result * 59 + ($isAbstract == null ? 43 : ((Object)$isAbstract).hashCode());
        ExtensionObject $dataTypeDefinition = this.getDataTypeDefinition();
        result = result * 59 + ($dataTypeDefinition == null ? 43 : ((Object)$dataTypeDefinition).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "DataTypeNode(isAbstract=" + this.getIsAbstract() + ", dataTypeDefinition=" + this.getDataTypeDefinition() + ")";
    }

    private static final class DataTypeNodeBuilderImpl
    extends DataTypeNodeBuilder<DataTypeNode, DataTypeNodeBuilderImpl> {
        private DataTypeNodeBuilderImpl() {
        }

        @Override
        protected DataTypeNodeBuilderImpl self() {
            return this;
        }

        @Override
        public DataTypeNode build() {
            return new DataTypeNode(this);
        }
    }

    public static abstract class DataTypeNodeBuilder<C extends DataTypeNode, B extends DataTypeNodeBuilder<C, B>>
    extends TypeNode.TypeNodeBuilder<C, B> {
        private Boolean isAbstract;
        private ExtensionObject dataTypeDefinition;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DataTypeNodeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(DataTypeNode instance, DataTypeNodeBuilder<?, ?> b) {
            b.isAbstract(instance.isAbstract);
            b.dataTypeDefinition(instance.dataTypeDefinition);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B isAbstract(Boolean isAbstract) {
            this.isAbstract = isAbstract;
            return (B)this.self();
        }

        public B dataTypeDefinition(ExtensionObject dataTypeDefinition) {
            this.dataTypeDefinition = dataTypeDefinition;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DataTypeNode.DataTypeNodeBuilder(super=" + super.toString() + ", isAbstract=" + this.isAbstract + ", dataTypeDefinition=" + this.dataTypeDefinition + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<DataTypeNode> {
        @Override
        public Class<DataTypeNode> getType() {
            return DataTypeNode.class;
        }

        @Override
        public DataTypeNode decode(SerializationContext context, UaDecoder decoder) {
            NodeId nodeId = decoder.readNodeId("NodeId");
            NodeClass nodeClass = decoder.readEnum("NodeClass", NodeClass.class);
            QualifiedName browseName = decoder.readQualifiedName("BrowseName");
            LocalizedText displayName = decoder.readLocalizedText("DisplayName");
            LocalizedText description = decoder.readLocalizedText("Description");
            UInteger writeMask = decoder.readUInt32("WriteMask");
            UInteger userWriteMask = decoder.readUInt32("UserWriteMask");
            ReferenceNode[] references = (ReferenceNode[])decoder.readStructArray("References", ReferenceNode.TYPE_ID);
            Boolean isAbstract = decoder.readBoolean("IsAbstract");
            ExtensionObject dataTypeDefinition = decoder.readExtensionObject("DataTypeDefinition");
            return new DataTypeNode(nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, references, isAbstract, dataTypeDefinition);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, DataTypeNode value) {
            encoder.writeNodeId("NodeId", value.getNodeId());
            encoder.writeEnum("NodeClass", value.getNodeClass());
            encoder.writeQualifiedName("BrowseName", value.getBrowseName());
            encoder.writeLocalizedText("DisplayName", value.getDisplayName());
            encoder.writeLocalizedText("Description", value.getDescription());
            encoder.writeUInt32("WriteMask", value.getWriteMask());
            encoder.writeUInt32("UserWriteMask", value.getUserWriteMask());
            encoder.writeStructArray("References", (Object[])value.getReferences(), ReferenceNode.TYPE_ID);
            encoder.writeBoolean("IsAbstract", value.getIsAbstract());
            encoder.writeExtensionObject("DataTypeDefinition", value.getDataTypeDefinition());
        }
    }
}

